/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.callistcfg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbs.business.basedata.callistcfg.CalListFieldHelper;

public class CalListFiledConfigPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String KEY_TREE_VIEW = "treeviewap";
    private static final String KEY_ENTRY = "entryentity";
    private static final String OP_SAVE = "donothing_save";
    private static final String OP_MODIFY = "donothing_modify";
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_CLOSE = "close";
    private static final Log logger = LogFactory.getLog(CalListFiledConfigPlugin.class);
    private static final String KEY_SEARCH = "searchap";

    public void registerListener(EventObject eventObject) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        this.getView().setStatus(OperationStatus.VIEW);
        this.initTreeNode();
    }

    private boolean getLock() {
        String groupId = MutexHelper.getMutexGroupId((String)"hsbs_callistfieldcfg", (String)"edit");
        DataMutex dataMutex = DataMutex.create();
        Map mutex = dataMutex.getLockInfo(String.valueOf(0L), groupId, "hsbs_callistfieldcfg");
        boolean locked = null != mutex && !mutex.isEmpty();
        try {
            dataMutex.close();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
        return locked;
    }

    private void initTreeNode() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        TreeNode rootNode = CalListFieldHelper.queryAndBuildTreeNode();
        treeView.deleteAllNodes();
        treeView.addNode(rootNode);
        this.getPageCache().put("treeNode", JSON.toJSONString((Object)rootNode));
        this.removeChangeData();
        TreeNode firstObjNode = (TreeNode)rootNode.getChildren().get(0);
        treeView.expand(firstObjNode.getId());
        treeView.treeNodeClick(firstObjNode.getId(), ((TreeNode)firstObjNode.getChildren().get(0)).getId());
        treeView.focusNode((TreeNode)firstObjNode.getChildren().get(0));
        this.drawEntry((TreeNode)firstObjNode.getChildren().get(0));
    }

    private void removeChangeData() {
        this.getPageCache().remove("fieldData");
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        String treeNodeStr = this.getPageCache().get("treeNode");
        TreeNode rootNode = (TreeNode)JSON.parseObject((String)treeNodeStr, TreeNode.class);
        List treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 3);
        treeNodes = treeNodes.stream().filter(node -> SWCListUtils.isEmpty((List)node.getChildren())).collect(Collectors.toList());
        String oldSearchkey = this.getPageCache().get("oldSearchkey");
        this.getPageCache().put("oldSearchkey", searchText);
        if (SWCListUtils.isEmpty(treeNodes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"CalListFiledConfigPlugin_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            this.getPageCache().remove("searchIndex");
            return;
        }
        if (SWCStringUtils.equals((String)oldSearchkey, (String)searchText)) {
            String oldSearchIndex = this.getPageCache().get("searchIndex");
            int index = SWCStringUtils.isEmpty((String)oldSearchIndex) ? 0 : Integer.parseInt(oldSearchIndex);
            treeView.showNode(((TreeNode)treeNodes.get(index % treeNodes.size())).getParentid());
            treeView.treeNodeClick(((TreeNode)treeNodes.get(index % treeNodes.size())).getParentid(), ((TreeNode)treeNodes.get(index % treeNodes.size())).getId());
            this.getPageCache().put("searchIndex", Integer.toString(++index));
        } else {
            treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
            treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
            this.getPageCache().remove("searchIndex");
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        String treeNodeStr = this.getPageCache().get("treeNode");
        TreeNode rootNode = (TreeNode)JSON.parseObject((String)treeNodeStr, TreeNode.class);
        TreeNode treeNode = rootNode.getTreeNode(nodeId, 3);
        String parentid = treeNode.getParentid();
        List children = treeNode.getChildren();
        if (!SWCListUtils.isEmpty((List)children)) {
            treeView.expand(nodeId);
            treeView.treeNodeClick(nodeId, ((TreeNode)children.get(0)).getId());
        } else if (SWCStringUtils.isNotEmpty((String)parentid) && !SWCStringUtils.equals((String)"all", (String)parentid)) {
            String currentObjId = this.getPageCache().get("currentObj");
            if (!SWCStringUtils.equals((String)currentObjId, (String)nodeId)) {
                this.drawEntry(treeNode);
            }
            treeView.focusNode(treeNode);
        }
    }

    private void drawEntry(TreeNode treeNode) {
        this.getView().setVisible(Boolean.valueOf(!SWCStringUtils.equals((String)treeNode.getId(), (String)"20000")), new String[]{"isusedbyrule"});
        String objNumber = (String)treeNode.getData();
        TableValueSetter setter = this.getTableValueSetter();
        this.laodEntry(treeNode.getId(), setter, objNumber);
        this.setDisableField();
        this.getPageCache().put("currentObj", treeNode.getId());
    }

    private void setDisableField() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
        List fieldEdits = entryGrid.getFieldEdits();
        DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
        int lineCount = this.getModel().getEntryRowCount(KEY_ENTRY);
        for (FieldEdit fieldEdit : fieldEdits) {
            String fieldName = fieldEdit.getFieldKey();
            if (!SWCStringUtils.equals((String)fieldName, (String)"isusedbyrule") && !SWCStringUtils.equals((String)fieldName, (String)"isusedbyviewsch")) continue;
            for (int i = 0; i < lineCount; ++i) {
                DynamicObject dy = dataEntitys[i];
                if (!this.getDisableFieldKeyList().contains(dy.getString("perruleobj.number") + '.' + dy.getString("number"))) continue;
                fieldEdit.setEnable(fieldName, false, i);
            }
        }
    }

    private void putFieldDataToCache(String nodeId) {
        String fieldData = this.getPageCache().get("fieldData");
        Map fieldDataMap = SWCStringUtils.isNotEmpty((String)fieldData) ? (Map)JSON.parseObject((String)fieldData, (TypeReference)new TypeReference<Map<Long, List<Map<String, Object>>>>(){}, (Feature[])new Feature[0]) : new HashMap(16);
        EntryGrid entryentity = (EntryGrid)this.getControl(KEY_ENTRY);
        EntryData entryData = entryentity.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        ArrayList filedcfgs = new ArrayList(10);
        for (DynamicObject dataEntity : dataEntitys) {
            boolean isusedbyrule = dataEntity.getBoolean("isusedbyrule");
            boolean isusedbyviewsch = dataEntity.getBoolean("isusedbyviewsch");
            HashMap<String, Object> fieldCfg = new HashMap<String, Object>(16);
            fieldCfg.put("name", dataEntity.getString("name"));
            fieldCfg.put("number", dataEntity.getString("number"));
            fieldCfg.put("type", dataEntity.getString("type"));
            fieldCfg.put("isusedbyrule", isusedbyrule);
            fieldCfg.put("isusedbyviewsch", isusedbyviewsch);
            fieldCfg.put("field", dataEntity.getString("field"));
            fieldCfg.put("perruleobj", dataEntity.getLong("perruleobj.id"));
            fieldCfg.put("perruleobj.number", dataEntity.getString("perruleobj.number"));
            filedcfgs.add(fieldCfg);
        }
        fieldDataMap.put(Long.valueOf(nodeId), filedcfgs);
        this.getPageCache().put("fieldData", JSON.toJSONString(fieldDataMap));
    }

    private void laodEntry(String nodeId, TableValueSetter setter, String objNumber) {
        Map pageFieldData;
        List pageFieldCfgs;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_callistfieldcfg");
        String fieldData = this.getPageCache().get("fieldData");
        Map<String, Map> pageFiledCfgMap = null;
        if (SWCStringUtils.isNotEmpty((String)fieldData) && (pageFieldCfgs = (List)(pageFieldData = (Map)JSON.parseObject((String)fieldData, (TypeReference)new TypeReference<Map<Long, List<Map<String, Object>>>>(){}, (Feature[])new Feature[0])).get(Long.valueOf(nodeId))) != null) {
            pageFiledCfgMap = pageFieldCfgs.stream().collect(Collectors.toMap(cfg -> cfg.get("number").toString(), cfg -> cfg));
        }
        DynamicObject[] filedCfgs = null;
        filedCfgs = SWCStringUtils.equals((String)objNumber, (String)"hsas_personhr") ? helper.query("name,type,number,isusedbyrule,isusedbyviewsch,perruleobj.number,perruleobj.id,field", new QFilter[]{new QFilter("perruleobj.number", "in", Arrays.asList("hsas_personhr", "hsas_employee", "hsas_pernontsprop"))}, "index asc") : helper.query("name,type,number,isusedbyrule,isusedbyviewsch,perruleobj.number,perruleobj.id,field", new QFilter[]{new QFilter("perruleobj", "=", (Object)Long.valueOf(nodeId))}, "index asc");
        Map<String, List<DynamicObject>> filedCfgMap = Arrays.stream(filedCfgs).collect(Collectors.groupingBy(object -> object.getString("perruleobj.number")));
        HashMap<String, MainEntityType> entityTypeMap = new HashMap<String, MainEntityType>(filedCfgMap.size());
        for (Map.Entry<String, List<DynamicObject>> filedEntry : filedCfgMap.entrySet()) {
            String entityNumber = filedEntry.getKey();
            MainEntityType mainEntityType = (MainEntityType)entityTypeMap.get(entityNumber);
            if (mainEntityType != null) continue;
            entityTypeMap.put(entityNumber, EntityMetadataCache.getDataEntityType((String)entityNumber));
        }
        for (DynamicObject field : filedCfgs) {
            Map filedcfg;
            String number = field.getString("number");
            String entityNumber = field.getString("perruleobj.number");
            MainEntityType mainEntityType = (MainEntityType)entityTypeMap.get(entityNumber);
            Map allFields = mainEntityType.getAllFields();
            IDataEntityProperty property = (IDataEntityProperty)allFields.get(number);
            ILocaleString name = field.getLocaleString("name");
            if (property != null) {
                name = property.getDisplayName();
            }
            String type = field.getString("type");
            String filed = field.getString("field");
            Boolean isusedbyrule = field.getBoolean("isusedbyrule");
            Boolean isusedbyviewsch = field.getBoolean("isusedbyviewsch");
            if (pageFiledCfgMap != null && (filedcfg = pageFiledCfgMap.get(number)) != null) {
                isusedbyrule = (Boolean)filedcfg.get("isusedbyrule");
                isusedbyviewsch = (Boolean)filedcfg.get("isusedbyviewsch");
            }
            setter.addRow(new Object[]{number, name, type, isusedbyrule, isusedbyviewsch, field.getLong("perruleobj.id"), filed});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData(KEY_ENTRY);
        model.batchCreateNewEntryRow(KEY_ENTRY, setter);
        model.endInit();
        this.getView().updateView(KEY_ENTRY);
    }

    private TableValueSetter getTableValueSetter() {
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("number", new Object[0]);
        setter.addField("name", new Object[0]);
        setter.addField("type", new Object[0]);
        setter.addField("isusedbyrule", new Object[0]);
        setter.addField("isusedbyviewsch", new Object[0]);
        setter.addField("perruleobj", new Object[0]);
        setter.addField("field", new Object[0]);
        return setter;
    }

    private String getPropType(IDataEntityProperty property) {
        String type = "";
        if (property instanceof TextProp) {
            type = "string";
        } else if (property instanceof BasedataProp) {
            type = "dynamicObject";
        } else if (property instanceof ComboProp) {
            type = "enum";
        } else if (property instanceof DateTimeProp) {
            type = "date";
        } else if (property instanceof DecimalProp) {
            type = "number";
        } else if (property instanceof BooleanProp) {
            type = "boolean";
        }
        return type;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "refresh": {
                String fieldData = this.getPageCache().get("fieldData");
                if (SWCStringUtils.isNotEmpty((String)fieldData)) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmToRefresh", (IFormPlugin)this);
                    HashMap<Integer, String> btnNameMap = new HashMap<Integer, String>();
                    btnNameMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"CalListFiledConfigPlugin_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    btnNameMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u5237\u65b0", (String)"CalListFiledConfigPlugin_5", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    MessageBoxOptions options = MessageBoxOptions.OKCancel;
                    String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u5237\u65b0\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"CalListFiledConfigPlugin_6", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMap);
                    return;
                }
                this.initTreeNode();
                break;
            }
            case "close": {
                String data = this.getPageCache().get("fieldData");
                if (SWCStringUtils.isNotEmpty((String)data)) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmToClose", (IFormPlugin)this);
                    HashMap<Integer, String> btnNameMap = new HashMap<Integer, String>();
                    btnNameMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"CalListFiledConfigPlugin_7", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    btnNameMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"CalListFiledConfigPlugin_8", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                    MessageBoxOptions options = MessageBoxOptions.OKCancel;
                    String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"CalListFiledConfigPlugin_9", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMap);
                    return;
                }
                this.getView().close();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "donothing_modify": {
                boolean lock = this.getLock();
                if (!lock) {
                    MutexHelper.require((String)"hsbs_callistfieldcfg", (Object)0L, (String)"edit", (StringBuilder)new StringBuilder());
                    ISWCAppCache appCache = SWCAppCache.get((String)"/UHLXNRR9KPZ");
                    appCache.put("hsbs_callistfieldcfglock", (Object)this.getView().getPageId());
                    this.getView().setStatus(OperationStatus.EDIT);
                    this.getPageCache().put("isLocked", Boolean.TRUE.toString());
                    break;
                }
                String errorMsg = ResManager.loadKDString((String)"\u6b64\u5b57\u6bb5\u914d\u7f6e\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\u4e2d\uff0c\u4ec5\u53ef\u67e5\u770b\uff0c\u4e0d\u53ef\u4fee\u6539\u3002", (String)"CalListFiledConfigPlugin_10", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
                break;
            }
            case "donothing_save": {
                this.saveFileds(false);
                break;
            }
        }
    }

    private void saveFileds(boolean isConfirmed) {
        String fieldData = this.getPageCache().get("fieldData");
        Map fieldDataMap = (Map)JSON.parseObject((String)fieldData, (TypeReference)new TypeReference<Map<Long, List<Map<String, Object>>>>(){}, (Feature[])new Feature[0]);
        ArrayList<DynamicObject> saveFiledConfigs = new ArrayList<DynamicObject>(10);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_callistfieldcfg");
        HashSet<String> newFileds = new HashSet<String>(16);
        if (fieldDataMap == null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CalListFiledConfigPlugin_11", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> modifyObjIds = new HashSet<Long>(10);
        for (Map.Entry fieldDataEntry : fieldDataMap.entrySet()) {
            List modifyFieldCfgs = (List)fieldDataEntry.getValue();
            Iterator iterator = modifyFieldCfgs.iterator();
            while (iterator.hasNext()) {
                Map modifyFieldCfg = (Map)iterator.next();
                modifyObjIds.add(Long.valueOf(modifyFieldCfg.get("perruleobj").toString()));
            }
        }
        DynamicObject[] fields = helper.query("id,name,type,field,isusedbyrule,isusedbyviewsch,perruleobj.number,number", new QFilter[]{new QFilter("perruleobj", "in", modifyObjIds)});
        Map<String, DynamicObject> fieldDbMap = Arrays.stream(fields).collect(Collectors.toMap(object -> object.getString("perruleobj.number") + '.' + object.getString("number"), object -> object));
        for (Map.Entry entry : fieldDataMap.entrySet()) {
            List modifyFieldCfgs = (List)entry.getValue();
            for (Map modifyFieldCfg : modifyFieldCfgs) {
                String number = (String)modifyFieldCfg.get("number");
                String objNumber = (String)modifyFieldCfg.get("perruleobj.number");
                String groupNumber = objNumber + '.' + number;
                DynamicObject instance = fieldDbMap.get(groupNumber);
                instance.set("name", modifyFieldCfg.get("name"));
                instance.set("number", (Object)number);
                instance.set("isusedbyrule", modifyFieldCfg.get("isusedbyrule"));
                instance.set("isusedbyviewsch", modifyFieldCfg.get("isusedbyviewsch"));
                instance.set("field", modifyFieldCfg.get("field"));
                instance.set("perruleobj", modifyFieldCfg.get("perruleobj"));
                if (Boolean.parseBoolean(modifyFieldCfg.get("isusedbyviewsch").toString())) {
                    newFileds.add(groupNumber);
                }
                saveFiledConfigs.add(instance);
            }
        }
        DynamicObject[] dbFieldsObjs = helper.query("number,perruleobj.number", new QFilter[]{new QFilter("perruleobj", "in", modifyObjIds), new QFilter("isusedbyviewsch", "=", (Object)Boolean.TRUE)});
        Set set = Arrays.stream(dbFieldsObjs).map(object -> object.getString("perruleobj.number") + '.' + object.getString("number")).collect(Collectors.toSet());
        set.removeAll(newFileds);
        try (TXHandle txHandle = TX.requiresNew();){
            helper.save(saveFiledConfigs.toArray(new DynamicObject[0]));
        }
        this.removeChangeData();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CalListFiledConfigPlugin_11", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        String result = messageBoxClosedEvent.getResult().toString();
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "confirmToSave": {
                if (!result.equals("Yes")) break;
                this.saveFileds(true);
                break;
            }
            case "confirmToRefresh": {
                if (!result.equals("Yes")) break;
                this.initTreeNode();
                break;
            }
            case "confirmToClose": {
                if (!result.equals("Yes")) break;
                this.getView().close();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "isusedbyrule": 
            case "isusedbyviewsch": {
                String focusNodeId = this.getPageCache().get("currentObj");
                this.putFieldDataToCache(focusNodeId);
                break;
            }
        }
    }

    public void pageRelease(EventObject object) {
        ISWCAppCache appCache;
        String lockedPageId;
        String isLocked = this.getPageCache().get("isLocked");
        if (SWCStringUtils.isNotEmpty((String)isLocked) && Boolean.parseBoolean(isLocked) && SWCStringUtils.equals((String)(lockedPageId = (String)(appCache = SWCAppCache.get((String)"/UHLXNRR9KPZ")).get("hsbs_callistfieldcfglock", String.class)), (String)this.getView().getPageId())) {
            MutexHelper.release((String)"hsbs_callistfieldcfg", (String)"edit", (String)String.valueOf(0L));
        }
    }

    public List<String> getDisableFieldKeyList() {
        ArrayList<String> disableFieldNameSet = new ArrayList<String>(16);
        disableFieldNameSet.add("hsas_salaryfile.number");
        disableFieldNameSet.add("hsas_personhr.name");
        disableFieldNameSet.add("hsas_employee.empnumber");
        return disableFieldNameSet;
    }
}

