/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.fieldmap;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCCoreBaseBillEdit;
import kd.swc.hsbs.common.util.XmlUtils;
import kd.swc.hsbs.common.vo.ApiXmlData;
import kd.swc.hsbs.common.vo.ApiXmlParam;
import kd.swc.hsbs.common.vo.FieldMapLabelEntity;
import kd.swc.hsbs.formplugin.web.utils.FieldMapConfDrawPageUtil;

public class FieldMapEdit
extends SWCCoreBaseBillEdit
implements TreeNodeClickListener,
CellClickListener,
SearchEnterListener,
BeforeF7SelectListener,
RowClickEventListener {
    private static final Log LOGGER = LogFactory.getLog(FieldMapEdit.class);
    public static final String PROJECT_RESOURCE = "swc-hsbs-formplugin";
    private static final String BAR_TOOL = "advcontoolbarap";
    private static final String BAR_ADD_OBJECT = "bar_addobject";
    private static final String BAR_ADD_ENTITY = "bar_addentry";
    private static final String BAR_DELETE_ENTITY = "bar_deleteentry";
    private static final String BAR_MODIFY = "bar_modify";
    private static final String FORM_FIELD_MAP = "fieldmapdetail";
    private static final String FIELD_KEY_SOURCEFIELD = "targetobjectfield";
    private static final String FIELD_KEY_TARGETFIELD = "subscibeapifield";
    private static final String FIELD_KEY_OBJECTID = "subscibeobject";
    private static final String FORM_FIELD_TARGET_OBJECT = "entityobject";
    private static final String CALL_BACK = "callback";
    private static final String METADATA_BACK = "metadata";
    private static final String METADATA_GRP_BACK = "data_group";
    private static final String TARGET_OBJECT_BACK = "target_object_back";
    private static final String CONTROL_KEY_PAIRTREE = "pairtree";
    private static final String CONTROL_KEY_BTN_MAP = "btn_map";
    private static final String CONTROL_KEY_BTN_UNMAP = "btn_unmap";
    private static final String TREE_ID_ROOT = "root";
    private static final String CONTROL_KEY_SEARCH_SOURCE = "search_source";
    private static final String CONTROL_KEY_SEARCH_TARGET = "search_target";
    private static final String CONTROL_KEY_TARGET_MAPPED = "mapped_target";
    private static final String CONTROL_KEY_FLEX_SOURCEFIELDS = "flex_sourcefields";
    private static final String CONTROL_KEY_FLEX_TARGETFIELDS = "flex_targetfields";
    private static final String CONTROL_KEY_FLEX_MAPPEDFIELDS = "flex_mappedfields";
    private static final String CONTROL_KEY_LBL_SOURCEHEAD = "lbl_soucehead";
    private static final String CONTROL_KEY_LBL_TARGETHEAD = "lbl_targethead";
    private static final String STATUS_SELECTED = "selected";
    private static final String STATUS_UNSELECTED = "unselected";
    private static final String CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE = "current_field_unmapped_source";
    private static final String CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET = "current_field_unmapped_target";
    private static final String CACHE_KEY_SELECTED_MAPPED_FIELDS = "selected_mapped_fields";
    private static final String CACHE_MAP_KEY_API_DATA = "api_data";
    private static final String MAP_KEY_OLD_VALUE = "old_value";
    private static final String MAP_KEY_OLD_GRP_VALUE = "old_group_value";
    private static final String MAP_KEY_TARGET_OBJECT_VALUE = "old_target_object_value";
    private static final String MAP_KEY_CURRENT_TREENODE = "current_node";
    private static final String PAY_ROLL_ACT = "payrollact";
    private static final String UNMAP = "unmap";
    private static final String DELETE_ROW = "delete_row";
    private SWCPageCache swcPageCache;

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TreeView treeView = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
        Button btnMap = (Button)this.getView().getControl(CONTROL_KEY_BTN_MAP);
        btnMap.addClickListener((ClickListener)this);
        Button btnUnmap = (Button)this.getView().getControl(CONTROL_KEY_BTN_UNMAP);
        btnUnmap.addClickListener((ClickListener)this);
        Search searchSource = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_SOURCE);
        searchSource.addEnterListener((SearchEnterListener)this);
        Search searchTarget = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_TARGET);
        searchTarget.addEnterListener((SearchEnterListener)this);
        Search targetMapped = (Search)this.getView().getControl(CONTROL_KEY_TARGET_MAPPED);
        targetMapped.addEnterListener((SearchEnterListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(FORM_FIELD_TARGET_OBJECT);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{BAR_TOOL, BAR_ADD_OBJECT, BAR_ADD_ENTITY, BAR_DELETE_ENTITY, BAR_MODIFY});
        BasedataEdit payrollact = (BasedataEdit)this.getView().getControl(PAY_ROLL_ACT);
        payrollact.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getModel().setDataChanged(false);
        this.initSWCPageCache();
    }

    private ApiXmlData getApiData(Long apiId) {
        String apiDataCacheKey = this.getApiDataCacheKey(apiId);
        ApiXmlData cachedApiXmlData = (ApiXmlData)this.getSWCPageCache().get(apiDataCacheKey, ApiXmlData.class);
        if (cachedApiXmlData != null) {
            return cachedApiXmlData;
        }
        try {
            LOGGER.info("\u8fdc\u7a0b\u8c03\u7528 HR \u83b7\u53d6 API \u63cf\u8ff0, Id: {}", (Object)apiId);
            String xmlData = (String)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"getXMLDescById", (Object[])new Object[]{apiId});
            ApiXmlData parse = XmlUtils.parse((String)xmlData);
            this.getSWCPageCache().put(apiDataCacheKey, (Object)parse);
            return parse;
        }
        catch (Exception e) {
            LOGGER.error("\u8fdc\u7a0b\u8c03\u7528 HR \u83b7\u53d6 API \u63cf\u8ff0\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private String getApiDataCacheKey(Long apiId) {
        return "api_data#" + apiId;
    }

    private ApiXmlParam getApiDataEntityByQueryField(ApiXmlData apiData, String targetEntityNumber, String targetFieldNumber) {
        if ("2".equals(apiData.getApiType())) {
            Long apiId = Long.valueOf(targetEntityNumber);
            List outputParams = apiData.getOutputParams();
            if (outputParams.isEmpty()) {
                return null;
            }
            if (!apiId.equals(apiData.getId())) {
                return null;
            }
            for (ApiXmlParam apiXmlParam : outputParams) {
                String key = apiXmlParam.getKey();
                if (!targetFieldNumber.equalsIgnoreCase(key)) continue;
                return apiXmlParam;
            }
        }
        return apiData.getOutputParams().stream().filter(entity -> StringUtils.equals((CharSequence)(targetEntityNumber + targetFieldNumber), (CharSequence)(entity.getQueryFieldRelEntity() + entity.getQueryField()))).findFirst().orElse(null);
    }

    private void initSWCPageCache() {
        this.swcPageCache = this.getSWCPageCache();
        ArrayList selectedFields = Lists.newArrayList();
        this.swcPageCache.put(CACHE_KEY_SELECTED_MAPPED_FIELDS, (Object)selectedFields);
    }

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        tree.setRootVisible(false);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.initPairTreeView();
        this.updateTreeView();
    }

    private void popConfirm(String description, String callback) {
        this.getView().showConfirm(description, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callback, (IFormPlugin)this));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String changedItem;
        switch (changedItem = args.getProperty().getName()) {
            case "apideploy": {
                this.showChangedApiDataConfirm(args);
                break;
            }
            case "entityobject": {
                this.showChangedTargetObjectConfirm(args);
                break;
            }
            case "payrollact": {
                if (null == args.getChangeSet()[0].getOldValue()) break;
                this.swcPageCache = new SWCPageCache(this.getView());
                this.swcPageCache.put(PAY_ROLL_ACT, (Object)this.getModel().getDataEntity().getLong("payrollact.id"));
                this.changePayrollact();
                break;
            }
        }
    }

    private void showChangedApiDataConfirm(PropertyChangedArgs args) {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject oldValue = (DynamicObject)args.getChangeSet()[0].getOldValue();
        Long apiId = oldValue == null ? null : Long.valueOf(oldValue.getLong("id"));
        IDataModel entryOperate = this.getModel();
        entryOperate.setEntryCurrentRowIndex("entryentity", row);
        entryOperate.deleteEntryData(FORM_FIELD_MAP);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(row);
        String targetName = dynamicObject.getString("entityobject.id");
        if (apiId != null) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.remove(targetName + "#" + apiId);
        }
        this.updateTreeView();
    }

    private void changePayrollact() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u534f\u4f5c\u6d3b\u52a8\uff0c\u5c06\u6e05\u7a7a\u76ee\u6807\u5b9e\u4f53\u4e0eAPI\u5b9e\u4f53\u8bbe\u7f6e\u548c\u5b57\u6bb5\u5173\u8054\u8bbe\u7f6e\uff0c\u786e\u8ba4\u66f4\u6539\uff1f", (String)"FileMapManagerEdit_14", (String)PROJECT_RESOURCE, (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(PAY_ROLL_ACT, (IFormPlugin)this));
    }

    private void showChangedTargetObjectConfirm(PropertyChangedArgs args) {
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        DynamicObject oldObject = (DynamicObject)args.getChangeSet()[0].getOldValue();
        String id = Optional.ofNullable(oldObject).map(obj -> oldObject.getString("ID")).orElse(null);
        if (StringUtils.isBlank((CharSequence)id)) {
            this.updateTreeView();
            return;
        }
        DynamicObjectCollection objects = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex)).getDynamicObjectCollection(FORM_FIELD_MAP);
        if (CollectionUtils.isEmpty((Collection)objects)) {
            this.updateTreeView();
            return;
        }
        this.swcPageCache = this.getSWCPageCache();
        this.swcPageCache.put(MAP_KEY_TARGET_OBJECT_VALUE, (Object)this.makeCacheOldValue(id, rowIndex));
        this.popConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u76ee\u6807\u5b9e\u4f53\u5bf9\u8c61\u540e\uff0c\u5b57\u6bb5\u5173\u8054\u8bbe\u7f6e\u4e2d\u5df2\u5173\u8054\u7684\u5b57\u6bb5\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"FileMapManagerEdit_10", (String)PROJECT_RESOURCE, (Object[])new Object[0]), TARGET_OBJECT_BACK);
    }

    private String makeCacheOldValue(String oldValue, int rowIndex) {
        return oldValue + "#" + rowIndex;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String control = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (control) {
            case "entityobject": {
                this.showF7TargetObjectList(showParameter);
                break;
            }
            case "payrollact": {
                beforeF7SelectEvent.addCustomQFilter(this.getPayRollActQFilter());
                break;
            }
        }
    }

    private QFilter getPayRollActQFilter() {
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsbs_payrollact");
        QFilter fieldMapQFilter = new QFilter("entryentity.triggercolla.ismustfieldmapping", "=", (Object)"1");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject[] query = swcDataServiceHelper.query(new QFilter[]{fieldMapQFilter, enableQFilter, statusQFilter});
        Set<Object> idSet = new HashSet(16);
        if (query != null && query.length != 0) {
            idSet = Arrays.stream(query).map(item -> item.getLong("id")).collect(Collectors.toSet());
        }
        return new QFilter("id", "in", idSet);
    }

    private void showF7TargetObjectList(ListShowParameter showParameter) {
        showParameter.setFormId("bos_listf7");
        showParameter.setShowApproved(false);
        showParameter.setShowUsed(false);
        showParameter.getListFilterParameter().setQFilters(this.getTargetObjectF7Filter());
        this.setFilteredTargetObjectToParameter(showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_addobject": {
                this.addObjectValidatePayrollact();
                break;
            }
            case "bar_addentry": {
                break;
            }
            case "bar_deleteentry": {
                this.deleteAndConfirm();
                break;
            }
        }
    }

    private void addObjectValidatePayrollact() {
        if (null == this.getModel().getValue(PAY_ROLL_ACT)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u534f\u4f5c\u6d3b\u52a8\u201d\u3002", (String)"FileMapManagerEdit_13", (String)PROJECT_RESOURCE, (Object[])new Object[0]));
        } else {
            this.showTargetObjectList();
        }
    }

    private void deleteAndConfirm() {
        int[] selectRows = this.getSelectRowIndex();
        if (selectRows.length < 1) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"FileMapManagerEdit_11", (String)PROJECT_RESOURCE, (Object[])new Object[0]);
            this.getView().showTipNotification(errMsg);
            return;
        }
        boolean hasMappedField = false;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int selectRow : selectRows) {
            DynamicObjectCollection objects = ((DynamicObject)entryEntity.get(selectRow)).getDynamicObjectCollection(FORM_FIELD_MAP);
            if (CollectionUtils.isEmpty((Collection)objects)) continue;
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u884c\u540e\uff0c\u5bf9\u5e94\u5b57\u6bb5\u7684\u5173\u8054\u8bbe\u7f6e\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"FileMapManagerEdit_8", (String)PROJECT_RESOURCE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_ROW, (IFormPlugin)this));
            hasMappedField = true;
            break;
        }
        if (!hasMappedField) {
            this.getModel().deleteEntryRows("entryentity", selectRows);
        }
    }

    private int[] getSelectRowIndex() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        return entryGrid.getSelectRows();
    }

    private void showTargetObjectList() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setShowTitle(false);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(true);
        showParameter.setFormId("bos_listf7");
        showParameter.setBillFormId("bos_entityobject");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK));
        showParameter.getListFilterParameter().setQFilters(this.getTargetObjectF7Filter());
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("880px");
        cssValue.setHeight("600px");
        openStyle.setInlineStyleCss(cssValue);
        this.setFilteredTargetObjectToParameter(showParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<QFilter> getTargetObjectF7Filter() {
        DynamicObjectCollection entryEnties = this.getModel().getDataEntity().getDynamicObjectCollection("payrollact.entryentity");
        if (entryEnties == null || entryEnties.isEmpty()) {
            return Collections.singletonList(new QFilter("number", "in", null));
        }
        List ids = entryEnties.stream().map(item -> item.getLong("triggercolla.id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        SWCDataServiceHelper triggerOrm = new SWCDataServiceHelper("hsbs_triggercolla");
        DynamicObjectCollection queryOriginalCollection = triggerOrm.queryOriginalCollection("entityobject.id,entityobject.number", new QFilter[]{qFilter});
        List objectIds = queryOriginalCollection.stream().map(item -> item.getString("entityobject.id")).distinct().collect(Collectors.toList());
        return Collections.singletonList(new QFilter("id", "in", objectIds));
    }

    private void setFilteredTargetObjectToParameter(ListShowParameter showParameter) {
        QFilter filter = new QFilter("number", "not in", this.getSelectedId());
        showParameter.getListFilterParameter().setFilter(filter);
    }

    private List<String> getSelectedId() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (DynamicObject entity : entryEntity) {
            String number = entity.getString("entityobject.number");
            if (!StringUtils.isNotBlank((CharSequence)number)) continue;
            result.add(number);
        }
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (null == returnData) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "callback": {
                List<String> selectedTargetObjects = this.getSelectedTargetObjects((ListSelectedRowCollection)returnData);
                this.insertEntryEntity(selectedTargetObjects);
                this.updateTreeView();
                break;
            }
        }
    }

    private void insertEntryEntity(List<String> selectedTargetObjects) {
        IDataModel dataModel = this.getModel();
        int entryEntityIndex = dataModel.getEntryRowCount("entryentity");
        dataModel.beginInit();
        for (String selectedTargetObject : selectedTargetObjects) {
            this.createRowData(selectedTargetObject, entryEntityIndex++);
        }
        dataModel.endInit();
        this.getView().updateView("entryentity");
    }

    private void createRowData(String selectedTargetObject, int index) {
        this.getModel().insertEntryRow("entryentity", index);
        this.getModel().setValue(FORM_FIELD_TARGET_OBJECT, (Object)selectedTargetObject, index);
    }

    private List<String> getSelectedTargetObjects(ListSelectedRowCollection selectedRows) {
        ArrayList result = Lists.newArrayList();
        for (ListSelectedRow selectedRow : selectedRows) {
            result.add(String.valueOf(selectedRow.getPrimaryKeyValue()));
        }
        return result;
    }

    private void initPairTreeView() {
        TreeView pairTree = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        TreeNode root = new TreeNode("", TREE_ID_ROOT, ResManager.loadKDString((String)"\u5168\u90e8", (String)"FileMapManagerEdit_2", (String)PROJECT_RESOURCE, (Object[])new Object[0]));
        String selectedTreeNode = this.getSelectedTreeNode(pairTree);
        if (StringUtils.isNotBlank((CharSequence)selectedTreeNode)) {
            pairTree.uncheckNode(selectedTreeNode);
            this.drawBaseMappingContainer();
        }
        this.saveRootNode(root);
        pairTree.addNode(root);
    }

    private void drawBaseMappingContainer() {
        Label targetObjectLabel = (Label)this.getView().getControl(CONTROL_KEY_LBL_SOURCEHEAD);
        targetObjectLabel.setText(ResManager.loadKDString((String)"\u76ee\u6807\u5b9e\u4f53\u5b57\u6bb5", (String)"FileMapManagerEdit_0", (String)PROJECT_RESOURCE, (Object[])new Object[0]));
        Label apiDataLabel = (Label)this.getView().getControl(CONTROL_KEY_LBL_TARGETHEAD);
        apiDataLabel.setText(ResManager.loadKDString((String)"API\u5b57\u6bb5", (String)"FileMapManagerEdit_1", (String)PROJECT_RESOURCE, (Object[])new Object[0]));
    }

    private void saveRootNode(TreeNode root) {
        SWCPageCache pageCache = this.getSWCPageCache();
        pageCache.put(TREE_ID_ROOT, (Object)root);
    }

    private SWCPageCache getSWCPageCache() {
        if (this.swcPageCache == null) {
            this.swcPageCache = new SWCPageCache(this.getView());
        }
        return this.swcPageCache;
    }

    private void updateTreeView() {
        SWCPageCache pageCache = this.getSWCPageCache();
        TreeView pairTree = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        String selectedTreeNodeId = this.getSelectedTreeNode(pairTree);
        TreeNode root = (TreeNode)pageCache.get(TREE_ID_ROOT, TreeNode.class);
        root.setChildren((List)Lists.newArrayList());
        DynamicObjectCollection entityPairEntry = this.getModel().getEntryEntity("entryentity");
        int mappedFieldAmount = 0;
        boolean isSelectedTreeNodeAlive = false;
        int nodeCount = 0;
        TreeNode firstTreeNode = null;
        for (DynamicObject entityPair : entityPairEntry) {
            DynamicObject targetObject = entityPair.getDynamicObject(FORM_FIELD_TARGET_OBJECT);
            DynamicObject apiDeploy = entityPair.getDynamicObject("apideploy");
            if (null == targetObject || apiDeploy == null) continue;
            String targetObjectNumber = targetObject.getString("number");
            String targetObjectName = targetObject.getString("name");
            String nodeId = this.getNodeId(targetObjectNumber, apiDeploy.getString("id"));
            DynamicObjectCollection details = entityPair.getDynamicObjectCollection(FORM_FIELD_MAP);
            int rowAmount = details.getRowCount();
            mappedFieldAmount += rowAmount;
            TreeNode treeNode = new TreeNode(TREE_ID_ROOT, nodeId, targetObjectName + "(" + rowAmount + ")");
            root.addChild(treeNode);
            if (nodeCount == 0 && StringUtils.isEmpty((CharSequence)selectedTreeNodeId)) {
                firstTreeNode = treeNode;
            }
            ++nodeCount;
            if (!StringUtils.equals((CharSequence)selectedTreeNodeId, (CharSequence)nodeId)) continue;
            isSelectedTreeNodeAlive = true;
        }
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8 ({0})", (String)"FileMapManagerEdit_15", (String)PROJECT_RESOURCE, (Object[])new Object[]{mappedFieldAmount}));
        pairTree.updateNode(root);
        pairTree.expand(TREE_ID_ROOT);
        if (isSelectedTreeNodeAlive) {
            pairTree.treeNodeClick(TREE_ID_ROOT, selectedTreeNodeId);
            TreeNode treeNode = root.getTreeNode(selectedTreeNodeId, 2);
            pairTree.focusNode(treeNode);
            if (treeNode != null) {
                pairTree.treeNodeClick(TREE_ID_ROOT, treeNode.getId());
            }
        } else {
            this.cleanFields();
            if (firstTreeNode != null) {
                pairTree.treeNodeClick(TREE_ID_ROOT, firstTreeNode.getId());
                pairTree.focusNode(firstTreeNode);
                this.drawAllFieldContainers(firstTreeNode.getId());
            } else {
                this.drawBaseMappingContainer();
            }
        }
        this.saveRootNode(root);
    }

    private String getNodeId(String sourceEntityId, String targetEntityId) {
        return sourceEntityId + "#" + targetEntityId;
    }

    private String getSelectedTreeNode(TreeView pairTree) {
        List selectedNodeIds = pairTree.getTreeState().getSelectedNodeId();
        if (CollectionUtils.isEmpty((Collection)selectedNodeIds)) {
            return "";
        }
        String currentNodeId = (String)selectedNodeIds.get(0);
        if (StringUtils.equals((CharSequence)currentNodeId, (CharSequence)TREE_ID_ROOT)) {
            return (String)this.getSWCPageCache().get(MAP_KEY_CURRENT_TREENODE, String.class);
        }
        return (String)selectedNodeIds.get(0);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        if (StringUtils.equals((CharSequence)treeView.getKey(), (CharSequence)CONTROL_KEY_PAIRTREE)) {
            String nodeId = (String)evt.getNodeId();
            this.treeNodeClickLoad(nodeId);
        }
    }

    private void treeNodeClickLoad(String nodeId) {
        if (StringUtils.equals((CharSequence)nodeId, (CharSequence)TREE_ID_ROOT)) {
            this.getSelectedTreeNode((TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE));
            return;
        }
        this.swcPageCache = this.getSWCPageCache();
        this.swcPageCache.put(MAP_KEY_CURRENT_TREENODE, (Object)nodeId);
        this.clearSearchText();
        this.drawAllFieldContainers(nodeId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (this.isUnmappedFieldFlex(key)) {
            this.changeUnmappedFieldSelectStatus(key);
        }
        if (this.isMappedMainFieldFlex(key)) {
            this.changeMappedFieldSelectStatus(key);
        }
        switch (key) {
            case "btn_map": {
                this.mapSelectedFields();
                break;
            }
            case "btn_unmap": {
                this.showUnmapConfirm();
                break;
            }
        }
    }

    private boolean isUnmappedFieldFlex(String key) {
        return key.contains("flex_fieldum");
    }

    private boolean isMappedMainFieldFlex(String key) {
        return key.contains("flex_fieldmm");
    }

    private void changeMappedFieldSelectStatus(String key) {
        SWCPageCache pageCache = this.getSWCPageCache();
        Map<String, String> treeNodeInfo = this.getSelectedNodeInfo(pageCache);
        FieldMapLabelEntity mappedFieldsInfo = this.decodeFieldMapLabelEntity(treeNodeInfo.get(key));
        List<String> selectedFields = this.getSelectedMappedFields(pageCache);
        boolean isSelected = selectedFields.contains(key);
        if (isSelected) {
            selectedFields.remove(key);
        } else {
            selectedFields.add(key);
        }
        isSelected = !isSelected;
        this.changeMappedFieldBorderLineColor(key, isSelected, mappedFieldsInfo);
        pageCache.put(CACHE_KEY_SELECTED_MAPPED_FIELDS, selectedFields);
        pageCache.put(this.getSelectedTreeNodeId(), treeNodeInfo);
    }

    private FieldMapLabelEntity decodeFieldMapLabelEntity(String json) {
        if (SWCStringUtils.isEmpty((String)json)) {
            return null;
        }
        try {
            return (FieldMapLabelEntity)SWCJSONUtils.cast((String)json, FieldMapLabelEntity.class);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            return null;
        }
    }

    private String encodeFieldMapLabelEntity(FieldMapLabelEntity entity) {
        try {
            return SWCJSONUtils.toString((Object)entity);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            return null;
        }
    }

    private void changeMappedFieldBorderLineColor(String fieldFlexKey, boolean isSelected, FieldMapLabelEntity mappedFieldsInfo) {
        if (mappedFieldsInfo == null) {
            return;
        }
        FieldMapLabelEntity source = null;
        FieldMapLabelEntity target = null;
        if (mappedFieldsInfo.wasTarget()) {
            target = mappedFieldsInfo;
            source = this.decodeFieldMapLabelEntity(mappedFieldsInfo.getRelationEntityJson());
        } else {
            target = this.decodeFieldMapLabelEntity(mappedFieldsInfo.getRelationEntityJson());
            source = mappedFieldsInfo;
        }
        if (source == null || target == null) {
            return;
        }
        FlexPanelAp mappedFieldAp = isSelected ? FieldMapConfDrawPageUtil.combineSelectedMappedFieldAp(source, target) : FieldMapConfDrawPageUtil.combineUnselectedMappedFieldAp(source, target);
        this.getView().updateControlMetadata(fieldFlexKey, mappedFieldAp.createControl());
    }

    private void changeUnmappedFieldSelectStatus(String newKey) {
        SWCPageCache pageCache = this.getSWCPageCache();
        FieldMapLabelEntity newFieldInfo = this.getUnmappedFieldInfo(newKey, pageCache);
        if (newFieldInfo == null) {
            return;
        }
        String position = newFieldInfo.getPosition();
        String currentSelectedFileKeyPosition = StringUtils.equals((CharSequence)position, (CharSequence)"source") ? CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE : CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET;
        String currentSelectedFlexKey = (String)pageCache.get(currentSelectedFileKeyPosition, String.class);
        if (!StringUtils.isEmpty((CharSequence)currentSelectedFlexKey)) {
            this.changeUnmappedFieldBorderLineColor(currentSelectedFlexKey, STATUS_UNSELECTED);
        }
        this.changeUnmappedFieldBorderLineColor(newKey, STATUS_SELECTED);
        pageCache.put(currentSelectedFileKeyPosition, (Object)newKey);
    }

    private void mapSelectedFields() {
        FieldMapLabelEntity sourceEntity;
        SWCPageCache cache = this.getSWCPageCache();
        Map<String, String> treeNodeInfo = this.getSelectedNodeInfo(cache);
        String targetObjectFieldKey = (String)cache.get(CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE, String.class);
        String metaDataFieldKey = (String)cache.get(CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET, String.class);
        if (null == treeNodeInfo || treeNodeInfo.isEmpty() || StringUtils.isEmpty((CharSequence)targetObjectFieldKey) || StringUtils.isEmpty((CharSequence)metaDataFieldKey)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5173\u8054\u7684\u5b57\u6bb5\u3002", (String)"FileMapManagerEdit_3", (String)PROJECT_RESOURCE, (Object[])new Object[0]));
            return;
        }
        FieldMapLabelEntity targetEntity = this.decodeFieldMapLabelEntity(treeNodeInfo.get(targetObjectFieldKey));
        if (!this.compareFieldType(targetEntity, sourceEntity = this.decodeFieldMapLabelEntity(treeNodeInfo.get(metaDataFieldKey)))) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0e\u5b57\u6bb5\u7c7b\u578b\u76f8\u7b26\u7684\u9009\u9879\u3002", (String)"FileMapManagerEdit_4", (String)PROJECT_RESOURCE, (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            return;
        }
        String targetObjectField = targetEntity.getFieldNumber();
        String metaDataField = sourceEntity.getFieldNumber();
        String metaDataEntityId = sourceEntity.getEntityNumber();
        TreeView tree = (TreeView)this.getControl(CONTROL_KEY_PAIRTREE);
        String nodeId = this.getSelectedTreeNode(tree);
        this.addMappedFieldsToDetail(targetObjectField, metaDataField, metaDataEntityId);
        targetEntity.setIsMapped(true);
        targetEntity.setRelationEntityJson(this.encodeFieldMapLabelEntity(sourceEntity));
        sourceEntity.setIsMapped(true);
        sourceEntity.setRelationEntityJson(this.encodeFieldMapLabelEntity(targetEntity));
        treeNodeInfo.put(targetObjectFieldKey, this.encodeFieldMapLabelEntity(targetEntity));
        treeNodeInfo.put(metaDataFieldKey, this.encodeFieldMapLabelEntity(sourceEntity));
        cache.put(this.getSelectedTreeNodeId(), treeNodeInfo);
        cache.remove(CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE);
        cache.remove(CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET);
        this.drawAllFieldContainers(nodeId);
        this.updateTreeView();
    }

    private boolean compareFieldType(FieldMapLabelEntity targetEntity, FieldMapLabelEntity sourceEntity) {
        String sourceType;
        if (targetEntity == null || sourceEntity == null) {
            return false;
        }
        String targetType = FieldMapConfDrawPageUtil.FIELD_TYPE_VLUE_MAP.get(targetEntity.getFieldType());
        if (StringUtils.equals((CharSequence)targetType, (CharSequence)(sourceType = FieldMapConfDrawPageUtil.FIELD_TYPE_VLUE_MAP.get(sourceEntity.getFieldType())))) {
            return true;
        }
        if (targetType.equalsIgnoreCase("DynamicObject") && (sourceType.equalsIgnoreCase("Long") || sourceType.equalsIgnoreCase("String"))) {
            return true;
        }
        return targetType.equalsIgnoreCase("LocalString") && sourceType.equalsIgnoreCase("String");
    }

    private void addMappedFieldsToDetail(String sourceField, String targetField, String targetEntityId) {
        String nodeId = this.getSelectedTreeNodeId();
        DynamicObject entity = this.getDynamicObjByNodeId(nodeId);
        if (null == entity) {
            return;
        }
        DynamicObjectCollection details = entity.getDynamicObjectCollection(FORM_FIELD_MAP);
        DynamicObject object = details.addNew();
        object.set(FIELD_KEY_SOURCEFIELD, (Object)sourceField);
        object.set(FIELD_KEY_TARGETFIELD, (Object)targetField);
        object.set(FIELD_KEY_OBJECTID, (Object)targetEntityId);
        this.getView().updateView(FORM_FIELD_MAP);
    }

    private void unmapSelectedFields() {
        SWCPageCache pageCache = this.getSWCPageCache();
        List<String> selectedFields = this.getSelectedMappedFields(pageCache);
        TreeView tree = (TreeView)this.getControl(CONTROL_KEY_PAIRTREE);
        String nodeId = this.getSelectedTreeNode(tree);
        for (String fieldFlexKey : selectedFields) {
            Map<String, String> treeNodeInfo = this.getSelectedNodeInfo(pageCache);
            FieldMapLabelEntity mappedFieldsInfo = this.decodeFieldMapLabelEntity(treeNodeInfo.get(fieldFlexKey));
            if (mappedFieldsInfo == null) continue;
            FieldMapLabelEntity source = null;
            FieldMapLabelEntity target = null;
            if (mappedFieldsInfo.wasTarget()) {
                target = mappedFieldsInfo;
                source = this.decodeFieldMapLabelEntity(mappedFieldsInfo.getRelationEntityJson());
            } else {
                target = this.decodeFieldMapLabelEntity(mappedFieldsInfo.getRelationEntityJson());
                source = mappedFieldsInfo;
            }
            if (target == null || source == null) continue;
            source.clearMap();
            target.clearMap();
            this.deleteMappedField(source.getFieldNumber(), target.getFieldNumber(), nodeId);
            treeNodeInfo.put(FieldMapConfDrawPageUtil.getUnmappedFlexKey(source), this.encodeFieldMapLabelEntity(source));
            treeNodeInfo.put(FieldMapConfDrawPageUtil.getUnmappedFlexKey(target), this.encodeFieldMapLabelEntity(target));
            treeNodeInfo.remove(FieldMapConfDrawPageUtil.getMappedLabelFlexKey(source, target));
            pageCache.put(nodeId, treeNodeInfo);
        }
        selectedFields.clear();
        pageCache.put(CACHE_KEY_SELECTED_MAPPED_FIELDS, selectedFields);
        this.drawAllFieldContainers(nodeId);
    }

    private List<String> getSelectedMappedFields(SWCPageCache pageCache) {
        ArrayList selectedFields = (ArrayList)pageCache.get(CACHE_KEY_SELECTED_MAPPED_FIELDS, List.class);
        if (null == selectedFields) {
            selectedFields = new ArrayList();
        }
        return selectedFields;
    }

    private void clearSearchText() {
        Search searchSource = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_SOURCE);
        searchSource.setSearchKey("");
        Search searchTarget = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_TARGET);
        searchTarget.setSearchKey("");
        Search targetMapped = (Search)this.getView().getControl(CONTROL_KEY_TARGET_MAPPED);
        targetMapped.setSearchKey("");
    }

    private void drawAllFieldContainers(String nodeId) {
        this.clearFieldsCache();
        String[] tableNumbers = nodeId.split("#");
        if (tableNumbers.length < 2) {
            return;
        }
        String sourceEntityNumber = tableNumbers[0];
        String targetEntityNumber = tableNumbers[1];
        Long apiId = Long.valueOf(targetEntityNumber);
        this.drawUnmappedObjectFieldContainer(sourceEntityNumber, "");
        this.drawUnmappedApiDataFieldContainer(apiId, "");
        this.drawMappedFieldContainer(sourceEntityNumber, apiId, "", nodeId);
    }

    private String getCurrentRowEntityNumber() {
        String currentNodeId = (String)this.getSWCPageCache().get(MAP_KEY_CURRENT_TREENODE, String.class);
        String[] datas = currentNodeId.split("#");
        if (datas == null || datas.length == 0) {
            return null;
        }
        return datas[0];
    }

    private int getEntryRowByEntityNumber(String entityNumber) {
        int result = -1;
        if (SWCStringUtils.isEmpty((String)entityNumber)) {
            return result;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null || entryEntity.size() == 0) {
            return result;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            String entityObject = dynamicObject.getString("entityobject.number");
            if (!entityNumber.equalsIgnoreCase(entityObject)) continue;
            return i;
        }
        return result;
    }

    private void deleteMappedField(String sourcePropKey, String targetPropKey, String nodeId) {
        Integer index = this.getIndexFromEntityByNodeId(nodeId);
        DynamicObject entity = this.getDynamicObjByNodeId(nodeId);
        if (null == index || null == entity) {
            return;
        }
        DynamicObjectCollection mappedFields = entity.getDynamicObjectCollection(FORM_FIELD_MAP);
        ArrayList<Integer> indexToDelete = new ArrayList<Integer>();
        for (int i = 0; i < mappedFields.size(); ++i) {
            DynamicObject mappedField = (DynamicObject)mappedFields.get(i);
            if (!StringUtils.equals((CharSequence)sourcePropKey, (CharSequence)mappedField.getString(FIELD_KEY_SOURCEFIELD)) || !StringUtils.equals((CharSequence)targetPropKey, (CharSequence)mappedField.getString(FIELD_KEY_TARGETFIELD))) continue;
            indexToDelete.add(i);
        }
        IDataModel entryOperate = this.getModel();
        entryOperate.setEntryCurrentRowIndex("entryentity", index.intValue());
        entryOperate.deleteEntryRows(FORM_FIELD_MAP, indexToDelete.stream().mapToInt(Integer::valueOf).toArray());
    }

    private void clearFieldsCache() {
        SWCPageCache cache = this.getSWCPageCache();
        cache.remove(CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE);
        cache.remove(CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET);
        cache.remove(CACHE_KEY_SELECTED_MAPPED_FIELDS);
    }

    private void cleanFields() {
        this.drawEmptyFieldContainer(CONTROL_KEY_FLEX_SOURCEFIELDS, STATUS_UNSELECTED);
        this.drawEmptyFieldContainer(CONTROL_KEY_FLEX_TARGETFIELDS, STATUS_UNSELECTED);
        this.drawEmptyFieldContainer(CONTROL_KEY_FLEX_MAPPEDFIELDS, STATUS_SELECTED);
    }

    private void drawEmptyFieldContainer(String containerKey, String emptyType) {
        FlexPanelAp fieldsContainerFlexAp = StringUtils.equals((CharSequence)emptyType, (CharSequence)STATUS_UNSELECTED) ? FieldMapConfDrawPageUtil.createUnmappedFieldsContainerFlex(containerKey) : FieldMapConfDrawPageUtil.createMappedFieldsContainerFlex(containerKey);
        Container fieldsContainerFlex = (Container)this.getControl(containerKey);
        this.drawMappedFlex(fieldsContainerFlexAp, fieldsContainerFlex, containerKey);
    }

    private void drawUnmappedObjectFieldContainer(String entityName, String searchText) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection properties = entityType.getProperties();
        FlexPanelAp fieldsContainerFlexAp = FieldMapConfDrawPageUtil.createUnmappedFieldsContainerFlex(CONTROL_KEY_FLEX_SOURCEFIELDS);
        Container fieldsContainerFlex = (Container)this.getControl(CONTROL_KEY_FLEX_SOURCEFIELDS);
        Map<String, String> treeNodeInfo = this.getSelectedNodeInfo();
        for (IDataEntityProperty property : properties) {
            this.appendUnmappedField(entityType, fieldsContainerFlexAp, (DynamicProperty)property, searchText, treeNodeInfo);
        }
        List items = ((Container)fieldsContainerFlexAp.buildRuntimeControl()).getItems();
        fieldsContainerFlex.getItems().addAll(items);
        this.getView().createControlIndex(fieldsContainerFlex.getItems());
        this.getView().updateControlMetadata(CONTROL_KEY_FLEX_SOURCEFIELDS, fieldsContainerFlexAp.createControl());
        int fieldAmount = items.size();
        Label lblHead = (Label)this.getView().getControl(CONTROL_KEY_LBL_SOURCEHEAD);
        lblHead.setText(ResManager.loadKDString((String)"\u76ee\u6807\u5b9e\u4f53\u5b57\u6bb5({0})", (String)"FileMapManagerEdit_16", (String)PROJECT_RESOURCE, (Object[])new Object[]{fieldAmount}));
    }

    private void drawUnmappedApiDataFieldContainer(Long apiId, String searchText) {
        FlexPanelAp fieldsContainerFlexAp = FieldMapConfDrawPageUtil.createUnmappedFieldsContainerFlex(CONTROL_KEY_FLEX_TARGETFIELDS);
        Container fieldsContainerFlex = (Container)this.getControl(CONTROL_KEY_FLEX_TARGETFIELDS);
        ApiXmlData apiDatas = this.getApiData(apiId);
        if (apiDatas == null) {
            this.drawTargetFlex(fieldsContainerFlexAp, fieldsContainerFlex);
            return;
        }
        List apiDataList = apiDatas.getOutputParams();
        if (CollectionUtils.isEmpty((Collection)apiDataList)) {
            this.drawTargetFlex(fieldsContainerFlexAp, fieldsContainerFlex);
            return;
        }
        Map<String, String> treeNodeInfo = this.getSelectedNodeInfo();
        apiDataList.forEach(param -> this.appendUnmappedApiDataField((ApiXmlParam)param, fieldsContainerFlexAp, searchText, treeNodeInfo));
        this.drawTargetFlex(fieldsContainerFlexAp, fieldsContainerFlex);
    }

    private void drawTargetFlex(FlexPanelAp fieldsContainerFlexAp, Container fieldsContainerFlex) {
        List items = ((Container)fieldsContainerFlexAp.buildRuntimeControl()).getItems();
        fieldsContainerFlex.getItems().addAll(items);
        this.getView().createControlIndex(fieldsContainerFlex.getItems());
        this.getView().updateControlMetadata(CONTROL_KEY_FLEX_TARGETFIELDS, fieldsContainerFlexAp.createControl());
        int fieldAmount = items.size();
        Label lblHead = (Label)this.getView().getControl(CONTROL_KEY_LBL_TARGETHEAD);
        lblHead.setText(ResManager.loadKDString((String)"API\u5b57\u6bb5({0})", (String)"FileMapManagerEdit_17", (String)PROJECT_RESOURCE, (Object[])new Object[]{fieldAmount}));
    }

    private void drawMappedFieldContainer(String sourceEntityNumber, Long apiId, String searchText, String nodeId) {
        DynamicObject entity = this.getDynamicObjByNodeId(nodeId);
        if (null == entity) {
            return;
        }
        FlexPanelAp fieldsContainerFlexAp = FieldMapConfDrawPageUtil.createMappedFieldsContainerFlex(CONTROL_KEY_FLEX_MAPPEDFIELDS);
        Container fieldsContainerFlex = (Container)this.getControl(CONTROL_KEY_FLEX_MAPPEDFIELDS);
        ApiXmlData apiData = this.getApiData(apiId);
        if (apiData == null) {
            this.drawMappedFlex(fieldsContainerFlexAp, fieldsContainerFlex, CONTROL_KEY_FLEX_MAPPEDFIELDS);
            return;
        }
        DynamicObjectCollection mappedFields = entity.getDynamicObjectCollection(FORM_FIELD_MAP);
        for (DynamicObject mappedField : mappedFields) {
            ApiXmlParam apiDataEntity;
            String sourceFieldNumber = mappedField.getString(FIELD_KEY_SOURCEFIELD);
            String targetFieldNumber = mappedField.getString(FIELD_KEY_TARGETFIELD);
            String targetEntityNumber = mappedField.getString(FIELD_KEY_OBJECTID);
            if (StringUtils.isEmpty((CharSequence)sourceFieldNumber) || StringUtils.isEmpty((CharSequence)targetFieldNumber) || null == (apiDataEntity = this.getApiDataEntityByQueryField(apiData, targetEntityNumber, targetFieldNumber))) continue;
            FieldMapLabelEntity target = this.convertApiDataToLabelEntity(apiDataEntity, true);
            FieldMapLabelEntity source = this.convertEntityDataToLabelEntity(sourceEntityNumber, sourceFieldNumber, false);
            this.appendMappedField(source, target, fieldsContainerFlexAp, searchText);
        }
        this.drawMappedFlex(fieldsContainerFlexAp, fieldsContainerFlex, CONTROL_KEY_FLEX_MAPPEDFIELDS);
    }

    private void drawMappedFlex(FlexPanelAp fieldsContainerFlexAp, Container fieldsContainerFlex, String controlKeyFlexMappedfields) {
        List items = ((Container)fieldsContainerFlexAp.buildRuntimeControl()).getItems();
        fieldsContainerFlex.getItems().addAll(items);
        this.getView().createControlIndex(fieldsContainerFlex.getItems());
        this.getView().updateControlMetadata(controlKeyFlexMappedfields, fieldsContainerFlexAp.createControl());
    }

    private FieldMapLabelEntity convertEntityDataToLabelEntity(String entityNumber, String fieldNumber, boolean isTarget) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = entityType.getProperties();
        DynamicProperty fieldProp = (DynamicProperty)properties.get((Object)fieldNumber);
        FieldMapLabelEntity fieldMapLabelEntity = new FieldMapLabelEntity();
        LocaleString entityDisplayName = entityType.getDisplayName();
        fieldMapLabelEntity.setEntityName(entityDisplayName != null ? entityDisplayName.getLocaleValue() : entityType.getName());
        fieldMapLabelEntity.setEntityNumber(entityType.getName());
        LocaleString fieldDisplayName = fieldProp.getDisplayName();
        fieldMapLabelEntity.setFieldName(fieldDisplayName != null ? fieldDisplayName.getLocaleValue() : fieldProp.getName());
        fieldMapLabelEntity.setFieldNumber(fieldProp.getName());
        fieldMapLabelEntity.setFieldType(fieldProp.getPropertyType().getName());
        fieldMapLabelEntity.setFieldTypeName(FieldMapConfDrawPageUtil.getFieldTypeName(fieldProp.getPropertyType().getName()));
        fieldMapLabelEntity.setIsExtend(false);
        fieldMapLabelEntity.setIsMapped(false);
        fieldMapLabelEntity.setPosition(isTarget ? "target" : "source");
        fieldMapLabelEntity.setRelationEntityJson(null);
        return fieldMapLabelEntity;
    }

    private FieldMapLabelEntity convertApiDataToLabelEntity(ApiXmlParam apiDataParam, boolean isTarget) {
        FieldMapLabelEntity fieldMapLabelEntity = new FieldMapLabelEntity();
        fieldMapLabelEntity.setEntityName(apiDataParam.getEntityName());
        fieldMapLabelEntity.setEntityNumber(apiDataParam.getEntityNumber());
        fieldMapLabelEntity.setFieldName(apiDataParam.getName());
        fieldMapLabelEntity.setFieldNumber(apiDataParam.getKey());
        fieldMapLabelEntity.setFieldType(apiDataParam.getType());
        fieldMapLabelEntity.setFieldTypeName(FieldMapConfDrawPageUtil.getFieldTypeName(apiDataParam.getType()));
        fieldMapLabelEntity.setIsExtend(false);
        fieldMapLabelEntity.setIsMapped(false);
        fieldMapLabelEntity.setPosition(isTarget ? "target" : "source");
        fieldMapLabelEntity.setRelationEntityJson(null);
        return fieldMapLabelEntity;
    }

    private void appendUnmappedField(MainEntityType sourceEntityType, FlexPanelAp fieldsContainerFlexAp, DynamicProperty property, String searchText, Map<String, String> treeNodeInfo) {
        if (!this.isFieldShouldShow((IDataEntityProperty)property)) {
            return;
        }
        FieldMapLabelEntity label = new FieldMapLabelEntity();
        label.setEntityName(sourceEntityType.getDisplayName().getLocaleValue());
        label.setEntityNumber(sourceEntityType.getName());
        label.setFieldName(FieldMapConfDrawPageUtil.getPropDisplayName(property));
        label.setFieldNumber(property.getName());
        label.setFieldType(property.getPropertyType().getName());
        label.setFieldTypeName(FieldMapConfDrawPageUtil.getFieldTypeName(property.getPropertyType().getName()));
        label.setPosition("source");
        label.setIsExtend(false);
        FlexPanelAp unmappedFieldFlexAp = FieldMapConfDrawPageUtil.combineUnselectedUnmappedFieldAp(label);
        String fieldFlexKey = unmappedFieldFlexAp.getKey();
        boolean isMapped = this.isFieldMapped(fieldFlexKey, treeNodeInfo);
        label.setIsMapped(isMapped);
        this.cacheUnmappedFieldInfo(fieldFlexKey, label);
        if (!isMapped && this.matchWithLocaleAndSearch((IDataEntityProperty)property, searchText)) {
            fieldsContainerFlexAp.getItems().add(unmappedFieldFlexAp);
        }
    }

    private void appendUnmappedApiDataField(ApiXmlParam apiXmlParam, FlexPanelAp fieldsContainerFlexAp, String searchText, Map<String, String> treeNodeInfo) {
        FieldMapLabelEntity label = this.convertApiDataToLabelEntity(apiXmlParam, true);
        String fieldName = apiXmlParam.getName();
        FlexPanelAp unmappedFieldFlexAp = FieldMapConfDrawPageUtil.combineUnselectedUnmappedFieldAp(label);
        String fieldFlexKey = unmappedFieldFlexAp.getKey();
        boolean isMapped = this.isFieldMapped(fieldFlexKey, treeNodeInfo);
        this.cacheUnmappedApiDataFieldInfo(fieldFlexKey, apiXmlParam, isMapped);
        if (!isMapped && this.matchSearch(fieldName, searchText)) {
            fieldsContainerFlexAp.getItems().add(unmappedFieldFlexAp);
        }
    }

    private boolean isFieldShouldShow(IDataEntityProperty property) {
        LocaleString chineseName = property.getDisplayName();
        String dbName = property.getAlias();
        String name = property.getName();
        return !StringUtils.isEmpty((CharSequence)dbName) && (null != chineseName || "id".equals(name));
    }

    private boolean isFieldMapped(String fieldKey, Map<String, String> treeNodeInfo) {
        String selectedTreeNodeId = this.getSelectedTreeNodeId();
        String entityNumber = selectedTreeNodeId.split("#")[0];
        fieldKey = fieldKey.toLowerCase(Locale.ROOT);
        int entryRow = this.getEntryRowByEntityNumber(entityNumber);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryRow);
        if (entryRowEntity == null) {
            return false;
        }
        DynamicObjectCollection mappedFields = entryRowEntity.getDynamicObjectCollection(FORM_FIELD_MAP);
        for (DynamicObject mappedField : mappedFields) {
            String sourceEndKey = (entityNumber + "#" + mappedField.getString(FIELD_KEY_SOURCEFIELD)).toLowerCase(Locale.ROOT);
            String targetEndKey = (mappedField.getString(FIELD_KEY_OBJECTID) + "#" + mappedField.get(FIELD_KEY_TARGETFIELD)).toLowerCase(Locale.ROOT);
            if (!fieldKey.endsWith(sourceEndKey) && !fieldKey.endsWith(targetEndKey)) continue;
            return true;
        }
        return false;
    }

    private void cacheUnmappedFieldInfo(String fieldFlexKey, FieldMapLabelEntity entity) {
        SWCPageCache pageCache = this.getSWCPageCache();
        Map<String, String> tableInfo = this.getSelectedNodeInfo(pageCache);
        FieldMapLabelEntity fieldFlexInfo = this.decodeFieldMapLabelEntity(tableInfo.get(fieldFlexKey));
        if (null != fieldFlexInfo) {
            return;
        }
        tableInfo.put(fieldFlexKey, this.encodeFieldMapLabelEntity(entity));
        this.putFieldMapLabelEntityToCache(tableInfo);
    }

    private void putFieldMapLabelEntityToCache(Map<String, String> tableInfo) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put(this.getSelectedTreeNodeId(), tableInfo);
    }

    private void cacheUnmappedApiDataFieldInfo(String fieldFlexKey, ApiXmlParam apiXmlParam, boolean isMapped) {
        SWCPageCache pageCache = this.getSWCPageCache();
        Map<String, String> tableInfo = this.getSelectedNodeInfo(pageCache);
        FieldMapLabelEntity fieldFlexInfo = this.decodeFieldMapLabelEntity(tableInfo.get(fieldFlexKey));
        if (null != fieldFlexInfo) {
            return;
        }
        fieldFlexInfo = new FieldMapLabelEntity();
        fieldFlexInfo.setEntityName(apiXmlParam.getEntityName());
        fieldFlexInfo.setEntityNumber(apiXmlParam.getEntityNumber());
        fieldFlexInfo.setFieldName(apiXmlParam.getName());
        fieldFlexInfo.setFieldNumber(apiXmlParam.getKey());
        fieldFlexInfo.setFieldType(apiXmlParam.getType());
        fieldFlexInfo.setFieldTypeName(FieldMapConfDrawPageUtil.getFieldTypeName(apiXmlParam.getType()));
        fieldFlexInfo.setPosition("target");
        fieldFlexInfo.setIsMapped(isMapped);
        tableInfo.put(fieldFlexKey, this.encodeFieldMapLabelEntity(fieldFlexInfo));
        pageCache.put(this.getSelectedTreeNodeId(), tableInfo);
    }

    private void changeUnmappedFieldBorderLineColor(String fieldFlexKey, String selectedStatus) {
        SWCPageCache pageCache = this.getSWCPageCache();
        FieldMapLabelEntity fieldInfo = this.getUnmappedFieldInfo(fieldFlexKey, pageCache);
        FlexPanelAp selectedUnmappedFieldAp = null;
        if (STATUS_SELECTED.equals(selectedStatus)) {
            selectedUnmappedFieldAp = FieldMapConfDrawPageUtil.combineSelectedUnmappedFieldAp(fieldInfo);
        }
        if (STATUS_UNSELECTED.equals(selectedStatus)) {
            selectedUnmappedFieldAp = FieldMapConfDrawPageUtil.combineUnselectedUnmappedFieldAp(fieldInfo);
        }
        if (null != selectedUnmappedFieldAp) {
            this.getView().updateControlMetadata(fieldFlexKey, selectedUnmappedFieldAp.createControl());
        }
    }

    private FieldMapLabelEntity getUnmappedFieldInfo(String fieldFlexKey, SWCPageCache pageCache) {
        Map<String, String> tableInfo = this.getSelectedNodeInfo(pageCache);
        FieldMapLabelEntity fieldInfo = this.decodeFieldMapLabelEntity(tableInfo.get(fieldFlexKey));
        return fieldInfo;
    }

    private Map<String, String> getSelectedNodeInfo() {
        SWCPageCache cache = this.getSWCPageCache();
        return this.getSelectedNodeInfo(cache);
    }

    private Map<String, String> getSelectedNodeInfo(SWCPageCache pageCache) {
        Map tableInfo = (Map)pageCache.get(this.getSelectedTreeNodeId(), Map.class);
        if (null == tableInfo || tableInfo.isEmpty()) {
            return new HashMap<String, String>(1);
        }
        return tableInfo;
    }

    private String getSelectedTreeNodeId() {
        TreeView pairTree = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        return this.getSelectedTreeNode(pairTree);
    }

    private boolean matchWithLocaleAndSearch(IDataEntityProperty property, String searchText) {
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return true;
        }
        String displayName = FieldMapConfDrawPageUtil.getPropDisplayName((DynamicProperty)property);
        return StringUtils.isNotBlank((CharSequence)displayName) && StringUtils.contains((CharSequence)displayName, (CharSequence)searchText);
    }

    private boolean matchSearch(String displayName, String searchText) {
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return true;
        }
        return displayName.contains(searchText);
    }

    private boolean matchWithLocaleAndSearch(String sourceFieldName, String targetFieldName, String searchText) {
        return this.matchSearch(sourceFieldName, searchText) || this.matchSearch(targetFieldName, searchText);
    }

    private void appendMappedField(FieldMapLabelEntity source, FieldMapLabelEntity target, FlexPanelAp fieldsContainerFlexAp, String searchText) {
        FlexPanelAp fieldFlexAp = FieldMapConfDrawPageUtil.combineUnselectedMappedFieldAp(source, target);
        this.cacheMappedFieldInfo(fieldFlexAp.getKey(), source, target);
        if (this.matchWithLocaleAndSearch(source.getFieldName(), target.getFieldName(), searchText)) {
            fieldsContainerFlexAp.getItems().add(fieldFlexAp);
        }
    }

    private void cacheMappedFieldInfo(String key, FieldMapLabelEntity source, FieldMapLabelEntity target) {
        SWCPageCache pageCache = this.getSWCPageCache();
        Map<String, String> treeNodeInfo = this.getSelectedNodeInfo(pageCache);
        FieldMapLabelEntity fieldFlexInfo = this.decodeFieldMapLabelEntity(treeNodeInfo.get(key));
        if (null != fieldFlexInfo) {
            return;
        }
        target.setIsMapped(true);
        target.setRelationEntityJson(this.encodeFieldMapLabelEntity(source));
        source.setIsMapped(true);
        source.setRelationEntityJson(this.encodeFieldMapLabelEntity(target));
        treeNodeInfo.put(key, this.encodeFieldMapLabelEntity(source));
        pageCache.put(this.getSelectedTreeNodeId(), treeNodeInfo);
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (this.isClickableFieldFlex(key)) {
            this.bindFieldFlexClick(key, args);
        }
    }

    private void bindFieldFlexClick(String key, OnGetControlArgs args) {
        Container container = new Container();
        container.setKey(key);
        container.setView(this.getView());
        container.addClickListener((ClickListener)this);
        args.setControl((Control)container);
    }

    private boolean isClickableFieldFlex(String key) {
        return key.contains("flex_fieldum") || key.contains("flex_fieldmm");
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)args.getEntryProp().getName())) {
            this.updateTreeView();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals(UNMAP) && this.isClickYes(messageBoxClosedEvent)) {
            this.unmapSelectedFields();
            this.updateTreeView();
            return;
        }
        if (callBackId.contains(DELETE_ROW) && this.isClickYes(messageBoxClosedEvent)) {
            int[] selectRowIndex = this.getSelectRowIndex();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            this.getModel().deleteEntryRows("entryentity", selectRowIndex);
            return;
        }
        if (callBackId.contains(METADATA_GRP_BACK) || callBackId.contains(TARGET_OBJECT_BACK)) {
            String cacheId = this.getCacheIdByCallBackId(callBackId);
            String position = this.getPositionByCallBackId(callBackId);
            if (this.isClickYes(messageBoxClosedEvent)) {
                this.resetIfChangedMetaDataGroup(cacheId);
            } else {
                this.rollbackEntityDataByCacheIdAndPosition(cacheId, position);
            }
            this.updateTreeView();
        }
        if (PAY_ROLL_ACT.equals(callBackId)) {
            if (this.isClickYes(messageBoxClosedEvent)) {
                this.clearEntryEnty();
            } else {
                this.setPayRollActOldValue();
            }
        }
    }

    private void setPayRollActOldValue() {
        this.swcPageCache = new SWCPageCache(this.getView());
        Object payRollAct = this.swcPageCache.get(PAY_ROLL_ACT, Long.class);
        this.getModel().beginInit();
        this.getModel().setValue(PAY_ROLL_ACT, payRollAct);
        this.getModel().endInit();
        this.getView().updateView(PAY_ROLL_ACT);
    }

    private void clearEntryEnty() {
        int length = this.getModel().getEntryEntity("entryentity").size();
        int[] rows = new int[length];
        for (int n = 0; n < length; ++n) {
            rows[n] = n;
        }
        this.getModel().deleteEntryRows("entryentity", rows);
    }

    private String getPositionByCallBackId(String callBackId) {
        return FORM_FIELD_TARGET_OBJECT;
    }

    private String getCacheIdByCallBackId(String callBackId) {
        if (callBackId.contains(METADATA_GRP_BACK)) {
            return MAP_KEY_OLD_GRP_VALUE;
        }
        return MAP_KEY_TARGET_OBJECT_VALUE;
    }

    private void resetIfChangedMetaDataGroup(String cacheId) {
        this.swcPageCache = this.getSWCPageCache();
        String oldMetaData = (String)this.getSWCPageCache().get(cacheId, String.class);
        if (StringUtils.isBlank((CharSequence)oldMetaData)) {
            return;
        }
        String[] strs = oldMetaData.split("#");
        IDataModel entryOperate = this.getModel();
        entryOperate.setEntryCurrentRowIndex("entryentity", Integer.parseInt(strs[1]));
        entryOperate.deleteEntryData(FORM_FIELD_MAP);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(Integer.parseInt(strs[1]));
        String targetName = dynamicObject.getString("entityobject.id");
        this.swcPageCache.remove(this.getNodeId(targetName, strs[0]));
    }

    private boolean isClickYes(MessageBoxClosedEvent messageBoxClosedEvent) {
        return StringUtils.equals((CharSequence)"Yes", (CharSequence)messageBoxClosedEvent.getResultValue());
    }

    private void rollbackEntityDataByCacheIdAndPosition(String cacheId, String position) {
        this.swcPageCache = this.getSWCPageCache();
        String cacheValue = (String)this.swcPageCache.get(cacheId, String.class);
        String[] strs = cacheValue.split("#");
        this.getModel().beginInit();
        this.getView().getModel().setValue(position, (Object)strs[0], Integer.parseInt(strs[1]));
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void rollbackDataByCacheIdAndPosition(String cacheId, String position) {
        this.swcPageCache = this.getSWCPageCache();
        String cacheValue = (String)this.swcPageCache.get(cacheId, String.class);
        String[] strs = cacheValue.split("#");
        this.getModel().beginInit();
        this.getView().getModel().setValue(position, (Object)strs[0]);
        this.getModel().endInit();
        this.getView().updateView(position);
    }

    private void showUnmapConfirm() {
        SWCPageCache pageCache = this.getSWCPageCache();
        List<String> selectedFields = this.getSelectedMappedFields(pageCache);
        if (CollectionUtils.isEmpty(selectedFields)) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u89e3\u9664\u5173\u8054\u7684\u5b57\u6bb5\u3002", (String)"FileMapManagerEdit_7", (String)PROJECT_RESOURCE, (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u89e3\u9664\u5173\u8054\uff1f", (String)"FileMapManagerEdit_5", (String)PROJECT_RESOURCE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(UNMAP, (IFormPlugin)this));
    }

    private DynamicObject getDynamicObjByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId) || !StringUtils.contains((CharSequence)nodeId, (CharSequence)"#")) {
            return null;
        }
        String[] tableNumbers = nodeId.split("#");
        String targetObject = tableNumbers[0];
        String metadata = tableNumbers[1];
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        return entryEntity.stream().filter(dynamicObject -> StringUtils.equals((CharSequence)targetObject, (CharSequence)dynamicObject.getString("entityobject.ID")) && StringUtils.equals((CharSequence)metadata, (CharSequence)dynamicObject.getString("apideploy.id"))).findFirst().orElse(null);
    }

    private Integer getIndexFromEntityByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId) || !StringUtils.contains((CharSequence)nodeId, (CharSequence)"#")) {
            return null;
        }
        String[] tableNumbers = nodeId.split("#");
        String targetObject = tableNumbers[0];
        String metadata = tableNumbers[1];
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject object = (DynamicObject)entryEntity.get(i);
            if (!StringUtils.equals((CharSequence)targetObject, (CharSequence)object.getString("entityobject.ID")) || !StringUtils.equals((CharSequence)metadata, (CharSequence)object.getString("apideploy.id"))) continue;
            return i;
        }
        return null;
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String key = search.getKey();
        String searchText = evt.getText();
        String nodeId = this.getSelectedTreeNodeId();
        if (StringUtils.isBlank((CharSequence)nodeId) || !StringUtils.contains((CharSequence)nodeId, (CharSequence)"#")) {
            return;
        }
        String[] tableNumbers = nodeId.split("#");
        String sourceTable = tableNumbers[0];
        String targetTable = tableNumbers[1];
        switch (key) {
            case "search_source": {
                this.drawUnmappedObjectFieldContainer(sourceTable, searchText);
                break;
            }
            case "search_target": {
                this.drawUnmappedApiDataFieldContainer(Long.valueOf(targetTable), searchText);
                break;
            }
            case "mapped_target": {
                this.drawMappedFieldContainer(sourceTable, Long.valueOf(targetTable), searchText, nodeId);
                break;
            }
        }
    }

    public void cellClick(CellClickEvent arg0) {
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

