/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.formula;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsbp.business.formula.utils.EnumConfigCacheUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class EnumConfigEdit
extends AbstractFormPlugin {
    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        Boolean issyspreset = dynamicObject.getBoolean("issyspreset");
        FormShowParameter form = this.getView().getFormShowParameter();
        if (issyspreset.booleanValue()) {
            form.setStatus(OperationStatus.VIEW);
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name", "entryentity", "del", "add"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        String newValue = "";
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"enumvalue")) {
            ChangeData data = args.getChangeSet()[0];
            newValue = (String)data.getNewValue();
            this.isEnumConfigRepeat(newValue, "enumvalue");
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"enumname")) {
            ChangeData data = args.getChangeSet()[0];
            DynamicObjectCollection dataObjs = (DynamicObjectCollection)data.getNewValue();
            for (DynamicObject dynamicObject : dataObjs) {
                if (!this.isLocalStr(dynamicObject.get("localeid").toString())) continue;
                newValue = dynamicObject.getString("enumname");
                this.isEnumConfigRepeat(newValue, "enumname");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        DynamicObject obj = this.getModel().getDataEntity();
        if (SWCStringUtils.equals((String)opKey, (String)"save")) {
            Long id = obj.getLong("id");
            EnumConfigCacheUtils.putEnumValueToCache((Long)id);
        }
    }

    private void isEnumConfigRepeat(String newValue, String feild) {
        int count = 0;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!ObjectUtils.isEmpty((Object)entryEntity)) {
            for (DynamicObject dynamicObject : entryEntity) {
                String fieldAlias = dynamicObject.getString(feild);
                if (!StringUtils.isNotBlank((CharSequence)fieldAlias) || !StringUtils.equals((CharSequence)fieldAlias, (CharSequence)newValue)) continue;
                ++count;
            }
            if (count > 1) {
                this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u503c[%s]\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (String)"EnumConfigEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), newValue));
                return;
            }
        }
    }

    private boolean isLocalStr(String localid) {
        String str = RequestContext.get().getLang().getLocale().toString();
        return str.equals(localid);
    }
}

