/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.formula.function;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.swc.hsbp.business.formula.utils.FormulaCacheUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.business.formula.FuncDefineSplitHelper;

public class FuncDefineEdit
extends SWCDataBaseEdit {
    private static final String DEFINE = "define";
    private static final String FUNCDATATYPE = "funcdatatype";
    private static final String PARAMDATATYPE = "paramdatatype";
    private static final String ENTRYENTITY = "entryentity";
    private static final String CODEEDIT = "codeeditap";
    private static final String FUNCEXP = "funcexp";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getModel().setDataChanged(false);
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        Boolean issyspreset = dynamicObject.getBoolean("issyspreset");
        String uniquecode = dynamicObject.getString("uniquecode");
        if (issyspreset.booleanValue()) {
            FormShowParameter form = this.getView().getFormShowParameter();
            form.setStatus(OperationStatus.VIEW);
        } else if (SWCStringUtils.isNotEmpty((String)uniquecode)) {
            this.checkFuncIsUsed(uniquecode);
        }
    }

    private void checkFuncIsUsed(String uniquecode) {
        ArrayList<String> itemUniqueCodeList = new ArrayList<String>(1);
        itemUniqueCodeList.add(uniquecode);
        Map itemRelMap = FormulaCacheUtils.checkItemIsUsedForFormula(itemUniqueCodeList, (String)"FC");
        Set formulaNameSet = (Set)itemRelMap.get(uniquecode);
        if (formulaNameSet != null && formulaNameSet.size() > 0) {
            FormShowParameter form = this.getView().getFormShowParameter();
            form.setStatus(OperationStatus.VIEW);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fd\u6570\u5df2\u88ab\u8ba1\u7b97\u516c\u5f0f\u5f15\u7528\uff0c\u65e0\u6cd5\u4fee\u6539\uff0c\u5982\u9700\u8981\u66f4\u65b0\u51fd\u6570\uff0c\u8bf7\u53e6\u5916\u65b0\u5efa\u51fd\u6570\u7136\u540e\u4fee\u6539\u8ba1\u7b97\u516c\u5f0f\u5f15\u7528\u65b0\u7684\u51fd\u6570\u3002", (String)"FuncDefineEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        CodeEdit codeEdit = (CodeEdit)this.getView().getControl(CODEEDIT);
        String funcexp = this.getModel().getDataEntity().getString(FUNCEXP);
        codeEdit.setText(funcexp);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)"save")) {
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl(CODEEDIT);
            try {
                String funcExp = FuncDefineSplitHelper.formatMethodExp((String)codeEdit.getText().trim());
                this.getModel().setValue(FUNCEXP, (Object)funcExp);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
                args.setCancel(true);
                return;
            }
            String number = this.getModel().getDataEntity().getString("number");
            this.getModel().setValue("uniquecode", (Object)("FC_" + number));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)"deleteentry") || SWCStringUtils.equals((String)operate.getOperateKey(), (String)"moveentryup") || SWCStringUtils.equals((String)operate.getOperateKey(), (String)"moveentrydown")) {
            this.createFunctionCode();
        } else if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)"save")) {
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl(CODEEDIT);
            String funcexp = this.getModel().getDataEntity().getString(FUNCEXP);
            codeEdit.setText(funcexp);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        switch (fieldKey = args.getProperty().getName()) {
            case "define": 
            case "funcdatatype": 
            case "paramdatatype": {
                this.createFunctionCode();
                break;
            }
        }
    }

    private void createFunctionCode() {
        DynamicObject data = this.getModel().getDataEntity();
        String funcname = data.getString(DEFINE);
        String datatype = data.getString(FUNCDATATYPE);
        CodeEdit codeEdit = (CodeEdit)this.getView().getControl(CODEEDIT);
        if (StringUtils.isEmpty((CharSequence)funcname)) {
            return;
        }
        StringBuilder funccode = new StringBuilder();
        funccode.append("public ").append(datatype == null ? "void" : datatype).append(' ').append(funcname).append('(');
        DynamicObjectCollection parameterList = this.getModel().getEntryEntity(ENTRYENTITY);
        String parameterType = null;
        String parameterName = null;
        if (parameterList != null && parameterList.size() > 0) {
            int seq = 0;
            for (DynamicObject parameter : parameterList) {
                parameterType = parameter.getString(PARAMDATATYPE);
                seq = parameter.getInt("seq");
                parameterName = "param" + seq;
                if (SWCStringUtils.isEmpty((String)parameterType)) continue;
                if (seq == parameterList.size()) {
                    funccode.append(parameterType).append(' ').append(parameterName);
                    continue;
                }
                funccode.append(parameterType).append(' ').append(parameterName).append(',');
            }
        }
        String funcExp = codeEdit.getText();
        funccode.append(") {").append('\n');
        if (StringUtils.isEmpty((CharSequence)funcExp)) {
            funccode.append(' ').append("return").append(datatype == null ? ";" : " null;").append('\n');
            funccode.append('}');
        } else {
            funccode.append(' ').append(FuncDefineSplitHelper.createMethodExp((String)funcExp));
        }
        codeEdit.setText(funccode.toString());
    }

    public void beforeClosed(BeforeClosedEvent event) {
        String funcexp;
        CodeEdit codeEdit = (CodeEdit)this.getView().getControl(CODEEDIT);
        String value = codeEdit.getText();
        if (!SWCStringUtils.equals((String)value, (String)(funcexp = this.getModel().getDataEntity().getString(FUNCEXP)))) {
            this.getModel().setValue(FUNCEXP, (Object)value);
            event.setCancel(true);
            OperateOption operateOption = OperateOption.create();
            this.getView().invokeOperation("close", operateOption);
        }
    }
}

