/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.formula.item;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ItemDefineFiltersPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(ItemDefineFiltersPlugin.class);

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String oper = (String)showParam.getCustomParam("oper");
        if (StringUtils.isBlank((CharSequence)oper) && !"modify".equals(oper) && !"add".equals(oper)) {
            return;
        }
        Object initdata = showParam.getCustomParam("initdata");
        if (initdata == null) {
            return;
        }
        Map oldData = (Map)initdata;
        this.initFilterCondition((String)oldData.get("queryNumber"));
        Object datafilter = oldData.get("datafilter");
        if (!SWCObjectUtils.isEmpty(datafilter)) {
            this.setDataFilter(datafilter.toString());
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String oper = (String)showParam.getCustomParam("oper");
        if (StringUtils.isBlank((CharSequence)oper) && !"modify".equals(oper) && !"add".equals(oper)) {
            return;
        }
        Object initdata = showParam.getCustomParam("initdata");
        if (initdata == null) {
            return;
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            try {
                this.returnDataToParentAndClose();
            }
            catch (IOException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
            catch (RuntimeException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        } else if ("btncancel".equals(key)) {
            this.getView().close();
        }
    }

    private void returnDataToParentAndClose() throws IOException {
        Map<String, Object> data = this.getDataFilter();
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(data));
        this.getView().close();
    }

    private Map<String, Object> getDataFilter() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        FilterGrid filterGrid = (FilterGrid)this.getControl("filterGridap");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filteList = filterCondition.getFilterRow();
        if (filteList == null || filteList.isEmpty()) {
            return null;
        }
        String filterJson = SerializationUtils.toJsonString((Object)filterCondition);
        data.put("datafilter", filterJson);
        return data;
    }

    private void setDataFilter(String dataFilter) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)dataFilter, FilterCondition.class);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filterGridap");
        filterGrid.SetValue(filterCondition);
        filterGrid.getFilterGridState().setState(filterCondition);
    }

    private void initFilterCondition(String queryNum) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.getFilterRow().clear();
        List filterColumns = new ArrayList(10);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)queryNum);
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        ArrayList<String> fieldIds = new ArrayList<String>(10);
        if (dataEntityType instanceof QueryEntityType) {
            QueryEntityType queryEntityType = (QueryEntityType)dataEntityType;
            filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)queryEntityType);
            List childEntities = queryEntityType.getJoinEntitys();
            for (JoinEntity joinEntity : childEntities) {
                fieldMap.put(joinEntity.getAlias(), joinEntity.getDisplayName());
            }
            List selectFields = queryEntityType.getSelectFields();
            Iterator iterator = selectFields.iterator();
            while (iterator.hasNext()) {
                QuerySelectField querySelectField = (QuerySelectField)iterator.next();
                fieldIds.add(querySelectField.getAlias());
            }
        } else {
            filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)dataEntityType);
            Map allEntities = dataEntityType.getAllEntities();
            allEntities.keySet().forEach(param -> fieldMap.put(((EntityType)allEntities.get(param)).getAlias(), (String)((EntityType)allEntities.get(param)).getDisplayName()));
            Map fieldsMap = dataEntityType.getFields();
            for (Map.Entry entry : fieldsMap.entrySet()) {
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)entry.getValue();
                if (!ObjectUtils.isNotEmpty((Object)iDataEntityProperty)) continue;
                fieldIds.add(iDataEntityProperty.getName());
            }
        }
        ArrayList<Map> filterList = new ArrayList<Map>(10);
        for (Map map : filterColumns) {
            String string = (String)map.get("fieldName");
            if (!fieldIds.contains(string)) continue;
            boolean filterTag = false;
            for (Map.Entry entry : fieldMap.entrySet()) {
                String pattern;
                if (string.equals((String)entry.getKey() + ".number") || string.equals((String)entry.getKey() + ".name")) {
                    filterTag = true;
                }
                if (Pattern.matches(pattern = (String)entry.getKey() + "\\.(\\w)*number", string)) {
                    filterTag = true;
                }
                if (!string.startsWith((String)entry.getKey())) continue;
                String fieldCaption = (String)map.get("fieldCaption");
                int index = fieldCaption.indexOf(46) > 0 ? fieldCaption.indexOf(46) : 0;
                String result = fieldCaption.substring(index);
                map.put("fieldCaption", entry.getValue() + result);
            }
            if (!filterTag) {
                filterList.add(map);
                continue;
            }
            logger.info("\u6392\u9664\u8fc7\u6ee4\u5b57\u6bb5:%s", map.get("fieldCaption"));
        }
        filterGrid.setFilterColumns(filterList);
        filterGrid.setEntityNumber(queryNum);
        filterGrid.SetValue(fc);
        this.getView().updateView("filtergridap");
    }
}

