/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.insurancemap;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class InsuranMappingItemValidateHandle
extends AbstractValidateHandler {
    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.AFTER;
    }

    private QFilter getItemFilter(List<String> salaryitemnumbers) {
        QFilter filter = new QFilter("salaryitemtype.id", "=", (Object)1393357138549742592L);
        filter.and("datatype.storagetype", "in", Arrays.asList("num", "amount"));
        filter.and("number", "in", salaryitemnumbers);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        QFilter dataRuleForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"/UHLXNRR9KPZ", (String)"hsbs_insurproscheme", (String)"salaryitem", (String)"4730fc9f000003ae");
        if (dataRuleForBdProp != null) {
            filter.and(dataRuleForBdProp);
        }
        return filter;
    }

    public void validate(List<ImportBillData> list, ImportLog importLog) {
        ArrayList<String> insuranceitemnumbers = new ArrayList<String>(10);
        ArrayList<String> salaryitemnumbers = new ArrayList<String>(10);
        HashSet<String> orgNumbers = new HashSet<String>(16);
        for (ImportBillData billData : list) {
            JSONObject data = billData.getData().getJSONObject("hsbs_insurproscheme");
            JSONArray entityentity = data.getJSONArray("entityentity");
            if (entityentity == null) continue;
            for (int i = 0; i < entityentity.size(); ++i) {
                JSONObject orgData;
                String orgNumber;
                JSONObject salaryitem;
                String salaryitemNumber;
                JSONObject entryData = entityentity.getJSONObject(i);
                String insuranceitemnumber = entryData.getString("insuranceitemnumber");
                if (SWCStringUtils.isNotEmpty((String)insuranceitemnumber)) {
                    insuranceitemnumbers.add(insuranceitemnumber);
                }
                String string = salaryitemNumber = (salaryitem = entryData.getJSONObject("salaryitem")) == null ? null : salaryitem.getString("number");
                if (SWCStringUtils.isNotEmpty((String)salaryitemNumber)) {
                    salaryitemnumbers.add(salaryitemNumber);
                }
                String string2 = orgNumber = (orgData = data.getJSONObject("org")) == null ? null : orgData.getString("number");
                if (!SWCStringUtils.isNotEmpty((String)orgNumber)) continue;
                orgNumbers.add(orgNumber);
            }
        }
        SWCDataServiceHelper insuranceItemhelper = new SWCDataServiceHelper("sitbs_insuranceitem");
        QFilter insuranceItemfilter = new QFilter("number", "in", insuranceitemnumbers);
        insuranceItemfilter.and("status", "=", (Object)"C");
        insuranceItemfilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection insuranceitems = insuranceItemhelper.queryOriginalCollection("id,number,datatype.storagetype,country.number", insuranceItemfilter.toArray());
        Map<String, DynamicObject> insuranceitemMap = insuranceitems.stream().collect(Collectors.toMap(o -> o.getString("number"), o -> o, (v1, v2) -> v1));
        SWCDataServiceHelper salaryItemHelper = new SWCDataServiceHelper("hsbs_salaryitem");
        DynamicObjectCollection salaryItems = salaryItemHelper.queryOriginalCollection("id,number,datatype.storagetype,areatype,country.number", this.getItemFilter(salaryitemnumbers).toArray());
        SWCDataServiceHelper orgHelper = new SWCDataServiceHelper("bos_org");
        DynamicObjectCollection orgs = orgHelper.queryOriginalCollection("id,number", new QFilter("number", "in", orgNumbers).toArray());
        HashMap orgSalaryItemMap = new HashMap(16);
        Map<String, DynamicObject> salaryitemMap = salaryItems.stream().collect(Collectors.toMap(o -> o.getString("number"), o -> o, (v1, v2) -> v1));
        Map<String, DynamicObject> orgMap = orgs.stream().collect(Collectors.toMap(o -> o.getString("number"), o -> o, (v1, v2) -> v1));
        for (ImportBillData billData : list) {
            JSONObject data = billData.getData().getJSONObject("hsbs_insurproscheme");
            JSONObject country = data.getJSONObject("country");
            String countryNumber = country == null ? null : country.getString("number");
            JSONObject org = data.getJSONObject("org");
            String orgNumber = org == null ? null : org.getString("number");
            JSONArray entityentity = data.getJSONArray("entityentity");
            HashSet<String> existSalaryNumbers = new HashSet<String>(16);
            if (entityentity == null) continue;
            for (int i = 0; i < entityentity.size(); ++i) {
                long salaryItemId;
                String errorMsg;
                JSONObject entryData = entityentity.getJSONObject(i);
                ConcurrentHashMap rowErrors = importLog.getRowErrors();
                ConcurrentHashMap errMap = (ConcurrentHashMap)rowErrors.get(billData.getSheetName());
                JSONObject salaryitem = entryData.getJSONObject("salaryitem");
                String salaryitemNumber = null;
                if (salaryitem != null) {
                    salaryitemNumber = salaryitem.getString("number");
                }
                if (SWCStringUtils.isEmpty(salaryitemNumber)) continue;
                DynamicObject salaryItem = salaryitemMap.get(salaryitemNumber);
                if (salaryItem == null) {
                    if (errMap != null && errMap.get(entryData.getInteger("$excelIndex")) != null) continue;
                    errorMsg = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u4e0d\u5b58\u5728\u3002\u53ef\u80fd\u7684\u539f\u56e0\u6709\uff1a1.\u65e0\u5df2\u5ba1\u6838\u3001\u53ef\u7528\u7684\u85aa\u916c\u9879\u76ee\uff1b2.\u85aa\u916c\u9879\u76ee\u7c7b\u522b\u975e\u201c\u793e\u4f1a\u4fdd\u9669\u6263\u51cf\u201d\uff1b3.\u85aa\u916c\u9879\u76ee\u6570\u636e\u7c7b\u578b\u4e0d\u4e3a\u91d1\u989d\u6216\u6570\u503c\u7c7b\u578b\u3002", (String)"InsuranMappingItemValidateHandle_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
                    importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), entryData.getInteger("$excelIndex").intValue(), errorMsg);
                    continue;
                }
                if (!existSalaryNumbers.add(salaryitemNumber)) {
                    errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u85aa\u916c\u9879\u76ee\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"InsuranMappingItemValidateHandle_1", (String)"swc-hsbs-formplugin", (Object[])new Object[]{salaryitemNumber});
                    importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), entryData.getInteger("$excelIndex").intValue(), errorMsg);
                    continue;
                }
                Set canUseItems = (Set)orgSalaryItemMap.get(orgNumber);
                DynamicObject orgObj = orgMap.get(orgNumber);
                if (orgObj == null) continue;
                if (canUseItems == null) {
                    QFilter salaryItemFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (Long)orgObj.getLong("id"));
                    DynamicObjectCollection canUseItemObjs = salaryItemHelper.queryOriginalCollection("id", salaryItemFilter.toArray());
                    canUseItems = canUseItemObjs.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                    orgSalaryItemMap.put(orgNumber, canUseItems);
                }
                if (!canUseItems.contains(salaryItemId = salaryItem.getLong("id"))) {
                    String errorMsg2 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u4e0d\u5728\u5f53\u524d\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u8303\u56f4\u5185\u3002", (String)"InsuranMappingItemValidateHandle_6", (String)"swc-hsbs-formplugin", (Object[])new Object[]{salaryitemNumber});
                    importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), entryData.getInteger("$excelIndex").intValue(), errorMsg2);
                    continue;
                }
                String areatype = salaryItem.getString("areatype");
                if (SWCStringUtils.equals((String)areatype, (String)"2") && !SWCStringUtils.equals((String)salaryItem.getString("country.number"), (String)countryNumber)) {
                    String errorMsg3 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u7684\u56fd\u5bb6\u5730\u533a\u7c7b\u578b\u4e0d\u4e3a\u901a\u7528\u6216\u6307\u5b9a\u65f6\uff0c\u4e0d\u5728\u7ef4\u62a4\u7684\u56fd\u5bb6\u5730\u533a\u5185\u3002\u56fd\u5bb6\u5730\u533a\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"InsuranMappingItemValidateHandle_2", (String)"swc-hsbs-formplugin", (Object[])new Object[]{salaryitemNumber});
                    importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), entryData.getInteger("$excelIndex").intValue(), errorMsg3);
                    continue;
                }
                String insuranceitemnumber = entryData.getString("insuranceitemnumber");
                if (!SWCStringUtils.isNotEmpty((String)insuranceitemnumber)) continue;
                DynamicObject insuranceitem = insuranceitemMap.get(insuranceitemnumber);
                if (insuranceitem == null) {
                    String errorMsg4 = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u9669\u79cd\u9879\u76ee\u3002", (String)"InsuranMappingItemValidateHandle_3", (String)"swc-hsbs-formplugin", (Object[])new Object[]{salaryitemNumber});
                    importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), entryData.getInteger("$excelIndex").intValue(), errorMsg4);
                    continue;
                }
                if (!SWCStringUtils.equals((String)insuranceitem.getString("datatype.storagetype"), (String)salaryItem.getString("datatype.storagetype"))) {
                    String errorMsg5 = ResManager.loadKDString((String)"\u9669\u79cd\u9879\u76ee\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u85aa\u916c\u9879\u76ee\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u540c\uff0c\u9700\u4fdd\u6301\u4e00\u81f4\u3002", (String)"InsuranMappingItemValidateHandle_4", (String)"swc-hsbs-formplugin", (Object[])new Object[]{salaryitemNumber});
                    importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), entryData.getInteger("$excelIndex").intValue(), errorMsg5);
                    continue;
                }
                if (!SWCStringUtils.equals((String)insuranceitem.getString("country.number"), (String)countryNumber)) {
                    String errorMsg6 = ResManager.loadKDString((String)"\u9669\u79cd\u9879\u76ee\u7684\u56fd\u5bb6\u5730\u533a\u4e0d\u5728\u7ef4\u62a4\u7684\u56fd\u5bb6\u5730\u533a\u5185\uff0c\u6216\u56fd\u5bb6\u5730\u533a\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"InsuranMappingItemValidateHandle_5", (String)"swc-hsbs-formplugin", (Object[])new Object[]{salaryitemNumber});
                    importLog.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), entryData.getInteger("$excelIndex").intValue(), errorMsg6);
                    continue;
                }
                entryData.put("insuranceitem", (Object)insuranceitem.getLong("id"));
            }
        }
    }
}

