/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.insurancemap;

import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.ext.hr.metadata.form.control.Hint;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.datachanged.BizChangedHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.business.insurance.service.SInsurBaseFetchCfgService;
import kd.swc.hsbs.common.enums.HSBSErrorInfoEnum;

public class InsuranceBaseFetchCfgEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(InsuranceBaseFetchCfgEdit.class);
    private static final String BASE_FETCH_ITEM_NAME = "basefetchitemname";
    private static final String ACCUMULATOR = "accumulator";
    private static final String SALARY_STD_ITEM = "standarditem";

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{BASE_FETCH_ITEM_NAME});
        BasedataEdit accumulator = (BasedataEdit)this.getControl(ACCUMULATOR);
        accumulator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit salaryStdItem = (BasedataEdit)this.getControl(SALARY_STD_ITEM);
        salaryStdItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.addDefaultHint();
    }

    public void beforeBindData(EventObject eventObject) {
        OperationStatus operationStatus;
        this.addDefaultHint();
        if (Boolean.TRUE.toString().equals(this.getView().getFormShowParameter().getCustomParam("hideHisversion"))) {
            TextEdit hisversion = (TextEdit)this.getControl("hisversion");
            hisversion.setVisible(null, false);
        }
        Boolean numberEnabled = (OperationStatus.ADDNEW.equals((Object)(operationStatus = this.getView().getFormShowParameter().getStatus())) || OperationStatus.EDIT.equals((Object)operationStatus)) && !BaseDataHisHelper.isHisList((IFormView)this.getView());
        this.getView().setEnable(numberEnabled, new String[]{"number"});
        this.baseFetchItem();
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "basefetchitemname": {
                DynamicObject dyObj = this.getModel().getDataEntity(true);
                Long countryId = dyObj.getLong("country.id");
                QFilter auditAndEnableFilter = new QFilter("enable", "=", (Object)"1");
                auditAndEnableFilter.and("status", "=", (Object)"C");
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
                qFilters.add(new QFilter("country", "=", (Object)countryId));
                qFilters.add(auditAndEnableFilter);
                ListFilterParameter listFilterParameter = new ListFilterParameter(qFilters, (String)null);
                ListShowParameter para = ShowFormHelper.createShowListForm((String)"sitbs_basefetchitem", (boolean)false);
                para.setListFilterParameter(listFilterParameter);
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sitbs_basefetchitem"));
                this.getView().showForm((FormShowParameter)para);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        long countryId = this.getModel().getDataEntity(true).getLong("country.id");
        QFilter qFilter = new QFilter("country.id", "in", Arrays.asList(0L, countryId));
        if (ACCUMULATOR.equals(beforeF7SelectEvent.getProperty().getName())) {
            long createOrgId = this.getModel().getDataEntity(true).getLong("createorg.id");
            if (createOrgId == 0L) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(HSBSErrorInfoEnum.BASE_FETCH_CFG_FOR_MUST_INPUT_CREATE_ORG_FIRST.getErrCode());
                return;
            }
            qFilter.and(SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_accumulator", (Long)createOrgId));
            beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(qFilter));
        } else if (SALARY_STD_ITEM.equals(beforeF7SelectEvent.getProperty().getName())) {
            beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(qFilter));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        IDataEntityProperty property = e.getProperty();
        if ("fetchsrc".equals(property.getName())) {
            Object oldValue = changeSet[0].getOldValue();
            Object newValue2 = changeSet[0].getNewValue();
            if (oldValue instanceof String && SWCStringUtils.isNotEmpty((String)((String)oldValue)) && !String.valueOf(oldValue).equals(newValue2)) {
                ComboProp comboProp = (ComboProp)property;
                String currFetchSrc = (String)newValue2;
                this.resetFetchSrc(comboProp, currFetchSrc);
            }
        } else if (BASE_FETCH_ITEM_NAME.equals(property.getName()) && SWCStringUtils.isEmpty((String)(newValue = (String)changeSet[0].getNewValue()))) {
            this.getModel().setValue("basefetchitem", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "auditconfirmchange": 
            case "confirmchange": 
            case "changesave": {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                String baseFetchItemName = dataEntity.getString(BASE_FETCH_ITEM_NAME);
                if (SWCStringUtils.isEmpty((String)baseFetchItemName)) {
                    dataEntity.set("basefetchitem", null);
                    BizChangedHelper.operateBizChangedSet((DynamicObject)dataEntity, Collections.singletonList("basefetchitem"), (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.DELETE);
                    return;
                }
                if (dataEntity.getLong("basefetchitem") == 0L) {
                    Table baseFetchItemInfoTable = SInsurBaseFetchCfgService.getBaseFetchItemInfoByName(Collections.singletonList(baseFetchItemName));
                    Object baseFetchItemIdObj = baseFetchItemInfoTable.get((Object)baseFetchItemName, (Object)"id");
                    if (!(baseFetchItemIdObj instanceof Long) || Long.valueOf(0L).equals(baseFetchItemIdObj)) {
                        args.setCancel(true);
                        this.getView().showErrorNotification(HSBSErrorInfoEnum.BASE_FETCH_CFG_FOR_ITEM_NOT_EXISTS.getInfo(new Object[]{baseFetchItemName}));
                        this.getModel().setValue("basefetchitem", null);
                        return;
                    }
                    dataEntity.set("basefetchitem", baseFetchItemIdObj);
                    BizChangedHelper.operateBizChangedSet((DynamicObject)dataEntity, Collections.singletonList("basefetchitem"), (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.DELETE);
                }
                OperateOption option = formOperate.getOption();
                option.setVariableValue("isDetail", Boolean.TRUE.toString());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection selRow;
        if ("sitbs_basefetchitem".equals(evt.getActionId()) && (selRow = (ListSelectedRowCollection)evt.getReturnData()) != null && !selRow.isEmpty()) {
            this.getModel().setValue(BASE_FETCH_ITEM_NAME, (Object)selRow.get(0).getName());
            this.getModel().setValue("basefetchitem", selRow.get(0).getPrimaryKeyValue());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        BizChangedHelper.operateBizChangedSet((DynamicObject)this.getModel().getDataEntity(true), Collections.singletonList("basefetchitem"), (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.DELETE);
    }

    private void baseFetchItem() {
        Map fetchItemInfo;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long baseFetchItemId = dataEntity.getLong("basefetchitem");
        if (baseFetchItemId == 0L) {
            return;
        }
        Map reslutMap = SInsurBaseFetchCfgService.getBaseFetchItemInfoByStatus((Collection)Lists.newArrayList((Object[])new Long[]{baseFetchItemId}), (int)1);
        if (reslutMap != null && reslutMap.get(baseFetchItemId) != null && (fetchItemInfo = (Map)reslutMap.get(baseFetchItemId)) != null && !fetchItemInfo.isEmpty()) {
            this.getModel().setValue(BASE_FETCH_ITEM_NAME, fetchItemInfo.get("name"));
        }
        this.getView().getModel().setDataChanged(false);
    }

    private void resetFetchSrc(ComboProp comboProp, String currFetchSrc) {
        List comboItems = comboProp.getComboItems();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (comboItems != null) {
            boolean fetchSrcEmpty = SWCStringUtils.isEmpty((String)currFetchSrc);
            for (ValueMapItem comboItem : comboItems) {
                if (!dataEntity.getDataEntityType().getProperties().containsKey((Object)comboItem.getValue())) continue;
                if (fetchSrcEmpty) {
                    this.getModel().setValue(comboItem.getValue(), null);
                    continue;
                }
                if (currFetchSrc.equals(comboItem.getValue())) continue;
                this.getModel().setValue(comboItem.getValue(), null);
            }
        }
    }

    private void addDefaultHint() {
        String hintContent;
        Hint hintAp = (Hint)this.getControl("hintap");
        if (hintAp != null && ((hintContent = hintAp.getHintContent()) == null || hintContent.trim().length() == 0)) {
            String contentInfo = HSBSErrorInfoEnum.BASE_FETCH_CFG_FOR_CFG_NOTICE_01.getInfo() + "<br/>" + HSBSErrorInfoEnum.BASE_FETCH_CFG_FOR_CFG_NOTICE_02.getInfo() + "<br/>" + HSBSErrorInfoEnum.BASE_FETCH_CFG_FOR_CFG_NOTICE_03.getInfo();
            hintAp.setHintContent(contentInfo);
        }
    }
}

