/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.insurancemap;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.expt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.swc.hsbs.business.insurance.service.SInsurBaseFetchCfgService;

public class InsuranceBaseFetchCfgHRExportPlugin
implements HRExportPlugin {
    private static final Log log = LogFactory.getLog(InsuranceBaseFetchCfgHRExportPlugin.class);

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        List headerWriterFormats = args.getHeaderWriterFormats();
        if (headerWriterFormats != null && headerWriterFormats.size() > 0) {
            headerWriterFormats.forEach(header -> {
                List fields;
                Map properties = header.getProperties();
                if (properties != null) {
                    properties.remove("basefetchitem");
                }
                if ((fields = header.getFields()) != null) {
                    fields.remove("basefetchitem");
                }
            });
        }
    }

    public void beforeWriteData(BeforeWriteDataEventArgs args) {
        List tplDataRows = args.getTplDataRows();
        if (tplDataRows == null || tplDataRows.size() == 0) {
            return;
        }
        HashSet fetchConfigIds = new HashSet(16);
        args.getRowDataPkIds().values().stream().map(mapItem -> mapItem.get("hsbs_sinsbsfetchcfg")).forEach(val -> {
            if (val instanceof Long) {
                fetchConfigIds.add((Long)val);
            } else if (val instanceof Collection) {
                fetchConfigIds.addAll((Collection)val);
            }
        });
        Map resultMap = SInsurBaseFetchCfgService.getBaseFetchItemDetailByCfg(fetchConfigIds, (int)1, (String)"number");
        if (resultMap == null || resultMap.isEmpty()) {
            log.info("InsuranceBaseFetchCfgHRExportPlugin.beforeWriteData: the result of 'getBaseFetchItemDetailByCfg' is null.");
            return;
        }
        for (Map row : tplDataRows) {
            String number = null;
            Map fetchItemMap = null;
            for (Map.Entry next : row.entrySet()) {
                Map map = (Map)next.getValue();
                if (map == null || map.isEmpty()) continue;
                String colKey = (String)map.get("key");
                if ("basefetchitemname".equals(colKey)) {
                    fetchItemMap = map;
                } else if ("number".equals(colKey)) {
                    number = (String)map.get("val");
                }
                if (number == null || fetchItemMap == null) continue;
                break;
            }
            if (number == null || fetchItemMap == null || resultMap.get(number) == null) continue;
            fetchItemMap.put("val", ((Map)resultMap.get(number)).get("name"));
        }
    }
}

