/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.insurancemap;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.enu.ValidatorEnum;
import kd.hr.impt.common.plugin.AfterValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.BeforeTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.swc.hsbs.business.insurance.service.SInsurBaseFetchCfgService;
import kd.swc.hsbs.formplugin.web.insurancemap.InsuranceBaseFetchCfgHRImportValidator;

public class InsuranceBaseFetchCfgHRImportPlugin
implements HRImportPlugin {
    private static final Log log = LogFactory.getLog(InsuranceBaseFetchCfgHRImportPlugin.class);

    public void afterValidate(AfterValidateEventArgs args) {
        List billDatas = args.getBillDatas();
    }

    public void beforeInitValidator(BeforeInitValidatorEventArgs args) {
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, (AbstractValidateHandler)new InsuranceBaseFetchCfgHRImportValidator());
    }

    public void beforeTemplateValidate(BeforeTemplateValidateEventArgs args) {
        Map entityFields = args.getEntityFields();
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        List importBillDatas = args.getImportBillDatas();
        Object[] baseFetchCfgObjs = args.getDynamicObjects();
        if (importBillDatas == null || importBillDatas.isEmpty() || baseFetchCfgObjs == null || baseFetchCfgObjs.length == 0) {
            return;
        }
        HashMap<Long, String> baseFetchCfgAndBaseFetchItemNameMap = new HashMap<Long, String>(16);
        for (ImportBillData importBillData : importBillDatas) {
            JSONObject data = importBillData.getData();
            Object pkId = importBillData.getPkId();
            if (data == null || !(pkId instanceof Long) || data.getJSONObject("hsbs_sinsbsfetchcfg") == null) continue;
            JSONObject baseFetchCfgJson = data.getJSONObject("hsbs_sinsbsfetchcfg");
            baseFetchCfgAndBaseFetchItemNameMap.put((Long)pkId, baseFetchCfgJson.getString("basefetchitemname"));
        }
        Table baseFetchItemInfoTable = SInsurBaseFetchCfgService.getBaseFetchItemInfoByName(baseFetchCfgAndBaseFetchItemNameMap.values());
        for (Object baseFetchCfgObj : baseFetchCfgObjs) {
            DynamicObject baseFetchCfgDy;
            String baseFetchItemName;
            Object baseFetchItemIdObj;
            if (!(baseFetchCfgObj instanceof DynamicObject) || !((baseFetchItemIdObj = baseFetchItemInfoTable.get((Object)(baseFetchItemName = (String)baseFetchCfgAndBaseFetchItemNameMap.get((baseFetchCfgDy = (DynamicObject)baseFetchCfgObj).getLong("id"))), (Object)"id")) instanceof Long) || !baseFetchCfgDy.getDataEntityType().getProperties().containsKey((Object)"basefetchitem")) continue;
            baseFetchCfgDy.set("basefetchitem", baseFetchItemIdObj);
        }
    }
}

