/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.insurancemap;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Table;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbs.business.insurance.service.SInsurBaseFetchCfgService;
import kd.swc.hsbs.common.enums.HSBSErrorInfoEnum;

public class InsuranceBaseFetchCfgHRImportValidator
extends AbstractValidateHandler {
    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.AFTER;
    }

    public void validate(List<ImportBillData> billDataList, ImportLog logger) {
        HashSet<String> validBaseFetchItemNames = new HashSet<String>(16);
        for (ImportBillData importBillData : billDataList) {
            JSONObject data = importBillData.getData();
            if (data.getJSONObject("hsbs_sinsbsfetchcfg") == null) continue;
            JSONObject baseFetchCfgJson = data.getJSONObject("hsbs_sinsbsfetchcfg");
            validBaseFetchItemNames.add(baseFetchCfgJson.getString("basefetchitemname"));
        }
        Table baseFetchItemTable = SInsurBaseFetchCfgService.getBaseFetchItemInfoByName(validBaseFetchItemNames);
        for (ImportBillData billData : billDataList) {
            JSONObject data = billData.getData();
            if (data.getJSONObject("hsbs_sinsbsfetchcfg") == null) continue;
            JSONObject baseFetchCfgJson = data.getJSONObject("hsbs_sinsbsfetchcfg");
            String baseFetchItemName = baseFetchCfgJson.getString("basefetchitemname");
            Map detailItemInfo = (Map)baseFetchItemTable.rowMap().get(baseFetchItemName);
            boolean isItemInvalid = SWCStringUtils.isNotEmpty((String)baseFetchItemName) && (detailItemInfo == null || !"C".equals(detailItemInfo.get("status")) || !"1".equals(detailItemInfo.get("enable")));
            if (!isItemInvalid) continue;
            logger.writeRowLog(billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), HSBSErrorInfoEnum.BASE_FETCH_CFG_FOR_ITEM_NOT_EXISTS_OR_UNAUDITED_DISABLED.getInfo(new Object[]{baseFetchItemName}));
        }
    }
}

