/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.insurancemap;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.common.util.GlobalParam;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbs.business.insurance.service.SInsurBaseFetchCfgService;

public class InsuranceBaseFetchCfgList
extends HRDataBaseList {
    private Log log = LogFactory.getLog(InsuranceBaseFetchCfgList.class);
    private final String SINSUR_BS_FETCH_IIEM_NAME = "basefetchitemname";
    private final String SINSUR_BS_FETCH_CFG_AND_ITEM_REF = "SINSUR_BS_FETCH_CFG_AND_ITEM_REF";

    public void setFilter(SetFilterEvent event) {
        event.setOrderBy("createtime desc,number asc");
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObjectCollection rows = event.getPageData();
        if (rows == null || rows.isEmpty()) {
            return;
        }
        List billIds = rows.stream().map(object -> object.getLong("id")).collect(Collectors.toList());
        Map resultMap = SInsurBaseFetchCfgService.getBaseFetchItemInfoByCfg(billIds, (int)1);
        GlobalParam.set((String)"SINSUR_BS_FETCH_CFG_AND_ITEM_REF", (Object)resultMap);
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        Map baseFetchCfgInfoMap = (Map)GlobalParam.get((String)"SINSUR_BS_FETCH_CFG_AND_ITEM_REF");
        if (baseFetchCfgInfoMap == null || baseFetchCfgInfoMap.isEmpty()) {
            return;
        }
        switch (columnDesc.getKey()) {
            case "basefetchitemname": {
                String billId = evt.getRowData().getString("id");
                Map baseFetchCfgInfo = (Map)baseFetchCfgInfoMap.get(billId);
                if (baseFetchCfgInfo == null || baseFetchCfgInfo.get("name") == null) break;
                evt.setFormatValue(baseFetchCfgInfo.get("name"));
                break;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent event) {
        BillShowParameter parameter = event.getParameter();
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        if (BaseDataHisHelper.isHisList((IFormView)this.getView())) {
            List listColumns = args.getListColumns();
            if (listColumns == null) {
                return;
            }
            StringJoiner hyperlinkFields = new StringJoiner(",");
            for (IListColumn listColumn : listColumns) {
                String listFieldKey = listColumn.getListFieldKey();
                if (!listColumn.isHyperlink() || !SWCStringUtils.isNotEmpty((String)listFieldKey) || "number".equals(listFieldKey) || "name".equals(listFieldKey)) continue;
                hyperlinkFields.add(listFieldKey);
            }
            if (hyperlinkFields.length() > 0) {
                this.getView().getFormShowParameter().setCustomParam("notOpenDefaultHyperLink", (Object)hyperlinkFields.toString());
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("basefetchitemname".equals(fieldName)) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            String baseFetchCfgIdStr = String.valueOf(listView.getFocusRowPkId());
            Long baseFetchCfgId = Long.valueOf(baseFetchCfgIdStr);
            Map baseFetchItemInfo = (Map)SInsurBaseFetchCfgService.getBaseFetchItemInfoByCfg(Collections.singletonList(baseFetchCfgId), (int)1).get(baseFetchCfgIdStr);
            if (baseFetchItemInfo == null || baseFetchItemInfo.get("id") == null) {
                return;
            }
            Long baseFetchItemId = Long.parseLong((String)baseFetchItemInfo.get("id"));
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setPkId((Object)baseFetchItemId);
            baseShowParameter.setStatus(OperationStatus.VIEW);
            String appId = this.getView().getFormShowParameter().getCheckRightAppId();
            String pageId = this.getView().getPageId() + appId + baseFetchItemId;
            baseShowParameter.setPageId(pageId);
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            baseShowParameter.setFormId("sitbs_basefetchitem");
            this.log.info("InsuranceBaseFetchCfgList.billListHyperLinkClick: begin to open baseFetchCfg.");
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }
}

