/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.insurancemap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class InsuranceItemMappingSchemeEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String ADD_KEY = "donothing_add";
    private static final String SITBS_INSURENCE_ITEM = "sitbs_insuranceitem";
    private static final String SALARYITEM_KEY = "salaryitem";

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"insuranceitemname"});
    }

    public void beforeBindData(EventObject eventObject) {
        this.loadInsuranceItem();
    }

    public void afterBindData(EventObject eventObject) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (Objects.nonNull(customParams) && Objects.nonNull(customParams.get("isChange")) && ((Boolean)customParams.get("isChange")).booleanValue()) {
            this.getPageCache().put("isClearRow", "false");
        }
    }

    private void loadInsuranceItem() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entityentity = dataEntity.getDynamicObjectCollection("entityentity");
        List itemIds = entityentity.stream().map(entity -> entity.getLong("insuranceitem")).collect(Collectors.toList());
        if (SWCListUtils.isEmpty(itemIds)) {
            return;
        }
        Map reslutMap = (Map)SWCMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getInsuranceItemByIds", (Object[])new Object[]{itemIds});
        for (int i = 0; i < entityentity.size(); ++i) {
            Long itemId = ((DynamicObject)entityentity.get(i)).getLong("insuranceitem");
            Map itemContentMap = (Map)reslutMap.get(itemId);
            if (itemContentMap == null) continue;
            this.getModel().setValue("groupname", itemContentMap.get("groupname"), i);
            this.getModel().setValue("insuranceitemnumber", itemContentMap.get("insuranceitemnumber"), i);
            this.getModel().setValue("insuranceitemname", itemContentMap.get("insuranceitemname"), i);
        }
        this.getView().getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        DynamicObject dyObj = this.getModel().getDataEntity();
        switch (opKey) {
            case "donothing_add": {
                args.setCancel(true);
                QFilter itemFilter = this.getItemFilter();
                this.openItemF7("hsbs_salaryitem", ADD_KEY, Collections.singletonList(itemFilter), "bos_listf7", true);
                break;
            }
            case "save": {
                List hasPermOrgs;
                if (SWCPermissionServiceHelper.isSuperUser()) break;
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHLXNRR9KPZ", (String)"hsbs_insurproscheme", (String)"47150e89000000ac");
                long orgId = this.getModel().getDataEntity().getLong("org.id");
                if (permOrgs.hasAllOrgPerm() || (hasPermOrgs = permOrgs.getHasPermOrgs()) != null && hasPermOrgs.contains(orgId)) break;
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201c{0}\u201d\u6743\u9650\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"InsuranceItemMappingSchemeEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[]{this.getModel().getDataEntity().getString("org.name")}));
                break;
            }
            case "donothing": {
                args.setCancel(true);
                break;
            }
        }
    }

    private List<QFilter> getSinsuranceItemFilter(Long countryId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        QFilter filter = new QFilter("country", "=", (Object)countryId);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("status", "=", (Object)"C"));
        qFilters.add(filter);
        return qFilters;
    }

    private QFilter getItemFilter() {
        DynamicObject dyObj = this.getModel().getDataEntity(true);
        QFilter baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (Long)dyObj.getLong("org.id"));
        QFilter filter = new QFilter("salaryitemtype.id", "=", (Object)1393357138549742592L);
        DynamicObjectCollection entityentity = dyObj.getDynamicObjectCollection("entityentity");
        List existIds = entityentity.stream().map(object -> object.getLong("salaryitem.id")).collect(Collectors.toList());
        filter.and(new QFilter("id", "not in", existIds));
        QFilter filter1 = new QFilter("areatype", "=", (Object)"1");
        QFilter filter2 = new QFilter("areatype", "=", (Object)"2");
        filter2.and(new QFilter("country", "=", (Object)dyObj.getLong("country.id")));
        filter.and(filter2.or(filter1));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and("datatype.storagetype", "in", Arrays.asList("num", "amount"));
        filter.and(baseDataFilter);
        return filter;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String callBackValue = closedCallBackEvent.getActionId();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        switch (callBackValue) {
            case "sitbs_insuranceitem": {
                this.setSinsurItemVlaue(rows);
                break;
            }
            case "donothing_add": {
                this.addItemEntry(rows);
                break;
            }
        }
    }

    private void openItemF7(String billFormId, String callBackParam, List<QFilter> qFilters, String formId, boolean isMulti) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(formId);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(isMulti);
        showParameter.setShowTitle(false);
        showParameter.setHasRight(true);
        showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackParam));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setSinsurItemVlaue(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        List itemIds = rows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        Map reslutMap = (Map)SWCMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getInsuranceItemByIds", (Object[])new Object[]{itemIds});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entityentity");
        ListSelectedRow listSelectedRow = rows.get(0);
        Map itemContentMap = (Map)reslutMap.get((Long)listSelectedRow.getPrimaryKeyValue());
        if (itemContentMap != null) {
            model.setValue("insuranceitem", listSelectedRow.getPrimaryKeyValue(), rowIndex);
            model.setValue("groupname", itemContentMap.get("groupname"), rowIndex);
            model.setValue("insuranceitemnumber", itemContentMap.get("insuranceitemnumber"), rowIndex);
            model.setValue("insuranceitemname", itemContentMap.get("insuranceitemname"), rowIndex);
        }
    }

    private void addItemEntry(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(SALARYITEM_KEY, new Object[0]);
        for (ListSelectedRow listSelectedRow : rows) {
            vs.addRow(new Object[]{listSelectedRow.getPrimaryKeyValue()});
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entityentity", vs);
        model.endInit();
        this.getView().updateView("entityentity");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "salaryitem": {
                beforeF7SelectEvent.addCustomQFilter(this.getItemFilter());
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        switch (fieldKey = args.getProperty().getName()) {
            case "country": {
                this.getModel().deleteEntryData("entityentity");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "insuranceitemname": {
                DynamicObject dyObj = this.getModel().getDataEntity();
                Long countryId = dyObj.getLong("country.id");
                int entityIndex = this.getModel().getEntryCurrentRowIndex("entityentity");
                DynamicObject salaryitem = (DynamicObject)this.getModel().getValue(SALARYITEM_KEY, entityIndex);
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
                salaryitem = helper.queryOne("datatype.storagetype", salaryitem.getPkValue());
                if (salaryitem == null) {
                    return;
                }
                List<QFilter> salaryItemFilters = this.getSinsuranceItemFilter(countryId);
                salaryItemFilters.add(new QFilter("datatype.storagetype", "=", (Object)salaryitem.getString("datatype.storagetype")));
                this.openItemF7(SITBS_INSURENCE_ITEM, SITBS_INSURENCE_ITEM, salaryItemFilters, "bos_templatetreelistf7", false);
                break;
            }
        }
    }
}

