/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.insurancemap;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.expt.common.plugin.AfterQueryDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class InsuranceMappingExportPlugin
extends SWCDataBaseList
implements HRExportPlugin {
    public void afterQueryData(AfterQueryDataEventArgs args) {
        super.afterQueryData(args);
        List dataList = args.getDataList();
        List ids = dataList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        SWCDataServiceHelper mappinghelper = new SWCDataServiceHelper("hsbs_insurproscheme");
        DynamicObjectCollection insurancedatas = mappinghelper.queryOriginalCollection("id,entityentity.id,entityentity.insuranceitem", new QFilter("id", "in", ids).toArray());
        Map<Long, Map<Long, List<DynamicObject>>> insuranceDataMap = insurancedatas.stream().collect(Collectors.groupingBy(o -> o.getLong("id"), Collectors.groupingBy(o -> o.getLong("entityentity.id"))));
        List insuranceItemIds = insurancedatas.stream().map(o -> o.getLong("entityentity.insuranceitem")).collect(Collectors.toList());
        SWCDataServiceHelper insuranceitemHelper = new SWCDataServiceHelper("sitbs_insuranceitem");
        DynamicObjectCollection insuranceitems = insuranceitemHelper.queryOriginalCollection("id,name,number", new QFilter("id", "in", insuranceItemIds).toArray());
        Map<Long, DynamicObject> itemMap = insuranceitems.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o, (v1, v2) -> v1));
        for (DynamicObject data : dataList) {
            long id = data.getLong("id");
            Map allEntities = ((MainEntityType)data.getDataEntityType()).getAllEntities();
            if (!allEntities.containsKey("entityentity")) break;
            DynamicObjectCollection dataDynamicObjectCollection = data.getDynamicObjectCollection("entityentity");
            if (dataDynamicObjectCollection == null) continue;
            for (DynamicObject entry : dataDynamicObjectCollection) {
                long insuranceitemid;
                DynamicObject insuranceitem;
                List<DynamicObject> insuranceinfos;
                Long entryId = entry.getLong("id");
                Map<Long, List<DynamicObject>> salaryItemMap = insuranceDataMap.get(id);
                if (salaryItemMap == null || SWCListUtils.isEmpty(insuranceinfos = salaryItemMap.get(entryId)) || (insuranceitem = itemMap.get(insuranceitemid = insuranceinfos.get(0).getLong("entityentity.insuranceitem"))) == null) continue;
                entry.set("insuranceitemnumber", (Object)insuranceitem.getString("number"));
                entry.set("insuranceitemname", (Object)insuranceitem.getString("name"));
            }
        }
    }
}

