/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.paybizaction;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.lang.StringUtils;

public class PayBizActionPlugin
extends BatchImportPlugin {
    public static final String STEPTYPE = "steptype";

    protected void beforeSave(List<ImportBillData> billData, ImportLogger logger) {
        super.beforeSave(billData, logger);
        String errorMsg = ResManager.loadKDString((String)"\u6b65\u9aa4\u7c7b\u578b\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"PayBizActionPlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        Object[] numbers = billData.stream().map(bill -> bill.getData().getString("number")).toArray();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_paybizaction");
        DynamicObject[] existDys = helper.query(STEPTYPE, new QFilter[]{new QFilter("number", "in", (Object)numbers)});
        Map<String, String> stepTypeMap = Arrays.stream(existDys).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getString(STEPTYPE)));
        Iterator<ImportBillData> it = billData.iterator();
        while (it.hasNext()) {
            JSONObject data;
            String stepType;
            ImportBillData bill2 = it.next();
            if (bill2.isEmpty() || !StringUtils.isNotEmpty((String)(stepType = stepTypeMap.get((data = bill2.getData()).getString("number")))) || stepType.equals(data.getString(STEPTYPE))) continue;
            it.remove();
            this.log(bill2.getStartIndex(), errorMsg, logger);
        }
    }

    private void log(int rowIndex, String errorMsg, ImportLogger logger) {
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            ((List)logCache.get(rowIndex)).add(new ImportLogger.ImportLog(errorMsg));
            logger.setLogCache(logCache);
        } else {
            logger.log(Integer.valueOf(rowIndex), errorMsg).fail();
        }
    }
}

