/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.taxmap;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class TaxItemMappingSchemeEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String ADDSALARYITEM_KEY = "donothing_addsalaryitem";
    private static final String ADD_SALARYITEM_RTN = "addSalaryItemReturn";
    private static final Long SIT_CALTAXTYPE_SUBMITTAX = 1102850557313347584L;
    private static final Long SIT_CALTAXTYPE_TAXRETURN = 1102850747902521344L;

    public void registerListener(EventObject eventObject) {
        BasedataEdit preTaxItem = (BasedataEdit)this.getView().getControl("pretaxitem");
        BasedataEdit afterTaxItem = (BasedataEdit)this.getView().getControl("aftertaxitem");
        BasedataEdit afterSalaryItem = (BasedataEdit)this.getView().getControl("aftersalaryitem");
        preTaxItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        afterTaxItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        afterSalaryItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        DynamicObjectCollection detailEntry = this.getModel().getEntryEntity("taxmapentry");
        int index = 0;
        for (DynamicObject obj : detailEntry) {
            DynamicObject afterTaxItem;
            DynamicObject afterTaxCategory = obj.getDynamicObject("aftertaxcategory");
            if (SWCObjectUtils.isEmpty((Object)afterTaxCategory)) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"aftertaxitem"});
            }
            if (SWCObjectUtils.isEmpty((Object)(afterTaxItem = obj.getDynamicObject("aftertaxitem")))) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"aftersalaryitem"});
            }
            ++index;
        }
        int entryIndex = this.getModel().getEntryCurrentRowIndex("taxmapentry");
        this.getView().updateView("taxmapentry", entryIndex);
        this.setOrgIdValue();
    }

    private void setOrgIdValue() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        DynamicObject data = this.getModel().getDataEntity();
        long existOrgId = data.getLong("org.id");
        if (OperationStatus.ADDNEW != parameter.getStatus() || existOrgId != 0L) {
            return;
        }
        String orgIdStr = (String)parameter.getCustomParam("SELECT_ORG_ID");
        long orgId = 0L;
        orgId = orgIdStr == null ? RequestContext.get().getOrgId() : Long.parseLong(orgIdStr);
        this.getModel().setValue("org", (Object)orgId);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        int rowIndex = evt.getRow();
        DynamicObjectCollection preItemEntity = this.getModel().getEntryEntity("salarymapentry");
        DynamicObjectCollection afterItemEntity = this.getModel().getEntryEntity("taxmapentry");
        DynamicObject countryObj = (DynamicObject)this.getModel().getValue("country");
        switch (fieldKey) {
            case "pretaxitem": {
                if (preItemEntity.size() <= 0) break;
                DynamicObject entry = (DynamicObject)preItemEntity.get(rowIndex);
                DynamicObject preSalaryItemObj = entry.getDynamicObject("presalaryitem");
                Long dataTypeId = preSalaryItemObj.getLong("datatype.id");
                Long taxCategoryId = entry.getLong("pretaxcategory.id");
                QFilter filter = new QFilter("taxcategories.fbasedataid_id", "=", (Object)taxCategoryId);
                filter.and(new QFilter("datatype.id", "=", (Object)dataTypeId));
                long countryId = 0L;
                if (!SWCObjectUtils.isEmpty((Object)countryObj)) {
                    countryId = countryObj.getLong("id");
                }
                filter.and("country.id", "=", (Object)countryId);
                filter.and("caltaxtype.id", "=", (Object)SIT_CALTAXTYPE_SUBMITTAX);
                filter.and(new QFilter("enable", "=", (Object)"1"));
                filter.and(new QFilter("status", "=", (Object)"C"));
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
                qFilters.add(filter);
                ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                listFilterParameter.setQFilters(qFilters);
                break;
            }
            case "aftertaxitem": {
                if (afterItemEntity.size() <= 0) break;
                DynamicObject entry = (DynamicObject)afterItemEntity.get(rowIndex);
                Long taxCategoryId = entry.getLong("aftertaxcategory.id");
                QFilter filter = new QFilter("taxcategories.fbasedataid_id", "=", (Object)taxCategoryId);
                long countryId = 0L;
                if (!SWCObjectUtils.isEmpty((Object)countryObj)) {
                    countryId = countryObj.getLong("id");
                }
                filter.and("country.id", "=", (Object)countryId);
                filter.and("caltaxtype.id", "=", (Object)SIT_CALTAXTYPE_TAXRETURN);
                filter.and(new QFilter("enable", "=", (Object)"1"));
                filter.and(new QFilter("status", "=", (Object)"C"));
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
                qFilters.add(filter);
                ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                listFilterParameter.setQFilters(qFilters);
                break;
            }
            case "aftersalaryitem": {
                if (afterItemEntity.size() <= 0) break;
                DynamicObject entry = (DynamicObject)afterItemEntity.get(rowIndex);
                DynamicObject afterTaxItemObj = entry.getDynamicObject("aftertaxitem");
                Long dataTypeId = afterTaxItemObj.getLong("datatype.id");
                DynamicObject country = (DynamicObject)this.getModel().getValue("country");
                QFilter filter = new QFilter("datatype.id", "=", (Object)dataTypeId);
                filter.and(new QFilter("calblock", "=", (Object)"1"));
                filter.and(new QFilter("enable", "=", (Object)"1"));
                filter.and(new QFilter("status", "=", (Object)"C"));
                filter.and(new QFilter("taxtag", "=", (Object)"2"));
                DynamicObject dyObj = this.getModel().getDataEntity();
                Long orgId = dyObj.getLong("org.id");
                QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (Long)orgId);
                filter.and(useOrgFilter);
                QFilter filter1 = new QFilter("areatype", "=", (Object)"1");
                QFilter filter2 = new QFilter("areatype", "=", (Object)"2");
                filter2.and("country", "=", (Object)country.getLong("id"));
                filter.and(filter1.or(filter2));
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
                qFilters.add(filter);
                ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                listFilterParameter.setQFilters(qFilters);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        FormOperate operate = (FormOperate)args.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "newentry": {
                DynamicObjectCollection detailEntry = this.getModel().getEntryEntity("taxmapentry");
                this.getView().setEnable(Boolean.FALSE, detailEntry.size(), new String[]{"aftertaxitem", "aftersalaryitem"});
                break;
            }
            case "donothing_addsalaryitem": {
                this.checkOrg(args);
                break;
            }
        }
    }

    private void checkOrg(BeforeDoOperationEventArgs args) {
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
        if (SWCObjectUtils.isEmpty((Object)orgObj)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"TaxItemMappingSchemeEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey = args.getOperateKey();
        DynamicObject dyObj = this.getModel().getDataEntity();
        Long countryId = dyObj.getLong("country.id");
        Long orgId = dyObj.getLong("org.id");
        switch (opKey) {
            case "donothing_addsalaryitem": {
                List<QFilter> salaryItemFilters = this.getSalaryItemFilters(countryId, orgId);
                this.openItemF7("hsbs_salaryitem", ADD_SALARYITEM_RTN, salaryItemFilters, "bos_listf7");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int index = changeSet[0].getRowIndex();
        IDataModel model = this.getModel();
        switch (fieldKey) {
            case "pretaxcategory": {
                DynamicObject preNewObj = (DynamicObject)changeSet[0].getNewValue();
                DynamicObject preOldObj = (DynamicObject)changeSet[0].getOldValue();
                if (preOldObj != null && !SWCObjectUtils.equals((Object)preNewObj, (Object)preOldObj)) {
                    model.setValue("pretaxitem", null);
                }
                if (SWCObjectUtils.isEmpty((Object)preNewObj)) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"pretaxitem"});
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"pretaxitem"});
                break;
            }
            case "aftertaxcategory": {
                DynamicObject afterNewObj = (DynamicObject)changeSet[0].getNewValue();
                DynamicObject afterOldObj = (DynamicObject)changeSet[0].getOldValue();
                if (afterOldObj != null && !SWCObjectUtils.equals((Object)afterNewObj, (Object)afterOldObj)) {
                    model.setValue("aftertaxitem", null);
                }
                if (SWCObjectUtils.isEmpty((Object)afterNewObj)) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"aftertaxitem", "aftersalaryitem"});
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"aftertaxitem"});
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"aftersalaryitem"});
                break;
            }
            case "aftertaxitem": {
                DynamicObject newObj = (DynamicObject)changeSet[0].getNewValue();
                DynamicObject oldObj = (DynamicObject)changeSet[0].getOldValue();
                if (oldObj != null && !SWCObjectUtils.equals((Object)newObj, (Object)oldObj)) {
                    model.setValue("aftersalaryitem", null, index);
                }
                if (SWCObjectUtils.isEmpty((Object)newObj)) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"aftersalaryitem"});
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"aftersalaryitem"});
                break;
            }
        }
    }

    private void setIsShowTaxItemEnable() {
        DynamicObjectCollection detailEntry = this.getModel().getEntryEntity("salarymapentry");
        int index = 0;
        for (DynamicObject obj : detailEntry) {
            DynamicObject preTaxCategory = obj.getDynamicObject("pretaxcategory");
            if (SWCObjectUtils.isEmpty((Object)preTaxCategory)) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"pretaxitem"});
            }
            ++index;
        }
    }

    private List<QFilter> getSalaryItemFilters(Long countryId, Long orgId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        QFilter filter = new QFilter("calblock", "=", (Object)"0");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("taxtag", "=", (Object)"1"));
        QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (Long)orgId);
        filter.and(useOrgFilter);
        QFilter filter1 = new QFilter("areatype", "=", (Object)"1");
        QFilter filter2 = new QFilter("areatype", "=", (Object)"2");
        filter2.and("country", "=", (Object)countryId);
        filter.and(filter1.or(filter2));
        qFilters.add(filter);
        return qFilters;
    }

    private void openItemF7(String billFormId, String callBackParam, List<QFilter> qFilters, String formId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(formId);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(false);
        showParameter.setHasRight(true);
        showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackParam));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String callBackValue = closedCallBackEvent.getActionId();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        switch (callBackValue) {
            case "addSalaryItemReturn": {
                this.addSalaryMapEntry(rows);
                break;
            }
        }
    }

    private void addSalaryMapEntry(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection collection = this.getModel().getEntryEntity("salarymapentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("presalaryitem", new Object[0]);
        int index = collection.size();
        model.beginInit();
        for (ListSelectedRow listSelectedRow : rows) {
            vs.addRow(new Object[]{listSelectedRow.getPrimaryKeyValue()});
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"pretaxitem"});
            ++index;
        }
        model.batchCreateNewEntryRow("salarymapentry", vs);
        model.endInit();
        this.setIsShowTaxItemEnable();
        this.getView().updateView("salarymapentry");
    }
}

