/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.treelist;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.common.util.SWCTreeListUtils;
import kd.swc.hsbs.service.StruTagCatServiceHelper;

public class StruCatTreeListPlugin
extends StandardTreeListPlugin
implements SearchEnterListener,
TreeNodeClickListener {
    private static final int CHILDREN_LEVEL = 10;

    public void initializeTree(EventObject eventObject) {
        TreeNode root = this.initRootNode();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addNode(root);
        this.loadChildNode();
        treeView.focusNode(root);
    }

    public void refreshNode(RefreshNodeEvent nodeEvent) {
        super.refreshNode(nodeEvent);
        TreeNode root = this.getTreeModel().getRoot();
        String nodeId = (String)nodeEvent.getNodeId();
        TreeNode currNode = root.getTreeNode(nodeId, 10);
        nodeEvent.setChildNodes(currNode.getChildren());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.expand("100000");
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent event) {
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)event.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        List childIds = SWCTreeListUtils.getLeafNodesId((TreeNode)currNode);
        List childIdLong = childIds.stream().map(id -> Long.parseLong(id)).collect(Collectors.toList());
        QFilter filter = new QFilter("struinscategory.id", "in", childIdLong);
        event.addQFilter(filter);
        event.setCancel(true);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId;
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode(nodeId = (String)evt.getNodeId(), 10);
        if (currNode.getChildren() == null) {
            this.getPageCache().put("pagecache", nodeId);
        } else {
            this.getPageCache().put("pagecache", null);
        }
    }

    private TreeNode initRootNode() {
        TreeNode root = new TreeNode();
        root.setId("100000");
        root.setText(ResManager.loadKDString((String)"\u85aa\u916c\u6784\u6210\u6807\u7b7e", (String)"StruCatTreeListPlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        root.setData((Object)"");
        root.setParentid("");
        root.setIsOpened(true);
        return root;
    }

    private void loadChildNode() {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        ITreeModel treeModel = this.getTreeModel();
        List objects = StruTagCatServiceHelper.getAllData();
        for (int i = 1; i < 4; ++i) {
            for (DynamicObject obj : objects) {
                String parentId;
                TreeNode node;
                if (i != obj.getInt("categorylevel")) continue;
                if (i == 1) {
                    node = new TreeNode("100000", obj.getString("id"), obj.getString("name"));
                    parentId = "100000";
                } else {
                    parentId = obj.getString("parent");
                    node = new TreeNode(obj.getString("parent"), obj.getString("id"), obj.getString("name"));
                }
                treeModel.addNode((Object)parentId, node);
                treeView.addNode(node);
            }
        }
    }
}

