/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.view;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class SalarySlipPrintEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String FIELD_SALARYITEM = "salaryitem";
    private static final String FIELD_SHOWNAME = "displayname";
    private static final String FIELD_ISSHOWZERO = "iszerodisplay";
    private static final String FIELD_ISSHOWNULL = "isemptydisplay";
    private static final String FIELD_PRINTTPL = "printtpl";
    private static final String FIELD_COUNTRY = "country";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
        BasedataEdit printTemplateEdit = (BasedataEdit)this.getView().getControl(FIELD_PRINTTPL);
        printTemplateEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey;
        switch (fieldKey = arg.getProperty().getName()) {
            case "printtpl": {
                Set<String> printTplIdSet = this.getPrintTplIdSet("hsas_calperson");
                ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
                QFilter filter = new QFilter("id", "in", printTplIdSet);
                param.getListFilterParameter().getQFilters().add(filter);
                break;
            }
        }
    }

    private Set<String> getPrintTplIdSet(String formId) {
        QFilter filter = new QFilter("billformid", "=", (Object)formId);
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_manageprinttpl", (String)"printtplid", (QFilter[])new QFilter[]{filter});
        HashSet<String> printTplIdSet = new HashSet<String>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            printTplIdSet.add(dynamicObject.getString("printtplid.id"));
        }
        return printTplIdSet;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "additem": {
                this.openSalaryItemF7();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        if (fieldKey.equals(FIELD_COUNTRY)) {
            this.checkOpenConfirmPage(args.getChangeSet(), Boolean.FALSE);
        }
    }

    private void checkOpenConfirmPage(ChangeData[] changeSets, Boolean isAraeType) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        if (entryEntity.isEmpty()) {
            return;
        }
        if (null == changeSets || changeSets.length == 0) {
            return;
        }
        String customValue = "";
        ChangeData changeData = changeSets[0];
        Object oldValue = changeData.getOldValue();
        if (oldValue != null) {
            DynamicObject country = (DynamicObject)oldValue;
            Object countryId = country.get("id");
            customValue = String.valueOf(countryId);
        }
        String msg = ResManager.loadKDString((String)"\u5207\u6362\u540e\u5c06\u6e05\u7a7a\u201c\u85aa\u916c\u9879\u76ee\u201d\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"SalarySlipPrintEdit_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(FIELD_COUNTRY), null, customValue);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String callStr = event.getActionId();
        Object returnData = event.getReturnData();
        ListSelectedRowCollection dataColl = null;
        switch (callStr) {
            case "hsbs_salaryitem": {
                dataColl = (ListSelectedRowCollection)returnData;
                this.addItemsToEntity(dataColl);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String[] entryEntityKeys = new String[]{KEY_ENTRYENTITY};
        if (FIELD_COUNTRY.equals(messageBoxClosedEvent.getCallBackId())) {
            AreaHelper.confirmAfterModifyCountry((MessageBoxClosedEvent)messageBoxClosedEvent, (IDataModel)this.getModel(), (IFormView)this.getView(), null, (String[])entryEntityKeys);
        }
    }

    private void openSalaryItemF7() {
        if (!this.checkCountry()) {
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsbs_salaryitem", (boolean)true);
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsbs_salaryitem"));
        showParameter.setListFilterParameter(new ListFilterParameter(this.getSalaryItemFilter(), null));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean checkCountry() {
        Object country = this.getModel().getValue(FIELD_COUNTRY);
        if (country == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u3002", (String)"SalarySlipPrintEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<QFilter> getSalaryItemFilter() {
        QFilter salaryItemDataRuleFilter;
        List<Long> billIds;
        DynamicObject mainOrgObj;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        MainEntityType billEntityType = this.getModel().getDataEntityType();
        String mainOrgProp = billEntityType.getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrgProp) && (mainOrgObj = (DynamicObject)this.getModel().getValue(mainOrgProp)) != null && mainOrgObj.getPkValue() != null) {
            long orgID = (Long)mainOrgObj.getPkValue();
            IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
            QFilter qFilter = baseDataService.getBaseDataFilter("hsbs_salaryitem", Long.valueOf(orgID));
            qFilters.add(qFilter);
        }
        if ((billIds = this.getEntryItemIds()).size() > 0) {
            qFilters.add(new QFilter("id", "not in", billIds));
        }
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        QFilter areaFilter = AreaHelper.addAreaFilter((long)countryId, (String)"2");
        if (null != areaFilter) {
            qFilters.add(areaFilter);
        }
        if ((salaryItemDataRuleFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/US+X3ECAB+C", (String)"hsbs_salslipprint", (String)FIELD_SALARYITEM)) != null) {
            qFilters.add(salaryItemDataRuleFilter);
        }
        return qFilters;
    }

    private List<Long> getEntryItemIds() {
        DynamicObjectCollection coll = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (DynamicObject dynamicObject : coll) {
            long salaryitemId;
            DynamicObject salaryitemObj = (DynamicObject)dynamicObject.get(FIELD_SALARYITEM);
            if (SWCBaseUtils.isEmpty((DynamicObject)salaryitemObj) || billIds.contains(salaryitemId = salaryitemObj.getLong("id"))) continue;
            billIds.add(salaryitemId);
        }
        return billIds;
    }

    private void addItemsToEntity(ListSelectedRowCollection dataColl) {
        if (dataColl == null || dataColl.size() == 0) {
            return;
        }
        ArrayList<Long> billIds = new ArrayList<Long>(dataColl.size());
        for (ListSelectedRow listSelectedRow : dataColl) {
            billIds.add(Long.valueOf(listSelectedRow.getPrimaryKeyValue().toString()));
        }
        String selectProperties = "id,name,number,datatype.id,datatype.name";
        QFilter filter = new QFilter("id", "in", billIds);
        DynamicObject[] coll = new SWCDataServiceHelper("hsbs_salaryitem").query(selectProperties, new QFilter[]{filter}, "number asc");
        this.loadItemToEntity(coll);
    }

    private void loadItemToEntity(DynamicObject[] coll) {
        ArrayList<String> failList = new ArrayList<String>();
        int total = 0;
        int success = 0;
        int fail = 0;
        boolean index = false;
        List<Long> entryItemIds = this.getEntryItemIds();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(FIELD_SALARYITEM, new Object[0]);
        vs.addField(FIELD_SHOWNAME, new Object[0]);
        vs.addField(FIELD_ISSHOWZERO, new Object[0]);
        vs.addField(FIELD_ISSHOWNULL, new Object[0]);
        for (DynamicObject dynamicObject : coll) {
            ++total;
            long salaryItemId = dynamicObject.getLong("id");
            String salaryItemName = dynamicObject.getString("name");
            if (entryItemIds.contains(salaryItemId)) {
                ++fail;
                failList.add(ResManager.loadKDString((String)"{0}\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0\u3002", (String)"SalarySlipPrintEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[]{salaryItemName}));
                continue;
            }
            ++success;
            vs.addRow(new Object[]{salaryItemId, salaryItemName, false, false});
        }
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
        if (fail != 0) {
            String totalMessage = ResManager.loadKDString((String)"\u5171\u6dfb\u52a0{0}\u4e2a\u85aa\u916c\u9879\u76ee\uff0c{1}\u4e2a\u6dfb\u52a0\u6210\u529f\uff0c{2}\u4e2a\u6dfb\u52a0\u5931\u8d25\u3002", (String)"SalarySlipPrintEdit_3", (String)"swc-hsbs-formplugin", (Object[])new Object[]{total, success, fail});
            this.showOperationResult(ResManager.loadKDString((String)"\u6dfb\u52a0\u85aa\u916c\u9879\u76ee", (String)"SalarySlipPrintEdit_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), totalMessage, failList);
        }
    }

    private void showOperationResult(String operateName, String title, List<String> failList) {
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, failList);
        this.getView().showForm(parameters);
    }
}

