/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.view;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.common.model.MultiLangEnumBridge;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.cal.helper.CalItemHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.hsbs.common.vo.SalaryItemGroupObject;

public class SalarySlipViewEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String SEQ = "seq";
    private static final String ITEMCOUNT = "itemcount";
    private static final String QUERYSCOPE = "queryscope";
    private static final String CURRENCYTYPE = "currencytype";
    private static final String AUTOENDNOTE = "autoendnote";
    private static final String ISSHOWPAYFLOW = "isshowpayflow";
    private static final String DEFAULTTITLE = "defaulttitle";
    private static final String ISNEEDCONFIRM = "isneedconfirm";
    private static final String SALARYITEMTYPE = "salaryitemtype";
    private static final String RICHTEXTEDITORAP = "richtexteditorap";
    private static final String MAILSENDER = "mailsender";
    private static final String EMAILTHEME = "emailtheme";
    private static final String TABPAGEAUTOENDAP = "flexpanelautoendap";
    private static final String TABPAGEMAILAP = "flexpanelemailap";
    private static final String ISAUTOENDSUMMARY = "isautoendsummary";
    private static final String ISAUTOENDTOPSHOW = "isautoendtopshow";
    private static final String ISZERODISPLAY = "iszerodisplay";
    private static final String ITEMDISPLAYNAME = "itemdisplayname";
    private static final String ISUNLIMITED = "isunlimited";
    private static final String VALIDDURATION = "validduration";
    private static final String QUERYDURATION = "queryduration";
    private static final String ISPUSHNOTIFY = "ispushnotify";
    private static final String GROUPNAME = "groupname";
    private static final String GROUPDISPLAYNAME = "groupdisplayname";
    private static final String STRUINSTAG_ID = "struinstag.id";
    private static final String SALARYITEMTYPE_ID = "salaryitemtype.id";
    private static final String HSBS_MOVEGROUP = "hsbs_movegroup";
    private static final String ISSENDBYAUTO = "issendbyauto";
    private static final String ISSENDBYMAIL = "issendbymail";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SUBENTRYENTITY = "subentryentity";
    private static final long AMOUNT_ID = 1020L;
    private static final String EMAILCONTENT = "emailcontent";
    private static final String AUDITCONFIRMCHANGE = "auditconfirmchange";
    private static final String FIELD_AREATYPE = "areatype";
    private static final String FIELD_AREATYPE_GENERAL = "1";
    private static final String FIELD_AREATYPE_ASSIGN = "2";
    private static final String FIELD_COUNTRY = "country";
    private static final String CALLBACK_COUNTRY = "calllbackcountry";
    private static final String MSG_TEMP = "msgtemplate";
    private static final String ITEMCATEGORY = "itemcategory";
    private static final String ITEM = "item";
    private static final String[] OPTIONAL_PARAMETER_ARRAY = new String[]{"themenamelabel", "themenumberlabel", "themecompanylabel", "themedepartmentlabel", "themejoblabel", "themepayrolldatelabel", "themedaterangelabel", "themecalcountlabel", "themecurrentdatelabel", "emailnamelabel", "emailnumberlabel", "emailcompanylabel", "emaildepartmentlabel", "emailjoblabel", "emailpayrolldatelabel", "emaildaterangelabel", "emailcalcountlabel", "emailcurrentdatelabel"};
    private static final Map<String, MultiLangEnumBridge> LABEL_MAP = new HashMap<String, MultiLangEnumBridge>(16);
    private static final Map<String, String> ITEM_MAP;

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"advcontoolbarap_detail"});
        this.addClickListeners(OPTIONAL_PARAMETER_ARRAY);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl(MSG_TEMP);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)MSG_TEMP)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("msg_template");
            QFilter filter = new QFilter("msgentity", "=", (Object)"hsas_salaryslip");
            int count = helper.count(new QFilter[]{filter});
            if (count <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u7528\u6d88\u606f\u6a21\u677f\uff0c\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u670d\u52a1\u4e91>\u516c\u5171\u8bbe\u7f6e>\u6d88\u606f\u8bbe\u7f6e>\u6d88\u606f\u6a21\u677f\u201d\u8fdb\u884c\u65b0\u589e\u3002", (String)"SalarySlipViewEdit_31", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("tplF7MultiSelect", (Object)Boolean.TRUE);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String saveStatus = this.getModel().getDataEntity().getString("status");
        if ("A".equals(saveStatus)) {
            Control sControl = (Control)evt.getSource();
            switch (sControl.getKey()) {
                case "themenamelabel": 
                case "themenumberlabel": 
                case "themecompanylabel": 
                case "themedepartmentlabel": 
                case "themejoblabel": 
                case "themepayrolldatelabel": 
                case "themedaterangelabel": 
                case "themecalcountlabel": 
                case "themecurrentdatelabel": {
                    this.setArgToTheme(sControl.getKey());
                    break;
                }
                case "emailnamelabel": 
                case "emailnumberlabel": 
                case "emailcompanylabel": 
                case "emaildepartmentlabel": 
                case "emailjoblabel": 
                case "emailpayrolldatelabel": 
                case "emaildaterangelabel": 
                case "emailcalcountlabel": 
                case "emailcurrentdatelabel": {
                    this.setArgToRichText(sControl.getKey());
                    break;
                }
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        DecimalEdit queryEdit = (DecimalEdit)this.getView().getControl(QUERYDURATION);
        queryEdit.setMustInput(true);
        this.getView().setVisible(Boolean.FALSE, new String[]{CURRENCYTYPE});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.sendByMailConfig();
        this.puchNotifyConfig();
        this.textAndLabelConfig();
        this.sendByAutoConfig();
        this.richTextEditConfig();
        this.setEmailContent();
        this.loadSubEntryCalItem();
        this.refreshTopShowEnable(((AbstractFormDataModel)this.getModel()).getEntityEntity(ENTRYENTITY));
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", FIELD_COUNTRY});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        switch (name) {
            case "issendbyauto": {
                this.showAutoEndPanel();
                break;
            }
            case "issendbymail": {
                this.showMailPanel();
                break;
            }
            case "groupdisplayname": {
                this.verifyGroupDisplayName();
                break;
            }
            case "itemdisplayname": {
                this.verifyItemDisplayName();
                break;
            }
            case "ispushnotify": {
                this.puchNotifyConfig();
                break;
            }
            case "isautoendsummary": {
                this.summaryConfig();
                break;
            }
            case "isautoendtopshow": {
                this.topShowCountChecker();
                break;
            }
            case "isunlimited": {
                this.validDurationConfig();
                break;
            }
            case "iszerodisplay": {
                this.zeroDisplayConfig();
                break;
            }
            case "country": {
                this.checkOpenConfirmPage(oldValue);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "saveandnew": 
            case "submit": 
            case "audit": 
            case "auditconfirmchange": 
            case "changesave": {
                if (this.setSendWayMustInput(args)) break;
                this.setEmailContentFromEditor();
                this.setValidDuration();
                this.clearCacheData();
                break;
            }
            case "close": {
                if (this.setSendWayMustInput(args)) break;
                this.setEmailContentFromEditor();
                break;
            }
            case "donothing_movegroup": {
                this.checkEntryAndDetail(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "donothing_addsalaryitem": {
                this.openCalItemF7();
                break;
            }
            case "donothing_movegroup": {
                this.openMoveGroupPlugin();
                break;
            }
            case "donothing_addgroup": {
                this.openF7BySalaryClassRef();
                break;
            }
            case "deleteentry_detail": {
                int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
                this.setItemCount((AbstractFormDataModel)this.getModel(), index);
                break;
            }
            case "save": 
            case "enable": 
            case "disable": {
                if (!args.getOperationResult().isSuccess()) break;
                this.getView().setEnable(Boolean.FALSE, new String[]{"createorg"});
                break;
            }
            case "audit": 
            case "unaudit": 
            case "submit": {
                if (args.getOperationResult().isSuccess()) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{RICHTEXTEDITORAP});
                }
                this.setEmailContent();
                break;
            }
            case "unsubmit": {
                if (args.getOperationResult().isSuccess()) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{RICHTEXTEDITORAP});
                }
                this.setEmailContent();
                break;
            }
            case "copy": 
            case "new": {
                this.getView().setEnable(Boolean.TRUE, new String[]{"createorg"});
                break;
            }
            case "newentry": {
                this.refreshTopShowEnable(((AbstractFormDataModel)this.getModel()).getEntityEntity(ENTRYENTITY));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "calllbackcountry": {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                String[] entryEntityKeys = new String[]{SUBENTRYENTITY, ENTRYENTITY};
                AreaHelper.confirmAfterModifyCountry((MessageBoxClosedEvent)event, (IDataModel)model, (IFormView)this.getView(), null, (String[])entryEntityKeys);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "hsbs_viewitemselect": {
                this.setSubEntryByCalItem(closedCallBackEvent);
                break;
            }
            case "hsbs_salaryitemtype": {
                this.setEntryValueBySalaryItemType(closedCallBackEvent);
                break;
            }
            case "hsbs_movegroup": {
                this.moveSalaryItemToOtherGroup(closedCallBackEvent);
                break;
            }
        }
    }

    private void moveSalaryItemToOtherGroup(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        IDataModel model = this.getModel();
        DynamicObjectCollection subEntryEntityList = model.getEntryEntity(SUBENTRYENTITY);
        SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl(SUBENTRYENTITY);
        int[] selectedRows = subEntryGrid.getEntryState().getSelectedRows();
        DynamicObjectCollection fromObjectColl = new DynamicObjectCollection();
        boolean flag = false;
        for (int index : selectedRows) {
            DynamicObject subEntryObj = (DynamicObject)subEntryEntityList.get(index);
            fromObjectColl.add((Object)subEntryObj);
            long dataTypeId = subEntryObj.getLong("itemdatatype.id");
            if (dataTypeId == 1020L) continue;
            flag = true;
        }
        int fromParentSeq = (Integer)returnData.get("fromParentSeq") - 1;
        SalaryItemGroupObject toParentObject = (SalaryItemGroupObject)returnData.get("selectedObj");
        int toParentSeq = toParentObject.getSeq() - 1;
        model.setEntryCurrentRowIndex(ENTRYENTITY, toParentSeq);
        DynamicObjectCollection toSubEntryEntityColl = this.getModel().getEntryEntity(SUBENTRYENTITY);
        DynamicObject toParentObjct = (DynamicObject)toSubEntryEntityColl.getParent();
        boolean summaryFlag = toParentObjct.getBoolean(ISAUTOENDSUMMARY);
        if (summaryFlag && flag) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u4e0b\u5305\u542b\u6570\u636e\u7c7b\u578b\u4e0d\u4e3a\u91d1\u989d\u7684\u5de5\u8d44\u6761\u9879\u76ee\uff0c\u65e0\u6cd5\u8fdb\u884c\u6c47\u603b\u3002", (String)"SalarySlipViewEdit_26", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            model.setValue(ISAUTOENDSUMMARY, (Object)Boolean.FALSE, toParentSeq);
        }
        int entryIndex = toSubEntryEntityColl.size();
        this.getModel().appendEntryRow(SUBENTRYENTITY, entryIndex, fromObjectColl.size());
        model.setValue(ITEMCOUNT, (Object)this.getModel().getEntryEntity(SUBENTRYENTITY).size(), toParentSeq);
        model.beginInit();
        for (DynamicObject tempObj : fromObjectColl) {
            this.getModel().setValue(ITEMCATEGORY, tempObj.get(ITEMCATEGORY), entryIndex);
            this.getModel().setValue(ITEM, tempObj.get(ITEM), entryIndex);
            this.getModel().setValue("itemdatatype", tempObj.get("itemdatatype"), entryIndex);
            this.getModel().setValue(ITEMDISPLAYNAME, tempObj.get(ITEMDISPLAYNAME), entryIndex);
            this.getModel().setValue(ISZERODISPLAY, tempObj.get(ISZERODISPLAY), entryIndex);
            this.getModel().setValue("isemptydisplay", tempObj.get("isemptydisplay"), entryIndex);
            ++entryIndex;
        }
        model.endInit();
        model.setEntryCurrentRowIndex(ENTRYENTITY, fromParentSeq);
        EntryGrid entryGrid = (EntryGrid)this.getControl(SUBENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        model.deleteEntryRows(SUBENTRYENTITY, selectRows);
        model.setValue(ITEMCOUNT, (Object)this.getModel().getEntryEntity(SUBENTRYENTITY).size(), fromParentSeq);
        this.getView().updateView(ENTRYENTITY);
        this.getView().updateView(SUBENTRYENTITY);
    }

    private boolean isViewEditable() {
        if (BaseDataHisHelper.isCurrPage((IFormView)this.getView())) {
            String dyObjStatus = this.getModel().getDataEntity().getString("status");
            return !"B".equals(dyObjStatus) && !"C".equals(dyObjStatus);
        }
        String dyObjStatus = this.getModel().getDataEntity().getString("datastatus");
        return "-5".equals(dyObjStatus);
    }

    private void textAndLabelConfig() {
        boolean isViewEditable = this.isViewEditable();
        this.getView().setEnable(Boolean.valueOf(isViewEditable), new String[]{RICHTEXTEDITORAP});
        this.getView().setEnable(Boolean.valueOf(isViewEditable), OPTIONAL_PARAMETER_ARRAY);
    }

    private void puchNotifyConfig() {
        boolean isPushNotify = this.getModel().getDataEntity().getBoolean(ISPUSHNOTIFY);
        if (isPushNotify) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MSG_TEMP});
            BasedataEdit msgBaseData = (BasedataEdit)this.getView().getControl(MSG_TEMP);
            msgBaseData.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{MSG_TEMP});
        }
    }

    private void summaryConfig() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int index = model.getEntryCurrentRowIndex(ENTRYENTITY);
        DynamicObjectCollection entityEntity = model.getEntityEntity(ENTRYENTITY);
        DynamicObject entryObj = (DynamicObject)entityEntity.get(index);
        DynamicObjectCollection subEntityEntity = entryObj.getDynamicObjectCollection(SUBENTRYENTITY);
        boolean summaryFlag = entryObj.getBoolean(ISAUTOENDSUMMARY);
        if (summaryFlag) {
            for (DynamicObject object : subEntityEntity) {
                Long datatype = object.getLong("itemdatatype.id");
                if (datatype.equals(1020L)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u4e0b\u5305\u542b\u6570\u636e\u7c7b\u578b\u4e0d\u4e3a\u91d1\u989d\u7684\u5de5\u8d44\u6761\u9879\u76ee\uff0c\u65e0\u6cd5\u8fdb\u884c\u6c47\u603b\u3002", (String)"SalarySlipViewEdit_26", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(ISAUTOENDSUMMARY, (Object)0, index);
                return;
            }
            this.getView().setEnable(Boolean.TRUE, index, new String[]{ISAUTOENDTOPSHOW});
        } else {
            this.getModel().setValue(ISAUTOENDTOPSHOW, (Object)0, index);
            this.getView().setEnable(Boolean.FALSE, index, new String[]{ISAUTOENDTOPSHOW});
        }
    }

    private void zeroDisplayConfig() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int index = model.getEntryCurrentRowIndex(ENTRYENTITY);
        DynamicObjectCollection entityEntity = model.getEntityEntity(ENTRYENTITY);
        DynamicObject entryObj = (DynamicObject)entityEntity.get(index);
        int subIndex = model.getEntryCurrentRowIndex(SUBENTRYENTITY);
        DynamicObjectCollection subEntityEntity = entryObj.getDynamicObjectCollection(SUBENTRYENTITY);
        DynamicObject subEntryObj = (DynamicObject)subEntityEntity.get(subIndex);
        boolean isZeroDisplay = subEntryObj.getBoolean(ISZERODISPLAY);
        if (isZeroDisplay) {
            String itemName = subEntryObj.getString(ITEMCATEGORY);
            if (SWCStringUtils.isEmpty((String)itemName)) {
                return;
            }
            Long type = subEntryObj.getLong("itemdatatype.id");
            if (!(type.equals(1010L) || type.equals(1020L) || type.equals(1040L))) {
                this.getModel().setValue(ISZERODISPLAY, (Object)0, subIndex);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u9879\u76ee\u7684\u6570\u636e\u7c7b\u578b\u4e3a\u975e\u91d1\u989d/\u6570\u503c\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u201c\u6570\u636e\u4e3a0\u65f6\u663e\u793a\u201d\u3002", (String)"SalarySlipViewEdit_28", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void richTextEditConfig() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        boolean mailFlag = this.getModel().getDataEntity().getBoolean(ISSENDBYMAIL);
        if (OperationStatus.EDIT.equals((Object)status) && this.isViewEditable()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"createorg"});
            if (mailFlag) {
                this.getView().setEnable(Boolean.TRUE, new String[]{RICHTEXTEDITORAP});
            }
        }
        if (mailFlag && OperationStatus.VIEW.equals((Object)status) && this.isViewEditable()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{RICHTEXTEDITORAP});
        }
    }

    private void sendByAutoConfig() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean endAutoFlag = dataEntity.getBoolean(ISSENDBYAUTO);
        if (!endAutoFlag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ISAUTOENDTOPSHOW, ISAUTOENDSUMMARY, TABPAGEAUTOENDAP});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{ISAUTOENDTOPSHOW, ISAUTOENDSUMMARY, TABPAGEAUTOENDAP});
        int validDuration = dataEntity.getInt(VALIDDURATION);
        boolean isUnlimited = dataEntity.getBoolean(ISUNLIMITED);
        if (isUnlimited) {
            this.getView().setEnable(Boolean.FALSE, new String[]{QUERYDURATION});
            validDuration = 0;
        }
        this.getModel().setValue(QUERYDURATION, (Object)validDuration);
        this.getModel().setDataChanged(false);
    }

    private void setEmailContent() {
        String emailContent = this.getModel().getDataEntity().getString(EMAILCONTENT);
        if (StringUtils.isNotBlank((CharSequence)emailContent)) {
            RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(RICHTEXTEDITORAP);
            richTextEditor.setText(emailContent);
        }
    }

    private void sendByMailConfig() {
        BasedataEdit baseEdit = (BasedataEdit)this.getControl(MAILSENDER);
        TextEdit textEdit = (TextEdit)this.getControl(EMAILTHEME);
        boolean isSendByMailFlag = this.getModel().getDataEntity().getBoolean(ISSENDBYMAIL);
        if (isSendByMailFlag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TABPAGEMAILAP});
            baseEdit.setMustInput(true);
            textEdit.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TABPAGEMAILAP});
            baseEdit.setMustInput(false);
            textEdit.setMustInput(false);
        }
    }

    private void setArgToTheme(String key) {
        String[] textValueArr = key.split("theme");
        key = textValueArr[1];
        String labelArg = "{" + this.getLabelValue(key) + "}";
        String oldEmailThemeValue = this.getModel().getDataEntity().getString(EMAILTHEME);
        if (StringUtils.isNotEmpty((CharSequence)oldEmailThemeValue)) {
            oldEmailThemeValue = oldEmailThemeValue.trim() + labelArg;
            this.getModel().setValue(EMAILTHEME, (Object)oldEmailThemeValue);
        } else {
            this.getModel().setValue(EMAILTHEME, (Object)labelArg);
        }
        TextEdit textEdit = (TextEdit)this.getControl(EMAILTHEME);
        textEdit.setFocus(true);
    }

    private void setArgToRichText(String labelKey) {
        String[] textValueArr = labelKey.split("email");
        labelKey = textValueArr[1];
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(RICHTEXTEDITORAP, "insertText", new Object[]{"{" + this.getLabelValue(labelKey) + "}"});
    }

    private String getLabelValue(String key) {
        return LABEL_MAP.get(key).loadKDString();
    }

    private void validDurationConfig() {
        boolean isUnlimited = this.getModel().getDataEntity().getBoolean(ISUNLIMITED);
        if (isUnlimited) {
            int queryDuration = this.getModel().getDataEntity().getInt(QUERYDURATION);
            this.getPageCache().put(QUERYDURATION, String.valueOf(queryDuration));
            this.getModel().setValue(QUERYDURATION, (Object)0);
            this.getView().setEnable(Boolean.FALSE, new String[]{QUERYDURATION});
        } else {
            String queryDuration = this.getPageCache().get(QUERYDURATION);
            int duration = 0;
            if (!StringUtils.isEmpty((CharSequence)queryDuration)) {
                duration = Integer.parseInt(queryDuration);
            }
            this.getModel().setValue(QUERYDURATION, (Object)duration);
            this.getView().setEnable(Boolean.TRUE, new String[]{QUERYDURATION});
        }
    }

    private void verifyItemDisplayName() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int index = proxy.getEntryState(ENTRYENTITY).getFocusRow();
        if (index == -1) {
            return;
        }
        this.getModel().setEntryCurrentRowIndex(ENTRYENTITY, index);
        EntryGrid entryGrid = (EntryGrid)this.getControl(SUBENTRYENTITY);
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if (focusRow == -1) {
            return;
        }
        DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity(SUBENTRYENTITY);
        DynamicObject focusDyObj = (DynamicObject)subEntryEntity.get(focusRow);
        String focusItemName = focusDyObj.getString(ITEMDISPLAYNAME);
        if (SWCStringUtils.isEmpty((String)focusItemName)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject entryDyObj : entryEntity) {
            DynamicObjectCollection subDyObjColl = entryDyObj.getDynamicObjectCollection(SUBENTRYENTITY);
            for (int rowIndex = 0; rowIndex < subDyObjColl.size(); ++rowIndex) {
                DynamicObject dynamicObject = (DynamicObject)subDyObjColl.get(rowIndex);
                String entryDisplayName = dynamicObject.getString(ITEMDISPLAYNAME);
                if (focusRow == rowIndex || !focusItemName.equals(entryDisplayName)) continue;
                DynamicObject subEntryObj = (DynamicObject)subEntryEntity.get(focusRow);
                String itemName = subEntryObj.getString("item.name");
                String tipMessage = MessageFormat.format(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u9879\u76ee\u201c{0}\u201d\u7684\u663e\u793a\u540d\u79f0\u201c{1}\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SalarySlipViewEdit_13", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), itemName, focusItemName);
                this.getView().showErrorNotification(tipMessage);
            }
        }
    }

    private void verifyGroupDisplayName() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if (focusRow == -1) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObject focusDyObj = (DynamicObject)entryEntity.get(focusRow);
        String foucsGroupName = focusDyObj.getString(GROUPDISPLAYNAME);
        if (SWCStringUtils.isEmpty((String)foucsGroupName)) {
            return;
        }
        for (int rowIndex = 0; rowIndex < entryEntity.size(); ++rowIndex) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndex);
            String entryDisplayName = dynamicObject.getString(GROUPDISPLAYNAME);
            if (!foucsGroupName.equals(entryDisplayName) || focusDyObj.equals(dynamicObject)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u9879\u76ee\u5206\u7ec4\u663e\u793a\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SalarySlipViewEdit_11", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        }
    }

    private void showMailPanel() {
        TextEdit themeEdit = (TextEdit)this.getControl(EMAILTHEME);
        BasedataEdit senderEdit = (BasedataEdit)this.getControl(MAILSENDER);
        boolean isSendByMailFlag = this.getModel().getDataEntity().getBoolean(ISSENDBYMAIL);
        senderEdit.setMustInput(isSendByMailFlag);
        themeEdit.setMustInput(isSendByMailFlag);
        if (isSendByMailFlag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TABPAGEMAILAP});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TABPAGEMAILAP});
            boolean autoFlag = this.getModel().getDataEntity().getBoolean(ISSENDBYAUTO);
            if (autoFlag) {
                this.getView().setVisible(Boolean.TRUE, new String[]{ISAUTOENDSUMMARY});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{ISAUTOENDSUMMARY});
            }
        }
    }

    private void showAutoEndPanel() {
        boolean endAutoFlag = this.getModel().getDataEntity().getBoolean(ISSENDBYAUTO);
        if (endAutoFlag) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TABPAGEAUTOENDAP, ISAUTOENDSUMMARY, ISAUTOENDTOPSHOW});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TABPAGEAUTOENDAP, ISAUTOENDSUMMARY, ISAUTOENDTOPSHOW});
        }
    }

    private Set<Long> getIntersectionInColls(DynamicObject[] array, List<Long> list) {
        if (SWCArrayUtils.isEmpty((Object[])array) || CollectionUtils.isEmpty(list)) {
            return null;
        }
        HashSet<Long> salaryItemSet = new HashSet<Long>(list.size());
        for (Long salaryItemId : list) {
            salaryItemSet.add(salaryItemId);
        }
        HashSet<Long> intersectionSet = new HashSet<Long>(array.length);
        for (DynamicObject dyObj : array) {
            long entrySalaryItemId = dyObj.getLong("id");
            if (!salaryItemSet.contains(entrySalaryItemId)) continue;
            intersectionSet.add(entrySalaryItemId);
        }
        return intersectionSet;
    }

    private void setEntryValueBySalaryItemType(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (CollectionUtils.isEmpty((Collection)selectedCollection)) {
            return;
        }
        DynamicObjectCollection entityEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        String entityId = this.getView().getEntityId();
        SWCDataServiceHelper viewHelper = new SWCDataServiceHelper(entityId);
        SWCDataServiceHelper typeHelper = new SWCDataServiceHelper("hsbs_salaryitemtype");
        Object[] primaryKeyValues = selectedCollection.getPrimaryKeyValues();
        DynamicObject[] dynamicObjects = typeHelper.query(primaryKeyValues);
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            dataMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        for (ListSelectedRow selectedRow : selectedCollection) {
            DynamicObject dynamicObject = (DynamicObject)dataMap.get((Long)selectedRow.getPrimaryKeyValue());
            if (dynamicObject == null) continue;
            DynamicObject emptyDynamicObject = viewHelper.generateEmptyEntryDynamicObject(ENTRYENTITY);
            String name = dynamicObject.getString("name");
            emptyDynamicObject.set(GROUPNAME, (Object)name);
            emptyDynamicObject.set(GROUPDISPLAYNAME, (Object)name);
            emptyDynamicObject.set(SALARYITEMTYPE, (Object)dynamicObject);
            entityEntity.add((Object)emptyDynamicObject);
        }
        SWCDataServiceHelper salaryItemHelper = new SWCDataServiceHelper("hsbs_salaryitem");
        QFilter qFilter = new QFilter(SALARYITEMTYPE_ID, "in", (Object)primaryKeyValues);
        qFilter.and(new QFilter("enable", "=", (Object)FIELD_AREATYPE_GENERAL));
        qFilter.and("status", "=", (Object)"C");
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        if (countryId != 0L) {
            QFilter filter = new QFilter(FIELD_AREATYPE, "=", (Object)FIELD_AREATYPE_ASSIGN);
            filter.and("country.id", "=", (Object)countryId);
            filter.or(new QFilter(FIELD_AREATYPE, "=", (Object)FIELD_AREATYPE_GENERAL));
            qFilter.and(filter);
        }
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (Long)this.getModel().getDataEntity().getLong("createorg.id")));
        String selectProperties = "salaryitemtype,datatype";
        DynamicObject[] salaryItemDynamicObjects = salaryItemHelper.query(selectProperties, new QFilter[]{qFilter});
        Set<Long> intersectionInColls = null;
        List<Long> subEntrySalaryItemIds = this.getSubEntrySalaryItemIds();
        if (subEntrySalaryItemIds != null && !subEntrySalaryItemIds.isEmpty() && (intersectionInColls = this.getIntersectionInColls(salaryItemDynamicObjects, subEntrySalaryItemIds)) != null && !intersectionInColls.isEmpty()) {
            String tipMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6dfb\u52a0\u7684\u5206\u7ec4\u4e2d%d\u4e2a\u85aa\u916c\u9879\u76ee\u5df2\u5b58\u5728\uff0c\u5df2\u4e3a\u60a8\u81ea\u52a8\u6392\u9664\u3002", (String)"SalarySlipViewEdit_23", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), intersectionInColls.size());
            this.getView().showTipNotification(tipMessage);
        }
        for (DynamicObject entryObj : entityEntity) {
            DynamicObjectCollection dynamicObjectCollection = entryObj.getDynamicObjectCollection(SUBENTRYENTITY);
            int index = 1;
            for (DynamicObject salaryItemObj : salaryItemDynamicObjects) {
                long salaryItemId = salaryItemObj.getLong("id");
                if (intersectionInColls != null && !intersectionInColls.isEmpty() && intersectionInColls.contains(salaryItemId)) continue;
                long typeId = salaryItemObj.getLong(SALARYITEMTYPE_ID);
                if (entryObj.getLong(SALARYITEMTYPE_ID) != typeId) continue;
                DynamicObject emptyDynamicObject = viewHelper.generateEmptyEntryDynamicObject(SUBENTRYENTITY);
                emptyDynamicObject.set(ITEMDISPLAYNAME, (Object)salaryItemObj.getString("name"));
                emptyDynamicObject.set(SEQ, (Object)index++);
                emptyDynamicObject.set(ITEMCATEGORY, (Object)"hsbs_salaryitem");
                emptyDynamicObject.set(ITEM, (Object)salaryItemObj);
                emptyDynamicObject.set("itemdatatype", salaryItemObj.get("datatype"));
                dynamicObjectCollection.add((Object)emptyDynamicObject);
            }
            entryObj.set(ITEMCOUNT, (Object)dynamicObjectCollection.size());
        }
        this.updateModelCacheAndPage(entityEntity);
    }

    private void setValidDuration() {
        boolean unlimited = this.getModel().getDataEntity().getBoolean(ISUNLIMITED);
        if (!unlimited) {
            int queryDuration = this.getModel().getDataEntity().getInt(QUERYDURATION);
            this.getModel().setValue(VALIDDURATION, (Object)queryDuration);
        }
    }

    private void setEmailContentFromEditor() {
        RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(RICHTEXTEDITORAP);
        String text = richTextEditor.getText();
        this.getModel().setValue(EMAILCONTENT, (Object)text);
    }

    private boolean setSendWayMustInput(BeforeDoOperationEventArgs args) {
        boolean flag;
        boolean isSendByAutoVal = this.getModel().getDataEntity().getBoolean(ISSENDBYAUTO);
        boolean isSendByMailVal = this.getModel().getDataEntity().getBoolean(ISSENDBYMAIL);
        boolean bl = flag = !isSendByAutoVal && !isSendByMailVal;
        if (flag) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u9879\u53d1\u5e03\u65b9\u5f0f\u3002", (String)"SalarySlipViewEdit_9", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        }
        return flag;
    }

    private void openF7BySalaryClassRef() {
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        if (0L == countryId) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u540e\u518d\u9009\u62e9\u201c\u5de5\u8d44\u6761\u9879\u76ee\u201d\u3002", (String)"SalarySlipViewEdit_30", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter countryFilter = AreaHelper.addCountryFilter((long)countryId);
        List<Long> billIds = this.getEntryEntityIds();
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"hsbs_salaryitemtype", (Long)this.getModel().getDataEntity().getLong("createorg.id"));
        if (filter != null) {
            countryFilter.and(filter);
        }
        if (!CollectionUtils.isEmpty(billIds)) {
            countryFilter.and(new QFilter("id", "not in", billIds));
        }
        this.openF7("hsbs_salaryitemtype", true, "hsbs_salaryitemtype", countryFilter);
    }

    private int findElement(DynamicObjectCollection coll, DynamicObject element, int except) {
        if (coll == null) {
            return -1;
        }
        String elementGroupName = element.getString(GROUPDISPLAYNAME);
        if (StringUtils.isEmpty((CharSequence)elementGroupName)) {
            return -1;
        }
        for (int i = 0; i < coll.size(); ++i) {
            boolean entryF7Flag;
            DynamicObject dynamicObject = (DynamicObject)coll.get(i);
            String entryDisplayName = dynamicObject.getString(GROUPDISPLAYNAME);
            DynamicObject typeObj = dynamicObject.getDynamicObject(SALARYITEMTYPE);
            boolean customFlag = typeObj == null;
            boolean bl = entryF7Flag = typeObj != null;
            if (!customFlag || entryF7Flag || !elementGroupName.equals(entryDisplayName) || element.equals(dynamicObject)) continue;
            return i;
        }
        return -1;
    }

    private void openMoveGroupPlugin() {
        DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity(SUBENTRYENTITY);
        DynamicObject parentEntryEntity = (DynamicObject)subEntryEntity.getParent();
        DynamicObjectCollection parentColl = new DynamicObjectCollection();
        DynamicObjectCollection coll = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject next : coll) {
            if (next.equals(parentEntryEntity)) continue;
            parentColl.add((Object)next);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(HSBS_MOVEGROUP);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("fromParentSeq", (Object)parentEntryEntity.getInt(SEQ));
        ArrayList<SalaryItemGroupObject> transferList = new ArrayList<SalaryItemGroupObject>(parentColl.size());
        SalaryItemGroupObject groupObject = null;
        for (DynamicObject dynamicObject : parentColl) {
            groupObject = new SalaryItemGroupObject();
            groupObject.setSeq(dynamicObject.getInt(SEQ));
            groupObject.setGroupName(dynamicObject.getString(GROUPNAME));
            groupObject.setGroupDisplayName(dynamicObject.getString(GROUPDISPLAYNAME));
            groupObject.setSalaryItemType(dynamicObject.getLong(SALARYITEMTYPE_ID));
            groupObject.setStruinstag(dynamicObject.getLong(STRUINSTAG_ID));
            transferList.add(groupObject);
        }
        parameter.setCustomParam(ENTRYENTITY, transferList);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, HSBS_MOVEGROUP));
        this.getView().showForm(parameter);
    }

    private void checkEntryAndDetail(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection coll = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)coll) || coll.size() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5de5\u8d44\u6761\u9879\u76ee\u5206\u7ec4\u4fe1\u606f\u3002", (String)"SalarySlipViewEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        for (int i = 0; i < coll.size(); ++i) {
            int elementIndex;
            DynamicObject dynamicObject = (DynamicObject)coll.get(i);
            if (SWCStringUtils.isEmpty((String)dynamicObject.getString(GROUPDISPLAYNAME))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5206\u7ec4\u663e\u793a\u540d\u79f0\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u8bf7\u586b\u5199\u5bf9\u5e94\u7684\u540d\u79f0\u3002", (String)"SalarySlipViewEdit_20", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if ((elementIndex = this.findElement(coll, dynamicObject, i)) == -1) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5206\u7ec4\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SalarySlipViewEdit_21", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        SubEntryGrid subEntryGrid = (SubEntryGrid)this.getControl(SUBENTRYENTITY);
        int[] selectedRows = subEntryGrid.getEntryState().getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u5206\u7ec4\u7684\u5de5\u8d44\u6761\u9879\u76ee\u3002", (String)"SalarySlipViewEdit_2", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void openCalItemF7() {
        long countryId = this.getModel().getDataEntity().getLong("country.id");
        if (0L == countryId) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u540e\u518d\u9009\u62e9\u201c\u5de5\u8d44\u6761\u9879\u76ee\u201d\u3002", (String)"SalarySlipViewEdit_30", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection coll = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)coll)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5de5\u8d44\u6761\u9879\u76ee\u5206\u7ec4\u4fe1\u606f\u3002", (String)"SalarySlipViewEdit_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity(SUBENTRYENTITY);
        DynamicObject parentEntryEntity = (DynamicObject)subEntryEntity.getParent();
        if (SWCStringUtils.isEmpty((String)parentEntryEntity.getString(GROUPDISPLAYNAME))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u7ec4\u7684\u663e\u793a\u540d\u79f0\u3002", (String)"SalarySlipViewEdit_12", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, String> itemFilter = this.getSubEntryCalItemFilter(countryId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsbs_viewitemselect");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsbs_viewitemselect"));
        showParameter.setCustomParam("dataFilter", itemFilter);
        this.getView().showForm(showParameter);
    }

    private List<Long> getSubEntrySalaryItemIds() {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entryColl)) {
            return null;
        }
        List<Long> billIdList = new ArrayList<Long>(entryColl.size());
        for (DynamicObject dynamicObject : entryColl) {
            DynamicObjectCollection subEntryColl = dynamicObject.getDynamicObjectCollection(SUBENTRYENTITY);
            if (CollectionUtils.isEmpty((Collection)subEntryColl)) continue;
            billIdList = subEntryColl.stream().filter(obj -> "hsbs_salaryitem".equals(obj.getString(ITEMCATEGORY))).map(obj -> obj.getLong("item.id")).collect(Collectors.toList());
        }
        return billIdList;
    }

    private void loadSubEntryCalItem() {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entryColl)) {
            return;
        }
        HashMap<String, List<Long>> itemMap = new HashMap<String, List<Long>>(16);
        for (DynamicObject dynamicObject : entryColl) {
            DynamicObjectCollection subEntryColl = dynamicObject.getDynamicObjectCollection(SUBENTRYENTITY);
            this.getItemIdMap(subEntryColl, itemMap);
        }
        HashBasedTable itemDataType = HashBasedTable.create();
        itemMap.forEach((itemCategory, itemIds) -> {
            QFilter filter = new QFilter("id", "in", itemIds);
            DynamicObjectCollection itemCol = CalItemHelper.getItemCol((String)itemCategory, (String)"id,datatype.id", (QFilter)filter, (String)"");
            itemCol.forEach(itemData -> {
                Long cfr_ignored_0 = (Long)itemDataType.put(itemCategory, (Object)itemData.getLong("id"), (Object)itemData.getLong("datatype.id"));
            });
        });
        IDataModel model = this.getModel();
        for (int entryIndex = 0; entryIndex < entryColl.size(); ++entryIndex) {
            DynamicObject dynamicObject = (DynamicObject)entryColl.get(entryIndex);
            model.setEntryCurrentRowIndex(ENTRYENTITY, entryIndex);
            DynamicObjectCollection subEntryColl = dynamicObject.getDynamicObjectCollection(SUBENTRYENTITY);
            for (int subIndex = 0; subIndex < subEntryColl.size(); ++subIndex) {
                DynamicObject subData = (DynamicObject)subEntryColl.get(subIndex);
                this.getModel().setValue("itemdatatype", itemDataType.get((Object)subData.getString(ITEMCATEGORY), (Object)subData.getLong("item.id")), subIndex);
            }
        }
        this.getView().updateView(SUBENTRYENTITY);
        this.getModel().setDataChanged(false);
    }

    private Map<String, String> getSubEntryCalItemFilter(long countryId) {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entryColl)) {
            return null;
        }
        HashMap<String, List<Long>> itemMap = new HashMap<String, List<Long>>(16);
        for (DynamicObject dynamicObject : entryColl) {
            DynamicObjectCollection subEntryColl = dynamicObject.getDynamicObjectCollection(SUBENTRYENTITY);
            this.getItemIdMap(subEntryColl, itemMap);
        }
        HashMap<String, String> itemFilterMap = new HashMap<String, String>(16);
        Long orgId = this.getModel().getDataEntity().getLong("createorg.id");
        Arrays.asList("hsbs_salaryitem", "hsbs_bizitem", "hsbs_fetchitem", "hsbs_supportitem").forEach(item -> {
            List ids;
            QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)item, (Long)orgId);
            if (filter == null) {
                filter = new QFilter(FIELD_AREATYPE_GENERAL, "=", (Object)1);
            }
            if (!CollectionUtils.isEmpty((Collection)(ids = (List)itemMap.get(item)))) {
                filter.and(new QFilter("id", "not in", (Object)ids));
            }
            filter.and(AreaHelper.addCountryFilter((long)countryId));
            itemFilterMap.put((String)item, SerializationUtils.serializeToBase64((Object)filter));
        });
        return itemFilterMap;
    }

    private void getItemIdMap(DynamicObjectCollection subEntryColl, Map<String, List<Long>> itemMap) {
        if (!CollectionUtils.isEmpty((Collection)subEntryColl)) {
            subEntryColl.forEach(obj -> {
                String itemCategory = obj.getString(ITEMCATEGORY);
                List billIdList = itemMap.computeIfAbsent(itemCategory, key -> new ArrayList(10));
                billIdList.add(obj.getLong("item.id"));
            });
        }
    }

    private List<Long> getEntryEntityIds() {
        DynamicObjectCollection coll = this.getModel().getEntryEntity(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)coll)) {
            return null;
        }
        ArrayList<Long> billIdList = new ArrayList<Long>(coll.size());
        for (DynamicObject dynamicObject : coll) {
            billIdList.add(dynamicObject.getLong(SALARYITEMTYPE_ID));
        }
        return billIdList;
    }

    private void openF7(String formId, boolean isMultiSelect, String actionId, QFilter filter) {
        ListShowParameter showParam = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect);
        QFilter qFilter = new QFilter("enable", "=", (Object)FIELD_AREATYPE_GENERAL);
        qFilter.and("status", "=", (Object)"C");
        if (filter != null) {
            qFilter.and(filter);
        }
        showParam.getListFilterParameter().setFilter(qFilter);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm((FormShowParameter)showParam);
    }

    private void setSubEntryByCalItem(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection entityEntity;
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField(ITEMCATEGORY, new Object[0]);
        setter.addField(ITEM, new Object[0]);
        setter.addField(ITEMDISPLAYNAME, new Object[0]);
        setter.addField("itemdatatype", new Object[0]);
        model.beginInit();
        boolean hasSelectedAutoEndSummary = false;
        int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        if (index != -1 && !CollectionUtils.isEmpty((Collection)(entityEntity = model.getEntityEntity(ENTRYENTITY)))) {
            DynamicObject entryObj = (DynamicObject)entityEntity.get(index);
            hasSelectedAutoEndSummary = entryObj.getBoolean(ISAUTOENDSUMMARY);
        }
        boolean hasUnSummary = false;
        DynamicObjectCollection selectedCollection = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
        for (DynamicObject selectedData : selectedCollection) {
            Long dataTypeId = selectedData.getLong("datatypeid");
            if (hasSelectedAutoEndSummary && !hasUnSummary && !this.isDataTypeAmount(dataTypeId)) {
                hasUnSummary = true;
            }
            LocaleString localeName = new LocaleString(selectedData.getString("itemname"));
            setter.addRow(new Object[]{ITEM_MAP.get(selectedData.getString(ITEMCATEGORY)), selectedData.getLong("itemid"), localeName, dataTypeId});
        }
        model.batchCreateNewEntryRow(SUBENTRYENTITY, setter);
        this.getView().updateView(SUBENTRYENTITY);
        model.endInit();
        this.setItemCountAndIsAutoEndSummary(model, index, hasUnSummary);
    }

    private boolean isDataTypeAmount(long dataTypeId) {
        return dataTypeId == 1020L;
    }

    private void setItemCountAndIsAutoEndSummary(AbstractFormDataModel model, int index, boolean hasUnAutoEndSummary) {
        if (index == -1) {
            return;
        }
        DynamicObjectCollection entityEntity = model.getEntityEntity(ENTRYENTITY);
        if (!CollectionUtils.isEmpty((Collection)entityEntity)) {
            DynamicObject entryObj = (DynamicObject)entityEntity.get(index);
            DynamicObjectCollection collection = entryObj.getDynamicObjectCollection(SUBENTRYENTITY);
            model.setValue(ITEMCOUNT, (Object)collection.size(), index);
            boolean summaryFlag = entryObj.getBoolean(ISAUTOENDSUMMARY);
            if (summaryFlag && hasUnAutoEndSummary) {
                model.setValue(ISAUTOENDSUMMARY, (Object)Boolean.FALSE, index);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u4e0b\u5305\u542b\u6570\u636e\u7c7b\u578b\u4e0d\u4e3a\u91d1\u989d\u7684\u5de5\u8d44\u6761\u9879\u76ee\uff0c\u65e0\u6cd5\u8fdb\u884c\u6c47\u603b\u3002", (String)"SalarySlipViewEdit_26", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void clearCacheData() {
        boolean isSendByMailFlag;
        boolean endAutoFlag = this.getModel().getDataEntity().getBoolean(ISSENDBYAUTO);
        if (!endAutoFlag) {
            this.getModel().setValue(ISPUSHNOTIFY, null);
            this.getModel().setValue(QUERYSCOPE, (Object)0);
            this.getModel().setValue(CURRENCYTYPE, (Object)1);
            this.getModel().setValue(ISNEEDCONFIRM, null);
            this.getModel().setValue(DEFAULTTITLE, null);
            this.getModel().setValue(ISSHOWPAYFLOW, null);
            this.getModel().setValue(AUTOENDNOTE, null);
        }
        if (!(isSendByMailFlag = this.getModel().getDataEntity().getBoolean(ISSENDBYMAIL))) {
            this.getModel().setValue(MAILSENDER, null);
            this.getModel().setValue(EMAILTHEME, null);
            RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(RICHTEXTEDITORAP);
            richTextEditor.setText(null);
        }
    }

    private void setItemCount(AbstractFormDataModel model, int index) {
        this.setItemCountAndIsAutoEndSummary(model, index, false);
    }

    private void refreshTopShowEnable(DynamicObjectCollection entityEntity) {
        for (int index = 0; index < entityEntity.size(); ++index) {
            DynamicObject entryObj = (DynamicObject)entityEntity.get(index);
            boolean summaryFlag = entryObj.getBoolean(ISAUTOENDSUMMARY);
            if (summaryFlag) {
                this.getView().setEnable(Boolean.TRUE, index, new String[]{ISAUTOENDTOPSHOW});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, index, new String[]{ISAUTOENDTOPSHOW});
        }
    }

    private void updateModelCacheAndPage(DynamicObjectCollection entityEntity) {
        this.getModel().updateEntryCache(entityEntity);
        this.getView().updateView(ENTRYENTITY);
        this.getView().updateView(SUBENTRYENTITY);
        this.refreshTopShowEnable(entityEntity);
    }

    private void topShowCountChecker() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        int count = 0;
        for (int index = 0; index < entryEntity.size(); ++index) {
            if (!((DynamicObject)entryEntity.get(index)).getBoolean(ISAUTOENDSUMMARY) || !((DynamicObject)entryEntity.get(index)).getBoolean(ISAUTOENDTOPSHOW)) continue;
            if (count >= 8) {
                int selectedIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
                this.getModel().setValue(ISAUTOENDTOPSHOW, (Object)0, selectedIndex);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81ea\u52a9\u7aef\u9876\u90e8\u6700\u591a\u663e\u793a8\u4e2a\u5de5\u8d44\u6761\u9879\u76ee\u5206\u7ec4\u3002", (String)"SalarySlipViewEdit_25", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                return;
            }
            ++count;
        }
    }

    private void checkOpenConfirmPage(Object oldValue) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity(SUBENTRYENTITY);
        if (entryEntity.isEmpty() && (subEntryEntity == null || subEntryEntity.isEmpty())) {
            return;
        }
        if (null == oldValue) {
            return;
        }
        DynamicObject country = (DynamicObject)oldValue;
        Object countryId = country.get("id");
        String customValue = "";
        if (countryId != null) {
            customValue = String.valueOf(countryId);
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\u5c06\u6e05\u7a7a\u201c\u5de5\u8d44\u6761\u9879\u76ee\u201d\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"SalarySlipViewEdit_29", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(CALLBACK_COUNTRY), null, customValue);
    }

    static {
        LABEL_MAP.put("namelabel", new MultiLangEnumBridge("\u5458\u5de5\u59d3\u540d", "SalarySlipViewEdit_6", "swc-hsbs-formplugin"));
        LABEL_MAP.put("numberlabel", new MultiLangEnumBridge("\u5458\u5de5\u7f16\u53f7", "SalarySlipViewEdit_16", "swc-hsbs-formplugin"));
        LABEL_MAP.put("companylabel", new MultiLangEnumBridge("\u516c\u53f8", "SalarySlipViewEdit_3", "swc-hsbs-formplugin"));
        LABEL_MAP.put("departmentlabel", new MultiLangEnumBridge("\u90e8\u95e8", "SalarySlipViewEdit_4", "swc-hsbs-formplugin"));
        LABEL_MAP.put("joblabel", new MultiLangEnumBridge("\u5c97\u4f4d", "SalarySlipViewEdit_5", "swc-hsbs-formplugin"));
        LABEL_MAP.put("payrolldatelabel", new MultiLangEnumBridge("\u85aa\u8d44\u6240\u5c5e\u5e74\u6708", "SalarySlipViewEdit_17", "swc-hsbs-formplugin"));
        LABEL_MAP.put("daterangelabel", new MultiLangEnumBridge("\u85aa\u8d44\u8d77\u6b62\u65e5\u671f", "SalarySlipViewEdit_18", "swc-hsbs-formplugin"));
        LABEL_MAP.put("calcountlabel", new MultiLangEnumBridge("\u6838\u7b97\u6b21\u6570", "SalarySlipViewEdit_19", "swc-hsbs-formplugin"));
        LABEL_MAP.put("currentdatelabel", new MultiLangEnumBridge("\u5f53\u524d\u65e5\u671f", "SalarySlipViewEdit_7", "swc-hsbs-formplugin"));
        ITEM_MAP = ImmutableMap.builder().put((Object)"SL", (Object)"hsbs_salaryitem").put((Object)"BS", (Object)"hsbs_bizitem").put((Object)"SP", (Object)"hsbs_supportitem").put((Object)"FT", (Object)"hsbs_fetchitem").build();
    }
}

