/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.formplugin.web.view.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.swc.hsbp.business.cal.calitemtree.service.CalItemTreeAndEntryService;
import kd.swc.hsbp.business.cal.calitemtree.service.CalItemTreeService;
import kd.swc.hsbp.common.constants.CalItemTreeConstants;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class CalItemAddPlugin
extends AbstractFormPlugin
implements CalItemTreeConstants,
SearchEnterListener {
    private static final List<String> ITEMLIST = Arrays.asList("hsbs_salaryitem", "hsbs_bizitem", "hsbs_fetchitem", "hsbs_supportitem");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl("treesearchap");
        search.addEnterListener((SearchEnterListener)this);
        Search searchEntry = (Search)this.getView().getControl("columnsearchap");
        searchEntry.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent arg) {
        String searchText;
        Search search = (Search)arg.getSource();
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        CalItemTreeAndEntryService treeService = new CalItemTreeAndEntryService(treeView, this.getView(), ITEMLIST, "itemselectentry");
        if (SWCStringUtils.equals((String)"treesearchap", (String)search.getKey())) {
            searchText = arg.getText();
            List treeNodes = treeService.searchTree(searchText);
            DynamicObjectCollection selectDataCol = this.getView().getModel().getEntryEntity("itemselectentry");
            Set uniqueCodeSet = selectDataCol.stream().map(selectData -> selectData.getString("treenodeid")).collect(Collectors.toSet());
            treeService.checkSelectedTreeNode(treeNodes, uniqueCodeSet);
        }
        if (SWCStringUtils.equals((String)"columnsearchap", (String)search.getKey())) {
            searchText = arg.getText();
            treeService.searchEntry(searchText, Arrays.asList("itemnumber", "itemname"));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map filterMap = (Map)showParameter.getCustomParam("dataFilter");
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        CalItemTreeService treeService = new CalItemTreeService(treeView, this.getView(), ITEMLIST);
        treeService.initTree(filterMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String optKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        CalItemTreeAndEntryService treeService = new CalItemTreeAndEntryService(treeView, this.getView(), ITEMLIST, "itemselectentry");
        switch (optKey = formOperate.getOperateKey()) {
            case "do_moveto": {
                this.openMoveToPage(args);
                break;
            }
            case "do_addcolumn": {
                List mapList = treeService.addColumn("treenodeid");
                ArrayList addItemList = new ArrayList(mapList.size());
                mapList.forEach(dataMap -> {
                    HashMap<String, Object> itemEntryMap = new HashMap<String, Object>(16);
                    itemEntryMap.put("itemcategory", MapUtils.getString((Map)dataMap, (Object)"itemcategory"));
                    itemEntryMap.put("itemnumber", MapUtils.getString((Map)dataMap, (Object)"number"));
                    itemEntryMap.put("itemname", MapUtils.getString((Map)dataMap, (Object)"name"));
                    itemEntryMap.put("itemunicodeid", MapUtils.getLong((Map)dataMap, (Object)"uniquecode"));
                    itemEntryMap.put("treenodeid", MapUtils.getString((Map)dataMap, (Object)"treenodeid"));
                    itemEntryMap.put("itemid", MapUtils.getLong((Map)dataMap, (Object)"id"));
                    itemEntryMap.put("datatypeid", MapUtils.getLong((Map)dataMap, (Object)"datatype.id"));
                    addItemList.add(itemEntryMap);
                });
                treeService.batchCreateNewEntryRow(addItemList);
                break;
            }
            case "do_removecolumn": {
                treeService.removeColumn("treenodeid");
                break;
            }
            case "save": {
                treeService.returnData();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "movetoclosed": {
                this.moveToClosedEvent(evt);
                break;
            }
        }
    }

    private void openMoveToPage(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CalResultTplAddItemPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (rows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"CalResultTplAddItemPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsbs_viewitemmoveto");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u79fb\u52a8\u5230", (String)"CalResultTplAddItemPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "movetoclosed"));
        this.getView().showForm(showParameter);
    }

    private void moveToClosedEvent(ClosedCallBackEvent evt) {
        Map returnData = (Map)evt.getReturnData();
        if (SWCObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String clickStatus = MapUtils.getString((Map)returnData, (Object)"clickStatus");
        if (!SWCStringUtils.equals((String)"ok", (String)clickStatus)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        int oldRow = rows[0];
        int newRow = MapUtils.getIntValue((Map)returnData, (Object)"rownumber");
        IDataModel model = this.getModel();
        DynamicObjectCollection dataCol = model.getEntryEntity("itemselectentry");
        int size = dataCol.size();
        int n = newRow = --newRow > size - 1 ? size - 1 : newRow;
        if (oldRow == newRow) {
            return;
        }
        DynamicObject oldObj = (DynamicObject)dataCol.get(oldRow);
        model.deleteEntryRow("itemselectentry", oldRow);
        model.createNewEntryRow("itemselectentry", newRow, oldObj);
        EntryGrid grid = (EntryGrid)this.getView().getControl("itemselectentry");
        grid.selectRows(newRow, true);
    }
}

