/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.addperson.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.addperson.entity.CalPersonAddProgressInfo;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.vo.SWCOperationResult;

public class AddCalPersonHelper {
    public static final Log logger = LogFactory.getLog(AddCalPersonHelper.class);

    public static void setProgressToCache(long taskId, int size, Map<String, SWCOperationResult> result) {
        CalPersonAddProgressInfo progress = (CalPersonAddProgressInfo)SWCAppCache.get((String)"hsas").get(String.format(Locale.ROOT, "cache_addperson_key_%s", taskId), CalPersonAddProgressInfo.class);
        if (progress != null) {
            SWCOperationResult addpersonResult = result.get("addperson");
            int finishCount = progress.getFinish() + addpersonResult.getTotal();
            int successCount = progress.getSuccess() + addpersonResult.getSuccess();
            int failCount = progress.getFailMap().size() + addpersonResult.getFailMap().size();
            int remain = progress.getTotal() - finishCount;
            progress.getFailMap().putAll(addpersonResult.getFailMap());
            progress.setFinish(finishCount);
            progress.setSuccess(successCount);
            progress.setFail(failCount);
            progress.setRemain(remain);
            progress.setStatus(1);
            if (remain == 0) {
                PayrollTaskHelper.updateCalpayrollTaskPersonCount((Long)taskId);
                progress.setStatus(2);
                SWCAppCache.get((String)"hsas").remove(String.format(Locale.ROOT, "cache_addperson_count_key_%s", taskId));
            }
            SWCAppCache.get((String)"hsas").put(String.format(Locale.ROOT, "cache_addperson_key_%s", taskId), (Object)progress);
        }
    }

    public static Map<Long, String> getOnHoldBillMap(Long calTaskId) {
        SWCDataServiceHelper onholdbillHelper = new SWCDataServiceHelper("hsas_onholdbill");
        QFilter qFilter = new QFilter("caltask", "=", (Object)calTaskId).and(new QFilter("status", "!=", (Object)String.valueOf(OnHoldStatusEnum.STATUS_SAVE.getCode()))).and(QFilter.isNotNull((String)"status"));
        DynamicObjectCollection onholdBills = onholdbillHelper.queryOriginalCollection("status,salaryfile.id", qFilter.toArray());
        return onholdBills.stream().collect(Collectors.toMap(o -> o.getLong("salaryfile.id"), o -> o.getString("status"), (v1, v2) -> v1));
    }

    public static void addAddPerosnLog(Long calTaskId, Boolean isExc) {
        CalPersonAddProgressInfo progress = (CalPersonAddProgressInfo)SWCAppCache.get((String)"hsas").get(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), CalPersonAddProgressInfo.class);
        String opKey = CalPersonOperationEnum.OP_ADDCALPERSON.getOperationKey();
        if (isExc.booleanValue()) {
            opKey = CalPersonOperationEnum.OP_ADDEXCCALPERSON.getOperationKey();
        }
        MultiLangEnumBridge bridge = new MultiLangEnumBridge("\u6dfb\u52a0\u6210\u529f{0}\u4eba\uff0c\u6dfb\u52a0\u5931\u8d25{1}\u4eba\u3002", "AddCalPersonHelper_1", "swc-hscs-business");
        SWCOpLogServiceHelper.addOpLog((String)"hsas", (String)"hsas_calperson", (String)opKey, (String)"", (MultiLangEnumBridge)bridge, (String[])new String[]{String.valueOf(progress.getSuccess()), String.valueOf(progress.getFail())});
    }

    public static Map<Long, Long> assembleExistFileIdList(Long calTaskId, List<Long> fileIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        filter.and("salaryfile.id", "in", fileIdList);
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("id,salaryfile.id", new QFilter[]{filter});
        if (!SWCListUtils.isEmpty((List)personObjs)) {
            List existFileIdList = personObjs.stream().map(single -> single.getLong("salaryfile.id")).collect(Collectors.toList());
            fileIdList.removeAll(existFileIdList);
            return personObjs.stream().collect(Collectors.toMap(v1 -> v1.getLong("id"), v2 -> v2.getLong("salaryfile.id")));
        }
        return new HashMap<Long, Long>(0);
    }

    public static List<Long> getUncalPerson(Collection<Long> personIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", personIdList);
        filter.and("calstatus", "=", (Object)CalStateEnum.UNCAL.getCode());
        DynamicObjectCollection personObjs = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)personObjs)) {
            return new ArrayList<Long>(0);
        }
        return personObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
    }

    public void delCalPerson(List<Long> personId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        helper.delete(personId.toArray());
    }

    public void delCalPersonAndDelCalPersonMark(Long calTaskId, Collection<Long> delCalPersonIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salarydtmark");
        String field = "id,calpersonentry.calpersonid";
        QFilter filter = new QFilter("caltaskid", "=", (Object)calTaskId);
        filter.and("calpersonentry.calpersonid", "in", delCalPersonIdSet);
        DynamicObject[] markColl = helper.query(field, new QFilter[]{filter}, null);
        if (markColl == null || markColl.length == 0) {
            return;
        }
        ArrayList<Long> delCalPersonEntryIdList = new ArrayList<Long>(10);
        for (DynamicObject markObj : markColl) {
            DynamicObjectCollection calPersonEntry = markObj.getDynamicObjectCollection("calpersonentry");
            for (DynamicObject calPersonObj : calPersonEntry) {
                long calPersonId = calPersonObj.getLong("calpersonid");
                if (!delCalPersonIdSet.contains(calPersonId)) continue;
                delCalPersonEntryIdList.add(calPersonObj.getLong("id"));
            }
        }
        if (delCalPersonEntryIdList == null || delCalPersonEntryIdList.size() == 0) {
            return;
        }
        String deleteSqlModel = "DELETE FROM T_HSAS_CALPERSONMARK WHERE FENTRYID IN ({0})";
        int size = delCalPersonEntryIdList.size();
        int partCount = size / 500;
        if (partCount * 500 < size) {
            ++partCount;
        }
        for (int index = 1; index <= partCount; ++index) {
            int start = (index - 1) * 500;
            int end = index * 500;
            end = end > size ? size : end;
            List partTaskIdList = delCalPersonEntryIdList.subList(start, end);
            StringBuilder sb = new StringBuilder();
            Iterator iterator = partTaskIdList.iterator();
            while (iterator.hasNext()) {
                sb.append(String.valueOf(iterator.next()));
                if (!iterator.hasNext()) continue;
                sb.append(',');
            }
            String deleteSql = MessageFormat.format(deleteSqlModel, sb.toString());
            SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)deleteSql, (Object[])new Object[0]);
        }
    }

    public void deleteProration(List<Long> calPersonIdList) {
        if (CollectionUtils.isEmpty(calPersonIdList)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calprorationrel");
        QFilter[] filters = new QFilter[]{new QFilter("calpersonid", "in", calPersonIdList)};
        DynamicObject[] calProrationRels = helper.queryOriginalArray("id,prorationevent.id", filters);
        if (calProrationRels == null || calProrationRels.length == 0) {
            return;
        }
        Object[] pks = new Object[calProrationRels.length];
        LinkedList<Long> eventIds = new LinkedList<Long>();
        for (int index = 0; index < calProrationRels.length; ++index) {
            pks[index] = calProrationRels[index].get("id");
            eventIds.add(calProrationRels[index].getLong("prorationevent.id"));
        }
        helper.delete(pks);
        DynamicObjectCollection existRels = helper.queryOriginalCollection("prorationevent.id", new QFilter[]{new QFilter("prorationevent.id", "in", eventIds)});
        Set existEventIdSet = existRels.stream().map(existRel -> existRel.getLong("prorationevent.id")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(existEventIdSet)) {
            eventIds.removeAll(existEventIdSet);
        }
        if (!CollectionUtils.isEmpty(eventIds)) {
            DynamicObject[] prorationEvents;
            helper.setEntityName("hsas_prorationevent");
            for (DynamicObject prorationEvent : prorationEvents = helper.query(eventIds.toArray())) {
                prorationEvent.set("referencestatus", (Object)"1");
            }
            helper.update(prorationEvents);
        }
        helper.setEntityName("hsas_slprorationrecord");
        helper.deleteByFilter(filters);
    }

    public void cleanPersonCoverData(List<Long> personIdList) {
        if (SWCListUtils.isEmpty(personIdList)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        QFilter filter = new QFilter("calperson", "in", personIdList);
        helper.deleteByFilter(new QFilter[]{filter});
        helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        helper.deleteByFilter(new QFilter[]{filter});
    }

    public void updatePersonCount(Long calTaskId) {
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        SWCDataServiceHelper calpersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter taskFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        int count = calpersonHelper.count(new QFilter[]{taskFilter});
        DynamicObject task = taskHelper.queryOne("id,calpersoncount", (Object)calTaskId);
        task.set("calpersoncount", (Object)count);
        taskHelper.updateOne(task);
    }
}

