/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.addperson.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ProrationGenerateService {
    public final Log log = LogFactory.getLog(ProrationGenerateService.class);
    private List<DynamicObject> calPersonList;
    private List<Long> salaryFileIdList;
    private DynamicObject calTask;
    private Date startDate;
    private Date endDate;
    private Set<Long> calItemIdSet;

    public ProrationGenerateService(DynamicObject calTask, List<DynamicObject> calPersonList) {
        this.calTask = calTask;
        this.calPersonList = calPersonList;
        this.startDate = calTask.getDate("startdate");
        this.endDate = calTask.getDate("enddate");
        if (!CollectionUtils.isEmpty(calPersonList)) {
            this.salaryFileIdList = calPersonList.stream().map(calPerson -> calPerson.getLong("salaryfile")).collect(Collectors.toList());
        }
        this.collectCalItem();
    }

    private void collectCalItem() {
        Long calRuleId = this.calTask.getLong("calrulev.id");
        SWCDataServiceHelper calRuleHelper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject calRule = calRuleHelper.queryOne("salaryitem.id", (Object)calRuleId);
        DynamicObjectCollection entrys = calRule.getDynamicObjectCollection("calruleitementry");
        this.calItemIdSet = new HashSet<Long>(entrys.size());
        for (DynamicObject entry : entrys) {
            this.calItemIdSet.add(entry.getLong("salaryitem.id"));
        }
    }

    public void generateProration() {
        if (CollectionUtils.isEmpty(this.calPersonList)) {
            return;
        }
        this.generateItemProration();
    }

    public static void deleteProration(Set<Long> calPersonIdSet) {
        if (CollectionUtils.isEmpty(calPersonIdSet)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calprorationrel");
        QFilter[] filters = new QFilter[]{new QFilter("calpersonid", "in", calPersonIdSet)};
        DynamicObject[] calProrationRels = helper.queryOriginalArray("id,prorationevent.id", filters);
        if (calProrationRels == null || calProrationRels.length == 0) {
            return;
        }
        Object[] pks = new Object[calProrationRels.length];
        LinkedList<Long> eventIds = new LinkedList<Long>();
        for (int index = 0; index < calProrationRels.length; ++index) {
            pks[index] = calProrationRels[index].get("id");
            eventIds.add(calProrationRels[index].getLong("prorationevent.id"));
        }
        helper.delete(pks);
        DynamicObjectCollection existRels = helper.queryOriginalCollection("prorationevent.id", new QFilter[]{new QFilter("prorationevent.id", "in", eventIds)});
        Set existEventIdSet = existRels.stream().map(existRel -> existRel.getLong("prorationevent.id")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(existEventIdSet)) {
            eventIds.removeAll(existEventIdSet);
        }
        if (!CollectionUtils.isEmpty(eventIds)) {
            DynamicObject[] prorationEvents;
            helper.setEntityName("hsas_prorationevent");
            for (DynamicObject prorationEvent : prorationEvents = helper.query(eventIds.toArray())) {
                prorationEvent.set("referencestatus", (Object)"1");
            }
            helper.update(prorationEvents);
        }
        helper.setEntityName("hsas_slprorationrecord");
        helper.deleteByFilter(filters);
    }

    private void generateItemProration() {
        DynamicObject[] calPersons;
        this.log.info("\u5f00\u59cb\u5904\u7406\u9879\u76ee\u5206\u6bb5\u3002");
        Date startHandleDate = new Date();
        DynamicObject[] itemProrationEvents = this.queryProrationEvent("0");
        if (itemProrationEvents == null || itemProrationEvents.length == 0) {
            this.log.info("\u9879\u76ee\u5206\u6bb5\u63d0\u524d\u7ed3\u675f\uff0c\u65e0\u9700\u5206\u6bb5");
            return;
        }
        Date date = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        Map<Long, List<DynamicObject>> calPersonMap = this.calPersonList.stream().collect(Collectors.groupingBy(calPerson -> calPerson.getLong("salaryfile")));
        MainEntityType calProrationRelType = EntityMetadataCache.getDataEntityType((String)"hsas_calprorationrel");
        List<DynamicObject> calProrationRelList = this.createCalProrationRel((DynamicObjectType)calProrationRelType, calPersonMap, itemProrationEvents, userId, date);
        new SWCDataServiceHelper("hsas_calprorationrel").save(calProrationRelList.toArray(new DynamicObject[0]));
        this.log.info("\u751f\u6210\u5206\u6bb5\u4e8b\u4ef6\u5173\u7cfb\u8bb0\u5f55\u6570{}\u6761\u3002", (Object)calProrationRelList.size());
        List<DynamicObject> slProrationRecordList = this.batchCreateSlProrationRecord(itemProrationEvents, calPersonMap, userId, date);
        if (CollectionUtils.isEmpty(slProrationRecordList)) {
            this.log.info("\u9879\u76ee\u5206\u6bb5\u63d0\u524d\u7ed3\u675f\uff0c\u65e0\u9700\u5206\u6bb5");
            return;
        }
        new SWCDataServiceHelper("hsas_slprorationrecord").save(slProrationRecordList.toArray(new DynamicObject[0]));
        HashSet<Long> prorationCalPersonIdSet = new HashSet<Long>(this.calPersonList.size());
        HashSet<Long> usedEventIdSet = new HashSet<Long>(itemProrationEvents.length);
        for (DynamicObject slProrationRecord : slProrationRecordList) {
            prorationCalPersonIdSet.add(slProrationRecord.getLong("calpersonid"));
            DynamicObject[] events = slProrationRecord.getDynamicObjectCollection("prorationevent");
            for (DynamicObject event : events) {
                usedEventIdSet.add(event.getDynamicObject("fbasedataid").getLong("id"));
            }
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        for (DynamicObject calPerson2 : calPersons = calPersonHelper.query("id,isproration", new QFilter[]{new QFilter("id", "in", prorationCalPersonIdSet)})) {
            calPerson2.set("isproration", (Object)"1");
        }
        calPersonHelper.update(calPersons);
        ArrayList<DynamicObject> updateEvents = new ArrayList<DynamicObject>(itemProrationEvents.length);
        for (DynamicObject itemProrationEvent : itemProrationEvents) {
            if (!usedEventIdSet.contains(itemProrationEvent.getLong("id"))) continue;
            itemProrationEvent.set("referencestatus", (Object)"2");
            updateEvents.add(itemProrationEvent);
        }
        if (!CollectionUtils.isEmpty(updateEvents)) {
            new SWCDataServiceHelper("hsas_prorationevent").update(updateEvents.toArray(new DynamicObject[0]));
        }
        Date endHandleTime = new Date();
        this.log.info("\u9879\u76ee\u5206\u6bb5\u5904\u7406\u7ed3\u675f\uff0c\u8017\u65f6{}\u79d2\uff0c\u751f\u6210\u5206\u6bb5\u4e8b\u4ef6\u5173\u7cfb\u8bb0\u5f55\u6570{}\u6761\u3002", (Object)SWCDateTimeUtils.secondsTo((long)(endHandleTime.getTime() - startHandleDate.getTime())), (Object)slProrationRecordList.size());
    }

    private List<DynamicObject> batchCreateSlProrationRecord(DynamicObject[] itemProrationEvents, Map<Long, List<DynamicObject>> calPersonMap, Long userId, Date date) {
        this.log.info("\u5f00\u59cb\u6279\u91cf\u521b\u5efa\u9879\u76ee\u5206\u6bb5\u8bb0\u5f55");
        Map<Long, Map<Long, List<DynamicObject>>> prorationInfoMap = this.getItemProrationInfoMap(itemProrationEvents);
        LinkedList<DynamicObject> slProrationRecordList = new LinkedList<DynamicObject>();
        for (DynamicObject calPerson : this.calPersonList) {
            Long salaryFileId = calPerson.getLong("salaryfile");
            Long calPersonId = calPerson.getLong("id");
            Map<Long, List<DynamicObject>> itemInfo = prorationInfoMap.get(salaryFileId);
            if (itemInfo == null) continue;
            for (Map.Entry<Long, List<DynamicObject>> entry : itemInfo.entrySet()) {
                Long salaryItemId = entry.getKey();
                List<DynamicObject> prorationEventList = entry.getValue();
                if (!this.calItemIdSet.contains(salaryItemId) || CollectionUtils.isEmpty(prorationEventList)) continue;
                ArrayList<DynamicObject> newProrationRecordList = new ArrayList<DynamicObject>(prorationEventList.size() + 1);
                this.createSlProrationRecord(prorationEventList, newProrationRecordList, calPersonId, salaryItemId, userId, date);
                if (!CollectionUtils.isEmpty(newProrationRecordList)) {
                    ((DynamicObject)newProrationRecordList.get(newProrationRecordList.size() - 1)).set("enddate", (Object)this.endDate);
                }
                slProrationRecordList.addAll(newProrationRecordList);
            }
        }
        this.checkSalaryFilev(slProrationRecordList, calPersonMap.keySet());
        return slProrationRecordList;
    }

    private void createSlProrationRecord(List<DynamicObject> prorationEventList, List<DynamicObject> newProrationRecordList, Long calPersonId, Long salaryItemId, Long userId, Date date) {
        MainEntityType slProrationRecordType = EntityMetadataCache.getDataEntityType((String)"hsas_slprorationrecord");
        HashSet<Date> dateSet = new HashSet<Date>(prorationEventList.size());
        for (DynamicObject prorationEvent : prorationEventList) {
            Date prorationDate = prorationEvent.getDate("prorationdate");
            if (dateSet.contains(prorationDate)) continue;
            dateSet.add(prorationDate);
            ArrayList<Long> eventIdList = new ArrayList<Long>(1);
            eventIdList.add(prorationEvent.getLong("id"));
            if (CollectionUtils.isEmpty(newProrationRecordList) && prorationDate.after(this.startDate)) {
                DynamicObject headRecord = this.generateSlProrationRecord((DynamicObjectType)slProrationRecordType, calPersonId, salaryItemId, this.startDate, userId, date);
                newProrationRecordList.add(headRecord);
            }
            DynamicObject slProrationRecord = this.generateSlProrationRecord((DynamicObjectType)slProrationRecordType, calPersonId, salaryItemId, prorationDate, userId, date);
            SWCHisBaseDataHelper.setMulBaseDataFieldValue((DynamicObject)slProrationRecord, (String)"prorationevent", eventIdList);
            if (!CollectionUtils.isEmpty(newProrationRecordList)) {
                Date lastEndDate = SWCDateTimeUtils.addDay((Date)prorationDate, (long)-1L);
                DynamicObject lastProrationRecord = newProrationRecordList.get(newProrationRecordList.size() - 1);
                lastProrationRecord.set("enddate", (Object)lastEndDate);
                SWCHisBaseDataHelper.setMulBaseDataFieldValue((DynamicObject)lastProrationRecord, (String)"prorationevent", eventIdList);
            }
            newProrationRecordList.add(slProrationRecord);
        }
    }

    private void checkSalaryFilev(List<DynamicObject> slProrationRecordList, Set<Long> salaryFileIdSet) {
        this.log.info("\u5f00\u59cb\u6821\u9a8c\u6863\u6848\u7248\u672c");
        SWCDataServiceHelper salaryFileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("boid", "in", salaryFileIdSet);
        filter.and(new QFilter("paystatus", "=", (Object)"1"));
        filter.and(BaseDataHisHelper.getHisVerFilter());
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and("datastatus", "in", Arrays.asList("0", "1", "2"));
        DynamicObjectCollection salaryFiles = salaryFileHelper.queryOriginalCollection("boid,bsed,bsled", new QFilter[]{filter}, "bsed asc");
        Map<Long, List<DynamicObject>> salaryFileMap = salaryFiles.stream().collect(Collectors.groupingBy(salaryFile -> salaryFile.getLong("boid")));
        Map<Long, Long> salaryFileIdMap = this.calPersonList.stream().collect(Collectors.toMap(calPerson -> calPerson.getLong("id"), calPerson -> calPerson.getLong("salaryfile")));
        Iterator<DynamicObject> iterator = slProrationRecordList.iterator();
        while (iterator.hasNext()) {
            DynamicObject record = iterator.next();
            Date prorationStartDate = record.getDate("startdate");
            Date prorationEndDate = record.getDate("enddate");
            Long calPersonId = record.getLong("calpersonid");
            List<DynamicObject> salaryFilevList = salaryFileMap.get(salaryFileIdMap.get(calPersonId));
            if (CollectionUtils.isEmpty(salaryFilevList)) {
                iterator.remove();
                continue;
            }
            boolean isFail = true;
            for (DynamicObject salaryFilev : salaryFilevList) {
                Date bsed = salaryFilev.getDate("bsed");
                Date bsled = salaryFilev.getDate("bsled");
                if (bsed == null) continue;
                if (bsed.after(prorationEndDate)) break;
                if (bsled != null && bsled.before(prorationStartDate)) continue;
                isFail = false;
                break;
            }
            if (!isFail) continue;
            iterator.remove();
        }
    }

    private DynamicObject generateSlProrationRecord(DynamicObjectType slProrationRecordType, Long calPersonId, Long salaryItemId, Date startDate, Long userId, Date date) {
        DynamicObject slProrationRecord = (DynamicObject)slProrationRecordType.createInstance();
        slProrationRecord.set("calpersonid", (Object)calPersonId);
        slProrationRecord.set("salaryitem", (Object)salaryItemId);
        slProrationRecord.set("startdate", (Object)startDate);
        slProrationRecord.set("creator", (Object)userId);
        slProrationRecord.set("modifier", (Object)userId);
        slProrationRecord.set("createtime", (Object)date);
        slProrationRecord.set("modifytime", (Object)date);
        slProrationRecord.set("caltaskid", (Object)this.calTask.getLong("id"));
        return slProrationRecord;
    }

    private List<DynamicObject> createCalProrationRel(DynamicObjectType calProrationRelType, Map<Long, List<DynamicObject>> calPersonMap, DynamicObject[] itemProrationEvents, Long userId, Date date) {
        Long calTaskId = this.calTask.getLong("id");
        LinkedList<DynamicObject> newCalProrationRelList = new LinkedList<DynamicObject>();
        for (DynamicObject prorationEvent : itemProrationEvents) {
            DynamicObject calProrationRel = (DynamicObject)calProrationRelType.createInstance();
            calProrationRel.set("prorationevent", (Object)prorationEvent.getLong("id"));
            calProrationRel.set("caltask", (Object)calTaskId);
            calProrationRel.set("calpersonid", (Object)calPersonMap.get(prorationEvent.getLong("salaryfile.id")).get(0).getLong("id"));
            calProrationRel.set("creator", (Object)userId);
            calProrationRel.set("modifier", (Object)userId);
            calProrationRel.set("createtime", (Object)date);
            calProrationRel.set("modifytime", (Object)date);
            newCalProrationRelList.add(calProrationRel);
        }
        return newCalProrationRelList;
    }

    private Map<Long, Map<Long, List<DynamicObject>>> getItemProrationInfoMap(DynamicObject[] itemProrationEvents) {
        if (itemProrationEvents == null || itemProrationEvents.length == 0) {
            return new HashMap<Long, Map<Long, List<DynamicObject>>>(0);
        }
        HashMap<Long, Map<Long, List<DynamicObject>>> proratinInfoMap = new HashMap<Long, Map<Long, List<DynamicObject>>>(this.salaryFileIdList.size());
        for (DynamicObject proratinEvent : itemProrationEvents) {
            Long salaryFileId = proratinEvent.getLong("salaryfile.id");
            DynamicObjectCollection salaryItems = proratinEvent.getDynamicObjectCollection("salaryitem");
            Map itemInfo = proratinInfoMap.computeIfAbsent(salaryFileId, key -> new HashMap(16));
            for (DynamicObject salaryItem : salaryItems) {
                Long salaryItemId = salaryItem.getDynamicObject("fbasedataid").getLong("id");
                List eventList = itemInfo.computeIfAbsent(salaryItemId, key -> new LinkedList());
                eventList.add(proratinEvent);
            }
        }
        return proratinInfoMap;
    }

    private DynamicObject[] queryProrationEvent(String prorationType) {
        Long payrollGrpId = this.calTask.getLong("payrollgroupv.id");
        Long payrollScenevId = this.calTask.getLong("payrollscene.id");
        SWCDataServiceHelper payrollGrpHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter filter = new QFilter("id", "=", (Object)payrollGrpId);
        filter.and(new QFilter("payrollsceneentry.payrollscene", "=", (Object)payrollScenevId));
        DynamicObjectCollection payrollGrps = payrollGrpHelper.queryOriginalCollection("payrollsceneentry.prorationgenrule.id", new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)payrollGrps)) {
            return null;
        }
        SWCDataServiceHelper prorationEventHelper = new SWCDataServiceHelper("hsas_prorationevent");
        filter = new QFilter("salaryFile", "in", this.salaryFileIdList);
        filter.and(new QFilter("prorationtype", "=", (Object)prorationType));
        filter.and(new QFilter("prorationdate", "<=", (Object)this.endDate));
        filter.and(new QFilter("prorationdate", ">", (Object)this.startDate));
        filter.and(new QFilter("prorationgenrule", "=", (Object)((DynamicObject)payrollGrps.get(0)).getLong("payrollsceneentry.prorationgenrule.id")));
        filter.and(new QFilter("eventstatus", "=", (Object)"1"));
        DynamicObject[] proratinEvents = prorationEventHelper.query("id,salaryitem.id,prorationdate,salaryfile.id,createtime,referencestatus", filter.toArray(), "prorationdate asc,createtime desc");
        return proratinEvents;
    }

    public void checkUpdate(DynamicObjectCollection newCalPersons, DynamicObject[] oldCalPersons, Set<Long> updateIdsCache) {
        this.log.info("\u5f00\u59cb\u6821\u9a8c\u5206\u6bb5\u66f4\u65b0");
        long[] ids = DB.genLongIds((String)"t_hsas_calperson", (int)newCalPersons.size());
        for (int index = 0; index < newCalPersons.size(); ++index) {
            ((DynamicObject)newCalPersons.get(index)).set("id", (Object)ids[index]);
        }
        ArrayList<DynamicObject> waitToCheckNewCalPersons = new ArrayList<DynamicObject>(oldCalPersons.length);
        LinkedList<Long> oldCalPersonIdList = new LinkedList<Long>();
        HashMap<Long, Long> calPersonIdMap = new HashMap<Long, Long>(oldCalPersons.length);
        this.salaryFileIdList = new ArrayList<Long>(oldCalPersons.length);
        for (int index = 0; index < oldCalPersons.length; ++index) {
            DynamicObject oldCalPerson = oldCalPersons[index];
            DynamicObject newCalPerson = (DynamicObject)newCalPersons.get(index);
            if (updateIdsCache.contains(newCalPerson.getLong("salaryfilev.id"))) continue;
            waitToCheckNewCalPersons.add(newCalPerson);
            oldCalPersonIdList.add(oldCalPerson.getLong("id"));
            this.salaryFileIdList.add(oldCalPerson.getLong("salaryfile.id"));
            calPersonIdMap.put(newCalPerson.getLong("id"), oldCalPerson.getLong("id"));
        }
        if (CollectionUtils.isEmpty(oldCalPersonIdList)) {
            return;
        }
        DynamicObject[] itemProrationEvents = this.queryProrationEvent("0");
        if (itemProrationEvents == null || itemProrationEvents.length == 0) {
            this.log.info("\u9879\u76ee\u5206\u6bb5\u66f4\u65b0\u68c0\u6d4b\u63d0\u524d\u7ed3\u675f\uff0c\u65e0\u9700\u5206\u6bb5");
            return;
        }
        this.checkEventChange(itemProrationEvents, oldCalPersonIdList, waitToCheckNewCalPersons, updateIdsCache, calPersonIdMap);
        if (!CollectionUtils.isEmpty(waitToCheckNewCalPersons)) {
            this.checkProrationResult(itemProrationEvents, oldCalPersonIdList, waitToCheckNewCalPersons, calPersonIdMap, updateIdsCache);
        }
        this.log.info("\u6821\u9a8c\u5206\u6bb5\u66f4\u65b0\u7ed3\u675f");
    }

    private void checkProrationResult(DynamicObject[] itemProrationEvents, List<Long> oldCalPersonIdList, List<DynamicObject> waitToCheckNewCalPersons, Map<Long, Long> calPersonIdMap, Set<Long> updateIdsCache) {
        this.log.info("\u5f00\u59cb\u68c0\u67e5\u5206\u6bb5\u5907\u4efd\u7ed3\u679c\u662f\u5426\u53d8\u5316");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_slprorationrecord");
        DynamicObjectCollection oldRecords = helper.queryOriginalCollection("salaryitem.id,calpersonid,startdate,enddate", new QFilter[]{new QFilter("calpersonid", "in", oldCalPersonIdList)}, "startdate asc");
        HashMap<Long, Map<Long, List<String>>> oldItemInfoMap = new HashMap<Long, Map<Long, List<String>>>(oldCalPersonIdList.size());
        for (DynamicObject slProrationRecord : oldRecords) {
            Map itemInfo = oldItemInfoMap.computeIfAbsent(slProrationRecord.getLong("calpersonid"), key -> new HashMap(16));
            List itemList = itemInfo.computeIfAbsent(slProrationRecord.getLong("salaryitem.id"), key -> new ArrayList(10));
            itemList.add(SWCDateTimeUtils.format((Date)slProrationRecord.getDate("startdate"), (String)"yyyy-MM-dd") + '_' + SWCDateTimeUtils.format((Date)slProrationRecord.getDate("enddate"), (String)"yyyy-MM-dd"));
        }
        this.calPersonList = waitToCheckNewCalPersons;
        Map<Long, List<DynamicObject>> calPersonMap = waitToCheckNewCalPersons.stream().collect(Collectors.groupingBy(calPerson -> calPerson.getLong("salaryfile")));
        List<DynamicObject> slProrationRecordList = this.batchCreateSlProrationRecord(itemProrationEvents, calPersonMap, null, null);
        HashMap<Long, Map> itemInfoMap = new HashMap<Long, Map>(waitToCheckNewCalPersons.size());
        for (DynamicObject slProrationRecord : slProrationRecordList) {
            Map map = itemInfoMap.computeIfAbsent(slProrationRecord.getLong("calpersonid"), key -> new HashMap(16));
            List itemList = map.computeIfAbsent(slProrationRecord.getLong("salaryitem"), key -> new ArrayList(10));
            itemList.add(SWCDateTimeUtils.format((Date)slProrationRecord.getDate("startdate"), (String)"yyyy-MM-dd") + '_' + SWCDateTimeUtils.format((Date)slProrationRecord.getDate("enddate"), (String)"yyyy-MM-dd"));
        }
        Map<Long, DynamicObject> calPersonMapWithId = waitToCheckNewCalPersons.stream().collect(Collectors.toMap(calPerson -> calPerson.getLong("id"), calPerson -> calPerson));
        for (Map.Entry<Long, Map<Long, List<String>>> entry : itemInfoMap.entrySet()) {
            this.checkDateValid(entry, oldItemInfoMap, calPersonIdMap, updateIdsCache, calPersonMapWithId);
        }
    }

    private void checkDateValid(Map.Entry<Long, Map<Long, List<String>>> itemInfo, Map<Long, Map<Long, List<String>>> oldItemInfoMap, Map<Long, Long> calPersonIdMap, Set<Long> updateIdsCache, Map<Long, DynamicObject> calPersonMapWithId) {
        Long newCalPersonId = itemInfo.getKey();
        Map<Long, List<String>> oldItemInfo = oldItemInfoMap.get(calPersonIdMap.get(newCalPersonId));
        if (oldItemInfo == null) {
            updateIdsCache.add(calPersonMapWithId.get(newCalPersonId).getLong("salaryfilev.id"));
            return;
        }
        for (Map.Entry<Long, List<String>> itemEntry : itemInfo.getValue().entrySet()) {
            List<String> oldItemList = oldItemInfo.get(itemEntry.getKey());
            List<String> newItemList = itemEntry.getValue();
            if (CollectionUtils.isEmpty(oldItemList) || oldItemList.size() != newItemList.size()) {
                updateIdsCache.add(calPersonMapWithId.get(newCalPersonId).getLong("salaryfilev.id"));
                break;
            }
            boolean isDiffernt = false;
            for (int index = 0; index < newItemList.size(); ++index) {
                this.log.info(MessageFormat.format("compare proration item:{0}, new:{1}, old:{2}", itemEntry.getKey(), newItemList.get(index), oldItemList.get(index)));
                if (SWCStringUtils.equals((String)newItemList.get(index), (String)oldItemList.get(index))) continue;
                isDiffernt = true;
                break;
            }
            if (!isDiffernt) continue;
            updateIdsCache.add(calPersonMapWithId.get(newCalPersonId).getLong("salaryfilev.id"));
            break;
        }
    }

    private void checkEventChange(DynamicObject[] itemProrationEvents, List<Long> oldCalPersonIdList, List<DynamicObject> newCalPersons, Set<Long> updateIdsCache, Map<Long, Long> calPersonIdMap) {
        this.log.info("\u5f00\u59cb\u6821\u9a8c\u5206\u6bb5\u4e8b\u4ef6\u53d8\u66f4");
        Map<Long, DynamicObject> eventMap = Arrays.stream(itemProrationEvents).collect(Collectors.toMap(event -> event.getLong("id"), event -> event));
        SWCDataServiceHelper calProrationRelHelper = new SWCDataServiceHelper("hsas_calprorationrel");
        DynamicObjectCollection calProrationRels = calProrationRelHelper.queryOriginalCollection("id,prorationevent.id", new QFilter[]{new QFilter("calpersonid", "in", oldCalPersonIdList)});
        for (DynamicObject calProrationRel : calProrationRels) {
            eventMap.remove(calProrationRel.getLong("prorationevent.id"));
        }
        if (eventMap.size() == 0) {
            this.log.info("\u672a\u53d1\u751f\u5206\u6bb5\u4e8b\u4ef6\u53d8\u66f4");
            return;
        }
        Set salaryFileIdSet = eventMap.values().stream().map(event -> event.getLong("salaryfile.id")).collect(Collectors.toSet());
        Iterator<DynamicObject> iterator = newCalPersons.iterator();
        while (iterator.hasNext()) {
            DynamicObject calPerson = iterator.next();
            if (!salaryFileIdSet.contains(calPerson.getLong("salaryfile"))) continue;
            updateIdsCache.add(calPerson.getLong("salaryfilev.id"));
            iterator.remove();
            oldCalPersonIdList.remove(calPersonIdMap.get(calPerson.getLong("id")));
        }
        this.log.info("\u6821\u9a8c\u5206\u6bb5\u4e8b\u4ef6\u53d8\u66f4\u6821\u9a8c\u7ed3\u675f");
    }
}

