/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.attintegrate.handler;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.attinteg.IAttIntegrateExtPlugin;
import kd.sdk.swc.hsas.common.events.attinteg.AfterCreateBizDataEvent;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.enums.BizDataSrcSystemEnum;
import kd.swc.hsbp.common.enums.IgnoredStateEnum;
import kd.swc.hsbp.common.enums.IntegrationProcessStateEnum;
import kd.swc.hsbp.common.enums.ProcessResultEnum;
import kd.swc.hsbp.common.enums.WriteBackStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hscs.business.attintegrate.DefaultAttIntegrateExtPlugin;
import kd.swc.hscs.business.attintegrate.IntegrateState;
import kd.swc.hscs.business.attintegrate.handler.AbstractIntegrateHandler;
import kd.swc.hscs.business.bizdata.BizDataServiceHelper;
import kd.swc.hscs.business.salaryfile.SalaryFileServiceHelper;

public class BizDataIntegrateHandler
extends AbstractIntegrateHandler {
    private static final Log LOGGER = LogFactory.getLog(BizDataIntegrateHandler.class);
    private SWCDataServiceHelper salaryFileService = new SWCDataServiceHelper("hsas_salaryfile");
    private SWCDataServiceHelper calPeriodTypeService = new SWCDataServiceHelper("hsbs_calperiodtype");
    private SWCDataServiceHelper integMapScmService = new SWCDataServiceHelper("hsbs_attintegmapscm");
    private BizDataServiceHelper bizDataServiceHelper = new BizDataServiceHelper();
    private Map<String, Long> orgCountToScmMap;
    private Map<Long, DynamicObject> scmMap;
    private Map<Long, DynamicObject> periodTypeMap;
    private Map<Long, Map<Long, Long>> scmToItemMap;
    private HRPluginProxy<IAttIntegrateExtPlugin> extProxy = HRPlugInProxyFactory.create((Object)new DefaultAttIntegrateExtPlugin(), IAttIntegrateExtPlugin.class, (String)"kd.sdk.swc.hsas.business.extpoint.attinteg.IAttIntegrateExtPlugin#afterCreateBizData", null);

    public BizDataIntegrateHandler(DynamicObject summaryLog, DynamicObject batchLog, Long operator) {
        super(summaryLog, batchLog, operator);
    }

    @Override
    public boolean init() {
        DynamicObject[] result = this.integMapScmService.query("org,country,attperiod,calperiodtype,matchtype,attitem,bizitem", new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        if (result.length == 0) {
            LOGGER.warn("hsbs_attintegmapscm data is empty");
            return false;
        }
        this.scmMap = Arrays.stream(result).collect(Collectors.toMap(scheme -> scheme.getLong("id"), scheme -> scheme));
        this.orgCountToScmMap = new HashMap<String, Long>(this.scmMap.size());
        this.scmToItemMap = new HashMap<Long, Map<Long, Long>>(this.scmMap.size());
        this.periodTypeMap = new HashMap<Long, DynamicObject>(this.scmMap.size());
        HashSet<Long> periodTypeIdSet = new HashSet<Long>(this.scmMap.size());
        for (DynamicObject dynamicObject : this.scmMap.values()) {
            long salaryCalcOrg = dynamicObject.getLong("org.id");
            long country = dynamicObject.getLong("country.id");
            String key = String.format("%d_%d", salaryCalcOrg, country);
            if (this.orgCountToScmMap.containsKey(key)) {
                LOGGER.warn("hsbs_attintegmapscm data is duplicated, salaryCalcOrgId= {} ,countryId= {} ", (Object)salaryCalcOrg, (Object)country);
                continue;
            }
            long scmId = dynamicObject.getLong("id");
            this.orgCountToScmMap.put(key, scmId);
            periodTypeIdSet.add(dynamicObject.getLong("calperiodtype.id"));
            Map pairs = this.scmToItemMap.computeIfAbsent(scmId, value -> new HashMap());
            DynamicObjectCollection entryRows = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : entryRows) {
                long attItemId = entryRow.getLong("attitem.id");
                long bizItemId = entryRow.getLong("bizitem.id");
                pairs.put(attItemId, bizItemId);
            }
        }
        DynamicObject[] periodTypeResult = this.calPeriodTypeService.query("id,startdate,enddate", new QFilter[]{new QFilter("id", "in", periodTypeIdSet)});
        this.periodTypeMap = new HashMap<Long, DynamicObject>(periodTypeResult.length);
        for (DynamicObject periodTypeObj : periodTypeResult) {
            DynamicObjectCollection periodEntry = periodTypeObj.getDynamicObjectCollection("entryentity");
            long id = periodTypeObj.getLong("id");
            for (DynamicObject periodRow : periodEntry) {
                if (periodRow.get("startdate") != null && periodRow.get("enddate") != null) continue;
                LOGGER.warn("periodType data error");
            }
            Iterator iterator = periodEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject periodRow;
                periodRow = (DynamicObject)iterator.next();
                if (periodRow.get("startdate") != null && periodRow.get("enddate") != null) continue;
                LOGGER.warn("periodType data error");
                iterator.remove();
            }
            periodEntry.sort(Comparator.comparing(object -> object.getDate("startdate")));
            this.periodTypeMap.putIfAbsent(id, periodTypeObj);
        }
        return true;
    }

    @Override
    public void handleData() {
        Map<Long, DynamicObject> fileLogMap = Arrays.stream(this.fileLogs).collect(Collectors.toMap(obj -> obj.getLong("attfileid"), Function.identity()));
        Map<Long, Map<Long, Map<Long, Map<String, Object>>>> dataMap = this.groupByFileIdDepEmpIdAndSumItemId(this.rows);
        HashSet<String> tagNumberSet = new HashSet<String>(this.rows.size());
        for (Map row : this.rows) {
            tagNumberSet.add((String)row.get("tagnumber"));
        }
        HashMap<String, Long> fileDepEmpToScmMap = new HashMap<String, Long>();
        SalaryFileServiceHelper fileServiceHelper = new SalaryFileServiceHelper();
        List<Map<String, Object>> queryParam = this.fetchParamForSalaryFileQuery(this.rows);
        List<Map<String, Object>> result = fileServiceHelper.matchSalaryFileAndValidate(queryParam);
        Map<String, Long> depEmpToFileMap = this.groupByDepEmpAndDate(result);
        DynamicObject[] fileResult = this.salaryFileService.query("id,org,payrollregion,payrollgroup,adminorg,empgroup", new QFilter[]{new QFilter("id", "in", depEmpToFileMap.values())});
        Map<Long, DynamicObject> fileMap = Arrays.stream(fileResult).collect(Collectors.toMap(file -> file.getLong("id"), Function.identity()));
        DynamicObject[] oldBizResult = this.bizDataService.query("id,batchnumber,identifynumber", new QFilter[]{new QFilter("batchnumber", "=", (Object)this.batchVersionId), new QFilter("identifynumber", "in", tagNumberSet)});
        HashMap<String, DynamicObject> oldBizMap = new HashMap<String, DynamicObject>(oldBizResult.length);
        for (DynamicObject dynamicObject : oldBizResult) {
            oldBizMap.putIfAbsent(dynamicObject.getString("identifynumber"), dynamicObject);
        }
        HashMap<String, DynamicObject> newBizDataCollection = new HashMap<String, DynamicObject>(this.rows.size());
        this.batchCheckIntegrateData(this.attFileIds, dataMap, fileMap, this.fileStateMap, this.fileDepEmpStateMap, fileDepEmpToScmMap, this.fileDepEmpItemStateMap, depEmpToFileMap, oldBizMap, newBizDataCollection);
        List<Map<String, Object>> params = this.transBizObjsToValidateParam(newBizDataCollection);
        LOGGER.info("validateDataValue before,param={}", params);
        Map<Long, DynamicObject> bizItemPropMap = this.bizDataServiceHelper.getBizItemProp(params);
        Map<String, Object> validateResult = this.bizDataServiceHelper.validateDataValue(params, bizItemPropMap);
        Map<String, String> validateErrorCode = this.fetchErrorCode(validateResult);
        LOGGER.info("validateDataValue after,validateResult={}", validateResult);
        this.cleanStatus(this.attFileIds, validateErrorCode, this.fileStateMap, dataMap, this.fileDepEmpStateMap, this.fileDepEmpItemStateMap);
        this.batchCreateIntegrateLog(this.fileDepEmpStateMap, this.fileStateMap, fileLogMap, dataMap, fileDepEmpToScmMap, this.fileDepEmpItemStateMap, newBizDataCollection);
        LOGGER.info("fileStateMap: {}", (Object)this.fileStateMap);
        LOGGER.info("fileDepEmpStateMap: {}", (Object)this.fileDepEmpStateMap);
        LOGGER.info("fileDepEmpItemStateMap: {}", (Object)this.fileDepEmpItemStateMap);
    }

    @Override
    public String getBizDataEntityKey() {
        return "hsas_nonrecurbizdata";
    }

    private void batchCreateIntegrateLog(Map<String, IntegrateState> fileDepEmpStateMap, Map<Long, IntegrateState> fileStateMap, Map<Long, DynamicObject> fileLogMap, Map<Long, Map<Long, Map<Long, Map<String, Object>>>> dataMap, Map<String, Long> fileDepEmpToScmMap, Map<String, IntegrateState> fileDepEmpItemStateMap, Map<String, DynamicObject> newBizDataCollection) {
        for (Long attFileId : this.attFileIds) {
            IntegrateState attFileState = fileStateMap.get(attFileId);
            DynamicObject fileLogObj = fileLogMap.get(attFileId);
            fileLogObj.set("processstate", (Object)IntegrationProcessStateEnum.COMPLETE.getCode());
            fileLogObj.set("processresult", (Object)(attFileState.isCheckPass() ? ProcessResultEnum.SUCCESS.getCode() : ProcessResultEnum.FAILURE.getCode()));
            fileLogObj.set("ignoredstate", (Object)(attFileState.isIgnored() ? IgnoredStateEnum.YES.getCode() : IgnoredStateEnum.NO.getCode()));
            Map<Long, Map<Long, Map<String, Object>>> depEmpIdAndItemIdToDataMap = dataMap.get(attFileId);
            this.createIntegrateLog(attFileId, fileDepEmpStateMap, depEmpIdAndItemIdToDataMap, fileDepEmpToScmMap, fileDepEmpItemStateMap, newBizDataCollection, attFileState);
        }
    }

    private void createIntegrateLog(Long attFileId, Map<String, IntegrateState> fileDepEmpStateMap, Map<Long, Map<Long, Map<String, Object>>> depEmpIdAndItemIdToDataMap, Map<String, Long> fileDepEmpToScmMap, Map<String, IntegrateState> fileDepEmpItemStateMap, Map<String, DynamicObject> newBizDataCollection, IntegrateState attFileState) {
        long[] detailLogIds = DBServiceHelper.genLongIds((String)"hsas_attintegdetaillog", (int)depEmpIdAndItemIdToDataMap.size());
        int detailLogIdIndex = 0;
        for (Map.Entry<Long, Map<Long, Map<String, Object>>> depEmpEntry : depEmpIdAndItemIdToDataMap.entrySet()) {
            Long depEmpId = depEmpEntry.getKey();
            Map<Long, Map<String, Object>> itemDataMap = depEmpEntry.getValue();
            String fileDepEmpKey = String.format("%d_%d", attFileId, depEmpId);
            Long scmId = fileDepEmpToScmMap.get(fileDepEmpKey);
            IntegrateState fileDepEmpState = fileDepEmpStateMap.get(fileDepEmpKey);
            if (!fileDepEmpState.isCheckPass()) {
                this.setReasonToItemOfCheckPass(fileDepEmpItemStateMap, attFileId, depEmpId, itemDataMap, BizDataFailStatusEnum.FAILSTATUS_3060.getCode());
            }
            if (scmId == null) {
                LOGGER.info("current file depemp has no scm,fileDepEmpKey={}", (Object)fileDepEmpKey);
            }
            long detailLogId = detailLogIds[detailLogIdIndex++];
            DynamicObject detailLog = this.createDetailLog(detailLogId, this.summaryLogId, attFileId, depEmpId, scmId, IntegrationProcessStateEnum.COMPLETE, WriteBackStateEnum.INCOMPLETE, fileDepEmpState);
            this.detailLogCollection.add(detailLog);
            for (Map.Entry<Long, Map<String, Object>> itemEntry : itemDataMap.entrySet()) {
                Long sumAttItemId = itemEntry.getKey();
                Map<String, Object> itemData = itemEntry.getValue();
                String fileDepEmpItemStateKey = String.format("%d_%d_%d", attFileId, depEmpId, sumAttItemId);
                IntegrateState itemState = fileDepEmpItemStateMap.get(fileDepEmpItemStateKey);
                if (!attFileState.isCheckPass() || itemState.isIgnored()) {
                    DynamicObject itemDetailLog = this.createItemDetailLog(detailLogId, itemData, itemState, this.summaryLogId);
                    this.itemDetailLogCollection.add(itemDetailLog);
                    continue;
                }
                if (attFileState.isIgnored() || !fileDepEmpState.isCheckPass() || fileDepEmpState.isIgnored() || !itemState.isCheckPass() || itemState.isIgnored()) continue;
                String bizDataKey = String.format("%d_%d_%d", attFileId, depEmpId, sumAttItemId);
                DynamicObject bizData = newBizDataCollection.get(bizDataKey);
                this.bizDataList.add(bizData);
            }
        }
    }

    private void cleanStatus(List<Long> attFileIdOfProcessing, Map<String, String> validateErrorCode, Map<Long, IntegrateState> fileStateMap, Map<Long, Map<Long, Map<Long, Map<String, Object>>>> dataMap, Map<String, IntegrateState> fileDepEmpStateMap, Map<String, IntegrateState> fileDepEmpItemStateMap) {
        for (Long attFileId : attFileIdOfProcessing) {
            IntegrateState attFileState = fileStateMap.get(attFileId);
            if (!attFileState.isCheckPass() || attFileState.isIgnored()) continue;
            Map<Long, Map<Long, Map<String, Object>>> depEmpIdAndSumItemIdToDataMap = dataMap.get(attFileId);
            for (Map.Entry<Long, Map<Long, Map<String, Object>>> entry : depEmpIdAndSumItemIdToDataMap.entrySet()) {
                Long depEmpId = entry.getKey();
                IntegrateState fileDepEmpState = fileDepEmpStateMap.get(String.format("%d_%d", attFileId, depEmpId));
                if (fileDepEmpState.isIgnored()) continue;
                Map<Long, Map<String, Object>> sumItemIdToDataMap = entry.getValue();
                this.doCleanStatus(sumItemIdToDataMap, attFileId, depEmpId, validateErrorCode, attFileState, fileDepEmpState, fileDepEmpItemStateMap);
            }
            if (attFileState.isCheckPass()) continue;
            this.setDepEmpState(fileDepEmpStateMap, attFileId, depEmpIdAndSumItemIdToDataMap.keySet(), false);
        }
    }

    private void doCleanStatus(Map<Long, Map<String, Object>> sumItemIdToDataMap, Long attFileId, Long depEmpId, Map<String, String> validateErrorCode, IntegrateState attFileState, IntegrateState fileDepEmpState, Map<String, IntegrateState> fileDepEmpItemStateMap) {
        for (Map.Entry<Long, Map<String, Object>> itemEntry : sumItemIdToDataMap.entrySet()) {
            String errorCode;
            Long sumAttItemId = itemEntry.getKey();
            String itemKey = String.format("%d_%d_%d", attFileId, depEmpId, sumAttItemId);
            IntegrateState itemState = fileDepEmpItemStateMap.get(itemKey);
            if (itemState.isIgnored() || (errorCode = validateErrorCode.get(itemKey)) == null) continue;
            itemState.setCheckPass(false);
            itemState.setReasonCode(errorCode);
            fileDepEmpState.setCheckPass(false);
            attFileState.setCheckPass(false);
        }
    }

    private void batchCheckIntegrateData(List<Long> attFileIdOfProcessing, Map<Long, Map<Long, Map<Long, Map<String, Object>>>> dataMap, Map<Long, DynamicObject> fileMap, Map<Long, IntegrateState> fileStateMap, Map<String, IntegrateState> fileDepEmpStateMap, Map<String, Long> fileDepEmpToScmMap, Map<String, IntegrateState> fileDepEmpItemStateMap, Map<String, Long> depEmpToFileMap, HashMap<String, DynamicObject> oldBizMap, Map<String, DynamicObject> newBizDataCollection) {
        for (Long attFileId : attFileIdOfProcessing) {
            Map<Long, Map<Long, Map<String, Object>>> depEmpIdAndSumItemIdToDataMap = dataMap.get(attFileId);
            if (depEmpIdAndSumItemIdToDataMap == null || depEmpIdAndSumItemIdToDataMap.size() == 0) {
                LOGGER.info(MessageFormat.format("attitem data error,attFileId={0}", attFileId));
                continue;
            }
            this.checkIntegrateData(attFileId, fileMap, fileStateMap, fileDepEmpStateMap, fileDepEmpToScmMap, fileDepEmpItemStateMap, depEmpToFileMap, oldBizMap, newBizDataCollection, depEmpIdAndSumItemIdToDataMap);
        }
    }

    private void checkIntegrateData(Long attFileId, Map<Long, DynamicObject> fileMap, Map<Long, IntegrateState> fileStateMap, Map<String, IntegrateState> fileDepEmpStateMap, Map<String, Long> fileDepEmpToScmMap, Map<String, IntegrateState> fileDepEmpItemStateMap, Map<String, Long> depEmpToFileMap, HashMap<String, DynamicObject> oldBizMap, Map<String, DynamicObject> newBizDataCollection, Map<Long, Map<Long, Map<String, Object>>> depEmpIdAndSumItemIdToDataMap) {
        IntegrateState attFileState = fileStateMap.computeIfAbsent(attFileId, val -> new IntegrateState());
        int curFileDepEmpIgnoredSize = 0;
        for (Map.Entry<Long, Map<Long, Map<String, Object>>> entry : depEmpIdAndSumItemIdToDataMap.entrySet()) {
            Long depEmpId = entry.getKey();
            String fileDepEmpKey = String.format("%d_%d", attFileId, depEmpId);
            IntegrateState fileDepEmpState = fileDepEmpStateMap.computeIfAbsent(fileDepEmpKey, val -> new IntegrateState());
            Map<Long, Map<String, Object>> sumItemIdToDataMap = entry.getValue();
            this.setItemState(fileDepEmpItemStateMap, attFileId, depEmpId, sumItemIdToDataMap, null, true);
            Map<String, Object> firstDataOfCurrentFileDepEmp = new ArrayList<Map<String, Object>>(sumItemIdToDataMap.values()).get(0);
            Long startDate = (Long)firstDataOfCurrentFileDepEmp.get("startdate");
            Long endDate = (Long)firstDataOfCurrentFileDepEmp.get("enddate");
            Long attPeriodIdOfData = (Long)firstDataOfCurrentFileDepEmp.get("attperiodid");
            Long salaryFileId = depEmpToFileMap.get(String.format("%d_%d", depEmpId, endDate));
            if (salaryFileId == null) {
                this.setItemState(fileDepEmpItemStateMap, attFileId, depEmpId, sumItemIdToDataMap, BizDataFailStatusEnum.FAILSTATUS_3010, false);
                attFileState.setCheckPass(false);
                continue;
            }
            DynamicObject salaryFileObj = fileMap.get(salaryFileId);
            long orgId = salaryFileObj.getLong("org.id");
            long payRollRegionId = salaryFileObj.getLong("payrollregion.id");
            Long scmId = this.orgCountToScmMap.get(String.format("%d_%d", orgId, payRollRegionId));
            if (scmId == null) {
                this.setItemState(fileDepEmpItemStateMap, attFileId, depEmpId, sumItemIdToDataMap, BizDataFailStatusEnum.FAILSTATUS_3020, false);
                attFileState.setCheckPass(false);
                continue;
            }
            fileDepEmpToScmMap.put(fileDepEmpKey, scmId);
            DynamicObject scmObj = this.scmMap.get(scmId);
            long attPeriodTypeId = scmObj.getLong("attperiod.id");
            String matchType = scmObj.getString("matchtype");
            if (attPeriodTypeId != attPeriodIdOfData) {
                LOGGER.info("FAILSTATUS_3030 ,attperiod = {} ,attPeriodIdOfData = {}", (Object)attPeriodTypeId, (Object)attPeriodIdOfData);
                this.setItemState(fileDepEmpItemStateMap, attFileId, depEmpId, sumItemIdToDataMap, BizDataFailStatusEnum.FAILSTATUS_3030, false);
                attFileState.setCheckPass(false);
                continue;
            }
            long calPeriodTypeId = scmObj.getLong("calperiodtype.id");
            DynamicObject periodTypeObj = this.periodTypeMap.get(calPeriodTypeId);
            DynamicObjectCollection periodEntry = periodTypeObj.getDynamicObjectCollection("entryentity");
            DynamicObject periodObj = this.matchPeriod(matchType, startDate, endDate, periodEntry);
            if (periodObj == null) {
                LOGGER.info("FAILSTATUS_3030 ,matchType={} ,startDate = {} ,endDate = {} ,calPeriodTypeId={} ,periodEntry.size = {}", new Object[]{matchType, startDate, endDate, calPeriodTypeId, periodEntry.size()});
                this.setItemState(fileDepEmpItemStateMap, attFileId, depEmpId, sumItemIdToDataMap, BizDataFailStatusEnum.FAILSTATUS_3030, false);
                attFileState.setCheckPass(false);
                continue;
            }
            int curDepEmpIgnoredItemSize = 0;
            for (Map.Entry<Long, Map<String, Object>> itemEntry : sumItemIdToDataMap.entrySet()) {
                String bizDataKey;
                DynamicObject duplicateObj;
                Long sumItemId = itemEntry.getKey();
                Map<String, Object> itemData = itemEntry.getValue();
                String tagNumber = (String)itemData.get("tagnumber");
                Long attItemId = (Long)itemData.get("attitemid");
                DynamicObject oldBizData = oldBizMap.get(tagNumber);
                IntegrateState itemState = fileDepEmpItemStateMap.computeIfAbsent(String.format("%d_%d_%d", attFileId, depEmpId, sumItemId), val -> new IntegrateState());
                if (oldBizData != null) {
                    itemState.setCheckPass(false);
                    itemState.setReasonCode(BizDataFailStatusEnum.FAILSTATUS_1010.getCode());
                    attFileState.setCheckPass(false);
                    continue;
                }
                Map<Long, Long> pairs = this.scmToItemMap.get(scmId);
                Long bizItemId = pairs.get(attItemId);
                if (bizItemId == null) {
                    itemState.setIgnored(true);
                    itemState.setReasonCode(BizDataFailStatusEnum.FAILSTATUS_3050.getCode());
                    ++curDepEmpIgnoredItemSize;
                    continue;
                }
                DynamicObject newBizData = this.createBizData(this.batchVersionId, salaryFileObj, bizItemId, itemData, periodObj, periodTypeObj);
                AfterCreateBizDataEvent event = new AfterCreateBizDataEvent((Object)this);
                event.setSalaryFileId(salaryFileId);
                event.setBizItemId(bizItemId);
                event.setItemData(itemData);
                event.setPeriodTypeObj(periodTypeObj);
                event.setPeriodObj(periodObj);
                event.setBizData(newBizData);
                this.extProxy.callAfter(proxy -> {
                    proxy.afterCreateBizData(event);
                    return null;
                });
                if (event.getBizData() != null) {
                    newBizData = event.getBizData();
                }
                if ((duplicateObj = newBizDataCollection.putIfAbsent(bizDataKey = String.format("%d_%d_%d", attFileId, depEmpId, sumItemId), newBizData)) == null) continue;
                LOGGER.error(MessageFormat.format("attbizdata is error , key is {0}", bizDataKey));
            }
            if (curDepEmpIgnoredItemSize != sumItemIdToDataMap.size()) continue;
            fileDepEmpState.setIgnored(true);
            ++curFileDepEmpIgnoredSize;
        }
        if (curFileDepEmpIgnoredSize == depEmpIdAndSumItemIdToDataMap.size()) {
            attFileState.setIgnored(true);
        }
        if (!attFileState.isCheckPass()) {
            this.setDepEmpState(fileDepEmpStateMap, attFileId, depEmpIdAndSumItemIdToDataMap.keySet(), false);
        }
    }

    private void setDepEmpState(Map<String, IntegrateState> fileDepEmpStateMap, Long attFileId, Set<Long> depEmpIdSet, boolean isCheckPass) {
        for (Long depEmpId : depEmpIdSet) {
            String fileDepEmpItemStateKey = String.format("%d_%d", attFileId, depEmpId);
            IntegrateState depEmpState = fileDepEmpStateMap.get(fileDepEmpItemStateKey);
            if (depEmpState == null) {
                LOGGER.info("fileDepEmpStateMap data error");
                continue;
            }
            depEmpState.setCheckPass(isCheckPass);
        }
    }

    private DynamicObject createDetailLog(long detailLogId, Long summaryLogId, Long attFileId, Long depEmpId, Long scmId, IntegrationProcessStateEnum processState, WriteBackStateEnum writeBackStateEnum, IntegrateState fileDepEmpState) {
        DynamicObject dynamicObject = this.detailLogService.generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)detailLogId);
        dynamicObject.set("attintegsumlog", (Object)summaryLogId);
        dynamicObject.set("attfile", (Object)attFileId);
        dynamicObject.set("depemp", (Object)depEmpId);
        dynamicObject.set("attintegmapscm", (Object)scmId);
        dynamicObject.set("processstate", (Object)processState.getCode());
        dynamicObject.set("writebackstate", (Object)writeBackStateEnum.getCode());
        dynamicObject.set("ignoredstate", (Object)(fileDepEmpState.isIgnored() ? IgnoredStateEnum.YES.getCode() : IgnoredStateEnum.NO.getCode()));
        dynamicObject.set("processresult", (Object)(fileDepEmpState.isCheckPass() ? ProcessResultEnum.SUCCESS.getCode() : ProcessResultEnum.FAILURE.getCode()));
        return dynamicObject;
    }

    private Map<String, String> fetchErrorCode(Map<String, Object> validateResult) {
        List result = (List)validateResult.get("result");
        HashMap<String, String> resultMap = new HashMap<String, String>(result.size());
        for (Map oneData : result) {
            int status = (Integer)oneData.get("status");
            if (status != 0) continue;
            String bizDataCode = (String)oneData.get("bizdatacode");
            String errorCode = (String)oneData.get("errorcode");
            resultMap.putIfAbsent(bizDataCode, errorCode);
        }
        return resultMap;
    }

    private List<Map<String, Object>> transBizObjsToValidateParam(Map<String, DynamicObject> newBizDataCollection) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(newBizDataCollection.size());
        for (Map.Entry<String, DynamicObject> entry : newBizDataCollection.entrySet()) {
            String key = entry.getKey();
            DynamicObject itemData = entry.getValue();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("bizdatacode", key);
            hashMap.put("bizitemid", itemData.getLong("bizitem"));
            hashMap.put("value", itemData.getString("datavalue"));
            result.add(hashMap);
        }
        return result;
    }

    private DynamicObject createBizData(String batchVersionId, DynamicObject salaryFileObj, Long bizItemId, Map<String, Object> itemData, DynamicObject periodObj, DynamicObject periodTypeObj) {
        DynamicObject dynamicObject = this.bizDataService.generateEmptyDynamicObject();
        dynamicObject.set("batchnumber", (Object)batchVersionId);
        dynamicObject.set("salaryfile", (Object)salaryFileObj.getLong("id"));
        dynamicObject.set("groupid", itemData.get("attfileid"));
        dynamicObject.set("depemp", itemData.get("depempid"));
        dynamicObject.set("employee", itemData.get("employeeid"));
        dynamicObject.set("bizitem", (Object)bizItemId);
        dynamicObject.set("datavalue", (Object)((BigDecimal)itemData.get("value")).toPlainString());
        dynamicObject.set("bsed", (Object)periodObj.getDate("startdate"));
        dynamicObject.set("bsled", (Object)periodObj.getDate("enddate"));
        dynamicObject.set("calperiodtype", periodTypeObj.get("id"));
        dynamicObject.set("calperiod", periodObj.get("id"));
        dynamicObject.set("identifynumber", itemData.get("tagnumber"));
        dynamicObject.set("srcsystem", (Object)BizDataSrcSystemEnum.WTC.getCode());
        dynamicObject.set("auditstatus", (Object)"C");
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("datasources", (Object)"2");
        dynamicObject.set("bizuniquecode", (Object)((String)itemData.get("tagnumber") + Long.toHexString(bizItemId)));
        dynamicObject.set("org", salaryFileObj.get("org"));
        dynamicObject.set("payrollregion", salaryFileObj.get("payrollregion"));
        dynamicObject.set("payrollgroup", salaryFileObj.get("payrollgroup"));
        dynamicObject.set("adminorg", salaryFileObj.get("adminorg"));
        dynamicObject.set("empgroup", salaryFileObj.get("empgroup"));
        dynamicObject.set("creator", (Object)this.operator);
        dynamicObject.set("modifier", (Object)this.operator);
        return dynamicObject;
    }

    private DynamicObject matchPeriod(String matchType, Long startDate, Long endDate, DynamicObjectCollection periodEntry) {
        int lastIndex = periodEntry.size() - 1;
        block12: for (int i = 0; i < periodEntry.size(); ++i) {
            DynamicObject periodRow = (DynamicObject)periodEntry.get(i);
            long periodStartDate = periodRow.getDate("startdate").getTime();
            long periodEndDate = periodRow.getDate("enddate").getTime();
            switch (matchType) {
                case "1": {
                    if (startDate < periodStartDate || startDate > periodEndDate) continue block12;
                    return periodRow;
                }
                case "2": {
                    if (startDate < periodStartDate || startDate > periodEndDate || i + 1 > lastIndex) continue block12;
                    return (DynamicObject)periodEntry.get(i + 1);
                }
                case "3": {
                    if (endDate < periodStartDate || endDate > periodEndDate) continue block12;
                    return periodRow;
                }
                case "4": {
                    if (endDate < periodStartDate || endDate > periodEndDate || i + 1 > lastIndex) continue block12;
                    return (DynamicObject)periodEntry.get(i + 1);
                }
            }
        }
        return null;
    }

    private Map<String, Long> groupByDepEmpAndDate(List<Map<String, Object>> result) {
        HashMap<String, Long> resultMap = new HashMap<String, Long>(result.size());
        String keyTpl = "%d_%d";
        for (Map<String, Object> map : result) {
            int queryRowCount = (Integer)map.get("queryRowCount");
            Long matchSalaryFileId = (Long)map.get("matchSalaryFileId");
            Long depEmpId = (Long)map.get("depEmpId");
            Date date = (Date)map.get("endDate");
            if (queryRowCount == 0) {
                LOGGER.info("queryRowCount = 0,current result is ->{}", (Object)JSON.toJSONString(map));
                continue;
            }
            if (queryRowCount > 1) {
                LOGGER.info(MessageFormat.format("current depemp has more than one file,depempid = {0},date = {1}", depEmpId, SWCDateTimeUtils.format((Date)date)));
                continue;
            }
            if (queryRowCount != 1) continue;
            String key = String.format(keyTpl, depEmpId, date.getTime());
            resultMap.putIfAbsent(key, matchSalaryFileId);
        }
        return resultMap;
    }

    private List<Map<String, Object>> fetchParamForSalaryFileQuery(List<Map<String, Object>> rows) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(rows.size());
        HashSet<String> keySet = new HashSet<String>();
        String keyTpl = "%d_%d_%d";
        for (Map<String, Object> row : rows) {
            Long depEmpId = (Long)row.get("depempid");
            Long employeeId = (Long)row.get("employeeid");
            Long endDate = (Long)row.get("enddate");
            String key = String.format(keyTpl, depEmpId, employeeId, endDate);
            if (!keySet.add(key)) continue;
            HashMap<String, Comparable<Long>> subParam = new HashMap<String, Comparable<Long>>(3);
            subParam.put("employeeId", employeeId);
            subParam.put("depEmpId", depEmpId);
            subParam.put("endDate", new Date(endDate));
            result.add(subParam);
        }
        return result;
    }

    public Map<String, Long> getOrgCountToScmMap() {
        return this.orgCountToScmMap;
    }

    public void setOrgCountToScmMap(Map<String, Long> orgCountToScmMap) {
        this.orgCountToScmMap = orgCountToScmMap;
    }

    public Map<Long, DynamicObject> getScmMap() {
        return this.scmMap;
    }

    public void setScmMap(Map<Long, DynamicObject> scmMap) {
        this.scmMap = scmMap;
    }

    public Map<Long, DynamicObject> getPeriodTypeMap() {
        return this.periodTypeMap;
    }

    public void setPeriodTypeMap(Map<Long, DynamicObject> periodTypeMap) {
        this.periodTypeMap = periodTypeMap;
    }

    public Map<Long, Map<Long, Long>> getScmToItemMap() {
        return this.scmToItemMap;
    }

    public void setScmToItemMap(Map<Long, Map<Long, Long>> scmToItemMap) {
        this.scmToItemMap = scmToItemMap;
    }
}

