/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.exchangerate.helper.ExchangeRateHelper;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.base.ParentFormulaParse;
import kd.swc.hscs.business.cal.datagrade.calculation.CalculationHelper;
import kd.swc.hscs.business.cal.datagrade.utils.DataGradeCalculeUtil;
import kd.swc.hscs.business.cal.datagrade.utils.DataGradeMatchFailUtil;
import kd.swc.hscs.business.cal.fetchdata.helper.DataReaderCalHelper;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.business.cal.utils.FormulaParseUtils;
import kd.swc.hscs.common.vo.ItemInfo;
import kd.swc.hscs.common.vo.SalaryItemVO;
import kd.swc.hscs.common.vo.fetch.CalFetchConfigInfo;

public class FormulaParse
extends ParentFormulaParse {
    private static final Log logger = LogFactory.getLog(FormulaParse.class);
    private static final String YES = "Y";
    private static final String NO = "N";
    private Map<String, Map<String, Object>> sectionParamMap;
    private Map<String, Map<String, BigDecimal>> proportionMap;
    private Map<String, List<String>> itemSectionMap;
    private boolean isSection;
    private Map<String, SalaryItemVO> uniqueCodeMap;
    private HashSet<String> validUniqueCodeSet;
    private List<String> defaultSectionList = Collections.singletonList("1@30");
    private Map<String, Object> spItemMap;
    private Map<String, ItemInfo> spItemInfoMap;
    private List<String> spItemList;
    private List<String> ftItemCodeList;
    private Map<String, CalFetchConfigInfo> fetchItemConfigMap;
    private Map<String, Object> dataReaderDataMap;
    private Map<String, List<String>> slItemRelMap;
    Long calPersonId;
    Long calTaskId;
    private Map<String, Object> calTaskDataMap;
    private Map<String, ExchangeRateInfo> exrateCacheMap = new HashMap<String, ExchangeRateInfo>(16);
    Long calRecordId;
    private Map<String, Object> dmMap;
    private long formulaStartTime;
    private Map<String, Long> formulaConsumeTiemMap;

    public FormulaParse() {
        this.params = new HashMap(16);
        this.resultMap = new HashMap(16);
        this.proportionMap = new HashMap<String, Map<String, BigDecimal>>(16);
        this.itemSectionMap = new HashMap<String, List<String>>(16);
        this.itemSectionResultMap = new HashMap(16);
        this.sectionParamMap = new HashMap<String, Map<String, Object>>(16);
        this.spItemMap = new HashMap<String, Object>(16);
        this.spItemInfoMap = new HashMap<String, ItemInfo>(16);
        this.dmMap = new HashMap<String, Object>(16);
        this.messageMap = new LinkedHashMap(16);
        this.slAndBsItemRelMap = new HashMap(16);
        this.formulaConsumeTiemMap = new HashMap<String, Long>(16);
    }

    public List<String> getItemSectionList(String uniqueCode) {
        if (null == this.itemSectionMap) {
            return this.defaultSectionList;
        }
        List<String> sectionList = this.itemSectionMap.get(uniqueCode);
        if (null == sectionList || sectionList.size() == 0) {
            return this.defaultSectionList;
        }
        return sectionList;
    }

    private void setIsGetSectionResultFlag(String uniqueCode) {
        if (this.isCalProration || !this.checkItemIsSection(uniqueCode)) {
            this.isGetSectionResult = false;
            return;
        }
        List<String> dependSLItemList = this.slItemRelMap.get(uniqueCode);
        if (SWCListUtils.isEmpty(dependSLItemList)) {
            this.isGetSectionResult = false;
            return;
        }
        List<String> oriDataRangeList = this.getItemSectionList(uniqueCode);
        List<String> tempList = null;
        boolean flag = true;
        for (String dependSLItem : dependSLItemList) {
            if (!this.checkItemIsSection(dependSLItem) || !this.itemSectionResultMap.containsKey(dependSLItem)) {
                flag = false;
                break;
            }
            tempList = this.getItemSectionList(dependSLItem);
            if (tempList == null) {
                flag = false;
                break;
            }
            if (oriDataRangeList.size() == tempList.size() && oriDataRangeList.containsAll(tempList)) continue;
            flag = false;
            break;
        }
        this.isGetSectionResult = flag;
    }

    public Date parseDate(String dateStr) {
        Date date = null;
        try {
            date = SWCDateTimeUtils.parseDate((String)dateStr);
        }
        catch (Exception e) {
            logger.error("parse date error, dateStr = {}", (Object)dateStr);
        }
        return date;
    }

    public String getFieldValueAsString(String uniqueCode, String sectionKey, String salaryItemUniqueCode) {
        if (uniqueCode.startsWith("FT_") && this.fetchItemConfigMap != null && this.fetchItemConfigMap.size() > 0) {
            this.invokeGetFetchItem(uniqueCode, this.checkItemIsSection(salaryItemUniqueCode));
        }
        if (this.checkItemIsSection(salaryItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                if (this.isCalProration) {
                    return this.getFieldValueAsString(uniqueCode);
                }
                return null;
            }
            Object obj = sectionParamMap.get(uniqueCode);
            if (obj == null) {
                return null;
            }
            this.addSlAndBsItemRelData(uniqueCode, sectionKey);
            return obj.toString();
        }
        return this.getFieldValueAsString(uniqueCode);
    }

    public String getSPItemValue(String uniqueCode) {
        if (this.spItemMap != null) {
            Object obj = this.spItemMap.get(uniqueCode);
            return obj == null ? null : obj.toString();
        }
        return null;
    }

    public void addSPItemValue(String uniqueCode, Object value) {
        if (!this.spItemList.contains(uniqueCode)) {
            return;
        }
        if (value instanceof Date) {
            value = SWCDateTimeUtils.format((Date)((Date)value));
        }
        value = FormulaParseUtils.dealSpItemValue(uniqueCode, value, this.spItemInfoMap);
        this.spItemMap.put(uniqueCode, value);
    }

    public BigDecimal dealSpItemValuePrecision(String uniqueCode, BigDecimal value) {
        return (BigDecimal)FormulaParseUtils.dealSpItemValue(uniqueCode, value, this.spItemInfoMap);
    }

    public BigDecimal getFieldValueAsBigDecimal(String uniqueCode, String sectionKey, String salaryItemUniqueCode) {
        if (uniqueCode.startsWith("FT_") && this.fetchItemConfigMap != null && this.fetchItemConfigMap.size() > 0) {
            this.invokeGetFetchItem(uniqueCode, this.checkItemIsSection(salaryItemUniqueCode));
        }
        if (this.checkItemIsSection(salaryItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                return null;
            }
            Object obj = sectionParamMap.get(uniqueCode);
            if (obj == null) {
                return null;
            }
            this.addSlAndBsItemRelData(uniqueCode, sectionKey);
            return new BigDecimal(obj.toString());
        }
        return this.getFieldValueAsBigDecimal(uniqueCode);
    }

    public Date getFieldValueAsDate(String uniqueCode, String sectionKey, String salaryItemUniqueCode) {
        if (uniqueCode.startsWith("FT_") && this.fetchItemConfigMap != null && this.fetchItemConfigMap.size() > 0) {
            this.invokeGetFetchItem(uniqueCode, this.checkItemIsSection(salaryItemUniqueCode));
        }
        if (this.checkItemIsSection(salaryItemUniqueCode)) {
            Map<String, Object> sectionParamMap = this.sectionParamMap.get(sectionKey);
            if (sectionParamMap == null) {
                return null;
            }
            Object obj = sectionParamMap.get(uniqueCode);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Date) {
                this.addSlAndBsItemRelData(uniqueCode, sectionKey);
                return (Date)obj;
            }
            return null;
        }
        return this.getFieldValueAsDate(uniqueCode);
    }

    private boolean checkItemIsSection(String uniqueCode) {
        if (null == this.itemSectionMap || !this.isSection) {
            return false;
        }
        List<String> sectionKeyList = this.itemSectionMap.get(uniqueCode);
        if (sectionKeyList == null || sectionKeyList.size() == 0) {
            return false;
        }
        if (sectionKeyList.size() > 1) {
            return true;
        }
        return !SWCStringUtils.equals((String)this.defaultSectionList.get(0), (String)sectionKeyList.get(0));
    }

    public void addResultValue(String uniqueCode, BigDecimal value, String sectionKey) {
        if (!this.isCalProration) {
            value = this.convertItemValue(uniqueCode, value, sectionKey);
        }
        if (this.checkItemIsSection(uniqueCode) || this.isCalProration) {
            if (this.resultMap.containsKey(uniqueCode)) {
                return;
            }
            if (value == null) {
                return;
            }
            Map itemResultMap = this.itemSectionResultMap.getOrDefault(uniqueCode, new HashMap(16));
            value = value.setScale(CalUtils.getSystemDefaultScal(), RoundingMode.HALF_UP);
            value = (BigDecimal)this.checkAndReturn(uniqueCode, sectionKey, value);
            itemResultMap.put(sectionKey, value);
            this.itemSectionResultMap.put(uniqueCode, itemResultMap);
        } else {
            value = this.dealItemDataScal(uniqueCode, value);
            this.addResultValue(uniqueCode, value);
        }
    }

    private BigDecimal convertItemValue(String uniqueCode, BigDecimal value, String sectionKey) {
        if (null == value || this.isGetSectionResult) {
            return value;
        }
        Map<String, BigDecimal> proportionMap = this.proportionMap.get(uniqueCode);
        BigDecimal proportion = null;
        proportion = null != proportionMap && null != proportionMap.get(sectionKey) ? proportionMap.get(sectionKey) : BigDecimal.ONE;
        return proportion.multiply(value);
    }

    private BigDecimal dealItemDataScal(String uniqueCode, BigDecimal value) {
        if (value == null || this.isCalProration || this.uniqueCodeMap == null) {
            return value;
        }
        SalaryItemVO item = this.uniqueCodeMap.get(uniqueCode);
        if (item == null) {
            return value;
        }
        return value.setScale((int)item.getScale(), ItemDataUtils.getRoundingMode((long)item.getDataroundId()));
    }

    public void addResultValue(String uniqueCode, Date value, String sectionKey) {
        if (this.isSection && this.checkItemIsSection(uniqueCode)) {
            Map itemResultMap = this.itemSectionResultMap.getOrDefault(uniqueCode, new HashMap(16));
            itemResultMap.put(sectionKey, this.checkAndReturn(uniqueCode, sectionKey, value));
            this.itemSectionResultMap.put(uniqueCode, itemResultMap);
        } else {
            this.addResultValue(uniqueCode, value);
        }
    }

    public void addResultValue(String uniqueCode, String value, String sectionKey) {
        if (this.checkItemIsSection(uniqueCode)) {
            Map itemResultMap = this.itemSectionResultMap.getOrDefault(uniqueCode, new HashMap(16));
            itemResultMap.put(sectionKey, this.checkAndReturn(uniqueCode, sectionKey, value));
            this.itemSectionResultMap.put(uniqueCode, itemResultMap);
        } else {
            this.addResultValue(uniqueCode, value);
        }
    }

    public void sumItemResultValue(String uniqueCode) {
        if (this.isCalProration) {
            return;
        }
        BigDecimal result = null;
        Map itemResultMap = (Map)this.itemSectionResultMap.get(uniqueCode);
        if (itemResultMap == null || itemResultMap.size() == 0) {
            if (this.checkItemIsSection(uniqueCode)) {
                this.addResultValue(uniqueCode, result);
            }
            this.addFormulaConsumeTime(System.currentTimeMillis(), uniqueCode);
            return;
        }
        Object otherResult = null;
        for (Map.Entry entry : itemResultMap.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof BigDecimal) {
                if (result == null) {
                    result = BigDecimal.ZERO;
                }
                result = result.add((BigDecimal)entry.getValue());
                continue;
            }
            otherResult = entry.getValue();
        }
        if (otherResult != null) {
            this.resultMap.put(uniqueCode, otherResult);
        } else {
            result = this.dealItemDataScal(uniqueCode, result);
            this.addResultValue(uniqueCode, result);
        }
        this.addFormulaConsumeTime(System.currentTimeMillis(), uniqueCode);
    }

    private void addFormulaConsumeTime(long formulaEndTime, String uniqueCode) {
        SalaryItemVO item = this.uniqueCodeMap.get(uniqueCode);
        long consumeTime = formulaEndTime - this.formulaStartTime;
        if (item == null) {
            this.formulaConsumeTiemMap.put(uniqueCode, consumeTime);
        } else {
            this.formulaConsumeTiemMap.put(item.getName(), consumeTime);
        }
    }

    private Object checkAndReturn(String uniqueCode, String sectionKey, Object value) {
        if (this.isCalProration) {
            return value;
        }
        Map itemDataMap = (Map)this.itemSectionResultMap.get(uniqueCode);
        if (itemDataMap == null) {
            return value;
        }
        Object result = itemDataMap.get(sectionKey);
        if (result == null) {
            return value;
        }
        this.removeSlAndBsItemRelData(uniqueCode, sectionKey);
        return result;
    }

    public void setCurrentSectionKey(String sectionKey) {
        this.currentSectionKey = sectionKey;
    }

    public BigDecimal getDataGradeBigDecimalResult(String uniqueCode, String resultId, Object[] params) throws KDBizException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        if (this.dmMap == null || this.dmMap.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u7248\u672c\u7684\u6570\u636e\u5206\u7ea7\u3002", (String)"FormulaParse_2", (String)"swc-hscs-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        Map gradeData = (Map)this.dmMap.get(uniqueCode);
        if (gradeData == null || gradeData.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u7248\u672c\u7684\u6570\u636e\u5206\u7ea7\u3002", (String)"FormulaParse_2", (String)"swc-hscs-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        this.exrateGradeConditionData(gradeData, params);
        Map<String, Object> resultMap = this.dataGradeCalResult(uniqueCode, params, paramsMap);
        if (resultMap == null || resultMap.size() == 0) {
            return null;
        }
        String result = (String)resultMap.get("result");
        if (SWCStringUtils.equals((String)result, (String)"stopCal")) {
            String gradeName = (String)gradeData.get("name");
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7[%s]\u5339\u914d\u5931\u8d25\uff0c\u505c\u6b62\u8ba1\u7b97\u3002", (String)"FormulaParse_1", (String)"swc-hscs-business", (Object[])new Object[0]);
            msg = String.format(Locale.ROOT, msg, gradeName);
            throw new KDBizException(msg);
        }
        String resultFieldId = FormulaParseUtils.getResultFieldId(resultId, paramsMap);
        BigDecimal resultVal = DataGradeCalculeUtil.getBigDecimalVal(resultMap.get(resultFieldId));
        return this.exrateGradeResultData(gradeData, resultVal, resultId);
    }

    private BigDecimal exrateGradeResultData(Map<String, Object> gradeData, BigDecimal resultVal, String resultId) {
        if (resultVal == null) {
            return resultVal;
        }
        List resultList = (List)gradeData.get("resultList");
        if (resultList == null || resultList.size() == 0) {
            return resultVal;
        }
        Map<String, Object> resultMap = this.getResultValByResultId(resultList, resultId);
        if (resultMap == null || resultMap.size() == 0) {
            return resultVal;
        }
        String resultValTypeNumber = (String)resultMap.get("resultValTypeNumber");
        if (!SWCStringUtils.equals((String)resultValTypeNumber, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
            return resultVal;
        }
        String resultCurrencyIdStr = (String)resultMap.get("resultCurrencyId");
        if (SWCStringUtils.isEmpty((String)resultCurrencyIdStr)) {
            return resultVal;
        }
        BigDecimal exrateVal = this.getDataGradeResultExrateData(Long.parseLong(resultCurrencyIdStr), resultVal);
        return exrateVal;
    }

    private Map<String, Object> getResultValByResultId(List<Map<String, Object>> resultList, String resultId) {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(resultList.size());
        for (Map<String, Object> map : resultList) {
            String id = (String)map.get("resultId");
            resultMap.put(id, map);
        }
        return (Map)resultMap.get(resultId);
    }

    public String getDataGradeStringResult(String uniqueCode, String resultId, Object[] params) throws KDBizException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        if (this.dmMap == null || this.dmMap.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u7248\u672c\u7684\u6570\u636e\u5206\u7ea7\u3002", (String)"FormulaParse_2", (String)"swc-hscs-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        Map gradeData = (Map)this.dmMap.get(uniqueCode);
        if (gradeData == null || gradeData.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u7248\u672c\u7684\u6570\u636e\u5206\u7ea7\u3002", (String)"FormulaParse_2", (String)"swc-hscs-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        this.exrateGradeConditionData(gradeData, params);
        Map<String, Object> resultMap = this.dataGradeCalResult(uniqueCode, params, paramsMap);
        if (resultMap == null || resultMap.size() == 0) {
            return null;
        }
        String result = (String)resultMap.get("result");
        if (SWCStringUtils.equals((String)result, (String)"stopCal")) {
            String gradeName = (String)gradeData.get("name");
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7[%s]\u5339\u914d\u5931\u8d25\uff0c\u505c\u6b62\u8ba1\u7b97\u3002", (String)"FormulaParse_1", (String)"swc-hscs-business", (Object[])new Object[0]);
            msg = String.format(Locale.ROOT, msg, gradeName);
            throw new KDBizException(msg);
        }
        String resultFieldId = FormulaParseUtils.getResultFieldId(resultId, paramsMap);
        return (String)resultMap.get(resultFieldId);
    }

    public Date getDataGradeDateResult(String uniqueCode, String resultId, Object[] params) throws KDBizException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        if (this.dmMap == null || this.dmMap.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u7248\u672c\u7684\u6570\u636e\u5206\u7ea7\u3002", (String)"FormulaParse_2", (String)"swc-hscs-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        Map gradeData = (Map)this.dmMap.get(uniqueCode);
        if (gradeData == null || gradeData.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6709\u6548\u7248\u672c\u7684\u6570\u636e\u5206\u7ea7\u3002", (String)"FormulaParse_2", (String)"swc-hscs-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        this.exrateGradeConditionData(gradeData, params);
        Map<String, Object> resultMap = this.dataGradeCalResult(uniqueCode, params, paramsMap);
        if (resultMap == null || resultMap.size() == 0) {
            return null;
        }
        String result = (String)resultMap.get("result");
        if (SWCStringUtils.equals((String)result, (String)"stopCal")) {
            String gradeName = (String)gradeData.get("name");
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7[%s]\u5339\u914d\u5931\u8d25\uff0c\u505c\u6b62\u8ba1\u7b97\u3002", (String)"FormulaParse_1", (String)"swc-hscs-business", (Object[])new Object[0]);
            msg = String.format(Locale.ROOT, msg, gradeName);
            throw new KDBizException(msg);
        }
        String resultFieldId = FormulaParseUtils.getResultFieldId(resultId, paramsMap);
        Date result2 = null;
        try {
            Object resultDate = resultMap.get(resultFieldId);
            result2 = resultDate instanceof Date ? (Date)resultDate : SWCDateTimeUtils.parseDate((String)(resultMap.get(resultFieldId) + ""));
        }
        catch (ParseException exception) {
            logger.error("date parse error", (Throwable)exception);
        }
        return result2;
    }

    private BigDecimal getDataGradeConditionExrateData(Long gradeCurrencyId, Integer gradeCurrencyAmtp, BigDecimal value) {
        logger.info("start getDataGradeConditionExrateData gradeCurrencyId is {}, gradeCurrencyAmtp is {}, value is {}", new Object[]{gradeCurrencyId, gradeCurrencyAmtp, value});
        if (this.calTaskDataMap == null || this.calTaskDataMap.size() == 0) {
            return value;
        }
        if (gradeCurrencyId == null) {
            return value;
        }
        Long calCurrencyId = (Long)this.calTaskDataMap.get("calCurrencyId");
        if (calCurrencyId == null) {
            return value;
        }
        Long exratetableId = (Long)this.calTaskDataMap.get("exratetableId");
        Date exratedate = (Date)this.calTaskDataMap.get("exratedate");
        if (gradeCurrencyId.longValue() == calCurrencyId.longValue()) {
            return value;
        }
        String key = calCurrencyId + "@" + gradeCurrencyId;
        ExchangeRateInfo info = this.exrateCacheMap.get(key);
        if (null == info) {
            info = ExchangeRateHelper.getExchangeRateInfo((Long)calCurrencyId, (Long)gradeCurrencyId, (Long)exratetableId, (Date)exratedate);
            if (null != info) {
                this.exrateCacheMap.put(key, info);
            } else {
                logger.error("Formulaparse getDataGradeConditionExrateData null,calCurrencyId={},gradeCurrencyId={}", (Object)calCurrencyId, (Object)gradeCurrencyId);
            }
        }
        if (null != info) {
            value = info.getQuoteType().booleanValue() ? value.divide(info.getExchangeRate(), 18, 1) : value.multiply(info.getExchangeRate());
        } else {
            return value;
        }
        value = value.setScale((int)gradeCurrencyAmtp, 4);
        logger.info("end getDataGradeConditionExrateData gradeCurrencyId is {}, gradeCurrencyAmtp is {}, value is {}", new Object[]{gradeCurrencyId, gradeCurrencyAmtp, value});
        return value;
    }

    private BigDecimal getDataGradeResultExrateData(Long gradeCurrencyId, BigDecimal value) {
        if (this.calTaskDataMap == null || this.calTaskDataMap.size() == 0) {
            logger.info("calTaskDataMap is null or empty");
            return value;
        }
        if (gradeCurrencyId == null) {
            logger.info("gradeCurrencyId is null");
            return value;
        }
        Long calCurrencyId = (Long)this.calTaskDataMap.get("calCurrencyId");
        if (calCurrencyId == null) {
            logger.info("calCurrencyId is null");
            return value;
        }
        Long exratetableId = (Long)this.calTaskDataMap.get("exratetableId");
        Date exratedate = (Date)this.calTaskDataMap.get("exratedate");
        if (gradeCurrencyId.longValue() == calCurrencyId.longValue()) {
            return value;
        }
        String key = gradeCurrencyId + "@" + calCurrencyId;
        ExchangeRateInfo info = this.exrateCacheMap.get(key);
        if (null == info) {
            info = ExchangeRateHelper.getExchangeRateInfo((Long)gradeCurrencyId, (Long)calCurrencyId, (Long)exratetableId, (Date)exratedate);
            if (null != info) {
                this.exrateCacheMap.put(key, info);
            } else {
                logger.error("Formulaparse getDataGradeResultExrateData null,calCurrencyId={},gradeCurrencyId={}", (Object)calCurrencyId, (Object)gradeCurrencyId);
            }
        }
        if (null != info) {
            value = info.getQuoteType().booleanValue() ? value.divide(info.getExchangeRate(), 18, 1) : value.multiply(info.getExchangeRate());
        } else {
            return value;
        }
        return value;
    }

    private void exrateGradeConditionData(Map<String, Object> gradeData, Object[] params) {
        List conditionData = (List)gradeData.get("conditionList");
        if (conditionData != null && conditionData.size() > 0) {
            for (int i = 0; i < conditionData.size(); ++i) {
                String conditionCurrencyIdStr;
                Object valueObj;
                Map conditionMap = (Map)conditionData.get(i);
                String conditionValType = (String)conditionMap.get("conditionValType");
                if (!SWCStringUtils.equals((String)conditionValType, (String)DataGradeValueTypeEnum.AMOUNT.getCode()) || !((valueObj = params[i]) instanceof BigDecimal) || SWCStringUtils.isEmpty((String)(conditionCurrencyIdStr = (String)conditionMap.get("conditionCurrencyId")))) continue;
                Integer conditionCurrencyAmtp = (Integer)conditionMap.get("conditionCurrencyAmtp");
                BigDecimal value = (BigDecimal)valueObj;
                BigDecimal exrateVal = this.getDataGradeConditionExrateData(Long.parseLong(conditionCurrencyIdStr), conditionCurrencyAmtp, value);
                if (exrateVal == null) continue;
                params[i] = exrateVal;
            }
        }
    }

    private Map<String, Object> dataGradeCalResult(String uniqueCode, Object[] params, Map<String, Object> paramsMap) throws KDBizException {
        Map gradeData = (Map)this.dmMap.get(uniqueCode);
        HashMap<String, Object> resultMap = new HashMap(16);
        if (this.dataGradeConditionValIsNull(params)) {
            String failPolicy = (String)gradeData.get("failpolice");
            FormulaParseUtils.buildResultData(paramsMap, gradeData);
            List resultDatas = (List)paramsMap.get("resultDatas");
            DataGradeMatchFailUtil.matchFailAction(resultMap, failPolicy, resultDatas);
            return resultMap;
        }
        FormulaParseUtils.getDataGradeParams(params, paramsMap, gradeData);
        resultMap = CalculationHelper.calculation(paramsMap);
        return resultMap;
    }

    private boolean dataGradeConditionValIsNull(Object[] params) {
        for (Object param : params) {
            if (param != null) continue;
            return true;
        }
        return false;
    }

    public void invokeGetFetchItem(String uniqueCode, boolean isSection) {
        CalFetchConfigInfo fetchConfigInfo = this.fetchItemConfigMap.get(uniqueCode);
        if (fetchConfigInfo != null && fetchConfigInfo.getCalculationfetch().booleanValue()) {
            HashSet<String> fetchItemCodeSet = new HashSet<String>(16);
            if (!SWCListUtils.isEmpty(this.ftItemCodeList)) {
                fetchItemCodeSet.addAll(this.ftItemCodeList);
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            if (this.dataReaderDataMap != null) {
                dataMap.putAll(this.dataReaderDataMap);
            }
            dataMap.putAll(this.params);
            try {
                DataReaderCalHelper.invokeDataFetch(dataMap, fetchItemCodeSet, uniqueCode, this.fetchItemConfigMap.get(uniqueCode), this.params, this.spItemMap, this.calPersonId, this.calTaskId, this.dataReaderDataMap, this.currentSectionKey, this.sectionParamMap, isSection, this.defaultSectionList.get(0));
            }
            catch (ParseException e) {
                logger.info("ftUnquecode = {},msg={}", (Object)uniqueCode, (Object)e.getMessage());
                throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u53d6\u6570\u5931\u8d25\u3002", (String)"FormulaParse_7", (String)"swc-hscs-business", (Object[])new Object[0])), new Object[0]);
            }
        }
    }

    protected boolean isNotNeedHandled(String slUniqueCode) {
        this.formulaStartTime = System.currentTimeMillis();
        this.setIsGetSectionResultFlag(slUniqueCode);
        if (this.resultMap.containsKey(slUniqueCode)) {
            return false;
        }
        return !this.isCalProration && (this.validUniqueCodeSet == null || this.validUniqueCodeSet.size() == 0 || !this.validUniqueCodeSet.contains(slUniqueCode));
    }

    public Date getProrationStartDate() {
        String msg = null;
        msg = this.isCalProration ? ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u6bb5\u5f00\u59cb\u65e5\u671f\u5931\u8d25\u3002", (String)"FormulaParse_5", (String)"swc-hscs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u83b7\u53d6\u85aa\u916c\u9879\u76ee\u201c{0}\u201d\u7684\u5206\u6bb5\u5f00\u59cb\u65e5\u671f\u5931\u8d25\u3002", (String)"FormulaParse_3", (String)"swc-hscs-business", (Object[])new Object[]{this.uniqueCodeMap.get(this.salaryItemUniqueCode).getName()});
        if (SWCStringUtils.isEmpty((String)this.currentSectionKey)) {
            logger.error("uniqueCode = {},currentSectionKey is empty", (Object)this.salaryItemUniqueCode);
            throw new KDBizException(msg);
        }
        String[] sectionArray = this.currentSectionKey.split("@");
        try {
            return SWCDateTimeUtils.parseDate((String)sectionArray[0], (String)"yyyy-MM-dd");
        }
        catch (ParseException ex) {
            logger.error("uniqueCode = {}", (Object)this.salaryItemUniqueCode);
            logger.error("parseDate error,", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", msg), new Object[0]);
        }
    }

    public Date getProrationEndDate() {
        String msg = null;
        msg = this.isCalProration ? ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u6bb5\u7ed3\u675f\u65e5\u671f\u5931\u8d25\u3002", (String)"FormulaParse_6", (String)"swc-hscs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u83b7\u53d6\u85aa\u916c\u9879\u76ee\u201c{0}\u201d\u7684\u5206\u6bb5\u7ed3\u675f\u65e5\u671f\u5931\u8d25\u3002", (String)"FormulaParse_4", (String)"swc-hscs-business", (Object[])new Object[]{this.uniqueCodeMap.get(this.salaryItemUniqueCode).getName()});
        if (SWCStringUtils.isEmpty((String)this.currentSectionKey)) {
            logger.error("uniqueCode = {},currentSectionKey is empty", (Object)this.salaryItemUniqueCode);
            throw new KDBizException(msg);
        }
        String[] sectionArray = this.currentSectionKey.split("@");
        try {
            return SWCDateTimeUtils.parseDate((String)sectionArray[1], (String)"yyyy-MM-dd");
        }
        catch (ParseException ex) {
            logger.error("uniqueCode = {}", (Object)this.salaryItemUniqueCode);
            logger.error("parseDate error,", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", msg), new Object[0]);
        }
    }

    public String getFirstSection() {
        Date prorationStartDate = this.getProrationStartDate();
        Date startDate = (Date)this.calTaskDataMap.get("startDate");
        if (this.isEqual(startDate, prorationStartDate)) {
            return YES;
        }
        return NO;
    }

    public String getLastSection() {
        Date prorationEndDate = this.getProrationEndDate();
        Date endDate = (Date)this.calTaskDataMap.get("endDate");
        if (this.isEqual(endDate, prorationEndDate)) {
            return YES;
        }
        return NO;
    }

    public Map<String, CalFetchConfigInfo> getFetchItemConfigMap() {
        return this.fetchItemConfigMap;
    }

    public void setFetchItemConfigMap(Map<String, CalFetchConfigInfo> fetchItemConfigMap) {
        this.fetchItemConfigMap = fetchItemConfigMap;
    }

    public List<String> getFtItemCodeList() {
        return this.ftItemCodeList;
    }

    public void setFtItemCodeList(List<String> ftItemCodeList) {
        this.ftItemCodeList = ftItemCodeList;
    }

    public void setDmMap(Map<String, Object> dmMap) {
        this.dmMap = dmMap;
    }

    public void setSection(boolean isSection) {
        this.isSection = isSection;
    }

    @Override
    public void setCalProration(boolean isCalProration) {
        this.isCalProration = isCalProration;
    }

    public Map<String, SalaryItemVO> getUniqueCodeMap() {
        return this.uniqueCodeMap;
    }

    public void setUniqueCodeMap(Map<String, SalaryItemVO> uniqueCodeMap) {
        this.uniqueCodeMap = uniqueCodeMap;
    }

    public void setValidUniqueCodeSet(HashSet<String> validUniqueCodeSet) {
        this.validUniqueCodeSet = validUniqueCodeSet;
    }

    public void setSectionParamMap(Map<String, Map<String, Object>> sectionParamMap) {
        if (null == sectionParamMap) {
            sectionParamMap = new HashMap<String, Map<String, Object>>(16);
        }
        this.sectionParamMap = sectionParamMap;
    }

    public Map<String, Map<String, Object>> getSectionParamMap() {
        return this.sectionParamMap;
    }

    public void setSpItemList(List<String> spItemList) {
        if (null == spItemList) {
            spItemList = new ArrayList<String>();
        }
        this.spItemList = spItemList;
    }

    public Map<String, Map<String, BigDecimal>> getProportionMap() {
        return this.proportionMap;
    }

    public void setProportionMap(Map<String, Map<String, BigDecimal>> proportionMap) {
        this.proportionMap = proportionMap;
    }

    public Map<String, List<String>> getItemSectionMap() {
        return this.itemSectionMap;
    }

    public void setItemSectionMap(Map<String, List<String>> itemSectionMap) {
        if (null == itemSectionMap) {
            itemSectionMap = new HashMap<String, List<String>>(16);
        }
        this.itemSectionMap = itemSectionMap;
    }

    public Map<String, Map<String, Object>> getItemSectionResultMap() {
        return this.itemSectionResultMap;
    }

    public Map<String, Object> getSpItemMap() {
        return this.spItemMap;
    }

    public void setSpItemMap(Map<String, Object> assItemMap) {
        if (null == assItemMap) {
            assItemMap = new HashMap<String, Object>(16);
        }
        this.spItemMap = assItemMap;
    }

    public Map<String, Object> getDataReaderDataMap() {
        return this.dataReaderDataMap;
    }

    public void setDataReaderDataMap(Map<String, Object> dataReaderDataMap) {
        this.dataReaderDataMap = dataReaderDataMap;
    }

    public Long getCalPersonId() {
        return this.calPersonId;
    }

    public void setCalPersonId(Long calPersonId) {
        this.calPersonId = calPersonId;
    }

    public Long getCalTaskId() {
        return this.calTaskId;
    }

    public void setCalTaskId(Long calTaskId) {
        this.calTaskId = calTaskId;
    }

    public Map<String, Object> getCalTaskDataMap() {
        return this.calTaskDataMap;
    }

    public void setCalTaskDataMap(Map<String, Object> calTaskDataMap) {
        this.calTaskDataMap = calTaskDataMap;
    }

    public Long getCalRecordId() {
        return this.calRecordId;
    }

    public void setCalRecordId(Long calRecordId) {
        this.calRecordId = calRecordId;
    }

    public void setDefaultSectionList(List<String> defaultSectionList) {
        this.defaultSectionList = defaultSectionList;
    }

    public void setSlItemRelMap(Map<String, List<String>> slItemRelMap) {
        this.slItemRelMap = slItemRelMap;
    }

    public void setSpItemInfoMap(Map<String, ItemInfo> spItemInfoMap) {
        this.spItemInfoMap = spItemInfoMap;
    }

    public Map<String, Long> getFormulaConsumeTiemMap() {
        return this.formulaConsumeTiemMap;
    }

    public void setFormulaConsumeTiemMap(Map<String, Long> formulaConsumeTiemMap) {
        this.formulaConsumeTiemMap = formulaConsumeTiemMap;
    }
}

