/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.base;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCDateUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.common.vo.acc.AccDetailsVO;
import kd.swc.hscs.common.vo.acc.AccInfo;
import kd.swc.hscs.common.vo.acc.AccMemberInfo;

public class ParentFormulaParse
implements Cloneable {
    private static final Log log = LogFactory.getLog(ParentFormulaParse.class);
    protected Map<String, Object> params;
    protected Map<String, Object> resultMap;
    protected Map<String, Map<String, Object>> itemSectionResultMap;
    protected Map<String, AccDetailsVO> accDetailsMap;
    protected Map<String, List<AccMemberInfo>> accMemberMap;
    protected Map<String, BigDecimal> usedBsItemMap;
    protected String salaryItemUniqueCode;
    protected String calBlock;
    protected boolean isCalProration;
    protected String currentSectionKey;
    protected boolean isGetSectionResult = false;
    protected Map<String, List<String>> messageMap;
    protected Map<String, Map<String, Set<String>>> slAndBsItemRelMap;

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Throwable)e);
        }
        return object;
    }

    public void calculate() {
    }

    public Map<String, Map<String, Set<String>>> getSlAndBsItemRelMap() {
        return this.slAndBsItemRelMap;
    }

    public void setSlAndBsItemRelMap(Map<String, Map<String, Set<String>>> slAndBsItemRelMap) {
        this.slAndBsItemRelMap = slAndBsItemRelMap;
    }

    public String getSalaryItemUniqueCode() {
        return this.salaryItemUniqueCode;
    }

    public void setSalaryItemUniqueCode(String salaryItemUniqueCode) {
        this.salaryItemUniqueCode = salaryItemUniqueCode;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        if (null == params) {
            params = new HashMap<String, Object>(16);
        }
        this.params = params;
    }

    public Map<String, Object> getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(Map<String, Object> resultMap) {
        if (null == resultMap) {
            resultMap = new HashMap<String, Object>(16);
        }
        this.resultMap = resultMap;
    }

    public BigDecimal getAccValueAsBigDecimal(String uniqueCode) {
        if (this.accDetailsMap != null) {
            AccDetailsVO accDetails = this.accDetailsMap.get(uniqueCode);
            if (accDetails == null) {
                return BigDecimal.ZERO;
            }
            if (accDetails.isOnlyFormulaUse()) {
                return accDetails.getInitValue().add(accDetails.getCurrentValue());
            }
            if (accDetails.getAccInfo() == null) {
                return accDetails.getInitValue().add(accDetails.getCurrentValue());
            }
            if (SWCStringUtils.equals((String)"3", (String)accDetails.getAccInfo().getUpdateStrategy())) {
                this.sumAccMemberValue(accDetails);
            }
            if (SWCStringUtils.equals((String)"2", (String)accDetails.getAccInfo().getUpdateStrategy())) {
                return accDetails.getInitValue();
            }
            return accDetails.getInitValue().add(accDetails.getCurrentValue());
        }
        return BigDecimal.ZERO;
    }

    private void sumAccMemberValue(AccDetailsVO accDetails) {
        AccInfo accInfo = accDetails.getAccInfo();
        if (SWCListUtils.isEmpty((List)accInfo.getMemberInfoList())) {
            return;
        }
        for (AccMemberInfo info : accInfo.getMemberInfoList()) {
            if (!info.isUsed()) continue;
            BigDecimal itemValue = SWCStringUtils.equals((String)info.getMemberType(), (String)"1") ? (BigDecimal)this.resultMap.get(info.getSlUniqueCode()) : this.usedBsItemMap.get(info.getBsUniqueCode());
            ParentFormulaParse.dealItemValue(info, accDetails, itemValue, this.calBlock);
        }
    }

    public static void dealItemValue(AccMemberInfo info, AccDetailsVO accDetails, BigDecimal itemValue, String calBlock) {
        if (itemValue == null || accDetails == null || !info.isUsed() || accDetails.isMemberUsed(info.getMemberKey())) {
            return;
        }
        itemValue = itemValue.multiply(info.getPercentFixVal()).multiply(new BigDecimal("0.01"));
        if (SWCStringUtils.equals((String)info.getOperator(), (String)"1")) {
            accDetails.setCurrentValue(accDetails.getCurrentValue().add(itemValue));
        } else {
            accDetails.setCurrentValue(accDetails.getCurrentValue().subtract(itemValue));
        }
        accDetails.memberUsed(info.getMemberKey(), calBlock);
    }

    protected void sumItemValueForMemberIsUpdate(String uniqueCode, BigDecimal itemValue, String itemType) {
        List<AccMemberInfo> memberList;
        if (this.isCalProration) {
            return;
        }
        if (SWCStringUtils.equals((String)itemType, (String)"BS")) {
            if (this.usedBsItemMap.containsKey(uniqueCode)) {
                return;
            }
            this.usedBsItemMap.put(uniqueCode, itemValue);
        }
        if ((memberList = this.getAccMemberMap().get(uniqueCode)) == null || memberList.size() == 0 || itemValue == null || BigDecimal.ZERO.compareTo(itemValue) == 0 || this.accDetailsMap.size() == 0) {
            return;
        }
        for (AccMemberInfo info : memberList) {
            ParentFormulaParse.dealItemValue(info, this.accDetailsMap.get(info.getUniqueCode()), itemValue, this.calBlock);
        }
    }

    public String getFieldValueAsString(String uniqueCode) {
        if (this.params != null) {
            Object obj = this.params.get(uniqueCode);
            if (obj == null) {
                return null;
            }
            this.addSlAndBsItemRelData(uniqueCode, this.currentSectionKey);
            return obj.toString();
        }
        return null;
    }

    protected void addSlAndBsItemRelData(String bsUniqueCode, String currentSectionKey) {
        Set<String> bizItemList;
        if (!bsUniqueCode.startsWith("BS_") || this.isCalProration) {
            return;
        }
        Map<String, Set<String>> dateRangeMap = this.slAndBsItemRelMap.get(this.salaryItemUniqueCode);
        if (dateRangeMap == null) {
            dateRangeMap = new HashMap<String, Set<String>>(16);
            this.slAndBsItemRelMap.put(this.salaryItemUniqueCode, dateRangeMap);
        }
        if ((bizItemList = dateRangeMap.get(currentSectionKey)) == null) {
            bizItemList = new HashSet<String>(16);
            dateRangeMap.put(currentSectionKey, bizItemList);
        }
        bizItemList.add(bsUniqueCode);
    }

    protected void removeSlAndBsItemRelData(String salaryItemUniqueCode, String currentSectionKey) {
        Map<String, Set<String>> dateRangeMap = this.slAndBsItemRelMap.get(salaryItemUniqueCode);
        if (dateRangeMap == null) {
            return;
        }
        dateRangeMap.remove(currentSectionKey);
        if (dateRangeMap.size() == 0) {
            this.slAndBsItemRelMap.remove(salaryItemUniqueCode);
        }
    }

    public BigDecimal getFieldValueAsBigDecimal(String uniqueCode) {
        if (this.params == null) {
            this.dealBsParamData(uniqueCode, BigDecimal.ZERO);
            return null;
        }
        Object obj = this.params.get(uniqueCode);
        if (obj == null) {
            return null;
        }
        this.addSlAndBsItemRelData(uniqueCode, this.currentSectionKey);
        BigDecimal itemValue = new BigDecimal(obj.toString());
        this.dealBsParamData(uniqueCode, itemValue);
        return itemValue;
    }

    private void dealBsParamData(String uniqueCode, BigDecimal itemValue) {
        if (this.isCalProration || !uniqueCode.startsWith("BS_")) {
            return;
        }
        this.sumItemValueForMemberIsUpdate(uniqueCode, itemValue, "BS");
    }

    public Date getFieldValueAsDate(String uniqueCode) {
        if (this.params != null) {
            Object obj = this.params.get(uniqueCode);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Date) {
                this.addSlAndBsItemRelData(uniqueCode, this.currentSectionKey);
                return (Date)obj;
            }
        }
        return null;
    }

    public String getResultValueAsString(String uniqueCode) {
        if (this.resultMap != null) {
            Object obj = this.resultMap.get(uniqueCode);
            return obj == null ? null : obj.toString();
        }
        return null;
    }

    public BigDecimal getResultValueAsBigDecimal(String uniqueCode) {
        Object value = null;
        if (this.isGetSectionResult) {
            if (this.itemSectionResultMap == null || this.itemSectionResultMap.get(uniqueCode) == null) {
                return null;
            }
            Map<String, Object> rangeValueMap = this.itemSectionResultMap.get(uniqueCode);
            value = rangeValueMap.get(this.currentSectionKey);
            if (value == null) {
                return null;
            }
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            return new BigDecimal(value.toString());
        }
        if (this.resultMap == null || this.resultMap.get(uniqueCode) == null) {
            return null;
        }
        value = this.resultMap.get(uniqueCode);
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    public Date getResultValueAsDate(String uniqueCode) {
        if (this.resultMap != null) {
            Object obj = this.resultMap.get(uniqueCode);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Date) {
                return (Date)obj;
            }
        }
        return null;
    }

    public void addResultValue(String uniqueCode, BigDecimal value) {
        if (this.resultMap.containsKey(uniqueCode)) {
            this.removeSlAndBsItemRelData(uniqueCode, this.currentSectionKey);
            this.sumItemValueForMemberIsUpdate(uniqueCode, this.getResultValueAsBigDecimal(uniqueCode), "SL");
            return;
        }
        if (value == null) {
            return;
        }
        this.resultMap.put(uniqueCode, value);
        this.sumItemValueForMemberIsUpdate(uniqueCode, value, "SL");
    }

    public void updateAccValueForResultCover(String uniqueCode) {
        if (this.resultMap.containsKey(uniqueCode)) {
            this.sumItemValueForMemberIsUpdate(uniqueCode, this.getResultValueAsBigDecimal(uniqueCode), "SL");
            return;
        }
    }

    public void addResultValue(String uniqueCode, Date value) {
        if (this.resultMap.containsKey(uniqueCode)) {
            this.removeSlAndBsItemRelData(uniqueCode, this.currentSectionKey);
            return;
        }
        this.resultMap.put(uniqueCode, value);
    }

    public void addResultValue(String uniqueCode, String value) {
        if (this.resultMap.containsKey(uniqueCode)) {
            this.removeSlAndBsItemRelData(uniqueCode, this.currentSectionKey);
            return;
        }
        this.resultMap.put(uniqueCode, value);
    }

    public void outputErrorMessage(String message) {
        log.info("formula output error message,salaryItem uniquecode is {}", (Object)this.salaryItemUniqueCode);
        if (SWCStringUtils.isNotEmpty((String)message) && message.length() > 255) {
            message = message.substring(0, 255);
        }
        throw new KDBizException(message);
    }

    public void outputPromptMessage(String message) {
        if (SWCStringUtils.isEmpty((String)message)) {
            return;
        }
        List<String> tempList = this.messageMap.get(this.salaryItemUniqueCode);
        if (tempList == null) {
            tempList = new ArrayList<String>(10);
            this.messageMap.put(this.salaryItemUniqueCode, tempList);
        }
        tempList.add(message);
    }

    public BigDecimal plus(BigDecimal param1, BigDecimal param2) {
        param1 = param1 == null ? BigDecimal.ZERO : param1;
        param2 = param2 == null ? BigDecimal.ZERO : param2;
        return param1.add(param2);
    }

    public BigDecimal subtract(BigDecimal param1, BigDecimal param2) {
        param1 = param1 == null ? BigDecimal.ZERO : param1;
        param2 = param2 == null ? BigDecimal.ZERO : param2;
        return param1.subtract(param2);
    }

    public BigDecimal multiply(BigDecimal param1, BigDecimal param2) {
        param1 = param1 == null ? BigDecimal.ZERO : param1;
        param2 = param2 == null ? BigDecimal.ZERO : param2;
        return param1.multiply(param2);
    }

    public BigDecimal divide(BigDecimal param1, BigDecimal param2) throws Exception {
        param1 = param1 == null ? BigDecimal.ZERO : param1;
        BigDecimal bigDecimal = param2 = param2 == null ? BigDecimal.ZERO : param2;
        if (param2.compareTo(BigDecimal.ZERO) == 0) {
            throw new Exception(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u5b58\u5728\u4f7f\u7528\u9664\u6cd5\u7684\u8868\u8fbe\u5f0f\uff0c\u4e14\u672c\u6b21\u8ba1\u7b97\u4e2d\u9664\u6570\u4e3a0\uff0c\u65e0\u6570\u5b66\u610f\u4e49\uff0c\u8bf7\u68c0\u67e5\u8c03\u6574\u6570\u636e\u540e\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"ParentFormulaParse_0", (String)"swc-hscs-business", (Object[])new Object[0]));
        }
        return param1.divide(param2, 18, 1);
    }

    public BigDecimal rounding(BigDecimal value, Integer scale) {
        value = value == null ? BigDecimal.ZERO : value;
        return value.setScale((int)scale, 4);
    }

    public boolean isEqual(String param1, String param2) {
        if (param1 != null) {
            return param1.equals(param2);
        }
        if (param2 != null) {
            return param2.equals(param1);
        }
        return true;
    }

    public boolean isEqual(BigDecimal param1, BigDecimal param2) {
        return this.isEqual(param1, param2, true);
    }

    public boolean isEqual(BigDecimal param1, BigDecimal param2, boolean isSetDefault) {
        if (isSetDefault) {
            param1 = param1 == null ? BigDecimal.ZERO : param1;
            BigDecimal bigDecimal = param2 = param2 == null ? BigDecimal.ZERO : param2;
        }
        if (param1 == null && param2 == null) {
            return true;
        }
        if (param1 == null || param2 == null) {
            return false;
        }
        return param1.compareTo(param2) == 0;
    }

    public boolean isEqual(Date param1, Date param2) {
        return SWCDateUtils.isEqual((Date)param1, (Date)param2);
    }

    public boolean isEqual(boolean param1, Object param2) {
        return false;
    }

    public boolean isEqual(boolean param1, boolean param2) {
        return param1 && param2;
    }

    public boolean unEqual(BigDecimal param1, BigDecimal param2) {
        return !this.isEqual(param1, param2);
    }

    public boolean unEqual(String param1, String param2) {
        return !this.isEqual(param1, param2);
    }

    public boolean unEqual(BigDecimal param1, BigDecimal param2, boolean isSetDefault) {
        if (isSetDefault) {
            param1 = param1 == null ? BigDecimal.ZERO : param1;
            param2 = param2 == null ? BigDecimal.ZERO : param2;
        }
        return !this.isEqual(param1, param2, false);
    }

    public boolean unEqual(Date param1, Date param2) {
        return !SWCDateUtils.isEqual((Date)param1, (Date)param2);
    }

    public boolean contains(String param1, String param2) {
        if (param1 == null || param2 == null) {
            return false;
        }
        return param1.contains(param2);
    }

    public boolean unEqual(boolean param1, boolean param2) {
        return !this.isEqual(param1, param2);
    }

    public boolean unEqual(boolean param1, Object param2) {
        return true;
    }

    public boolean gt(Calendar param1, Calendar param2) {
        if (param1 == null || param2 == null) {
            return false;
        }
        return param1.compareTo(param2) > 0;
    }

    public boolean gt(BigDecimal param1, BigDecimal param2) {
        if (param1 == null) {
            param1 = new BigDecimal(0);
        }
        if (param2 == null) {
            param2 = new BigDecimal(0);
        }
        return param1.compareTo(param2) > 0;
    }

    public boolean gt(Date param1, Date param2) {
        return SWCDateUtils.after((Date)param1, (Date)param2);
    }

    public boolean lt(BigDecimal param1, BigDecimal param2) {
        if (param1 == null) {
            param1 = new BigDecimal(0);
        }
        if (param2 == null) {
            param2 = new BigDecimal(0);
        }
        return param1.compareTo(param2) < 0;
    }

    public boolean lt(Date param1, Date param2) {
        return SWCDateUtils.before((Date)param1, (Date)param2);
    }

    public boolean gtOrEqual(BigDecimal param1, BigDecimal param2) {
        if (param1 == null) {
            param1 = new BigDecimal(0);
        }
        if (param2 == null) {
            param2 = new BigDecimal(0);
        }
        return param1.compareTo(param2) >= 0;
    }

    public boolean gtOrEqual(Date param1, Date param2) {
        if (param1 == null || param2 == null) {
            return false;
        }
        return !SWCDateUtils.before((Date)param1, (Date)param2);
    }

    public boolean ltOrEqual(BigDecimal param1, BigDecimal param2) {
        if (param1 == null) {
            param1 = new BigDecimal(0);
        }
        if (param2 == null) {
            param2 = new BigDecimal(0);
        }
        return param1.compareTo(param2) <= 0;
    }

    public boolean ltOrEqual(Calendar param1, Calendar param2) {
        if (param1 == null || param2 == null) {
            return false;
        }
        return param1.compareTo(param2) <= 0;
    }

    public boolean ltOrEqual(Date param1, Date param2) {
        if (param1 == null || param2 == null) {
            return false;
        }
        return !SWCDateUtils.after((Date)param1, (Date)param2);
    }

    public Map<String, AccDetailsVO> getAccDetailsMap() {
        return this.accDetailsMap;
    }

    public void setAccDetailsMap(Map<String, AccDetailsVO> accDetailsMap) {
        if (accDetailsMap == null) {
            accDetailsMap = new HashMap<String, AccDetailsVO>(16);
        }
        this.accDetailsMap = accDetailsMap;
    }

    public Map<String, List<AccMemberInfo>> getAccMemberMap() {
        return this.accMemberMap;
    }

    public void setAccMemberMap(Map<String, List<AccMemberInfo>> accMemberMap) {
        if (accMemberMap == null) {
            accMemberMap = new HashMap<String, List<AccMemberInfo>>(16);
        }
        this.accMemberMap = accMemberMap;
    }

    public void setUsedBsItemMap(Map<String, BigDecimal> usedBsItemMap) {
        if (usedBsItemMap == null) {
            usedBsItemMap = new HashMap<String, BigDecimal>(16);
        }
        this.usedBsItemMap = usedBsItemMap;
    }

    public void setCalBlock(String calBlock) {
        this.calBlock = calBlock;
    }

    public void setCalProration(boolean isCalProration) {
        this.isCalProration = isCalProration;
    }

    public void setItemSectionResultMap(Map<String, Map<String, Object>> itemSectionResultMap) {
        if (itemSectionResultMap == null) {
            itemSectionResultMap = new HashMap<String, Map<String, Object>>(16);
        }
        this.itemSectionResultMap = itemSectionResultMap;
    }

    public String getCurrentSectionKey() {
        return this.currentSectionKey;
    }

    public Map<String, List<String>> getMessageMap() {
        return this.messageMap;
    }

    public void setMessageMap(Map<String, List<String>> messageMap) {
        this.messageMap = messageMap;
    }
}

