/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.datagrade.calculation;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.datagrade.utils.DataGradeCalculeUtil;
import kd.swc.hscs.business.cal.datagrade.utils.DataGradeMatchFailUtil;

public class MatchCloseLowHelper {
    private static final Log log = LogFactory.getLog(MatchCloseLowHelper.class);

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> matchCloseLowCal(Map<String, Object> params) {
        void var13_16;
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        retMap.put("result", "success");
        List conditionIds = (List)params.get("conditionIds");
        if (SWCObjectUtils.isEmpty((Object)conditionIds)) {
            return null;
        }
        List resultIds = (List)params.get("resultIds");
        if (SWCObjectUtils.isEmpty((Object)resultIds)) {
            return null;
        }
        Map conditionMap = (Map)params.get("conditionMap");
        if (SWCObjectUtils.isEmpty((Object)conditionMap)) {
            return null;
        }
        List resultDatas = (List)params.get("resultDatas");
        if (SWCObjectUtils.isEmpty((Object)resultDatas)) {
            return null;
        }
        String failPolicy = (String)params.get("failpolice");
        String beyondPolicy = (String)params.get("beyondpolicy");
        Map gradeDataMap = (Map)params.get("gradeDataMap");
        log.info("MatchCloseLowHelper gradeDataMap is:{}", (Object)gradeDataMap);
        if (gradeDataMap == null) {
            return null;
        }
        ArrayList<Object> conditionIdStrList = new ArrayList<Object>(16);
        ArrayList<Object> conditionIdOtherList = new ArrayList<Object>(16);
        for (Object conditionId : conditionIds) {
            if (((String)conditionId).contains(DataGradeValueTypeEnum.TEXT.getDesc())) {
                conditionIdStrList.add(conditionId);
                continue;
            }
            conditionIdOtherList.add(conditionId);
        }
        StringBuilder rowKey = new StringBuilder("###");
        for (String string : conditionIdStrList) {
            Object conditionValue = conditionMap.get(string);
            if (conditionValue == null) continue;
            rowKey.append('#').append(conditionValue);
        }
        List<Map<String, Object>> gradeDataList = (List<Map<String, Object>>)gradeDataMap.get(rowKey.toString());
        if (gradeDataList == null || gradeDataList.size() == 0) {
            DataGradeMatchFailUtil.matchFailAction(retMap, failPolicy, resultDatas);
            return retMap;
        }
        if (gradeDataList.size() == 1 && conditionIdOtherList.size() == 0) {
            Map map = (Map)gradeDataList.get(0);
            for (String string : resultIds) {
                retMap.put(string, map.get(string));
            }
            return retMap;
        }
        ArrayList arrayList = new ArrayList(10);
        for (String string : conditionIdOtherList) {
            Object conditionValue;
            List<Map<String, Object>> list = MatchCloseLowHelper.matchLowVal(gradeDataList, string, conditionValue = conditionMap.get(string), beyondPolicy);
            if (list == null || list.size() == 0) {
                DataGradeMatchFailUtil.matchFailAction(retMap, failPolicy, resultDatas);
                return retMap;
            }
            gradeDataList = list;
        }
        if (var13_16.size() > 1) {
            DataGradeMatchFailUtil.matchFailAction(retMap, failPolicy, resultDatas);
            return retMap;
        }
        if (var13_16.size() == 1) {
            Map matchSucMap = (Map)var13_16.get(0);
            for (String resultId : resultIds) {
                retMap.put(resultId, matchSucMap.get(resultId));
            }
            return retMap;
        }
        return retMap;
    }

    private static List<Map<String, Object>> matchLowVal(List<Map<String, Object>> gradeDataList, String conditionId, Object conditionValue, String beyondPolicy) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(gradeDataList.size());
        if (conditionId.contains(DataGradeValueTypeEnum.AMOUNT.getDesc()) || conditionId.contains(DataGradeValueTypeEnum.DECIMAL.getDesc())) {
            MatchCloseLowHelper.matchDecimalLowVal(gradeDataList, conditionId, (BigDecimal)conditionValue, retList, beyondPolicy);
        } else if (conditionId.contains(DataGradeValueTypeEnum.DATE.getDesc())) {
            MatchCloseLowHelper.matchDateLowVal(gradeDataList, conditionId, (Date)conditionValue, retList, beyondPolicy);
        }
        return retList;
    }

    private static Date getDateVal(Object value) {
        if (value instanceof String) {
            try {
                return SWCDateTimeUtils.parseDate((String)((String)value));
            }
            catch (ParseException e) {
                log.info("MatchCloseHighHelper getDateVal error!");
            }
        } else if (value instanceof Date) {
            return (Date)value;
        }
        return null;
    }

    private static void matchDateLowVal(List<Map<String, Object>> gradeDataList, String conditionId, Date conditionValue, List<Map<String, Object>> retList, String beyondPolicy) {
        if (gradeDataList.size() == 1) {
            Map<String, Object> gardeDataMap = gradeDataList.get(0);
            Date fieldVal = MatchCloseLowHelper.getDateVal(gardeDataMap.get(conditionId));
            if (fieldVal == null) {
                return;
            }
            if (conditionValue.compareTo(fieldVal) >= 0) {
                retList.add(gardeDataMap);
            } else if (SWCStringUtils.equals((String)beyondPolicy, (String)"1")) {
                retList.add(gardeDataMap);
            }
            return;
        }
        Map<String, Object> firstGradeMap = gradeDataList.get(0);
        Map<String, Object> lastGradeMap = gradeDataList.get(gradeDataList.size() - 1);
        Date minFieldVal = MatchCloseLowHelper.getDateVal(firstGradeMap.get(conditionId));
        Date maxFieldVal = MatchCloseLowHelper.getDateVal(lastGradeMap.get(conditionId));
        if (conditionValue.compareTo(maxFieldVal) >= 0) {
            for (int index = gradeDataList.size() - 1; index >= 0; --index) {
                Map<String, Object> dataMap = gradeDataList.get(index);
                Date fieldVal = MatchCloseLowHelper.getDateVal(dataMap.get(conditionId));
                if (fieldVal == null) continue;
                if (fieldVal.compareTo(maxFieldVal) != 0) break;
                retList.add(dataMap);
            }
            return;
        }
        if (conditionValue.compareTo(minFieldVal) < 0) {
            if (SWCStringUtils.equals((String)beyondPolicy, (String)"0")) {
                return;
            }
            for (int index = 0; index < gradeDataList.size(); ++index) {
                Map<String, Object> dataMap = gradeDataList.get(index);
                Date fieldVal = MatchCloseLowHelper.getDateVal(dataMap.get(conditionId));
                if (fieldVal == null) continue;
                if (fieldVal.compareTo(minFieldVal) != 0) break;
                retList.add(dataMap);
            }
            return;
        }
        Date findVal = null;
        for (int index = 1; index < gradeDataList.size(); ++index) {
            Map<String, Object> preGradeMap = gradeDataList.get(index - 1);
            Map<String, Object> afterGradeMap = gradeDataList.get(index);
            Date preFieldVal = MatchCloseLowHelper.getDateVal(preGradeMap.get(conditionId));
            Date afterFieldVal = MatchCloseLowHelper.getDateVal(afterGradeMap.get(conditionId));
            if (preFieldVal == null || afterFieldVal == null) continue;
            if (conditionValue.compareTo(preFieldVal) == 0) {
                findVal = preFieldVal;
                break;
            }
            if (conditionValue.compareTo(afterFieldVal) == 0) {
                findVal = afterFieldVal;
                break;
            }
            if (conditionValue.compareTo(preFieldVal) <= 0 || conditionValue.compareTo(afterFieldVal) >= 0) continue;
            findVal = preFieldVal;
            break;
        }
        if (findVal == null) {
            return;
        }
        for (Map<String, Object> gradeDataMap : gradeDataList) {
            Date fieldVal = MatchCloseLowHelper.getDateVal(gradeDataMap.get(conditionId));
            if (fieldVal == null || fieldVal.compareTo(findVal) != 0) continue;
            retList.add(gradeDataMap);
        }
    }

    private static void matchDecimalLowVal(List<Map<String, Object>> gradeDataList, String conditionId, BigDecimal conditionValue, List<Map<String, Object>> retList, String beyondPolicy) {
        if (gradeDataList.size() == 1) {
            Map<String, Object> gardeDataMap = gradeDataList.get(0);
            BigDecimal fieldVal = DataGradeCalculeUtil.getBigDecimalVal(gardeDataMap.get(conditionId));
            if (fieldVal == null) {
                return;
            }
            if (conditionValue.compareTo(fieldVal) >= 0) {
                retList.add(gardeDataMap);
            } else if (SWCStringUtils.equals((String)beyondPolicy, (String)"1")) {
                retList.add(gardeDataMap);
            }
            return;
        }
        Map<String, Object> firstGradeMap = gradeDataList.get(0);
        Map<String, Object> lastGradeMap = gradeDataList.get(gradeDataList.size() - 1);
        BigDecimal minFieldVal = DataGradeCalculeUtil.getBigDecimalVal(firstGradeMap.get(conditionId));
        BigDecimal maxFieldVal = DataGradeCalculeUtil.getBigDecimalVal(lastGradeMap.get(conditionId));
        if (conditionValue.compareTo(maxFieldVal) >= 0) {
            int index;
            ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>(gradeDataList.size());
            for (index = gradeDataList.size() - 1; index >= 0; --index) {
                Map<String, Object> dataMap = gradeDataList.get(index);
                BigDecimal fieldVal = DataGradeCalculeUtil.getBigDecimalVal(dataMap.get(conditionId));
                if (fieldVal == null) continue;
                if (fieldVal.compareTo(maxFieldVal) != 0) break;
                tempList.add(dataMap);
            }
            for (index = tempList.size() - 1; index >= 0; --index) {
                retList.add((Map<String, Object>)tempList.get(index));
            }
            return;
        }
        if (conditionValue.compareTo(minFieldVal) < 0) {
            if (SWCStringUtils.equals((String)beyondPolicy, (String)"0")) {
                return;
            }
            for (int index = 0; index < gradeDataList.size(); ++index) {
                Map<String, Object> dataMap = gradeDataList.get(index);
                BigDecimal fieldVal = DataGradeCalculeUtil.getBigDecimalVal(dataMap.get(conditionId));
                if (fieldVal == null) continue;
                if (fieldVal.compareTo(minFieldVal) != 0) break;
                retList.add(dataMap);
            }
            return;
        }
        BigDecimal findVal = null;
        for (int index = 1; index < gradeDataList.size(); ++index) {
            Map<String, Object> preGradeMap = gradeDataList.get(index - 1);
            Map<String, Object> afterGradeMap = gradeDataList.get(index);
            BigDecimal preFieldVal = DataGradeCalculeUtil.getBigDecimalVal(preGradeMap.get(conditionId));
            BigDecimal afterFieldVal = DataGradeCalculeUtil.getBigDecimalVal(afterGradeMap.get(conditionId));
            if (preFieldVal == null || afterFieldVal == null) continue;
            if (conditionValue.compareTo(preFieldVal) == 0) {
                findVal = preFieldVal;
                break;
            }
            if (conditionValue.compareTo(afterFieldVal) == 0) {
                findVal = afterFieldVal;
                break;
            }
            if (conditionValue.compareTo(preFieldVal) <= 0 || conditionValue.compareTo(afterFieldVal) >= 0) continue;
            findVal = preFieldVal;
            break;
        }
        if (findVal == null) {
            return;
        }
        for (Map<String, Object> gradeDataMap : gradeDataList) {
            BigDecimal fieldVal = DataGradeCalculeUtil.getBigDecimalVal(gradeDataMap.get(conditionId));
            if (fieldVal == null || fieldVal.compareTo(findVal) != 0) continue;
            retList.add(gradeDataMap);
        }
    }
}

