/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.datagrade.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class DataGradeCalculeUtil {
    public static void calculeLineValue(List<List<Map<String, Object>>> dataList, Map<String, Object> conditionMap, Map<String, Object> retMap, String dataRoundNumber, List<Map<String, Object>> resultDatas) {
        List<Map<String, Object>> firstColl = dataList.get(0);
        Map<String, Object> firstObj = firstColl.get(0);
        String conditionId = (String)firstObj.get("fieldid");
        if (SWCStringUtils.isEmpty((String)conditionId)) {
            return;
        }
        int idx = conditionId.indexOf(45);
        if (idx == -1) {
            return;
        }
        String valueType = conditionId.substring(idx + 1, conditionId.lastIndexOf(45));
        Object conditionValue = conditionMap.get(conditionId);
        for (int i = 0; i < dataList.size() - 1; ++i) {
            List<Map<String, Object>> beforeDatas = dataList.get(i);
            Map<String, Object> beforeData = beforeDatas.get(0);
            List<Map<String, Object>> afterDatas = dataList.get(i + 1);
            Map<String, Object> afterData = afterDatas.get(0);
            if (!SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc()) && !SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) continue;
            BigDecimal beforeValue = (BigDecimal)beforeData.get("value");
            BigDecimal afterValue = (BigDecimal)afterData.get("value");
            BigDecimal value = (BigDecimal)conditionValue;
            if (value.compareTo(beforeValue) <= 0 || value.compareTo(afterValue) >= 0) continue;
            for (int j = 1; j < beforeDatas.size(); ++j) {
                int index;
                Map<String, Object> beforeResultData = beforeDatas.get(j);
                Map<String, Object> afterResultData = afterDatas.get(j);
                String resultId = (String)beforeResultData.get("fieldid");
                if (SWCStringUtils.isEmpty((String)resultId) || (index = resultId.indexOf(45)) == -1) continue;
                String resultType = resultId.substring(index + 1, resultId.lastIndexOf(45));
                Map<String, Object> resultMap = resultDatas.get(j - 1);
                if (!SWCStringUtils.equals((String)resultType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc()) && !SWCStringUtils.equals((String)resultType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) continue;
                BigDecimal beforeResultVal = (BigDecimal)beforeResultData.get("value");
                BigDecimal afterResultVal = (BigDecimal)afterResultData.get("value");
                BigDecimal valY = afterResultVal.subtract(beforeResultVal);
                BigDecimal valX = afterValue.subtract(beforeValue);
                BigDecimal rate = valY.divide(valX, 10, 4);
                BigDecimal intercept = rate.multiply(afterValue);
                intercept = afterResultVal.subtract(intercept);
                BigDecimal calculeResult = (BigDecimal)conditionMap.get(conditionId);
                BigDecimal calculeValue = rate.multiply(calculeResult).add(intercept);
                if (SWCStringUtils.equals((String)resultType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
                    String resultAccuracyStr = (String)resultMap.get("resultaccuracy");
                    int resultAccuracy = Integer.parseInt(resultAccuracyStr);
                    BigDecimal retVal = DataGradeCalculeUtil.calculateDataRound(calculeValue, dataRoundNumber, resultAccuracy);
                    retMap.put(resultId, retVal);
                    continue;
                }
                int amtPrecisionStr = (Integer)resultMap.get("amtPrecision");
                BigDecimal retVal = DataGradeCalculeUtil.calculateDataRound(calculeValue, dataRoundNumber, amtPrecisionStr);
                retMap.put(resultId, retVal);
            }
        }
    }

    private static BigDecimal calculateDataRound(BigDecimal calculeValue, String dataRound, int flag) {
        if (SWCStringUtils.equals((String)dataRound, (String)"1010_S")) {
            return calculeValue.setScale(flag, 4);
        }
        if (SWCStringUtils.equals((String)dataRound, (String)"1020_S")) {
            return calculeValue.setScale(flag, 1);
        }
        if (SWCStringUtils.equals((String)dataRound, (String)"1030_S")) {
            return calculeValue.setScale(flag, 0);
        }
        return null;
    }

    public static List<List<Map<String, Object>>> getMatchConditionNumber(List<List<Map<String, Object>>> datas, String id, int index, Object value) {
        ArrayList<List<Map<String, Object>>> retList = new ArrayList<List<Map<String, Object>>>(10);
        for (List<Map<String, Object>> dataList : datas) {
            Object conditionVal;
            Object fieldValue;
            Map<String, Object> dataObj = dataList.get(index);
            int idx = id.indexOf(45);
            if (idx == -1) continue;
            String valueType = id.substring(idx + 1, id.lastIndexOf(45));
            if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc()) || SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc())) {
                fieldValue = (BigDecimal)dataObj.get("value");
                if (((BigDecimal)fieldValue).compareTo((BigDecimal)(conditionVal = (BigDecimal)value)) != 0) continue;
                retList.add(dataList);
                continue;
            }
            if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.INTEGER.getDesc())) {
                fieldValue = (Integer)dataObj.get("value");
                conditionVal = (Integer)value;
                if (((Integer)fieldValue).intValue() != ((Integer)conditionVal).intValue()) continue;
                retList.add(dataList);
                continue;
            }
            if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
                fieldValue = (String)dataObj.get("value");
                if (!SWCStringUtils.equals((String)fieldValue, (String)(conditionVal = (String)value))) continue;
                retList.add(dataList);
                continue;
            }
            if (!SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DATE.getDesc())) continue;
            fieldValue = (Date)dataObj.get("value");
            conditionVal = (Date)value;
            if (((Date)fieldValue).getTime() != ((Date)conditionVal).getTime()) continue;
            retList.add(dataList);
        }
        return retList;
    }

    public static void setResultValue(Map<String, Object> resultObj, Map<String, Object> retMap) {
        String fieldId = (String)resultObj.get("fieldid");
        if (SWCStringUtils.isEmpty((String)fieldId)) {
            return;
        }
        if (fieldId.startsWith("condition-")) {
            return;
        }
        int idx = fieldId.indexOf(45);
        if (idx != -1) {
            String resultValType = fieldId.substring(idx + 1, fieldId.lastIndexOf(45));
            Object resultVal = resultObj.get("value");
            if (SWCStringUtils.equals((String)resultValType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc()) || SWCStringUtils.equals((String)resultValType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc())) {
                retMap.put(fieldId, resultVal);
            } else if (SWCStringUtils.equals((String)resultValType, (String)DataGradeValueTypeEnum.INTEGER.getDesc())) {
                retMap.put(fieldId, resultVal);
            } else if (SWCStringUtils.equals((String)resultValType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
                retMap.put(fieldId, resultVal);
            } else if (SWCStringUtils.equals((String)resultValType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
                retMap.put(fieldId, resultVal);
            }
        }
    }

    public static BigDecimal getBigDecimalVal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        return null;
    }
}

