/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.fetchdata.helper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hscs.service.api.ICustFetchService;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.exchangerate.helper.ExchangeRateHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.ConditionFieldTypeEnum;
import kd.swc.hsbp.common.enums.ConditionLogicTypeEnum;
import kd.swc.hsbp.common.enums.ConditionValueTypeEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.enums.PersonParamsEnum;
import kd.swc.hsbp.common.enums.RuleOperatorEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.common.vo.fetch.CalFetchConfigInfo;
import kd.swc.hscs.common.vo.fetch.CalResultMatchItemInfo;
import kd.swc.hscs.common.vo.fetch.FetchConfigFilterInfo;
import kd.swc.hscs.common.vo.fetch.FetchFieldInfo;
import kd.swc.hscs.common.vo.fetch.FetchSortedInfo;
import kd.swc.hscs.common.vo.fetch.FilterEntryInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DataReaderCalHelper {
    private static final Log logger = LogFactory.getLog(DataReaderCalHelper.class);
    private static final int SUM_PRORATIONINDEX = 0;
    private static Map<String, String> conditionMatchMap = new HashMap<String, String>(5);

    public void selectHisResultFetchData(Set<String> fetchItemCodeSet, Map<String, Object> taskFetchItemDataMap, Long calTaskId, CalFetchConfigInfo fetchConfigInfo, Map<String, Object> calTaskMap, Map<String, ExchangeRateInfo> exrateCacheMap, Map<Long, Map<String, Object>> allFetchItemDataMap, List<Long> calPersonIdList, Map<Long, Map<String, Object>> periodProrationRowMap, Map<Long, Map<String, Map<String, Object>>> itemProrationRowMap) {
        String selectLevel = fetchConfigInfo.getFilterInfo().getSelectLevel();
        String selectLevelValue = this.assembleSelectFieldByLevel(selectLevel);
        long start = System.currentTimeMillis();
        HashMap<String, Date> dateFilterMap = new HashMap<String, Date>(2);
        try {
            DataReaderCalHelper.assembleDateMap(dateFilterMap, fetchConfigInfo.getFilterInfo().getPrePeriodCount(), calTaskMap);
        }
        catch (ParseException exception) {
            logger.error("assembleDateMap_error", (Throwable)exception);
            throw new KDException((Throwable)exception, BosErrorCode.parse, new Object[]{ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{0}\u3002", (String)"DataReaderCalHelper_1", (String)"swc-hscs-business", (Object[])new Object[]{exception.getMessage()})});
        }
        Map<String, Date> dateMap = DataReaderCalHelper.assembleDateFilterMap(dateFilterMap, fetchConfigInfo.getFilterInfo(), calTaskMap, taskFetchItemDataMap);
        Date startItemValue = dateMap.get("startDate");
        Date endItemValue = dateMap.get("endDate");
        String dateMatchMethod = fetchConfigInfo.getFilterInfo().getDateMatchMethod();
        String calPersonDateMatchKey = DataReaderCalHelper.assembleDateMatchKeyByType(fetchConfigInfo.getFilterInfo().getDateMatch());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObject[] calPersons = helper.queryOriginalArray("id,salaryfile.id,salaryfile.employee.id,calresultid,salaryfile.person.id,empnumber", new QFilter[]{new QFilter("id", "in", calPersonIdList)});
        if (calPersons == null || calPersons.length == 0) {
            return;
        }
        long end = System.currentTimeMillis();
        logger.info("\u67e5\u8be2\u6863\u6848\u6216\u4eba\u5458id,calPersons.size:{},\u8017\u65f6:{} ms", (Object)calPersons.length, (Object)(end - start));
        List<String> matchIdList = Arrays.stream(calPersons).map(calPerson -> calPerson.getString(selectLevelValue)).collect(Collectors.toList());
        Map<String, Long> personIdMatchIdMap = Arrays.stream(calPersons).collect(Collectors.toMap(key -> key.getString(selectLevelValue), value -> value.getLong("id")));
        if (matchIdList == null || matchIdList.size() == 0) {
            return;
        }
        String calPersonSqlStr = DataReaderCalHelper.assembleCalPersonSql(calTaskId, selectLevel, matchIdList, fetchConfigInfo, calTaskMap, startItemValue, endItemValue, dateMatchMethod, calPersonDateMatchKey);
        logger.info("\u6784\u5efa\u67e5\u8be2calperson\u6570\u636esql:{}", (Object)calPersonSqlStr);
        ArrayList<Map<String, String>> calTableDataList = new ArrayList<Map<String, String>>(10);
        HashMap<Long, Long> calTableTaskCurrencyMap = new HashMap<Long, Long>(16);
        if (DataReaderCalHelper.queryHisResultFetchData(calPersonSqlStr, calTableDataList, calTableTaskCurrencyMap, startItemValue, endItemValue)) {
            return;
        }
        if (calTableDataList.size() == 0) {
            return;
        }
        HashMap<Long, List<Long>> personResultMap = new HashMap<Long, List<Long>>(16);
        ArrayList<Long> calTableIdList = new ArrayList<Long>(calTableDataList.size());
        DataReaderCalHelper.assemblePersonResultIds(personIdMatchIdMap, calTableDataList, personResultMap, calTableIdList);
        logger.info(MessageFormat.format("\u5386\u53f2\u85aa\u916c\u7ed3\u679c\u53d6\u6570\u914d\u7f6e{0}\u67e5\u8be2\u5b8c\u6210\uff0c\u67e5\u5f97\u6838\u7b97\u540d\u5355\u6570\u636e{1}\u6761\uff0c\u8017\u65f6:{2} ms", fetchConfigInfo.getFetchNumber(), personResultMap.size(), System.currentTimeMillis() - end));
        end = System.currentTimeMillis();
        HashMap<String, List<Long>> sourceItemCodeTypeMap = new HashMap<String, List<Long>>(16);
        HashMap<Long, String> fetchSourceItemMap = new HashMap<Long, String>(16);
        HashMap<Long, String> itemTypeMap = new HashMap<Long, String>(16);
        HashSet<Long> numItemIdSet = new HashSet<Long>(16);
        DataReaderCalHelper.assembleSourceItemCodeMap(numItemIdSet, fetchConfigInfo.getResultMatchItemInfo(), sourceItemCodeTypeMap, fetchSourceItemMap, itemTypeMap);
        HashMap<String, Map<Long, Map<Long, Map<String, Object>>>> resultDataMap = new HashMap<String, Map<Long, Map<Long, Map<String, Object>>>>(16);
        Map<String, String> handleStrategyMap = fetchConfigInfo.getResultMatchItemInfo().stream().collect(Collectors.toMap(CalResultMatchItemInfo::getMatchFetchItemCode, CalResultMatchItemInfo::getHandleStrategy));
        Map<String, CalResultMatchItemInfo> fetchItemInfoMap = fetchConfigInfo.getResultMatchItemInfo().stream().collect(Collectors.toMap(CalResultMatchItemInfo::getMatchFetchItemCode, Function.identity()));
        for (Map.Entry entry : sourceItemCodeTypeMap.entrySet()) {
            DataReaderCalHelper.executeQueryCalTableResultData((String)entry.getKey(), (List)entry.getValue(), calTableIdList, resultDataMap);
        }
        logger.info("\u67e5\u8be2\u7ed3\u679c\u6570\u636e\u7ed3\u675f\uff0c\u8017\u65f6:{} ms", (Object)(System.currentTimeMillis() - end));
        end = System.currentTimeMillis();
        this.packagePersonHisFetchItemData(fetchItemInfoMap, fetchItemCodeSet, calTaskMap, exrateCacheMap, allFetchItemDataMap, periodProrationRowMap, calTableTaskCurrencyMap, personResultMap, fetchSourceItemMap, itemTypeMap, resultDataMap, handleStrategyMap);
        logger.info("\u5c01\u88c5\u7ed3\u679c\u6570\u636e\u7ed3\u675f\uff0c\u8017\u65f6:{} ms", (Object)(System.currentTimeMillis() - end));
    }

    private String assembleSelectFieldByLevel(String selectLevel) {
        if (SWCStringUtils.equals((String)"1", (String)selectLevel)) {
            return "salaryfile.id";
        }
        if (SWCStringUtils.equals((String)"2", (String)selectLevel)) {
            return "salaryfile.employee.id";
        }
        if (SWCStringUtils.equals((String)"3", (String)selectLevel)) {
            return "salaryfile.person.id";
        }
        if (SWCStringUtils.equals((String)"4", (String)selectLevel)) {
            return "empnumber";
        }
        return "id";
    }

    private static void assemblePersonResultIds(Map<String, Long> personIdMatchIdMap, List<Map<String, String>> calTableDataList, Map<Long, List<Long>> personResultMap, List<Long> calTableIdList) {
        for (Map<String, String> map : calTableDataList) {
            String matchId = map.get("id");
            Long personId = personIdMatchIdMap.get(matchId);
            List resultIdList = personResultMap.getOrDefault(personId, new ArrayList(10));
            if (personId == null) continue;
            resultIdList.add(Long.valueOf(map.get("resultid")));
            calTableIdList.add(Long.valueOf(map.get("resultid")));
            personResultMap.put(personId, resultIdList);
        }
    }

    private static boolean queryHisResultFetchData(String calPersonSqlStr, List<Map<String, String>> calTableDataList, Map<Long, Long> calTableTaskCurrencyMap, Date startItemValue, Date endItemValue) {
        ArrayList<Date> paramsList = new ArrayList<Date>(2);
        if (startItemValue != null) {
            paramsList.add(startItemValue);
        }
        if (endItemValue != null) {
            paramsList.add(endItemValue);
        }
        Object[] params = paramsList.toArray();
        try (DataSet calTableDataSet = DB.queryDataSet((String)"DataReaderCalHelper.selectHisResultFetchData", (DBRoute)SWCConstants.SWC_ROUETE, (String)calPersonSqlStr, (Object[])params);){
            if (calTableDataSet == null) {
                boolean bl = true;
                return bl;
            }
            while (calTableDataSet.hasNext()) {
                Row row = calTableDataSet.next();
                HashMap<String, String> calTableMap = new HashMap<String, String>(3);
                calTableMap.put("id", row.getString("matchid"));
                calTableMap.put("resultid", row.getString("resultid"));
                calTableMap.put("currencyid", row.getString("currencyid"));
                calTableTaskCurrencyMap.put(row.getLong("resultid"), row.getLong("currencyid"));
                calTableDataList.add(calTableMap);
            }
        }
        return false;
    }

    private void packagePersonHisFetchItemData(Map<String, CalResultMatchItemInfo> fetchItemInfoMap, Set<String> fetchItemCodeSet, Map<String, Object> calTaskMap, Map<String, ExchangeRateInfo> exrateCacheMap, Map<Long, Map<String, Object>> allFetchItemDataMap, Map<Long, Map<String, Object>> periodProrationRowMap, Map<Long, Long> calTableTaskCurrencyMap, Map<Long, List<Long>> personResultMap, Map<Long, String> fetchSourceItemMap, Map<Long, String> itemTypeMap, Map<String, Map<Long, Map<Long, Map<String, Object>>>> resultDataMap, Map<String, String> handleStrategyMap) {
        Map<String, Long> itemDataTypeMap = this.queryFetchItemDataType(fetchItemCodeSet);
        for (Map.Entry<Long, List<Long>> entry : personResultMap.entrySet()) {
            Long personId = entry.getKey();
            List<Long> resultIdList = entry.getValue();
            if (SWCListUtils.isEmpty(resultIdList)) continue;
            Map allFetchDataMap = allFetchItemDataMap.computeIfAbsent(personId, value -> new HashMap(16));
            Map fetchDataMap = periodProrationRowMap.computeIfAbsent(personId, value -> new HashMap(16));
            try {
                Map<String, Object> resultFetchDataMap = DataReaderCalHelper.assembleResultDataMap(calTableTaskCurrencyMap, calTaskMap, itemTypeMap, fetchSourceItemMap, handleStrategyMap, resultDataMap, resultIdList, exrateCacheMap);
                if (resultFetchDataMap.size() > 0) {
                    for (Map.Entry<String, Object> dataEntry : resultFetchDataMap.entrySet()) {
                        String itemCode = dataEntry.getKey();
                        if (!fetchItemCodeSet.contains(itemCode)) continue;
                        CalResultMatchItemInfo itemInfo = fetchItemInfoMap.get(itemCode);
                        String dataType = itemInfo.getDataType();
                        Object value2 = dataEntry.getValue();
                        Long itemDataType = itemDataTypeMap.get(itemCode);
                        if (SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_NUM.getCode(), (String)dataType) && value2 != null) {
                            int precision = itemInfo.getPrecision();
                            RoundingMode dataRound = itemInfo.getDataRound();
                            fetchDataMap.put(itemCode, new BigDecimal(value2.toString()).setScale(precision, dataRound));
                            continue;
                        }
                        if (value2 instanceof Date && DataTypeEnum.STRING.getDbId() == itemDataType.longValue()) {
                            fetchDataMap.put(itemCode, SWCDateTimeUtils.format((Date)((Date)value2), (String)"yyyy-MM-dd"));
                            continue;
                        }
                        fetchDataMap.put(itemCode, value2);
                    }
                }
                allFetchDataMap.putAll(resultFetchDataMap);
            }
            catch (Exception exception) {
                logger.error("\u5c01\u88c5\u6570\u636e\u5931\u8d25", (Throwable)exception);
                throw exception;
            }
        }
    }

    public static String assembleCalPersonSql(Long calTaskId, String selectLevel, List<String> matchIdList, CalFetchConfigInfo fetchConfigInfo, Map<String, Object> calTaskMap, Date startItemValue, Date endItemValue, String dateMatchMethod, String calPersonDateMatchKey) {
        List calScene;
        StringBuilder sqlSb = new StringBuilder("select ");
        String matchIdListStr = SWCStringUtils.equals((String)selectLevel, (String)"4") ? StringUtils.join((Object[])matchIdList.toArray(), (String)"','") : StringUtils.join((Object[])matchIdList.toArray(), (String)",");
        if (SWCStringUtils.equals((String)selectLevel, (String)"2")) {
            sqlSb.append(" person.femployeeid matchid,");
        } else if (SWCStringUtils.equals((String)selectLevel, (String)"1")) {
            sqlSb.append(" person.fsalaryfileid matchid,");
        } else if (SWCStringUtils.equals((String)selectLevel, (String)"4")) {
            sqlSb.append(" person.fempnumber matchid,");
        }
        sqlSb.append(" person.fcalresultid resultid,grp.fcurrencyid currencyid from t_hsas_calperson person  left join t_hsas_calpayrolltask task on person.fcaltaskid = task.fid left join t_hsas_payrollgrp grp on task.fpayrollgroupvid  = grp.fid");
        if (SWCStringUtils.equals((String)"2", (String)dateMatchMethod) && SWCStringUtils.equals((String)"taska.fpaydate", (String)calPersonDateMatchKey)) {
            sqlSb.append(" left join t_hsas_calpayrolltask_a taska on task.fid = taska.fid");
        }
        if (SWCStringUtils.equals((String)selectLevel, (String)"2")) {
            sqlSb.append(" where person.femployeeid in (").append(matchIdListStr).append(')');
        } else if (SWCStringUtils.equals((String)selectLevel, (String)"1")) {
            sqlSb.append(" where person.fsalaryfileid in (").append(matchIdListStr).append(')');
        } else if (SWCStringUtils.equals((String)selectLevel, (String)"4")) {
            sqlSb.append(" where person.fempnumber in ('").append(matchIdListStr).append("')");
        }
        sqlSb.append(" and person.fcalresultid != 0");
        sqlSb.append(" and person.fcaltaskid != ").append(calTaskId);
        if (SWCStringUtils.equals((String)"1", (String)dateMatchMethod)) {
            if (startItemValue != null) {
                sqlSb.append(" and task.fenddate >= ?");
            } else {
                sqlSb.append(" and task.fenddate >= null");
            }
            if (endItemValue != null) {
                sqlSb.append(" and task.fstartdate <= ?");
            } else {
                sqlSb.append(" and task.fstartdate <= null");
            }
        } else if (SWCStringUtils.equals((String)"2", (String)dateMatchMethod)) {
            if (startItemValue != null) {
                sqlSb.append(" and ").append(calPersonDateMatchKey).append(" >= ?");
            } else {
                sqlSb.append(" and ").append(calPersonDateMatchKey).append(" >= null");
            }
            if (endItemValue != null) {
                sqlSb.append(" and ").append(calPersonDateMatchKey).append(" <= ?");
            } else {
                sqlSb.append(" and ").append(calPersonDateMatchKey).append(" <= null");
            }
        }
        String sceneLimit = fetchConfigInfo.getFilterInfo().getSceneLimit();
        if (SWCStringUtils.equals((String)"1", (String)sceneLimit)) {
            Long currCalScene = (Long)calTaskMap.get("payrollsceneId");
            sqlSb.append(" and task.fpayrollsceneid = ").append(currCalScene);
        } else if (SWCStringUtils.equals((String)"2", (String)sceneLimit) && (calScene = fetchConfigInfo.getFilterInfo().getCalScene()).size() > 0) {
            String calSceneStr = StringUtils.join((Object[])calScene.toArray(), (String)",");
            sqlSb.append(" and task.fpayrollsceneid in (").append(calSceneStr).append(')');
        }
        if (SWCStringUtils.equals((String)"1", (String)dateMatchMethod)) {
            sqlSb.append(" order by task.fenddate desc ");
        } else if (SWCStringUtils.equals((String)"2", (String)dateMatchMethod)) {
            sqlSb.append(" order by ").append(calPersonDateMatchKey).append(" desc ");
        }
        return sqlSb.toString();
    }

    private static Map<String, Object> assembleResultDataMap(Map<Long, Long> calTableTaskCurrencyMap, Map<String, Object> calTaskMap, Map<Long, String> itemTypeMap, Map<Long, String> fetchSourceItemMap, Map<String, String> handleStrategyMap, Map<String, Map<Long, Map<Long, Map<String, Object>>>> resultDataMap, List<Long> resultIdList, Map<String, ExchangeRateInfo> exrateCacheMap) {
        HashMap<String, Object> resutDataMap = new HashMap<String, Object>(16);
        for (Map.Entry<Long, String> itemEntry : fetchSourceItemMap.entrySet()) {
            Map<Long, Map<String, Object>> lastDataMap;
            Map<String, Object> dataMap;
            Object dataType;
            Object itemValue;
            Object dataTypeId;
            Long itemId = itemEntry.getKey();
            String itemCode = itemEntry.getValue();
            String itemType = itemTypeMap.get(itemId);
            Map<Long, Map<Long, Map<String, Object>>> resultMap = resultDataMap.get(itemType);
            if (resultMap == null || resultMap.size() == 0) continue;
            Long lastResultId = resultIdList.get(0);
            Long firstResultId = resultIdList.get(resultIdList.size() - 1);
            Map<Long, Map<String, Object>> lastSingleDataMap = resultMap.get(lastResultId);
            Map<Long, Map<String, Object>> firstSingleDataMap = resultMap.get(firstResultId);
            if (SWCStringUtils.equals((String)handleStrategyMap.get(itemCode), (String)"1")) {
                Map<String, Object> dataMap2;
                if (lastSingleDataMap == null || lastSingleDataMap.get(itemId) == null || (dataTypeId = (dataMap2 = lastSingleDataMap.get(itemId)).get("datatype")) == null) continue;
                itemValue = DataReaderCalHelper.assembleSingleItemValue(calTaskMap, calTableTaskCurrencyMap, dataMap2, exrateCacheMap);
                resutDataMap.put(itemCode, itemValue);
                continue;
            }
            if (SWCStringUtils.equals((String)handleStrategyMap.get(itemCode), (String)"2")) {
                Map<String, Object> firstDataMap;
                if (firstSingleDataMap == null || firstSingleDataMap.get(itemId) == null || (dataTypeId = (firstDataMap = firstSingleDataMap.get(itemId)).get("datatype")) == null) continue;
                itemValue = DataReaderCalHelper.assembleSingleItemValue(calTaskMap, calTableTaskCurrencyMap, firstDataMap, exrateCacheMap);
                resutDataMap.put(itemCode, itemValue);
                continue;
            }
            ArrayList<Long> tempResultIdList = new ArrayList<Long>(10);
            dataTypeId = resultIdList.iterator();
            while (dataTypeId.hasNext()) {
                Long resultId = dataTypeId.next();
                Map<Long, Map<String, Object>> tempResultMap = resultMap.get(resultId);
                if (tempResultMap == null || tempResultMap.get(itemId) == null) continue;
                tempResultIdList.add(resultId);
            }
            if (SWCListUtils.isEmpty(tempResultIdList) || (dataType = (dataMap = (lastDataMap = resultMap.get(tempResultIdList.get(0))).get(itemId)).get("datatype")) == null) continue;
            BigDecimal totalValue = BigDecimal.ZERO;
            Long dataTypeId2 = (Long)dataType;
            if (dataTypeId2 == 1010L || dataTypeId2 == 1020L) {
                for (Long tempResultId : tempResultIdList) {
                    Map<String, Object> dataMapT;
                    Map<Long, Map<String, Object>> singleData = resultMap.get(tempResultId);
                    if (singleData == null || (dataMapT = singleData.get(itemId)) == null) continue;
                    totalValue = totalValue.add((BigDecimal)DataReaderCalHelper.assembleSingleItemValue(calTaskMap, calTableTaskCurrencyMap, dataMapT, exrateCacheMap));
                }
            }
            resutDataMap.put(itemCode, totalValue);
        }
        return resutDataMap;
    }

    private static Object assembleSingleItemValue(Map<String, Object> calTaskMap, Map<Long, Long> calTableTaskCurrencyMap, Map<String, Object> singleDataMap, Map<String, ExchangeRateInfo> exrateCacheMap) {
        Long dataTypeId = Long.valueOf(singleDataMap.get("datatype").toString());
        Long currencyId = calTableTaskCurrencyMap.get(singleDataMap.get("id"));
        if (dataTypeId == 1010L) {
            BigDecimal value = new BigDecimal(singleDataMap.get("numvalue") + "");
            return value;
        }
        if (dataTypeId == 1020L) {
            try {
                if (currencyId == null) {
                    return BigDecimal.ZERO;
                }
                String valueStr = singleDataMap.get("amountvalue") + "";
                String decodeValue = StringUtils.isNotEmpty((CharSequence)valueStr) && valueStr.startsWith("d@f*g:") ? Encrypters.decode((String)valueStr) : valueStr;
                BigDecimal amountDecode = decodeValue == null || SWCStringUtils.equals((String)"null", (String)decodeValue) ? BigDecimal.ZERO : new BigDecimal(decodeValue);
                BigDecimal calAmountValue = DataReaderCalHelper.getExrateData(calTaskMap, amountDecode, currencyId, exrateCacheMap);
                return calAmountValue;
            }
            catch (ParseException e) {
                throw new KDException((Throwable)e, BosErrorCode.parse, new Object[]{ResManager.loadKDString((String)"\u6c47\u7387\u8f6c\u6362\u5931\u8d25{0}\u3002", (String)"DataReaderCalHelper_0", (String)"swc-hscs-business", (Object[])new Object[]{e.getMessage()})});
            }
        }
        if (dataTypeId == 1030L) {
            String textValue = singleDataMap.get("textvalue") + "";
            return textValue;
        }
        if (dataTypeId == 1050L) {
            String dateValueStr = singleDataMap.get("datevalue") + "";
            Date dateValue = null;
            try {
                dateValue = SWCDateTimeUtils.parseDate((String)dateValueStr, (String)"yyyy-MM-dd");
            }
            catch (ParseException exception) {
                logger.error("date parse error", (Throwable)exception);
            }
            return dateValue;
        }
        return BigDecimal.ZERO;
    }

    private static void executeQueryCalTableResultData(String itemType, List<Long> itemIdList, List<Long> calTableIdList, Map<String, Map<Long, Map<Long, Map<String, Object>>>> resultDataMap) {
        if (SWCListUtils.isEmpty(itemIdList)) {
            return;
        }
        switch (itemType) {
            case "1": {
                DataReaderCalHelper.handleSLItemData(itemType, itemIdList, calTableIdList, resultDataMap);
                break;
            }
            case "4": {
                DataReaderCalHelper.handleFTItemData(itemType, itemIdList, calTableIdList, resultDataMap);
                break;
            }
            case "2": {
                DataReaderCalHelper.handleSPItemData(itemType, itemIdList, calTableIdList, resultDataMap);
                break;
            }
            case "3": {
                DataReaderCalHelper.handleBSItemData(itemType, itemIdList, calTableIdList, resultDataMap);
                break;
            }
        }
    }

    private static void handleBSItemData(String itemType, List<Long> itemIdList, List<Long> calTableIdList, Map<String, Map<Long, Map<Long, Map<String, Object>>>> resultDataMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "in", calTableIdList);
        filter.and("hsas_calbsentry.bizitem.id", "in", itemIdList);
        filter.and("hsas_calbsentry.bsprorationindex", "=", (Object)0);
        String fields = "id,hsas_calbsentry.bizitem.id,hsas_calbsentry.bstextvalue,hsas_calbsentry.bsnumvalue,hsas_calbsentry.bscalamountvalue,hsas_calbsentry.bsdatevalue,hsas_calbsentry.bizitem.datatype.id";
        DynamicObjectCollection bsEntryList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        Map dataMap = resultDataMap.computeIfAbsent(itemType, value -> new HashMap(16));
        Map itemData = null;
        HashMap<String, Object> tempMap = null;
        for (DynamicObject entry : bsEntryList) {
            itemData = dataMap.computeIfAbsent(entry.getLong("id"), valueMap -> new HashMap(16));
            tempMap = new HashMap<String, Object>(16);
            tempMap.put("id", entry.getLong("id"));
            tempMap.put("itemid", entry.getLong("hsas_calbsentry.bizitem.id"));
            tempMap.put("textvalue", entry.getString("hsas_calbsentry.bstextvalue"));
            tempMap.put("numvalue", entry.getBigDecimal("hsas_calbsentry.bsnumvalue"));
            tempMap.put("amountvalue", entry.getString("hsas_calbsentry.bscalamountvalue"));
            tempMap.put("datevalue", entry.getDate("hsas_calbsentry.bsdatevalue"));
            tempMap.put("datatype", entry.getLong("hsas_calbsentry.bizitem.datatype.id"));
            itemData.put(entry.getLong("hsas_calbsentry.bizitem.id"), tempMap);
        }
    }

    private static void handleSPItemData(String itemType, List<Long> itemIdList, List<Long> calTableIdList, Map<String, Map<Long, Map<Long, Map<String, Object>>>> resultDataMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "in", calTableIdList);
        filter.and("hsas_calspentry.supportitem.id", "in", itemIdList);
        filter.and("hsas_calspentry.spprorationindex", "=", (Object)0);
        String fields = "id,hsas_calspentry.supportitem.id,hsas_calspentry.sptextvalue,hsas_calspentry.spnumvalue,hsas_calspentry.spdatevalue,hsas_calspentry.supportitem.datatype.id";
        DynamicObjectCollection spEntryList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        Map dataMap = resultDataMap.computeIfAbsent(itemType, value -> new HashMap(16));
        Map itemData = null;
        HashMap<String, Object> tempMap = null;
        for (DynamicObject entry : spEntryList) {
            itemData = dataMap.computeIfAbsent(entry.getLong("id"), valueMap -> new HashMap(16));
            tempMap = new HashMap<String, Object>(16);
            tempMap.put("id", entry.getLong("id"));
            tempMap.put("itemid", entry.getLong("hsas_calspentry.supportitem.id"));
            tempMap.put("textvalue", entry.getString("hsas_calspentry.sptextvalue"));
            tempMap.put("numvalue", entry.getBigDecimal("hsas_calspentry.spnumvalue"));
            tempMap.put("datevalue", entry.getDate("hsas_calspentry.spdatevalue"));
            tempMap.put("datatype", entry.getLong("hsas_calspentry.supportitem.datatype.id"));
            itemData.put(entry.getLong("hsas_calspentry.supportitem.id"), tempMap);
        }
    }

    private static void handleFTItemData(String itemType, List<Long> itemIdList, List<Long> calTableIdList, Map<String, Map<Long, Map<Long, Map<String, Object>>>> resultDataMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "in", calTableIdList);
        filter.and("hsas_calbcentry.fetchitem.id", "in", itemIdList);
        filter.and("hsas_calbcentry.ftprorationindex", "=", (Object)0);
        String fields = "id,hsas_calbcentry.fetchitem.id,hsas_calbcentry.bctextvalue,hsas_calbcentry.bcnumvalue,hsas_calbcentry.bcdatevalue,hsas_calbcentry.fetchitem.datatype.id";
        DynamicObjectCollection ftEntryList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        Map dataMap = resultDataMap.computeIfAbsent(itemType, value -> new HashMap(16));
        Map itemData = null;
        HashMap<String, Object> tempMap = null;
        for (DynamicObject entry : ftEntryList) {
            itemData = dataMap.computeIfAbsent(entry.getLong("id"), valueMap -> new HashMap(16));
            tempMap = new HashMap<String, Object>(16);
            tempMap.put("id", entry.getLong("id"));
            tempMap.put("itemid", entry.getLong("hsas_calbcentry.fetchitem.id"));
            tempMap.put("textvalue", entry.getString("hsas_calbcentry.bctextvalue"));
            tempMap.put("numvalue", entry.getBigDecimal("hsas_calbcentry.bcnumvalue"));
            tempMap.put("datevalue", entry.getDate("hsas_calbcentry.bcdatevalue"));
            tempMap.put("datatype", entry.getLong("hsas_calbcentry.fetchitem.datatype.id"));
            itemData.put(entry.getLong("hsas_calbcentry.fetchitem.id"), tempMap);
        }
    }

    private static void handleSLItemData(String itemType, List<Long> itemIdList, List<Long> calTableIdList, Map<String, Map<Long, Map<Long, Map<String, Object>>>> resultDataMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "in", calTableIdList);
        filter.and("hsas_caltableentry.salaryitem.id", "in", itemIdList);
        filter.and("hsas_caltableentry.slprorationindex", "=", (Object)0);
        String fields = "id,hsas_caltableentry.salaryitem.id,hsas_caltableentry.textvalue,hsas_caltableentry.numvalue,hsas_caltableentry.calamountvalue,hsas_caltableentry.datevalue,hsas_caltableentry.salaryitem.datatype.id";
        DynamicObjectCollection slEntryList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        Map dataMap = resultDataMap.computeIfAbsent(itemType, value -> new HashMap(16));
        Map itemData = null;
        HashMap<String, Object> tempMap = null;
        for (DynamicObject entry : slEntryList) {
            itemData = dataMap.computeIfAbsent(entry.getLong("id"), valueMap -> new HashMap(16));
            tempMap = new HashMap<String, Object>(16);
            tempMap.put("id", entry.getLong("id"));
            tempMap.put("itemid", entry.getLong("hsas_caltableentry.salaryitem.id"));
            tempMap.put("textvalue", entry.getString("hsas_caltableentry.textvalue"));
            tempMap.put("numvalue", entry.getBigDecimal("hsas_caltableentry.numvalue"));
            tempMap.put("amountvalue", entry.getString("hsas_caltableentry.calamountvalue"));
            tempMap.put("datevalue", entry.getDate("hsas_caltableentry.datevalue"));
            tempMap.put("datatype", entry.getLong("hsas_caltableentry.salaryitem.datatype.id"));
            itemData.put(entry.getLong("hsas_caltableentry.salaryitem.id"), tempMap);
        }
    }

    private static void assembleSourceItemCodeMap(Set<Long> numItemIdSet, List<CalResultMatchItemInfo> resultMatchItemInfo, Map<String, List<Long>> sourceItemCodeMap, Map<Long, String> fetchSourceItemMap, Map<Long, String> itemTypeMap) {
        for (CalResultMatchItemInfo info : resultMatchItemInfo) {
            Long itemId = Long.valueOf(info.getItemId());
            String itemType = info.getItemType();
            List itemIdList = sourceItemCodeMap.getOrDefault(itemType, new ArrayList(10));
            itemIdList.add(itemId);
            sourceItemCodeMap.put(itemType, itemIdList);
            fetchSourceItemMap.put(itemId, info.getMatchFetchItemCode());
            itemTypeMap.put(itemId, itemType);
            String dataType = info.getDataType();
            if (!SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_NUM.getCode(), (String)dataType)) continue;
            numItemIdSet.add(itemId);
        }
    }

    private static Map<String, Date> assembleDateFilterMap(Map<String, Date> dateFilterMap, FetchConfigFilterInfo filterInfo, Map<String, Object> calTaskMap, Map<String, Object> fetchedItemDataMap) {
        String dateMatchMethod = filterInfo.getDateMatchMethod();
        if (SWCStringUtils.equals((String)"2", (String)dateMatchMethod)) {
            String startItemUniqueCode = filterInfo.getStartFetchItemCode();
            String endItemUniqueCode = filterInfo.getEndFetchItemCode();
            Date startDate = (Date)fetchedItemDataMap.get(startItemUniqueCode);
            Date endDate = (Date)fetchedItemDataMap.get(endItemUniqueCode);
            dateFilterMap.put("startDate", startDate);
            dateFilterMap.put("endDate", endDate);
        }
        return dateFilterMap;
    }

    private static void assembleDateMap(Map<String, Date> dateFilterMap, int prePeriodCount, Map<String, Object> calTaskMap) throws ParseException {
        Map endMap;
        Long periodtype = (Long)calTaskMap.get("periodtype");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_calperiodtype");
        QFilter filter = new QFilter("id", "=", (Object)periodtype);
        DynamicObject object = helper.queryOne("id,entryentity,entrytity.startdate,entrytity.enddate", new QFilter[]{filter});
        Date tmpStartDate = SWCDateTimeUtils.parseDate((String)calTaskMap.get("startdate").toString(), (String)"yyyy-MM-dd");
        if (object == null) {
            return;
        }
        DynamicObjectCollection collection = object.getDynamicObjectCollection("entryentity");
        if (collection == null || collection.size() == 0) {
            return;
        }
        HashMap<Integer, Map<String, Date>> dateMap1 = new HashMap<Integer, Map<String, Date>>(16);
        HashMap<Date, Integer> dateMap2 = new HashMap<Date, Integer>(16);
        DataReaderCalHelper.assembleDateCollectionMap(collection, dateMap1, dateMap2);
        int index = (Integer)dateMap2.get(tmpStartDate);
        Map startMap = (Map)dateMap1.get(index + prePeriodCount);
        if (startMap == null || startMap.size() == 0) {
            startMap = (Map)dateMap1.get(dateMap1.size());
        }
        if ((endMap = (Map)dateMap1.get(index + 1)) == null || endMap.size() == 0) {
            endMap = (Map)dateMap1.get(dateMap1.size());
        }
        dateFilterMap.put("startDate", (Date)startMap.get("startdate"));
        dateFilterMap.put("endDate", (Date)endMap.get("enddate"));
    }

    private static void assembleDateCollectionMap(DynamicObjectCollection collection, Map<Integer, Map<String, Date>> dateMap1, Map<Date, Integer> dateMap2) throws ParseException {
        List ids = collection.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_calperiod");
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("id,startdate,enddate", new QFilter[]{filter}, "startdate desc");
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            Date startDate = ((DynamicObject)dynamicObjects.get(i)).getDate("startdate");
            Date endDate = ((DynamicObject)dynamicObjects.get(i)).getDate("enddate");
            dateMap2.put(SWCDateTimeUtils.formatDateToDate((Date)startDate, (String)"yyyy-MM-dd"), i + 1);
            HashMap<String, Date> singleMap = new HashMap<String, Date>(2);
            singleMap.put("startdate", startDate);
            singleMap.put("enddate", endDate);
            dateMap1.put(i + 1, singleMap);
        }
    }

    private static String assembleDateMatchKeyByType(String dateMatch) {
        String field = "";
        switch (dateMatch) {
            case "0": {
                field = "task.fstartdate";
                break;
            }
            case "1": {
                field = "task.fenddate";
                break;
            }
            case "2": {
                field = "taska.fpaydate";
                break;
            }
            case "3": {
                field = "task.fexratedate";
                break;
            }
        }
        return field;
    }

    private static BigDecimal getExrateData(Map<String, Object> calTaskMap, BigDecimal value, Long orgCurrencyId, Map<String, ExchangeRateInfo> exrateCacheMap) throws ParseException {
        Long calCurrencyId = MapUtils.getLong(calTaskMap, (Object)"calCurrencyId");
        Long exratetableId = MapUtils.getLong(calTaskMap, (Object)"exratetableId");
        Date exratedate = SWCDateTimeUtils.parseDate((String)((String)calTaskMap.get("exratedate")), (String)"yyyy-MM-dd");
        String key = calCurrencyId + "@" + orgCurrencyId;
        if (calCurrencyId == null || calCurrencyId.equals(orgCurrencyId)) {
            return value;
        }
        ExchangeRateInfo info = exrateCacheMap.get(key);
        if (null == info && null != (info = ExchangeRateHelper.getExchangeRateInfo((Long)orgCurrencyId, (Long)calCurrencyId, (Long)exratetableId, (Date)exratedate))) {
            exrateCacheMap.put(key, info);
        }
        if (null != info) {
            value = info.getQuoteType() != false ? value.divide(info.getExchangeRate(), 18, 1) : value.multiply(info.getExchangeRate());
        }
        return value;
    }

    public static void invokeDataFetch(Map<String, Object> fetchedDataMap, Set<String> fetchItemCodeSet, String uniqueCode, CalFetchConfigInfo fetchConfig, Map<String, Object> params, Map<String, Object> spItemMap, Long calPersonId, Long calTaskId, Map<String, Object> dataReaderDataMap, String dateRange, Map<String, Map<String, Object>> sectionParamMap, boolean isSection, String periodDateRange) throws ParseException {
        if (fetchConfig == null || !fetchConfig.getCalculationfetch().booleanValue()) {
            logger.info("fetchConfig is null or is not calculationFetch");
            return;
        }
        if (SWCStringUtils.equals((String)fetchConfig.getSelectType(), (String)"0")) {
            HashMap<Long, Map<String, Object>> periodProrationRowMap = new HashMap<Long, Map<String, Object>>(1);
            HashMap<Long, Map<String, Map<String, Object>>> itemProrationRowMap = new HashMap<Long, Map<String, Map<String, Object>>>(1);
            HashMap<Long, Map<String, Object>> allFetchItemDataMap = new HashMap<Long, Map<String, Object>>(1);
            ArrayList<Long> calPersonIdList = new ArrayList<Long>(1);
            calPersonIdList.add(calPersonId);
            allFetchItemDataMap.put(calPersonId, fetchedDataMap);
            HashMap<Long, Map<String, List<String>>> ftItemProrateRangeQueryMap = new HashMap<Long, Map<String, List<String>>>(1);
            String currentDateRange = dateRange;
            if (isSection) {
                HashMap<String, List<String>> ftProrateMap = new HashMap<String, List<String>>(1);
                ftProrateMap.put(uniqueCode, Collections.singletonList(dateRange));
                ftItemProrateRangeQueryMap.put(calPersonId, ftProrateMap);
                if (!fetchConfig.isProration()) {
                    currentDateRange = periodDateRange;
                }
            }
            logger.info("invokeDataFetch_fetchedDataMap:{}", (Object)fetchedDataMap.toString());
            DataReaderCalHelper dataReaderCalHelper = new DataReaderCalHelper();
            dataReaderCalHelper.selectFetchConfigData(fetchItemCodeSet, fetchConfig, calPersonIdList, calTaskId, allFetchItemDataMap, spItemMap, dataReaderDataMap, periodProrationRowMap, itemProrationRowMap, true, currentDateRange, ftItemProrateRangeQueryMap);
            if (isSection) {
                Map dateRangeMap = null;
                if (fetchConfig.isProration()) {
                    Map itemProrationMap = (Map)itemProrationRowMap.get(calPersonId);
                    if (itemProrationMap == null) {
                        return;
                    }
                    dateRangeMap = (Map)itemProrationMap.get(dateRange);
                } else {
                    dateRangeMap = (Map)allFetchItemDataMap.get(calPersonId);
                }
                if (dateRangeMap == null || dateRangeMap.get(uniqueCode) == null) {
                    return;
                }
                Map tempMap = sectionParamMap.getOrDefault(dateRange, new HashMap(16));
                tempMap.put(uniqueCode, dateRangeMap.get(uniqueCode));
                sectionParamMap.put(dateRange, tempMap);
            } else {
                Map readerDataMap = (Map)allFetchItemDataMap.get(calPersonId);
                if (readerDataMap == null || readerDataMap.size() == 0) {
                    return;
                }
                params.put(uniqueCode, readerDataMap.get(uniqueCode));
            }
        }
    }

    public void selectFetchConfigData(Set<String> fetchItemCodeSet, CalFetchConfigInfo fetchConfigInfo, List<Long> calPersonIdList, Long calTaskId, Map<Long, Map<String, Object>> allFetchItemDataMap, Map<String, Object> spItemMap, Map<String, Object> taskFetchItemDataMap, Map<Long, Map<String, Object>> itemResultParamMap, Map<Long, Map<String, Map<String, Object>>> itemSectionResultParamMap, boolean isCaling, String dateRange, Map<Long, Map<String, List<String>>> ftItemProrateRangeQueryMap) throws ParseException {
        String entity = fetchConfigInfo.getFetchSourceId();
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)entity);
        if (mainEntity instanceof QueryEntityType) {
            entity = ((QueryEntityType)mainEntity).getEntityName();
        }
        String dimensionality = fetchConfigInfo.getDimensionality();
        List filterEntryInfoList = fetchConfigInfo.getFilterInfo().getFilterEntryInfoList();
        logger.info("fetchConfigInfo:{}", (Object)JSONObject.toJSONString((Object)fetchConfigInfo));
        int totalFilter = calPersonIdList.size() * filterEntryInfoList.size();
        int batchCount = totalFilter % 300 == 0 ? totalFilter / 300 : totalFilter / 300 + 1;
        int batch = calPersonIdList.size() / batchCount;
        List batchPersonIdList = SWCListUtils.split(calPersonIdList, (int)batch);
        for (List personIdList : batchPersonIdList) {
            this.batchFetchData(fetchItemCodeSet, fetchConfigInfo, personIdList, calTaskId, allFetchItemDataMap, spItemMap, taskFetchItemDataMap, itemResultParamMap, itemSectionResultParamMap, isCaling, dateRange, ftItemProrateRangeQueryMap, entity, dimensionality);
        }
    }

    private void batchFetchData(Set<String> fetchItemCodeSet, CalFetchConfigInfo fetchConfigInfo, List<Long> calPersonIdList, Long calTaskId, Map<Long, Map<String, Object>> allFetchItemDataMap, Map<String, Object> spItemMap, Map<String, Object> taskFetchItemDataMap, Map<Long, Map<String, Object>> itemResultParamMap, Map<Long, Map<String, Map<String, Object>>> itemSectionResultParamMap, boolean isCaling, String dateRange, Map<Long, Map<String, List<String>>> ftItemProrateRangeQueryMap, String entity, String dimensionality) throws ParseException {
        ArrayList<String> selectFieldList = new ArrayList<String>(10);
        StringBuilder sortType = new StringBuilder();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        HashMap<Long, Map<String, Object>> personParamValueMap = new HashMap<Long, Map<String, Object>>(16);
        HashMap<String, String> filterFieldTypeMap = new HashMap<String, String>(16);
        this.generateFtQueryParam(filterFieldTypeMap, personParamValueMap, fetchConfigInfo, selectFieldList, sortType, filterList, spItemMap, taskFetchItemDataMap, calTaskId, allFetchItemDataMap, calPersonIdList);
        if (fetchConfigInfo.isProration()) {
            String[] dateRangeArray = dateRange.split("@");
            Date startDate = SWCDateTimeUtils.parseDate((String)dateRangeArray[0], (String)"yyyy-MM-dd");
            Date endDate = SWCDateTimeUtils.parseDate((String)dateRangeArray[1], (String)"yyyy-MM-dd");
            QFilter filter = new QFilter(fetchConfigInfo.getProrationStartField(), "<=", (Object)endDate);
            filter.and(fetchConfigInfo.getProrationEndField(), ">=", (Object)startDate);
            filterList.add(filter);
            if (!selectFieldList.contains(fetchConfigInfo.getProrationStartField())) {
                selectFieldList.add(fetchConfigInfo.getProrationStartField());
            }
            if (!selectFieldList.contains(fetchConfigInfo.getProrationEndField())) {
                selectFieldList.add(fetchConfigInfo.getProrationEndField());
            }
            if (sortType.length() > 0) {
                sortType.append(',');
            }
            sortType.append(fetchConfigInfo.getProrationStartField()).append(" desc");
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entity);
        QFilter[] qFilters = new QFilter[filterList.size()];
        filterList.toArray(qFilters);
        logger.info("\u5f00\u59cb\u67e5\u8be2:\u53d6\u6570\u914d\u7f6e:{},\u5b9e\u4f53:{}", (Object)fetchConfigInfo.getFetchNumber(), (Object)entity);
        StringBuilder filterStr = this.getFilterBuilder(qFilters);
        StringBuilder selectFieldsBuilder = this.getSelectFieldBuilder(selectFieldList);
        logger.info(MessageFormat.format("\u67e5\u8be2\u5b57\u6bb5\uff1a{0}\uff0c\u8fc7\u6ee4\u6761\u4ef6\uff1a{1}\uff0c\u6392\u5e8f\u65b9\u5f0f\uff1a{2}", selectFieldsBuilder.toString(), filterStr, sortType.toString()));
        DynamicObjectCollection rows = helper.queryOriginalCollection(selectFieldsBuilder.toString(), qFilters, sortType.toString());
        if (CollectionUtils.isEmpty((Collection)rows)) {
            logger.info("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return;
        }
        HashMap<String, List> rowsMap = new HashMap<String, List>(16);
        List<String> mainFilterFieldList = this.assembleMainPersonParamField(fetchConfigInfo, personParamValueMap);
        String mainFilterFields = StringUtils.join((Object[])mainFilterFieldList.toArray(), (char)'#');
        for (DynamicObject row : rows) {
            StringBuilder valueSb = new StringBuilder();
            for (String field : mainFilterFieldList) {
                String singleFieldType;
                if (valueSb.length() > 0) {
                    valueSb.append('#');
                }
                if (SWCStringUtils.isNotEmpty((String)(singleFieldType = (String)filterFieldTypeMap.get(field))) && SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_DATE.getCode(), (String)singleFieldType)) {
                    Date date = row.getDate(field);
                    if (date == null) continue;
                    valueSb.append(SWCDateTimeUtils.format((Date)date));
                    continue;
                }
                valueSb.append(row.getString(field));
            }
            List dataList = rowsMap.computeIfAbsent(valueSb.toString(), tempList -> new ArrayList(10));
            dataList.add(row);
        }
        for (Long calPersonId : calPersonIdList) {
            String mainFilterFieldValueStr;
            ArrayList<DynamicObject> matchRowList = new ArrayList<DynamicObject>(rows.size());
            Object mainField = ((Map)personParamValueMap.get(calPersonId)).get(mainFilterFields);
            String string = mainFilterFieldValueStr = mainField == null ? "" : mainField + "";
            Object rowList = SWCStringUtils.equals((String)"1", (String)dimensionality) ? (mainFilterFieldList.contains("id") ? (List)rowsMap.get(calTaskId + "") : (List)rowsMap.get(mainFilterFieldValueStr)) : (SWCStringUtils.isEmpty((String)mainFilterFieldValueStr) || isCaling ? rows : (List)rowsMap.get(mainFilterFieldValueStr));
            if (CollectionUtils.isEmpty((Collection)rowList)) continue;
            matchRowList.addAll((Collection<DynamicObject>)rowList);
            Map result = itemResultParamMap.getOrDefault(calPersonId, new HashMap(16));
            Map calingResult = allFetchItemDataMap.getOrDefault(calPersonId, new HashMap(16));
            this.matchPersonFetchItemValue(fetchConfigInfo, taskFetchItemDataMap, fetchItemCodeSet, matchRowList, result, calingResult);
            allFetchItemDataMap.put(calPersonId, calingResult);
            itemResultParamMap.put(calPersonId, result);
            if (!fetchConfigInfo.isProration()) continue;
            Map<String, List<String>> ftItemProrationMap = ftItemProrateRangeQueryMap.get(calPersonId);
            Map itemSectionResultMap = itemSectionResultParamMap.getOrDefault(calPersonId, new HashMap(16));
            this.matchItemSectionItemValue(fetchConfigInfo, fetchItemCodeSet, matchRowList, ftItemProrationMap, itemSectionResultMap);
            itemSectionResultParamMap.put(calPersonId, itemSectionResultMap);
        }
    }

    private void matchItemSectionItemValue(CalFetchConfigInfo fetchConfigInfo, Set<String> fetchItemCodeSet, List<DynamicObject> matchRowList, Map<String, List<String>> ftItemProrationMap, Map<String, Map<String, Object>> itemSectionResultMap) throws ParseException {
        if (ftItemProrationMap == null || ftItemProrationMap.size() == 0) {
            return;
        }
        List<String> dateRangeList = null;
        boolean sumFetch = fetchConfigInfo.isSumFetch();
        for (FetchFieldInfo field : fetchConfigInfo.getFieldInfoList()) {
            String fieldId = field.getField();
            String fetchItemCode = field.getFetchItemCode();
            String dataType = field.getDataType();
            String sumType = field.getSumType();
            if (!fetchItemCodeSet.contains(fetchItemCode) || SWCListUtils.isEmpty(dateRangeList = ftItemProrationMap.get(fetchItemCode))) continue;
            String[] dateRangeArr = null;
            Date startDate = null;
            Date endDate = null;
            Map tempItemMap = null;
            for (String dateRange : dateRangeList) {
                tempItemMap = itemSectionResultMap.getOrDefault(dateRange, new HashMap(16));
                dateRangeArr = dateRange.split("@");
                startDate = SWCDateTimeUtils.parseDate((String)dateRangeArr[0], (String)"yyyy-MM-dd");
                endDate = SWCDateTimeUtils.parseDate((String)dateRangeArr[1], (String)"yyyy-MM-dd");
                Object value = null;
                int count = 0;
                BigDecimal sum = BigDecimal.ZERO;
                for (DynamicObject matchRow : matchRowList) {
                    Date startField = matchRow.getDate(fetchConfigInfo.getProrationStartField());
                    Date endField = matchRow.getDate(fetchConfigInfo.getProrationEndField());
                    if (startField.after(endDate) || endField.before(startDate)) continue;
                    value = matchRow.get(fieldId);
                    if (value != null) {
                        if (value instanceof Long || value instanceof Integer) {
                            value = new BigDecimal(String.valueOf(value));
                        } else if (value instanceof Date && SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_TEXT.getCode(), (String)dataType)) {
                            value = SWCDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
                        }
                    }
                    if (!sumFetch) break;
                    if (value == null) continue;
                    if (SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_NUM.getCode(), (String)dataType) && SWCStringUtils.equals((String)"1", (String)sumType)) {
                        sum = sum.add(new BigDecimal(String.valueOf(value)));
                        continue;
                    }
                    ++count;
                }
                if (sumFetch) {
                    value = SWCStringUtils.equals((String)"1", (String)sumType) ? sum : Integer.valueOf(count);
                }
                if (value == null) continue;
                tempItemMap.put(fetchItemCode, value);
                itemSectionResultMap.put(dateRange, tempItemMap);
            }
        }
    }

    private List<String> assembleMainPersonParamField(CalFetchConfigInfo fetchConfigInfo, Map<Long, Map<String, Object>> personParamValueMap) {
        String valueType;
        List<String> mainFilterFieldList = new ArrayList<String>(10);
        List filterEntryInfoList = fetchConfigInfo.getFilterInfo().getFilterEntryInfoList();
        if (SWCListUtils.isEmpty((List)filterEntryInfoList)) {
            return mainFilterFieldList;
        }
        for (FilterEntryInfo filterEntryInfo : filterEntryInfoList) {
            valueType = filterEntryInfo.getValueType();
            String fieldType = filterEntryInfo.getFieldType();
            String fieldId = filterEntryInfo.getFieldId();
            boolean isPersonTaskParam = SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ID.getCode(), (String)fieldType) && (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)valueType) || SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_TASK.getCode(), (String)valueType));
            if (!isPersonTaskParam) continue;
            mainFilterFieldList.add(fieldId);
            return mainFilterFieldList;
        }
        if (!personParamValueMap.isEmpty()) {
            for (Map.Entry entry : personParamValueMap.entrySet()) {
                Map personValueMap = (Map)entry.getValue();
                if (personValueMap.isEmpty()) continue;
                mainFilterFieldList = personValueMap.keySet().stream().collect(Collectors.toList());
                StringBuilder keySb = new StringBuilder();
                StringBuilder valueSb = new StringBuilder();
                for (Map.Entry singleValue : personValueMap.entrySet()) {
                    if (keySb.length() > 0) {
                        keySb.append('#');
                        valueSb.append('#');
                    }
                    keySb.append((String)singleValue.getKey());
                    valueSb.append(singleValue.getValue());
                }
                personValueMap.put(keySb.toString(), valueSb.toString());
            }
        } else {
            for (FilterEntryInfo filterEntryInfo : filterEntryInfoList) {
                valueType = filterEntryInfo.getValueType();
                String fieldId = filterEntryInfo.getFieldId();
                boolean isSPParam = SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_SPITEM.getCode(), (String)valueType);
                if (!isSPParam) continue;
                mainFilterFieldList.add(fieldId);
            }
        }
        return mainFilterFieldList;
    }

    private void matchPersonFetchItemValue(CalFetchConfigInfo fetchConfigInfo, Map<String, Object> taskFetchItemDataMap, Set<String> fetchItemCodeSet, List<DynamicObject> matchRowList, Map<String, Object> result, Map<String, Object> calingResult) {
        String dimensionality = fetchConfigInfo.getDimensionality();
        boolean sumFetch = fetchConfigInfo.isSumFetch();
        Set<String> fieldItemCodeSet = fetchConfigInfo.getFieldInfoList().stream().map(single -> single.getFetchItemCode()).collect(Collectors.toSet());
        Map<String, Long> itemDataTypeMap = this.queryFetchItemDataType(fieldItemCodeSet);
        for (FetchFieldInfo field : fetchConfigInfo.getFieldInfoList()) {
            Object value;
            String fieldId = field.getField();
            String fetchItemCode = field.getFetchItemCode();
            String dataType = field.getDataType();
            Long itemDataType = itemDataTypeMap.get(fetchItemCode);
            String sumType = field.getSumType();
            int precision = field.getPrecision();
            RoundingMode dataRound = field.getDataRound();
            int count = 0;
            BigDecimal sum = BigDecimal.ZERO;
            if (sumFetch) {
                for (DynamicObject matchRow : matchRowList) {
                    value = matchRow.get(fieldId);
                    if (value == null) continue;
                    if (SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_NUM.getCode(), (String)dataType) && SWCStringUtils.equals((String)"1", (String)sumType)) {
                        sum = sum.add(new BigDecimal(String.valueOf(value)));
                        continue;
                    }
                    ++count;
                }
                value = SWCStringUtils.equals((String)"1", (String)sumType) ? sum.setScale(precision, dataRound) : Integer.valueOf(count);
            } else {
                value = matchRowList.get(0).get(fieldId);
                if (value == null) continue;
                if (value instanceof Long || value instanceof Integer || value instanceof BigDecimal) {
                    value = new BigDecimal(String.valueOf(value)).setScale(precision, dataRound);
                } else if (value instanceof Date && DataTypeEnum.STRING.getDbId() == itemDataType.longValue()) {
                    value = SWCDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
                }
            }
            if (value == null) continue;
            calingResult.put(fetchItemCode, value);
            if (fetchItemCodeSet.contains(fetchItemCode)) {
                result.put(fetchItemCode, value);
            }
            if (!SWCStringUtils.equals((String)"1", (String)dimensionality) || taskFetchItemDataMap.containsKey(fetchItemCode)) continue;
            taskFetchItemDataMap.put(fetchItemCode, value);
        }
    }

    private Map<String, Long> queryFetchItemDataType(Set<String> fetchItemCodeSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchitem");
        QFilter filter = new QFilter("uniquecode", "in", fetchItemCodeSet);
        DynamicObjectCollection itemObjs = helper.queryOriginalCollection("uniquecode,datatype.id", new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)itemObjs)) {
            return new HashMap<String, Long>(0);
        }
        return itemObjs.stream().collect(Collectors.toMap(v1 -> v1.getString("uniquecode"), v2 -> v2.getLong("datatype.id")));
    }

    @NotNull
    private StringBuilder getFilterBuilder(QFilter[] qFilters) {
        StringBuilder filterStr = new StringBuilder();
        for (QFilter filter : qFilters) {
            if (filterStr.length() > 0) {
                filterStr.append(',');
            }
            filterStr.append(filter);
        }
        return filterStr;
    }

    @NotNull
    private StringBuilder getSelectFieldBuilder(List<String> selectFieldList) {
        StringBuilder selectFieldsBuilder = new StringBuilder();
        for (String selectField : selectFieldList) {
            if (selectFieldsBuilder.length() > 0) {
                selectFieldsBuilder.append(',');
            }
            selectFieldsBuilder.append(selectField);
        }
        return selectFieldsBuilder;
    }

    private void generateFtQueryParam(Map<String, String> filterFieldTypeMap, Map<Long, Map<String, Object>> personParamValueMap, CalFetchConfigInfo fetchConfigInfo, List<String> selectFieldList, StringBuilder sortBuilder, List<QFilter> filterList, Map<String, Object> spItemMap, Map<String, Object> taskFetchItemDataMap, Long calTaskId, Map<Long, Map<String, Object>> allFetchItemDataMap, List<Long> calPersonIdList) {
        String dimensionality = fetchConfigInfo.getDimensionality();
        List fieldInfo = fetchConfigInfo.getFieldInfoList();
        List sortInfo = fetchConfigInfo.getSortedInfoList();
        FetchConfigFilterInfo filterInfo = fetchConfigInfo.getFilterInfo();
        String fetchSourceId = fetchConfigInfo.getFetchSourceId();
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)fetchSourceId);
        if (mainEntity instanceof QueryEntityType) {
            fetchSourceId = ((QueryEntityType)mainEntity).getEntityName();
        }
        List filterEntryInfoList = filterInfo.getFilterEntryInfoList();
        String conditionLogicType = filterInfo.getConditionLogicType();
        String conditionLogic = filterInfo.getConditionLogic();
        Map<Long, Map<String, Long>> personParamMap = this.assemblePersonParamMap(calPersonIdList);
        QFilter filter = null;
        if (filterEntryInfoList.size() == 1 && SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)((FilterEntryInfo)filterEntryInfoList.get(0)).getValueType())) {
            FilterEntryInfo entryInfo = (FilterEntryInfo)filterEntryInfoList.get(0);
            String fieldId = entryInfo.getFieldId();
            String value = entryInfo.getValue();
            ArrayList<Long> mainFilterValueList = new ArrayList<Long>(calPersonIdList.size());
            for (Long personId : calPersonIdList) {
                Map personValueMap = personParamValueMap.computeIfAbsent(personId, valueMap -> new HashMap(16));
                mainFilterValueList.add(this.getPersonParamData(fieldId, fetchSourceId, personValueMap, value, personParamMap.get(personId)));
            }
            filter = new QFilter(fieldId, "in", mainFilterValueList);
            if (!selectFieldList.contains(fieldId)) {
                selectFieldList.add(fieldId);
            }
        } else {
            Map<String, Map<Long, QFilter>> personKeyFilterMap = this.assembleConditionEntryFilterMap(filterFieldTypeMap, fetchSourceId, personParamValueMap, selectFieldList, calTaskId, calPersonIdList, filterEntryInfoList, conditionLogic, allFetchItemDataMap, spItemMap);
            if (SWCStringUtils.equals((String)"0", (String)dimensionality)) {
                Map<Long, QFilter> filterMap = this.initPersonFilterMap(conditionLogicType, personKeyFilterMap, filterEntryInfoList, calPersonIdList, conditionLogic);
                List<QFilter> personFilterList = filterMap.values().stream().collect(Collectors.toList());
                filter = this.getPersonFinalQFilter(filter, personFilterList);
            } else if (SWCStringUtils.equals((String)"1", (String)dimensionality)) {
                Map<String, QFilter> taskKeyFilterMap = this.assembleTaskKeyFilterMap(selectFieldList, calTaskId, filterEntryInfoList, conditionLogic, taskFetchItemDataMap);
                filter = this.initTaskFilterMap(conditionLogicType, taskKeyFilterMap, conditionLogic);
            }
        }
        filterList.add(filter);
        for (FetchFieldInfo field : fieldInfo) {
            if (selectFieldList.contains(field.getField())) continue;
            selectFieldList.add(field.getField());
        }
        this.assembleFetchSortInfo(selectFieldList, sortBuilder, sortInfo);
    }

    private Map<String, QFilter> assembleTaskKeyFilterMap(List<String> selectFieldList, Long calTaskId, List<FilterEntryInfo> filterEntryInfoList, String conditionLogic, Map<String, Object> taskFetchItemDataMap) {
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(16);
        Map entryInfoMap = filterEntryInfoList.stream().collect(Collectors.toMap(FilterEntryInfo::getConditionNumber, Function.identity()));
        List<String> splitStrList = Arrays.asList(ConditionLogicTypeEnum.AND.getWord(), ConditionLogicTypeEnum.OR.getWord(), "\\(", "\\)", " ");
        List<String> keyWordList = this.splitKeyWordList(splitStrList, conditionLogic);
        if (SWCListUtils.isEmpty(keyWordList)) {
            return filterMap;
        }
        for (String word : keyWordList) {
            FilterEntryInfo entryInfo = (FilterEntryInfo)entryInfoMap.get(word);
            if (entryInfo == null) continue;
            filterMap.put(word, this.assembleTaskFilterByEntryData(selectFieldList, calTaskId, taskFetchItemDataMap, entryInfo));
        }
        return filterMap;
    }

    private QFilter assembleTaskFilterByEntryData(List<String> selectFieldList, Long calTaskId, Map<String, Object> taskFetchItemDataMap, FilterEntryInfo entryInfo) {
        QFilter filter = null;
        String condition = entryInfo.getCondition();
        String valueType = entryInfo.getValueType();
        String fieldId = entryInfo.getFieldId();
        String value = entryInfo.getValue();
        String fieldType = entryInfo.getFieldType();
        if (SWCStringUtils.equals((String)RuleOperatorEnum.IS_NULL.getValue(), (String)condition) || SWCStringUtils.equals((String)RuleOperatorEnum.IS_NOT_NULL.getValue(), (String)condition)) {
            filter = this.assembleSingleFilter(condition, fieldId, null, fieldType);
        }
        if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_TASK.getCode(), (String)valueType)) {
            filter = this.assembleSingleFilter(condition, fieldId, calTaskId, fieldType);
        } else if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType)) {
            Object taskFtItemValue = this.assembleFixedValue(condition, taskFetchItemDataMap.get(value) + "", fieldType);
            filter = this.assembleSingleFilter(condition, fieldId, taskFtItemValue, fieldType);
        } else if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FIXED.getCode(), (String)valueType)) {
            Object fixedValue = this.assembleFixedValue(condition, value, fieldType);
            filter = this.assembleSingleFilter(condition, fieldId, fixedValue, fieldType);
        }
        if (!selectFieldList.contains(fieldId)) {
            selectFieldList.add(fieldId);
        }
        return filter;
    }

    private void assembleFetchSortInfo(List<String> selectFieldList, StringBuilder sortBuilder, List<FetchSortedInfo> sortInfo) {
        for (FetchSortedInfo sort : sortInfo) {
            String sortField = sort.getFieldId();
            if (sortField.endsWith(".id")) {
                sortField = sortField.substring(0, sortField.length() - 3);
            }
            if (!selectFieldList.contains(sortField)) {
                selectFieldList.add(sortField);
            }
            if (sortBuilder.length() > 0) {
                sortBuilder.append(',');
            }
            sortBuilder.append(sortField);
            sortBuilder.append(' ');
            String sortType = sort.getSortType();
            if (SWCStringUtils.equals((String)sortType, (String)"0")) {
                sortBuilder.append("asc");
                continue;
            }
            sortBuilder.append("desc");
        }
    }

    private QFilter getPersonFinalQFilter(QFilter filter, List<QFilter> personFilterList) {
        if (personFilterList.size() == 1) {
            filter = personFilterList.get(0);
        } else {
            for (int i = 0; i < personFilterList.size(); ++i) {
                filter = filter == null ? personFilterList.get(i) : filter.or(personFilterList.get(i));
            }
        }
        return filter;
    }

    private QFilter initTaskFilterMap(String conditionLogicType, Map<String, QFilter> keyFilterMap, String conditionLogic) {
        QFilter filter = null;
        List<String> conditionWordList = this.splitKeyWordList(Collections.singletonList(" "), conditionLogic);
        if (SWCStringUtils.equals((String)ConditionLogicTypeEnum.CUST.getCode(), (String)conditionLogicType)) {
            filter = this.executeExpression(conditionWordList, keyFilterMap, null, "1", 0L);
        } else {
            for (Map.Entry<String, QFilter> entry : keyFilterMap.entrySet()) {
                if (filter == null) {
                    filter = entry.getValue();
                    continue;
                }
                if (SWCStringUtils.equals((String)ConditionLogicTypeEnum.AND.getCode(), (String)conditionLogicType)) {
                    filter = filter.and(entry.getValue());
                    continue;
                }
                if (!SWCStringUtils.equals((String)ConditionLogicTypeEnum.OR.getCode(), (String)conditionLogicType)) continue;
                filter = filter.or(entry.getValue());
            }
        }
        return filter;
    }

    private QFilter executeExpression(List<String> conditionWordList, Map<String, QFilter> taskFilterMap, Map<String, Map<Long, QFilter>> personFilterMap, String dimensionality, Long personId) {
        Stack<String> optStack = new Stack<String>();
        Stack<QFilter> filterStack = new Stack<QFilter>();
        for (String key : conditionWordList) {
            QFilter filter = null;
            if (SWCStringUtils.equals((String)"1", (String)dimensionality)) {
                filter = taskFilterMap.get(key);
            } else {
                Map<Long, QFilter> filterMap = personFilterMap.get(key);
                if (filterMap != null) {
                    filter = filterMap.get(personId);
                }
            }
            if (SWCStringUtils.equals((String)"(", (String)key)) {
                optStack.push(key);
                continue;
            }
            if (SWCStringUtils.equals((String)")", (String)key)) {
                this.mergeFilter(optStack, filterStack, true);
                continue;
            }
            if (filter != null) {
                filterStack.push(filter);
                continue;
            }
            if (optStack.empty()) {
                optStack.push(key);
                continue;
            }
            this.compareAndMergeFilter(optStack, filterStack, key);
        }
        if (!optStack.isEmpty()) {
            this.mergeFilter(optStack, filterStack, false);
        }
        return (QFilter)filterStack.pop();
    }

    private void compareAndMergeFilter(Stack<String> optStack, Stack<QFilter> filterStack, String key) {
        String peekOpt = optStack.peek();
        int priority = this.getPriority(peekOpt, key);
        if (priority == -1 || priority == 0) {
            String opt = optStack.pop();
            QFilter filter2 = filterStack.pop();
            QFilter filter1 = filterStack.pop();
            QFilter filter = this.combileFilter(filter1, filter2, opt);
            if (filter != null) {
                filterStack.push(filter);
            }
            if (optStack.empty()) {
                optStack.push(key);
            } else {
                this.compareAndMergeFilter(optStack, filterStack, key);
            }
        } else {
            optStack.push(key);
        }
    }

    private int getPriority(String peekOpt, String key) {
        if (SWCStringUtils.equals((String)peekOpt, (String)key)) {
            return 0;
        }
        if (SWCStringUtils.equals((String)ConditionLogicTypeEnum.AND.getWord(), (String)key) && SWCStringUtils.equals((String)ConditionLogicTypeEnum.OR.getWord(), (String)peekOpt)) {
            return 1;
        }
        if (SWCStringUtils.equals((String)ConditionLogicTypeEnum.OR.getWord(), (String)key) && SWCStringUtils.equals((String)ConditionLogicTypeEnum.AND.getWord(), (String)peekOpt)) {
            return -1;
        }
        return 1;
    }

    private void mergeFilter(Stack<String> optStack, Stack<QFilter> filterStack, boolean isBracket) {
        QFilter filter;
        if (optStack.isEmpty() || filterStack.size() < 2) {
            return;
        }
        String key = optStack.pop();
        QFilter filter2 = filterStack.pop();
        QFilter filter1 = filterStack.pop();
        if (SWCStringUtils.equals((String)"(", (String)key) || SWCStringUtils.equals((String)")", (String)key)) {
            key = optStack.pop();
        }
        if ((filter = this.combileFilter(filter1, filter2, key)) != null) {
            filterStack.push(filter);
        }
        if (isBracket) {
            if (optStack.isEmpty()) {
                return;
            }
            if ("(".equals(optStack.peek())) {
                optStack.pop();
            } else {
                this.mergeFilter(optStack, filterStack, isBracket);
            }
        } else if (!optStack.empty()) {
            this.mergeFilter(optStack, filterStack, isBracket);
        }
    }

    private QFilter combileFilter(QFilter filter1, QFilter filter2, String key) {
        QFilter filter = filter1.copy();
        if (SWCStringUtils.equals((String)ConditionLogicTypeEnum.AND.getWord(), (String)key)) {
            return filter.and(filter2);
        }
        if (SWCStringUtils.equals((String)ConditionLogicTypeEnum.OR.getWord(), (String)key)) {
            return filter.or(filter2);
        }
        return null;
    }

    private Map<Long, QFilter> initPersonFilterMap(String conditionLogicType, Map<String, Map<Long, QFilter>> keyFilterMap, List<FilterEntryInfo> filterEntryInfoList, List<Long> calPersonIdList, String conditionLogic) {
        List<String> conditionWordList = this.splitKeyWordList(Collections.singletonList(" "), conditionLogic);
        HashMap<Long, QFilter> filterMap = new HashMap<Long, QFilter>(calPersonIdList.size());
        if (SWCStringUtils.equals((String)ConditionLogicTypeEnum.CUST.getCode(), (String)conditionLogicType)) {
            for (Long personId : calPersonIdList) {
                QFilter filter = this.executeExpression(conditionWordList, null, keyFilterMap, "0", personId);
                if (filter == null) continue;
                filterMap.put(personId, filter);
            }
        } else {
            for (Long personId : calPersonIdList) {
                QFilter filter = null;
                for (Map.Entry<String, Map<Long, QFilter>> entry : keyFilterMap.entrySet()) {
                    Map<Long, QFilter> personFilterMap = entry.getValue();
                    if (filter == null) {
                        filter = personFilterMap.get(personId);
                        continue;
                    }
                    if (SWCStringUtils.equals((String)ConditionLogicTypeEnum.AND.getCode(), (String)conditionLogicType)) {
                        filter = filter.and(personFilterMap.get(personId));
                        continue;
                    }
                    if (!SWCStringUtils.equals((String)ConditionLogicTypeEnum.OR.getCode(), (String)conditionLogicType)) continue;
                    filter = filter.or(personFilterMap.get(personId));
                }
                filterMap.put(personId, filter);
            }
        }
        return filterMap;
    }

    private Map<Long, Map<String, Long>> assemblePersonParamMap(List<Long> calPersonIdList) {
        HashMap<Long, Map<String, Long>> personParamMap = new HashMap<Long, Map<String, Long>>(calPersonIdList.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        String fields = "id,salaryfile.id,employee.id,salaryfile.person.id,empposorgrelhrv.depemp.id";
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)dynamicObjects)) {
            return personParamMap;
        }
        for (DynamicObject dyObj : dynamicObjects) {
            HashMap<String, Long> paramMap = new HashMap<String, Long>(4);
            paramMap.put("id", dyObj.getLong("id"));
            paramMap.put("salaryfile", dyObj.getLong("salaryfile.id"));
            paramMap.put("employee", dyObj.getLong("employee.id"));
            paramMap.put("person", dyObj.getLong("salaryfile.person.id"));
            paramMap.put("orgperson", dyObj.getLong("empposorgrelhrv.depemp.id"));
            personParamMap.put(dyObj.getLong("id"), paramMap);
        }
        return personParamMap;
    }

    private Map<String, Map<Long, QFilter>> assembleConditionEntryFilterMap(Map<String, String> filterFieldTypeMap, String fetchSourceId, Map<Long, Map<String, Object>> personParamValueMap, List<String> selectFieldList, Long calTaskId, List<Long> calPersonIdList, List<FilterEntryInfo> filterEntryInfoList, String conditionLogic, Map<Long, Map<String, Object>> allFetchItemDataMap, Map<String, Object> spItemMap) {
        HashMap<String, Map<Long, QFilter>> filterMap = new HashMap<String, Map<Long, QFilter>>(16);
        Map entryInfoMap = filterEntryInfoList.stream().collect(Collectors.toMap(FilterEntryInfo::getConditionNumber, Function.identity()));
        List<String> splitStrList = Arrays.asList(ConditionLogicTypeEnum.AND.getWord(), ConditionLogicTypeEnum.OR.getWord(), "\\(", "\\)", " ");
        List<String> keyWordList = this.splitKeyWordList(splitStrList, conditionLogic);
        if (SWCListUtils.isEmpty(keyWordList)) {
            return filterMap;
        }
        Map<Long, Map<String, Long>> personParamMap = this.assemblePersonParamMap(calPersonIdList);
        for (String word : keyWordList) {
            FilterEntryInfo entryInfo = (FilterEntryInfo)entryInfoMap.get(word);
            if (filterMap.containsKey(word) || entryInfo == null) continue;
            filterMap.put(word, this.assembleFilterByEntryData(filterFieldTypeMap, calPersonIdList, fetchSourceId, personParamValueMap, selectFieldList, calTaskId, spItemMap, allFetchItemDataMap, personParamMap, entryInfo));
        }
        return filterMap;
    }

    private Map<Long, QFilter> assembleFilterByEntryData(Map<String, String> filterFieldTypeMap, List<Long> calPersonIdList, String fetchSourceId, Map<Long, Map<String, Object>> personParamValueMap, List<String> selectFieldList, Long calTaskId, Map<String, Object> spItemMap, Map<Long, Map<String, Object>> allFetchItemDataMap, Map<Long, Map<String, Long>> personParamMap, FilterEntryInfo entryInfo) {
        HashMap<Long, QFilter> personFilterMap = new HashMap<Long, QFilter>(personParamMap.size());
        String condition = entryInfo.getCondition();
        String valueType = entryInfo.getValueType();
        String fieldId = entryInfo.getFieldId();
        String value = entryInfo.getValue();
        String fieldType = entryInfo.getFieldType();
        String spItemDefaultValue = entryInfo.getSpItemDefaultValue();
        List<String> mainFilterConditionList = Arrays.asList(RuleOperatorEnum.IS_NULL.getValue(), RuleOperatorEnum.EQUAL.getValue(), RuleOperatorEnum.IN.getValue());
        for (Long personId : calPersonIdList) {
            Map personValueMap = personParamValueMap.computeIfAbsent(personId, valueMap -> new HashMap(16));
            if (SWCStringUtils.equals((String)RuleOperatorEnum.IS_NULL.getValue(), (String)condition) || SWCStringUtils.equals((String)RuleOperatorEnum.IS_NOT_NULL.getValue(), (String)condition)) {
                personFilterMap.put(personId, this.assembleSingleFilter(condition, fieldId, null, fieldType));
                continue;
            }
            if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_PERSON.getCode(), (String)valueType)) {
                personFilterMap.put(personId, this.assembleSingleFilter(condition, fieldId, this.getPersonParamData(fieldId, fetchSourceId, personValueMap, value, personParamMap.get(personId)), fieldType));
            } else if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FTITEM.getCode(), (String)valueType)) {
                Object fetchItemValue = this.getFetchSpItemData(null, condition, value, allFetchItemDataMap.get(personId), fieldType);
                if (mainFilterConditionList.contains(condition)) {
                    if (fetchItemValue != null && SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_DATE.getCode(), (String)fieldType)) {
                        personValueMap.put(fieldId, SWCDateTimeUtils.format((Date)((Date)fetchItemValue)));
                    } else {
                        personValueMap.put(fieldId, fetchItemValue);
                    }
                    filterFieldTypeMap.put(fieldId, fieldType);
                }
                personFilterMap.put(personId, this.assembleSingleFilter(condition, fieldId, fetchItemValue, fieldType));
            } else if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_SPITEM.getCode(), (String)valueType)) {
                personFilterMap.put(personId, this.assembleSingleFilter(condition, fieldId, this.getFetchSpItemData(spItemDefaultValue, condition, value, spItemMap, fieldType), fieldType));
            } else if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_TASK.getCode(), (String)valueType)) {
                personValueMap.put("id", calTaskId);
                personFilterMap.put(personId, this.assembleSingleFilter(condition, fieldId, calTaskId, fieldType));
            } else if (SWCStringUtils.equals((String)ConditionValueTypeEnum.TYPE_FIXED.getCode(), (String)valueType)) {
                Object fixedValue = this.assembleFixedValue(condition, value, fieldType);
                personFilterMap.put(personId, this.assembleSingleFilter(condition, fieldId, fixedValue, fieldType));
            }
            if (selectFieldList.contains(fieldId)) continue;
            selectFieldList.add(fieldId);
        }
        return personFilterMap;
    }

    private Object assembleFixedValue(String condition, String value, String fieldType) {
        Object fixedValue;
        block13: {
            fixedValue = null;
            if (SWCStringUtils.isEmpty((String)value) || SWCStringUtils.equals((String)"null", (String)value)) {
                return fixedValue;
            }
            if (SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_DATE.getCode(), (String)fieldType)) {
                try {
                    if (value.length() == 10) {
                        fixedValue = SWCDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd");
                        break block13;
                    }
                    fixedValue = SWCDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (ParseException exception) {
                    logger.error((Throwable)exception);
                }
            } else if (SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_NUM.getCode(), (String)fieldType)) {
                fixedValue = new BigDecimal(value);
            } else if (SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ID.getCode(), (String)fieldType)) {
                if (SWCStringUtils.equals((String)RuleOperatorEnum.IN.getValue(), (String)condition) || SWCStringUtils.equals((String)RuleOperatorEnum.NOT_IN.getValue(), (String)condition)) {
                    String[] tempValues = value.split(";");
                    fixedValue = new ArrayList(tempValues.length);
                    for (int i = 0; i < tempValues.length; ++i) {
                        ((ArrayList)fixedValue).add(Long.parseLong(tempValues[i]));
                    }
                } else {
                    fixedValue = Long.parseLong(value);
                }
            } else {
                fixedValue = SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_TEXT.getCode(), (String)fieldType) || SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ENUM.getCode(), (String)fieldType) ? (SWCStringUtils.equals((String)RuleOperatorEnum.IN.getValue(), (String)condition) || SWCStringUtils.equals((String)RuleOperatorEnum.NOT_IN.getValue(), (String)condition) ? value.split(";") : value) : value;
            }
        }
        return fixedValue;
    }

    private Object getFetchSpItemData(String spItemDefaultValue, String condition, String value, Map<String, Object> fetchItemDataMap, String fieldType) {
        if (fetchItemDataMap != null) {
            Object itemValue = fetchItemDataMap.get(value);
            if (itemValue != null) {
                return this.assembleFixedValue(condition, itemValue + "", fieldType);
            }
            if (SWCStringUtils.isNotEmpty((String)spItemDefaultValue)) {
                return this.assembleFixedValue(condition, spItemDefaultValue, fieldType);
            }
        }
        return null;
    }

    private Long getPersonParamData(String fieldId, String fetchSourceId, Map<String, Object> personValueMap, String value, Map<String, Long> paramMap) {
        Long data = 0L;
        if (SWCStringUtils.equals((String)PersonParamsEnum.PARAM_CALPERSON.getCode(), (String)value)) {
            data = paramMap.get("id");
            personValueMap.put("id", data);
        } else {
            if (SWCStringUtils.equals((String)PersonParamsEnum.PARAM_SALARYFILE.getCode(), (String)value)) {
                data = paramMap.get("salaryfile");
            } else if (SWCStringUtils.equals((String)PersonParamsEnum.PARAM_ERPPEROSN.getCode(), (String)value)) {
                data = paramMap.get("employee");
            } else if (SWCStringUtils.equals((String)PersonParamsEnum.PARAM_PERSON.getCode(), (String)value)) {
                data = paramMap.get("person");
            } else if (SWCStringUtils.equals((String)PersonParamsEnum.PARAM_ORGPERSON.getCode(), (String)value)) {
                data = paramMap.get("orgperson");
            }
            this.setSinglePersonValue(fetchSourceId, personValueMap, data, fieldId);
        }
        return data;
    }

    private void setSinglePersonValue(String fetchSourceId, Map<String, Object> personValueMap, Long data, String field) {
        String str = field;
        if (field.endsWith(".id")) {
            str = field.substring(0, field.length() - 3);
        }
        if (fetchSourceId.contains(str)) {
            personValueMap.put("id", data);
        } else {
            personValueMap.put(field, data);
        }
    }

    private QFilter assembleSingleFilter(String condition, String fieldId, Object value, String fieldType) {
        List<String> normalOpList = Arrays.asList(RuleOperatorEnum.EQUAL.getValue(), RuleOperatorEnum.NOT_EQUAL.getValue(), RuleOperatorEnum.GREATER_THAN.getValue(), RuleOperatorEnum.GREATER_OR_EQUAL.getValue(), RuleOperatorEnum.LESS_THAN.getValue(), RuleOperatorEnum.LESS_OR_EQUAL.getValue(), RuleOperatorEnum.IN.getValue(), RuleOperatorEnum.NOT_IN.getValue(), RuleOperatorEnum.IS_NULL.getValue(), RuleOperatorEnum.IS_NOT_NULL.getValue());
        QFilter filter = null;
        if (normalOpList.contains(condition)) {
            filter = new QFilter(fieldId, conditionMatchMap.get(condition), value);
            if (SWCStringUtils.equals((String)condition, (String)RuleOperatorEnum.IS_NULL.getValue())) {
                if (SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ID.getCode(), (String)fieldType) || SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_NUM.getCode(), (String)fieldType)) {
                    filter.or(fieldId, "=", (Object)0);
                } else if (SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_TEXT.getCode(), (String)fieldType) || SWCStringUtils.equals((String)ConditionFieldTypeEnum.TYPE_ENUM.getCode(), (String)fieldType)) {
                    filter.or(fieldId, "=", (Object)" ");
                }
            }
        } else if (SWCStringUtils.equals((String)RuleOperatorEnum.CONTAINS.getValue(), (String)condition)) {
            filter = new QFilter(fieldId, "like", (Object)("%" + value + "%"));
        } else if (SWCStringUtils.equals((String)RuleOperatorEnum.NOT_CONTAINS.getValue(), (String)condition)) {
            filter = new QFilter(fieldId, "not like", (Object)("%" + value + "%"));
        } else if (SWCStringUtils.equals((String)RuleOperatorEnum.STARTS_WITH.getValue(), (String)condition)) {
            filter = new QFilter(fieldId, "like", (Object)(value + "%"));
        } else if (SWCStringUtils.equals((String)RuleOperatorEnum.ENDS_WITH.getValue(), (String)condition)) {
            filter = new QFilter(fieldId, "like", (Object)("%" + value));
        }
        return filter;
    }

    private List<String> splitKeyWordList(List<String> splitStrList, String conditionLogic) {
        String splitStr = splitStrList.stream().map(String::valueOf).collect(Collectors.joining("|"));
        List<String> keyWordList = Stream.of(conditionLogic.split(splitStr)).collect(Collectors.toList());
        keyWordList.removeIf(word -> SWCStringUtils.isEmpty((String)word));
        return keyWordList;
    }

    public void selectCustFetchConfigData(Set<String> fetchItemCodeSet, CalFetchConfigInfo fetchConfigInfo, List<Long> calPersonIdList, Long calTaskId, Map<Long, Map<String, Object>> allFetchItemDataMap, Map<String, Object> taskFetchItemDataMap, Map<Long, Map<String, Object>> periodProrationRowMap) {
        logger.info("selectCustFetchConfigData begin,config number is {}", (Object)fetchConfigInfo.getFetchNumber());
        String fetchPath = fetchConfigInfo.getFetchPath();
        List custFetchFilterEntryInfo = fetchConfigInfo.getFilterInfo().getFilterEntryInfoList();
        String dimensionality = fetchConfigInfo.getDimensionality();
        Class<?> clazz = null;
        ICustFetchService service = null;
        try {
            clazz = Class.forName(fetchPath);
            if (!ICustFetchService.class.isAssignableFrom(clazz)) {
                logger.error("{} not implements ICustFetchService\u3002", (Object)fetchPath);
                String msg = ResManager.loadKDString((String)"\u63d2\u4ef6\u53d6\u6570\u914d\u7f6e\u201c{0}\u201d\u8bf7\u6309\u4e8c\u5f00\u6587\u6863\u89c4\u8303\u8981\u6c42\u5b9e\u73b0\u7279\u5b9a\u63a5\u53e3\u3002", (String)"DataReaderCalHelper_3", (String)"swc-hscs-business", (Object[])new Object[]{fetchConfigInfo.getFetchNumber()});
                throw new KDBizException(msg);
            }
            service = (ICustFetchService)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error("instance cust fetch class error.", (Throwable)e);
            String msg = ResManager.loadKDString((String)"\u63d2\u4ef6\u53d6\u6570\u914d\u7f6e\u201c{0}\u201d\u7684\u63d2\u4ef6\u65e0\u6548\uff0c\u9700\u68c0\u67e5\u8c03\u8bd5\u540e\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"DataReaderCalHelper_2", (String)"swc-hscs-business", (Object[])new Object[]{fetchConfigInfo.getFetchNumber()});
            throw new KDBizException((Throwable)e, new ErrorCode("", msg), new Object[0]);
        }
        if (null == service) {
            return;
        }
        List fieldInfoList = fetchConfigInfo.getFieldInfoList();
        HashMap fetchItemMap = Maps.newHashMapWithExpectedSize((int)fieldInfoList.size());
        for (Object fetchFieldInfo : fieldInfoList) {
            fetchItemMap.put(fetchFieldInfo.getField(), fetchFieldInfo.getFetchItemCode());
        }
        HashMap<Long, HashMap<String, Object>> calPersonMap = new HashMap<Long, HashMap<String, Object>>(calPersonIdList.size());
        if (SWCStringUtils.equals((String)"0", (String)dimensionality)) {
            Map allCustFetchMap;
            if (!SWCListUtils.isEmpty((List)custFetchFilterEntryInfo)) {
                for (Long l : calPersonIdList) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
                    DataReaderCalHelper.dealCustFetchInParamData(custFetchFilterEntryInfo, hashMap, allFetchItemDataMap, taskFetchItemDataMap, l, dimensionality);
                    calPersonMap.put(l, hashMap);
                }
            }
            if ((allCustFetchMap = service.fetchDataCalPerson(calPersonIdList, calPersonMap)) == null) {
                return;
            }
            for (Map.Entry entry : allCustFetchMap.entrySet()) {
                long param = (Long)entry.getKey();
                Map tmpCustFetchMap = (Map)entry.getValue();
                HashMap custFetchMap = Maps.newHashMapWithExpectedSize((int)tmpCustFetchMap.size());
                HashMap custSaveFetchMap = Maps.newHashMapWithExpectedSize((int)tmpCustFetchMap.size());
                for (Map.Entry tempEntry : tmpCustFetchMap.entrySet()) {
                    String field = (String)tempEntry.getKey();
                    String fetchItemCode = (String)fetchItemMap.get(field);
                    if (fetchItemCode == null) continue;
                    if (fetchItemCodeSet.contains(fetchItemCode)) {
                        custSaveFetchMap.put(fetchItemCode, tempEntry.getValue());
                    }
                    custFetchMap.put(fetchItemCode, tempEntry.getValue());
                }
                DataReaderCalHelper.margeFetchItemDataMap(allFetchItemDataMap, periodProrationRowMap, custFetchMap, param, custSaveFetchMap);
            }
        }
        if (SWCStringUtils.equals((String)"1", (String)dimensionality)) {
            Map map;
            HashMap<String, Object> personMap = new HashMap<String, Object>(16);
            if (!SWCListUtils.isEmpty((List)custFetchFilterEntryInfo)) {
                DataReaderCalHelper.dealCustFetchInParamData(custFetchFilterEntryInfo, personMap, allFetchItemDataMap, taskFetchItemDataMap, 0L, dimensionality);
            }
            if ((map = service.fetchDataCalTask(calTaskId, personMap)) == null) {
                return;
            }
            HashMap hashMap = Maps.newHashMapWithExpectedSize((int)map.size());
            HashMap taskSaveMap = Maps.newHashMapWithExpectedSize((int)map.size());
            for (Map.Entry entry : map.entrySet()) {
                String fetchItemCode = (String)fetchItemMap.get(entry.getKey());
                if (fetchItemCode == null) continue;
                if (fetchItemCodeSet.contains(fetchItemCode)) {
                    taskSaveMap.put(fetchItemCode, entry.getValue());
                }
                hashMap.put(fetchItemCode, entry.getValue());
            }
            taskFetchItemDataMap.putAll(hashMap);
            for (Long calPersonId : calPersonIdList) {
                DataReaderCalHelper.margeFetchItemDataMap(allFetchItemDataMap, periodProrationRowMap, hashMap, calPersonId, taskSaveMap);
            }
        }
        logger.info("selectCustFetchConfigData end,config number is {}", (Object)fetchConfigInfo.getFetchNumber());
    }

    private static void margeFetchItemDataMap(Map<Long, Map<String, Object>> allFetchItemDataMap, Map<Long, Map<String, Object>> periodProrationRowMap, Map<String, Object> dataMap, Long calPersonId, Map<String, Object> custSaveFetchMap) {
        Map<String, Object> fetchItemDataMap = allFetchItemDataMap.get(calPersonId);
        if (fetchItemDataMap == null) {
            fetchItemDataMap = new HashMap<String, Object>(16);
            allFetchItemDataMap.put(calPersonId, fetchItemDataMap);
        }
        fetchItemDataMap.putAll(dataMap);
        Map<String, Object> saveItemDataMap = periodProrationRowMap.get(calPersonId);
        if (saveItemDataMap == null) {
            saveItemDataMap = new HashMap<String, Object>(16);
            periodProrationRowMap.put(calPersonId, saveItemDataMap);
        }
        saveItemDataMap.putAll(custSaveFetchMap);
    }

    private static void dealCustFetchInParamData(List<FilterEntryInfo> custFetchFilterEntryInfo, Map<String, Object> personMap, Map<Long, Map<String, Object>> allFetchItemDataMap, Map<String, Object> taskFetchItemDataMap, Long calPersonId, String dimensionality) {
        for (FilterEntryInfo filterEntryInfo : custFetchFilterEntryInfo) {
            Map<String, Object> calPersonMap;
            String fieldType = filterEntryInfo.getValueType();
            if (SWCStringUtils.equals((String)fieldType, (String)"1")) {
                personMap.put(filterEntryInfo.getFieldId(), DataReaderCalHelper.translateDataType(filterEntryInfo));
            }
            if (!SWCStringUtils.equals((String)fieldType, (String)"2")) continue;
            if (SWCStringUtils.equals((String)"0", (String)dimensionality) && null != (calPersonMap = allFetchItemDataMap.get(calPersonId))) {
                personMap.put(filterEntryInfo.getFieldId(), calPersonMap.get(filterEntryInfo.getValue()));
            }
            if (!SWCStringUtils.equals((String)"1", (String)dimensionality)) continue;
            personMap.put(filterEntryInfo.getFieldId(), taskFetchItemDataMap.get(filterEntryInfo.getValue()));
        }
    }

    private static Object translateDataType(FilterEntryInfo filterEntryInfo) {
        if (DataTypeEnum.getDataType((String)filterEntryInfo.getFieldType()) == DataTypeEnum.DATE) {
            try {
                return SWCDateTimeUtils.parseDate((String)filterEntryInfo.getValue(), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                logger.error("translateDataType", (Throwable)e);
            }
        } else {
            if (DataTypeEnum.getDataType((String)filterEntryInfo.getFieldType()) == DataTypeEnum.NUMBERIC) {
                return new BigDecimal(filterEntryInfo.getValue());
            }
            return filterEntryInfo.getValue();
        }
        return null;
    }

    public DynamicObject getAfterCalObjByTask(Long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskObj = helper.queryOne("payrollscenev.id", new QFilter[]{filter});
        if (taskObj == null) {
            return null;
        }
        Long sceneId = taskObj.getLong("payrollscenev.id");
        return this.getSceneSchemeAfterCalObj(sceneId);
    }

    public boolean getIsNoCountBizData(Long taskId) {
        DynamicObject afterCalObj = this.getAfterCalObjByTask(taskId);
        return afterCalObj.getBoolean("nocountbizdata");
    }

    public boolean getIsNoCountSinsurData(Long taskId) {
        DynamicObject afterCalObj = this.getAfterCalObjByTask(taskId);
        return afterCalObj.getBoolean("nocountsinsur");
    }

    public boolean getIsNoCountAttData(Long taskId) {
        DynamicObject afterCalObj = this.getAfterCalObjByTask(taskId);
        return afterCalObj.getBoolean("nocountatt");
    }

    public DynamicObject getSceneSchemeAfterCalObj(Long sceneId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        QFilter filter = new QFilter("id", "=", (Object)sceneId);
        DynamicObject sceneObj = helper.queryOne("schemeaftercal.id", new QFilter[]{filter});
        if (sceneObj == null) {
            return null;
        }
        long schemeAfterCalId = sceneObj.getLong("schemeaftercal.id");
        helper = new SWCDataServiceHelper("hsas_schemeaftercal");
        filter = new QFilter("id", "=", (Object)schemeAfterCalId);
        String fields = "number,calapprove,costallot,genbizdata,nocountbizdata,nocountsinsur,nocountatt";
        DynamicObjectCollection schemeAfterCalObjs = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (SWCListUtils.isEmpty((List)schemeAfterCalObjs)) {
            return null;
        }
        return (DynamicObject)schemeAfterCalObjs.get(0);
    }

    static {
        conditionMatchMap.put("0", "=");
        conditionMatchMap.put("1", ">");
        conditionMatchMap.put("2", ">=");
        conditionMatchMap.put("3", "<");
        conditionMatchMap.put("4", "<=");
        conditionMatchMap.put(RuleOperatorEnum.EQUAL.getValue(), "=");
        conditionMatchMap.put(RuleOperatorEnum.NOT_EQUAL.getValue(), "!=");
        conditionMatchMap.put(RuleOperatorEnum.GREATER_THAN.getValue(), ">");
        conditionMatchMap.put(RuleOperatorEnum.GREATER_OR_EQUAL.getValue(), ">=");
        conditionMatchMap.put(RuleOperatorEnum.LESS_THAN.getValue(), "<");
        conditionMatchMap.put(RuleOperatorEnum.LESS_OR_EQUAL.getValue(), "<=");
        conditionMatchMap.put(RuleOperatorEnum.IN.getValue(), "in");
        conditionMatchMap.put(RuleOperatorEnum.NOT_IN.getValue(), "not in");
        conditionMatchMap.put(RuleOperatorEnum.IS_NULL.getValue(), "is null");
        conditionMatchMap.put(RuleOperatorEnum.IS_NOT_NULL.getValue(), "is not null");
    }
}

