/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.generateclass;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.base.FormulaParse;
import kd.swc.hscs.business.cal.generateclass.MyClassLoader;
import kd.swc.hscs.common.vo.FormulaVO;
import org.jetbrains.annotations.NotNull;

public class FormulaAnalysis {
    private static final Log log = LogFactory.getLog(FormulaAnalysis.class);
    private static String className = "kd.swc.hscs.business.cal.base.FormulaParse";
    private static ClassPool pool = null;

    public static synchronized FormulaParse getFormulaExcuteInstance(List<FormulaVO> formulaInfoList, Map<String, String> fcMap) throws Exception {
        return FormulaAnalysis.makeClassAndInstance(formulaInfoList, fcMap, false);
    }

    public static synchronized FormulaParse makeConvertCalClassAndInstance(List<FormulaVO> formulaInfoList, Map<String, String> fcMap) throws Exception {
        return FormulaAnalysis.makeClassAndInstance(formulaInfoList, fcMap, true);
    }

    @NotNull
    private static FormulaParse makeClassAndInstance(List<FormulaVO> formulaInfoList, Map<String, String> fcMap, boolean isConvertCal) throws Exception {
        if (pool == null) {
            FormulaAnalysis.initPool();
        }
        if (pool == null) {
            throw new KDBizException(ResManager.loadKDString((String)"ClassPool\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"FormulaAnalysis_0", (String)"swc-hscs-business", (Object[])new Object[0]));
        }
        pool.insertClassPath((ClassPath)new ClassClassPath(FormulaParse.class));
        CtClass ctClass = null;
        ctClass = isConvertCal ? pool.makeClass("kd.swc.hscs.business.cal.base.ConvertFormulaCalImpl", pool.get(className)) : pool.makeClass(className + "Impl", pool.get(className));
        FormulaAnalysis.generateFuncMethods(fcMap, ctClass);
        StringBuffer executeFunBody = new StringBuffer();
        executeFunBody = FormulaAnalysis.generateFormulaMethods(formulaInfoList, ctClass, executeFunBody);
        String executeFunCode = String.format(Locale.ROOT, "\tpublic void calculate(){\n%s\n}", executeFunBody.toString());
        CtMethod newMehtod = CtNewMethod.make((String)executeFunCode, (CtClass)ctClass);
        ctClass.addMethod(newMehtod);
        MyClassLoader classLoader = new MyClassLoader(FormulaAnalysis.class.getClassLoader());
        Class clazz = null;
        try {
            FormulaParse formulaParseImpl;
            clazz = ctClass.toClass((ClassLoader)classLoader, classLoader.getClass().getProtectionDomain());
            FormulaParse formulaParse = formulaParseImpl = (FormulaParse)clazz.newInstance();
            return formulaParse;
        }
        catch (VerifyError e) {
            log.error((Throwable)e);
            throw new Exception(e);
        }
        finally {
            ctClass.detach();
            ctClass.defrost();
        }
    }

    private static StringBuffer generateFormulaMethods(List<FormulaVO> formulas, CtClass ctClass, StringBuffer executeFunBody) {
        StringBuffer formulaFunCode = null;
        int len = formulas.size();
        for (int index = 0; index < len; ++index) {
            FormulaVO formulaInfo = formulas.get(index);
            if (SWCStringUtils.isEmpty((String)formulaInfo.getExecuteCode())) continue;
            log.info("formula name is {},create formula method name is formula{}", (Object)formulaInfo.getName(), (Object)index);
            formulaFunCode = new StringBuffer();
            formulaFunCode.append(String.format(Locale.ROOT, "\tpublic void formula%s(){\n%s\n}\n", index, formulaInfo.getExecuteCode()));
            executeFunBody.append(String.format(Locale.ROOT, "\n\tformula%s();", index));
            try {
                CtMethod newMehtod = CtNewMethod.make((String)formulaFunCode.toString(), (CtClass)ctClass);
                ctClass.addMethod(newMehtod);
                continue;
            }
            catch (Exception ex) {
                log.error("generateFormulaMethods error.", (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("", MessageFormat.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u201c{0}\u201d\u751f\u6210\u5931\u8d25\uff1a{1}\u3002", (String)"FormulaAnalysis_2", (String)"swc-hscs-business", (Object[])new Object[0]), formulaInfo.getName(), ex.getMessage())), new Object[0]);
            }
        }
        return executeFunBody;
    }

    private static void generateFuncMethods(Map<String, String> fcMap, CtClass ctClass) {
        if (null == fcMap || fcMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, String> entry : fcMap.entrySet()) {
            try {
                CtMethod newMehtod = CtNewMethod.make((String)entry.getValue(), (CtClass)ctClass);
                ctClass.addMethod(newMehtod);
            }
            catch (Exception ex) {
                log.error("generateFuncMethods error.", (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("", MessageFormat.format(ResManager.loadKDString((String)"\u51fd\u6570\u201c{0}\u201d\u751f\u6210\u5931\u8d25\uff1a{1}\u3002", (String)"FormulaAnalysis_1", (String)"swc-hscs-business", (Object[])new Object[0]), entry.getKey(), ex.getMessage())), new Object[0]);
            }
        }
    }

    private static synchronized void initPool() {
        if (pool == null) {
            pool = new ClassPool((ClassPool)null);
            pool.appendSystemPath();
            pool.importPackage(FormulaParse.class.getPackage().getName());
            pool.importPackage("java.math.BigDecimal");
            pool.importPackage("java.text.SimpleDateFormat");
            pool.importPackage("java.util");
            pool.importPackage("java.lang");
            pool.importPackage("java.util.Date");
            pool.importPackage("java.util.List");
            pool.importPackage("java.util.Calendar");
            pool.importPackage("kd.swc.hscs.business.formula");
            pool.importPackage("kd.swc.hsbp.common.enums.FunctionErrorCodeEnum");
        }
    }

    public static synchronized void checkFuncMethod(String funcExp) throws Exception {
        if (pool == null) {
            FormulaAnalysis.initPool();
        }
        if (pool == null) {
            throw new KDBizException(ResManager.loadKDString((String)"ClassPool\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"FormulaAnalysis_0", (String)"swc-hscs-business", (Object[])new Object[0]));
        }
        pool.insertClassPath((ClassPath)new ClassClassPath(FormulaParse.class));
        CtClass ctClass = pool.makeClass("kd.swc.hscs.business.cal.base.FuncCheckImpl", pool.get(className));
        try {
            CtMethod newMehtod = CtNewMethod.make((String)funcExp, (CtClass)ctClass);
            ctClass.addMethod(newMehtod);
        }
        catch (Exception ex) {
            log.error("addMethod error.", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u5b9e\u4f8b\u5316\u3002", (String)"FormulaAnalysis_3", (String)"swc-hscs-business", (Object[])new Object[0])), new Object[0]);
        }
        MyClassLoader classLoader = new MyClassLoader(FormulaAnalysis.class.getClassLoader());
        Class clazz = null;
        try {
            clazz = ctClass.toClass((ClassLoader)classLoader, classLoader.getClass().getProtectionDomain());
            clazz.newInstance();
        }
        catch (VerifyError ex) {
            log.error("instance class error.", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u5b9e\u4f8b\u5316\u3002", (String)"FormulaAnalysis_3", (String)"swc-hscs-business", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            ctClass.detach();
            ctClass.defrost();
        }
    }

    public static synchronized FormulaParse getFuncExcuteInstance(String funcExp) throws Exception {
        FormulaAnalysis.initPool();
        if (pool == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"ClassPool\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u8054\u7cfb\u3002", (String)"FormulaAnalysis_0", (String)"swc-hscs-business", (Object[])new Object[0]));
        }
        pool.insertClassPath((ClassPath)new ClassClassPath(FormulaParse.class));
        CtClass ctClass = pool.makeClass("kd.swc.hscs.business.cal.base.FuncExcuteImpl", pool.get(className));
        CtMethod newMehtod = CtNewMethod.make((String)funcExp, (CtClass)ctClass);
        ctClass.addMethod(newMehtod);
        MyClassLoader classLoader = new MyClassLoader(FormulaAnalysis.class.getClassLoader());
        Class clazz = null;
        try {
            FormulaParse funcExcuteImpl;
            clazz = ctClass.toClass((ClassLoader)classLoader, classLoader.getClass().getProtectionDomain());
            FormulaParse formulaParse = funcExcuteImpl = (FormulaParse)clazz.newInstance();
            return formulaParse;
        }
        catch (VerifyError e) {
            log.error((Throwable)e);
            throw new Exception(ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u5b9e\u4f8b\u5316\u3002", (String)"FormulaAnalysis_3", (String)"swc-hscs-business", (Object[])new Object[0]), e);
        }
        finally {
            ctClass.detach();
            ctClass.defrost();
        }
    }

    public static synchronized byte[] getCalClassByteArray(List<FormulaVO> formulaInfoList, Map<String, String> fcMap) throws Exception {
        if (pool == null) {
            FormulaAnalysis.initPool();
        }
        pool.insertClassPath((ClassPath)new ClassClassPath(FormulaParse.class));
        CtClass ctClass = pool.makeClass("kd.swc.hscs.business.cal.base.FormulaParseImplDemo", pool.get(className));
        FormulaAnalysis.generateFuncMethods(fcMap, ctClass);
        StringBuffer executeFunBody = new StringBuffer();
        executeFunBody = FormulaAnalysis.generateFormulaMethods(formulaInfoList, ctClass, executeFunBody);
        String executeFunCode = String.format(Locale.ROOT, "\tpublic void calculate(){\n%s\n}", executeFunBody.toString());
        CtMethod newMehtod = CtNewMethod.make((String)executeFunCode, (CtClass)ctClass);
        ctClass.addMethod(newMehtod);
        byte[] calClass = ctClass.toBytecode();
        ctClass.detach();
        ctClass.defrost();
        return calClass;
    }
}

