/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.helper;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.salaryitem.filter.GetValidSalaryItemInSalaryFileService;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.base.FormulaParse;
import kd.swc.hscs.business.cal.utils.CalReportUtils;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.common.vo.BatchCalResultParamVO;
import kd.swc.hscs.common.vo.CalMessage;
import kd.swc.hscs.common.vo.CalParamCacheInfo;
import kd.swc.hscs.common.vo.CalParamVO;
import kd.swc.hscs.common.vo.CalRecordVO;
import kd.swc.hscs.common.vo.CalResultItem;
import kd.swc.hscs.common.vo.CalResultItemRel;
import kd.swc.hscs.common.vo.CalResultVO;
import kd.swc.hscs.common.vo.ProrationRuleVO;
import kd.swc.hscs.common.vo.SalaryItemVO;
import kd.swc.hscs.common.vo.acc.AccDetailsVO;
import org.apache.commons.collections.MapUtils;

public class SalaryCalServiceHelper {
    private static final Log logger = LogFactory.getLog(SalaryCalServiceHelper.class);
    private CalParamVO calParamVO;
    private Map<Long, Map<String, Object>> itemParamMap;
    private Map<Long, Map<String, Map<String, Object>>> itemSectionParamMap;
    private Map<Long, Map<String, List<String>>> itemSectionMap;
    private Map<Long, Map<String, Map<String, Object>>> slItemSectionResultMap;
    private Map<Long, Map<String, Object>> slItemResultMap;
    private Map<Long, Map<String, Object>> spItemCalResultMap;
    private Map<Long, Map<String, Object>> allDataReaderDataMap;
    private Map<Long, Map<String, Map<String, CalResultItem>>> calResultDataMap;
    private Map<Long, Map<String, AccDetailsVO>> allAccDetailsMap;
    private Map<Long, Map<String, List<String>>> calConvertSectionMap;
    private Map<Long, Map<String, Map<String, ProrationRuleVO>>> slItemConvertRelMap;
    private Map<Long, Map<String, Map<String, Integer>>> slItemProrationIndexMap;
    private Map<Long, Map<String, Long>> formulaConsumeTimeMap;
    private String traceId;

    public SalaryCalServiceHelper(CalParamVO calParamVO, String traceId) {
        this.calParamVO = calParamVO;
        this.traceId = traceId;
        this.formulaConsumeTimeMap = new HashMap<Long, Map<String, Long>>(16);
    }

    public void salaryItemCal(FormulaParse formulaCalImpl, Long calPersonId, HashMap<Long, HashSet<String>> calPersonSLItemRelMap, String calType, FormulaParse convertFormulaCalImpl, BatchCalResultParamVO batchResultVO) {
        CalRecordVO calRecord = new CalRecordVO();
        calRecord.setCalPersonId(String.valueOf(calPersonId));
        HashSet<String> validSLUniqueCodeSet = calPersonSLItemRelMap.get(calPersonId);
        if (validSLUniqueCodeSet == null || validSLUniqueCodeSet.isEmpty()) {
            String msg = this.getErrorMsg(calType);
            calRecord.setFailMsg(msg);
            calRecord.setCalStatus("2");
            calRecord.setFailType("4");
            calRecord.setErrorElement("-");
            batchResultVO.getCalRecordList().add(calRecord);
            return;
        }
        CalParamCacheInfo calParamCacheInfo = this.calParamVO.getCalParamMap();
        HashMap<String, Map<String, BigDecimal>> proportionMap = new HashMap<String, Map<String, BigDecimal>>(16);
        if (!this.calItemProrationValue(convertFormulaCalImpl, proportionMap, calPersonId, batchResultVO)) {
            return;
        }
        List spItemUniqueCodeList = calParamCacheInfo.getSpUniqueCodeList();
        Map spItemMap = calParamCacheInfo.getSpMap();
        Map spItemResultMap = calParamCacheInfo.getSpResultMap();
        HashMap<String, Object> spItemTempMap = null;
        if (null != spItemMap) {
            spItemTempMap = new HashMap<String, Object>(spItemMap);
            Map<String, Object> tempSpMap = this.spItemCalResultMap.get(calPersonId);
            if (tempSpMap != null) {
                spItemTempMap.putAll(tempSpMap);
            }
        }
        this.setFormulaCalImplProp(formulaCalImpl, calPersonId, spItemUniqueCodeList, spItemTempMap, validSLUniqueCodeSet, proportionMap);
        this.calculate(formulaCalImpl, calPersonId, batchResultVO, calRecord, spItemResultMap);
    }

    private boolean calItemProrationValue(FormulaParse convertFormulaCalImpl, Map<String, Map<String, BigDecimal>> proportionMap, Long calPersonId, BatchCalResultParamVO batchResultVO) {
        if (convertFormulaCalImpl == null || this.calConvertSectionMap.get(calPersonId) == null) {
            return true;
        }
        try {
            this.setConvertFormulaCalImplProp(convertFormulaCalImpl, calPersonId);
            convertFormulaCalImpl.calculate();
            Map<String, Map<String, Object>> itemSectionResultMap = convertFormulaCalImpl.getItemSectionResultMap();
            Map<String, Map<String, ProrationRuleVO>> itemConvertRuleMap = this.slItemConvertRelMap.get(calPersonId);
            if (itemConvertRuleMap == null || itemConvertRuleMap.size() == 0) {
                return true;
            }
            Map uniqueCodeMap = this.calParamVO.getUniqueCodeMap();
            ProrationRuleVO prorationRule = null;
            Map<String, Object> itemResultMap = null;
            Map dateRangeMap = null;
            for (Map.Entry<String, Map<String, ProrationRuleVO>> entry : itemConvertRuleMap.entrySet()) {
                for (Map.Entry<String, ProrationRuleVO> temp : entry.getValue().entrySet()) {
                    prorationRule = temp.getValue();
                    itemResultMap = itemSectionResultMap.get(prorationRule.getNumeratorId().toString());
                    if (null == itemResultMap) {
                        String noNumeratorMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u85aa\u916c\u9879\u76ee\u201c{0}\u201d\u7684\u5360\u6bd4\u65f6\uff0c\u5206\u5b50\u516c\u5f0f\u672a\u7b97\u51fa\u503c\u3002", (String)"SalaryCalServiceHelper_3", (String)"swc-hscs-business", (Object[])new Object[]{((SalaryItemVO)uniqueCodeMap.get(entry.getKey())).getName()});
                        throw new KDBizException(noNumeratorMsg);
                    }
                    BigDecimal numerator = (BigDecimal)itemResultMap.get(temp.getKey());
                    itemResultMap = itemSectionResultMap.get(prorationRule.getDenominatorId().toString());
                    if (null == itemResultMap) {
                        String noDenominatorMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u85aa\u916c\u9879\u76ee\u201c{0}\u201d\u7684\u5360\u6bd4\u65f6\uff0c\u5206\u6bcd\u516c\u5f0f\u672a\u8ba1\u7b97\u51fa\u503c\u3002", (String)"SalaryCalServiceHelper_4", (String)"swc-hscs-business", (Object[])new Object[]{((SalaryItemVO)uniqueCodeMap.get(entry.getKey())).getName()});
                        throw new KDBizException(noDenominatorMsg);
                    }
                    BigDecimal denominator = (BigDecimal)itemResultMap.get(temp.getKey());
                    if (BigDecimal.ZERO.compareTo(denominator) == 0) {
                        String noDenominatorMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u85aa\u916c\u9879\u76ee\u201c{0}\u201d\u7684\u5360\u6bd4\u65f6\uff0c\u5206\u6bcd\u516c\u5f0f\u8ba1\u7b97\u503c\u4e3a0\u3002", (String)"SalaryCalServiceHelper_5", (String)"swc-hscs-business", (Object[])new Object[]{((SalaryItemVO)uniqueCodeMap.get(entry.getKey())).getName()});
                        throw new KDBizException(noDenominatorMsg);
                    }
                    BigDecimal value = numerator.divide(denominator, ItemDataUtils.getScal((long)prorationRule.getDataPrecisionId()), ItemDataUtils.getRoundingMode((long)prorationRule.getDataRoundId()));
                    dateRangeMap = proportionMap.getOrDefault(entry.getKey(), new HashMap(16));
                    dateRangeMap.put(temp.getKey(), value);
                    proportionMap.put(entry.getKey(), dateRangeMap);
                }
            }
            return true;
        }
        catch (Exception ex) {
            logger.error("cal convert value error,calPersonId = {},calBatchId={},dateRange = {},uniqueCode={},errorMsg = {}", new Object[]{calPersonId, this.calParamVO.getCalBatchId(), convertFormulaCalImpl.getCurrentSectionKey(), convertFormulaCalImpl.getSalaryItemUniqueCode(), ex.getMessage()});
            CalUtils.printLog("itemSectionParamMap =>", this.itemSectionParamMap.get(calPersonId));
            logger.error((Throwable)ex);
            String msg = ex.getMessage();
            if (msg == null) {
                msg = ResManager.loadKDString((String)"\u8ba1\u7b97\u85aa\u916c\u9879\u76ee\u5206\u6bb5\u5360\u6bd4\u5931\u8d25\uff0c\u672a\u77e5\u5f02\u5e38\u3002", (String)"SalaryCalServiceHelper_0", (String)"swc-hscs-business", (Object[])new Object[0]);
            }
            CalRecordVO calRecord = new CalRecordVO();
            calRecord.setCalPersonId(String.valueOf(calPersonId));
            calRecord.setFailMsg(msg);
            calRecord.setCalStatus("2");
            calRecord.setFailType("3");
            calRecord.setErrorElement("-");
            batchResultVO.getCalRecordList().add(calRecord);
            return false;
        }
    }

    private void setConvertFormulaCalImplProp(FormulaParse convertFormulaCalImpl, Long calPersonId) {
        Map calTaskMap;
        convertFormulaCalImpl.setParams(this.itemParamMap.get(calPersonId));
        convertFormulaCalImpl.setSectionParamMap(this.itemSectionParamMap.get(calPersonId));
        convertFormulaCalImpl.setResultMap(new HashMap<String, Object>(16));
        convertFormulaCalImpl.setItemSectionResultMap(new HashMap<String, Map<String, Object>>(16));
        convertFormulaCalImpl.setProportionMap(new HashMap<String, Map<String, BigDecimal>>(16));
        convertFormulaCalImpl.setItemSectionMap(this.calConvertSectionMap.get(calPersonId));
        convertFormulaCalImpl.setDataReaderDataMap(this.allDataReaderDataMap.get(calPersonId));
        convertFormulaCalImpl.setCalPersonId(calPersonId);
        convertFormulaCalImpl.setCalTaskId(Long.valueOf(this.calParamVO.getCalTaskId()));
        convertFormulaCalImpl.setCalRecordId(Long.valueOf(this.calParamVO.getRecordId()));
        CalParamCacheInfo calParamInfo = this.calParamVO.getCalParamMap();
        Map dmCacheMap = calParamInfo.getDmMap();
        if (dmCacheMap != null && dmCacheMap.size() > 0) {
            convertFormulaCalImpl.setDmMap(dmCacheMap);
        }
        if ((calTaskMap = calParamInfo.getCalTaskMap()) != null && calTaskMap.size() > 0) {
            Long calCurrencyId = MapUtils.getLong((Map)calTaskMap, (Object)"calCurrencyId");
            Long exratetableId = MapUtils.getLong((Map)calTaskMap, (Object)"exratetableId");
            Date exratedate = null;
            try {
                exratedate = SWCDateTimeUtils.parseDate((String)((String)calTaskMap.get("exratedate")), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                logger.error("exratedate formate error!");
            }
            HashMap<String, Object> calTaskDataMap = new HashMap<String, Object>(16);
            calTaskDataMap.put("calCurrencyId", calCurrencyId);
            calTaskDataMap.put("exratetableId", exratetableId);
            calTaskDataMap.put("exratedate", exratedate);
            calTaskDataMap.put("startDate", calParamInfo.getStartDate());
            calTaskDataMap.put("endDate", calParamInfo.getEndDate());
            convertFormulaCalImpl.setCalTaskDataMap(calTaskDataMap);
        }
        convertFormulaCalImpl.setFetchItemConfigMap(calParamInfo.getFetchItemConfigMap());
        convertFormulaCalImpl.setFtItemCodeList(calParamInfo.getFetchItemCodeList());
        convertFormulaCalImpl.setSection(true);
        convertFormulaCalImpl.setCalProration(true);
        convertFormulaCalImpl.setMessageMap(new LinkedHashMap<String, List<String>>(16));
        convertFormulaCalImpl.setDefaultSectionList(Collections.singletonList(CalUtils.getDataRange(calParamInfo.getStartDate(), calParamInfo.getEndDate())));
        convertFormulaCalImpl.setSlAndBsItemRelMap(new HashMap<String, Map<String, Set<String>>>(16));
        convertFormulaCalImpl.setFormulaConsumeTiemMap(new HashMap<String, Long>(16));
    }

    private String getErrorMsg(String calType) {
        String msg = "preTaxCal".equals(calType) ? ResManager.loadKDString((String)"\u9002\u7528\u8d44\u683c\u7ec4\u4e0e\u8ba1\u7b97\u89c4\u5219\u4e2d\u7a0e\u524d/\u7a0e\u540e\u7684\u85aa\u916c\u9879\u76ee\u4ea4\u96c6\u4e3a\u7a7a\u3002", (String)"SalaryCalServiceHelper_2", (String)"swc-hscs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9002\u7528\u8d44\u683c\u7ec4\u4e0e\u8ba1\u7b97\u89c4\u5219\u4e2d\u7684\u85aa\u916c\u9879\u76ee\u4ea4\u96c6\u4e3a\u7a7a\u3002", (String)"SalaryCalServiceHelper_1", (String)"swc-hscs-business", (Object[])new Object[0]);
        return msg;
    }

    private void setFormulaCalImplProp(FormulaParse formulaCalImpl, Long calPersonId, List<String> spItemUniqueCodeList, Map<String, Object> spItemMap, HashSet<String> uniqueCodeSet, Map<String, Map<String, BigDecimal>> proportionMap) {
        Map calTaskMap;
        CalParamCacheInfo calParamInfo = this.calParamVO.getCalParamMap();
        formulaCalImpl.setParams(this.itemParamMap.get(calPersonId));
        formulaCalImpl.setSectionParamMap(this.itemSectionParamMap.get(calPersonId));
        formulaCalImpl.setResultMap(this.slItemResultMap.get(calPersonId));
        formulaCalImpl.setItemSectionResultMap(this.slItemSectionResultMap.get(calPersonId));
        formulaCalImpl.setProportionMap(proportionMap);
        formulaCalImpl.setItemSectionMap(this.itemSectionMap.get(calPersonId));
        formulaCalImpl.setUniqueCodeMap(this.calParamVO.getUniqueCodeMap());
        formulaCalImpl.setSpItemList(spItemUniqueCodeList);
        formulaCalImpl.setSpItemMap(spItemMap);
        formulaCalImpl.setSpItemInfoMap(calParamInfo.getSpItemInfoMap());
        formulaCalImpl.setValidUniqueCodeSet(uniqueCodeSet);
        formulaCalImpl.setDataReaderDataMap(this.allDataReaderDataMap.get(calPersonId));
        formulaCalImpl.setCalPersonId(calPersonId);
        formulaCalImpl.setCalTaskId(Long.valueOf(this.calParamVO.getCalTaskId()));
        formulaCalImpl.setCalRecordId(Long.valueOf(this.calParamVO.getRecordId()));
        formulaCalImpl.setAccDetailsMap(this.allAccDetailsMap.get(calPersonId));
        formulaCalImpl.setAccMemberMap(this.calParamVO.getAccMemberMap());
        formulaCalImpl.setUsedBsItemMap(null);
        formulaCalImpl.setSlItemRelMap(calParamInfo.getSlItemRelMap());
        Map dmCacheMap = calParamInfo.getDmMap();
        if (dmCacheMap != null && dmCacheMap.size() > 0) {
            formulaCalImpl.setDmMap(dmCacheMap);
        }
        if ((calTaskMap = calParamInfo.getCalTaskMap()) != null && calTaskMap.size() > 0) {
            Long calCurrencyId = MapUtils.getLong((Map)calTaskMap, (Object)"calCurrencyId");
            Long exratetableId = MapUtils.getLong((Map)calTaskMap, (Object)"exratetableId");
            Date exratedate = null;
            try {
                exratedate = SWCDateTimeUtils.parseDate((String)((String)calTaskMap.get("exratedate")), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                logger.error("setFormulaCalImplProp exratedate formate error!");
            }
            HashMap<String, Object> calTaskDataMap = new HashMap<String, Object>(16);
            calTaskDataMap.put("calCurrencyId", calCurrencyId);
            calTaskDataMap.put("exratetableId", exratetableId);
            calTaskDataMap.put("exratedate", exratedate);
            calTaskDataMap.put("startDate", calParamInfo.getStartDate());
            calTaskDataMap.put("endDate", calParamInfo.getEndDate());
            formulaCalImpl.setCalTaskDataMap(calTaskDataMap);
        }
        formulaCalImpl.setFetchItemConfigMap(calParamInfo.getFetchItemConfigMap());
        formulaCalImpl.setFtItemCodeList(calParamInfo.getFetchItemCodeList());
        if (this.itemSectionMap.containsKey(calPersonId)) {
            formulaCalImpl.setSection(true);
        } else {
            formulaCalImpl.setSection(false);
        }
        formulaCalImpl.setCalProration(false);
        formulaCalImpl.setMessageMap(new LinkedHashMap<String, List<String>>(16));
        formulaCalImpl.setDefaultSectionList(Collections.singletonList(CalUtils.getDataRange(calParamInfo.getStartDate(), calParamInfo.getEndDate())));
        formulaCalImpl.setSlAndBsItemRelMap(new HashMap<String, Map<String, Set<String>>>(16));
        formulaCalImpl.setFormulaConsumeTiemMap(new HashMap<String, Long>(16));
    }

    private Map<String, Map<String, Object>> copyItemSectionResultMap(Map<String, Map<String, Object>> itemSectionResultMap) {
        HashMap<String, Map<String, Object>> resultCoverMap = new HashMap<String, Map<String, Object>>(itemSectionResultMap.size());
        if (itemSectionResultMap.size() == 0) {
            return resultCoverMap;
        }
        Map tempMap = null;
        for (Map.Entry<String, Map<String, Object>> itemEntry : itemSectionResultMap.entrySet()) {
            tempMap = resultCoverMap.getOrDefault(itemEntry.getKey(), new HashMap(16));
            for (Map.Entry<String, Object> entry : itemEntry.getValue().entrySet()) {
                tempMap.put(entry.getKey(), entry.getValue());
            }
            resultCoverMap.put(itemEntry.getKey(), tempMap);
        }
        return resultCoverMap;
    }

    private void calculate(FormulaParse formulaCalImpl, Long calPersonId, BatchCalResultParamVO batchResultVO, CalRecordVO calRecord, Map<String, CalResultItem> spItemResultMap) {
        List needSaveSalaryItemList = this.calParamVO.getCalParamMap().getNeedSaveSalaryItemList();
        try {
            Map<String, Map<String, Object>> resultCoverMap = this.copyItemSectionResultMap(formulaCalImpl.getItemSectionResultMap());
            formulaCalImpl.calculate();
            CalResultVO calResult = null;
            SalaryItemVO tempSalaryItem = null;
            ArrayList<CalResultVO> calResultList = new ArrayList<CalResultVO>(10);
            Map uniqueCodeMap = this.calParamVO.getUniqueCodeMap();
            Map<String, Object> calResultMap = formulaCalImpl.getResultMap();
            for (Map.Entry<String, Object> entry : calResultMap.entrySet()) {
                tempSalaryItem = (SalaryItemVO)uniqueCodeMap.get(entry.getKey());
                if (null == tempSalaryItem || !needSaveSalaryItemList.contains(tempSalaryItem.getUniqueCode())) continue;
                calResult = new CalResultVO();
                calResult.setCalPersonId(calPersonId);
                calResult.setSalaryItemId(Long.valueOf(tempSalaryItem.getId()));
                calResult.setDataShowType(tempSalaryItem.getShowType());
                calResult.setStartDate(this.calParamVO.getCalParamMap().getStartDate());
                calResult.setEndDate(this.calParamVO.getCalParamMap().getEndDate());
                calResult.setProrationIndex(0);
                this.dealDataScal(tempSalaryItem, entry.getValue(), calResult);
                calResultList.add(calResult);
            }
            calResultList.addAll(this.getItemSectionResultList(formulaCalImpl, calPersonId, resultCoverMap));
            Map<String, Object> params = formulaCalImpl.getParams();
            Map<String, Object> spItemMap = formulaCalImpl.getSpItemMap();
            Map<String, Map<String, Object>> sectionParamMap = formulaCalImpl.getSectionParamMap();
            List<CalResultItem> calResultItemList = this.setCalValueToFormulaItemParam(calPersonId, params, spItemMap, spItemResultMap, sectionParamMap);
            calRecord.setCalStatus("1");
            List<CalMessage> calMessageList = this.getCalMessageList(formulaCalImpl.getMessageMap(), calPersonId);
            List<CalResultItemRel> calResultItemRelList = this.getCalResultItemRelList(formulaCalImpl.getSlAndBsItemRelMap(), calPersonId);
            batchResultVO.getCalRecordList().add(calRecord);
            batchResultVO.getCalResultItemList().addAll(calResultItemList);
            batchResultVO.getCalResultList().addAll(calResultList);
            batchResultVO.getCalMessageList().addAll(calMessageList);
            batchResultVO.getCalResultItemRelList().addAll(calResultItemRelList);
            batchResultVO.getAccDetailsList().addAll(this.cleanDataForAccDetails(formulaCalImpl.getAccDetailsMap()));
            this.formulaConsumeTimeMap.put(calPersonId, formulaCalImpl.getFormulaConsumeTiemMap());
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            logger.error("cal error,traceId = {},calPersonId = {},errorMsg = {}", new Object[]{this.traceId, calPersonId, ex.getMessage()});
            String msg = ex.getMessage();
            if (msg == null) {
                msg = ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\uff1a\u672a\u77e5\u5f02\u5e38\u3002", (String)"CalculationService_4", (String)"swc-hscs-business", (Object[])new Object[0]);
            }
            String errorElement = CalReportUtils.getErrorElement("3", formulaCalImpl);
            calRecord.setFailMsg(msg);
            calRecord.setCalStatus("2");
            calRecord.setFailType("3");
            calRecord.setErrorElement(errorElement);
            batchResultVO.getCalRecordList().add(calRecord);
        }
    }

    private List<CalResultItemRel> getCalResultItemRelList(Map<String, Map<String, Set<String>>> slAndBsItemRelMap, long calPersonId) {
        if (slAndBsItemRelMap == null || slAndBsItemRelMap.size() == 0) {
            return new ArrayList<CalResultItemRel>(0);
        }
        CalParamCacheInfo calParamInfo = this.calParamVO.getCalParamMap();
        if (!calParamInfo.isRecordAttBizData() && !calParamInfo.isRecordBizData()) {
            return new ArrayList<CalResultItemRel>(0);
        }
        Map bsDataMap = calParamInfo.getBsMap();
        Map bizItemInfoMap = (Map)bsDataMap.get("bizItemInfoMap");
        Map uniqueCodeMap = this.calParamVO.getUniqueCodeMap();
        Map<String, Map<String, Integer>> prorationIndexMap = this.slItemProrationIndexMap.get(calPersonId);
        Map<String, Integer> dateRangeMap = null;
        SalaryItemVO tempItem = null;
        CalResultItemRel rel = null;
        int prorationIndex = 0;
        Map tempBsMap = null;
        ArrayList<CalResultItemRel> calResultItemRelList = new ArrayList<CalResultItemRel>(10);
        for (Map.Entry<String, Map<String, Set<String>>> slItemEntry : slAndBsItemRelMap.entrySet()) {
            dateRangeMap = prorationIndexMap != null ? prorationIndexMap.get(slItemEntry.getKey()) : null;
            tempItem = (SalaryItemVO)uniqueCodeMap.get(slItemEntry.getKey());
            for (Map.Entry<String, Set<String>> dateRangeEntry : slItemEntry.getValue().entrySet()) {
                prorationIndex = dateRangeMap == null || !dateRangeMap.containsKey(dateRangeEntry.getKey()) ? 0 : dateRangeMap.get(dateRangeEntry.getKey());
                for (String bsCode : dateRangeEntry.getValue()) {
                    tempBsMap = (Map)bizItemInfoMap.get(bsCode);
                    if (!calParamInfo.isRecordBizData() && "0".equals(tempBsMap.get("classification")) || !calParamInfo.isRecordAttBizData() && "1".equals(tempBsMap.get("classification"))) continue;
                    Long bsItemId = Long.valueOf((String)tempBsMap.get("id"));
                    rel = new CalResultItemRel();
                    rel.setCalPersonId(Long.valueOf(calPersonId));
                    rel.setSalaryItemId(Long.valueOf(tempItem.getId()));
                    rel.setProrationIndex(prorationIndex);
                    rel.setBizItemId(bsItemId);
                    calResultItemRelList.add(rel);
                }
            }
        }
        return calResultItemRelList;
    }

    private List<CalMessage> getCalMessageList(Map<String, List<String>> messageMap, Long calPersonId) {
        ArrayList<CalMessage> calMessageList = new ArrayList<CalMessage>(10);
        if (messageMap == null || messageMap.size() == 0) {
            return calMessageList;
        }
        CalParamCacheInfo calParamCacheInfo = this.calParamVO.getCalParamMap();
        Map formulaItemRelMap = calParamCacheInfo.getFormulaItemRelMap();
        CalMessage messageObj = null;
        Long formulaId = null;
        for (Map.Entry<String, List<String>> entry : messageMap.entrySet()) {
            formulaId = (Long)formulaItemRelMap.get(entry.getKey());
            for (String msg : entry.getValue()) {
                messageObj = new CalMessage();
                messageObj.setCalPersonId(calPersonId);
                messageObj.setFormulaId(formulaId);
                messageObj.setMessage(msg);
                calMessageList.add(messageObj);
            }
        }
        return calMessageList;
    }

    private List<AccDetailsVO> cleanDataForAccDetails(Map<String, AccDetailsVO> accDetailsMap) {
        if (accDetailsMap == null || accDetailsMap.size() == 0) {
            return new ArrayList<AccDetailsVO>(0);
        }
        ArrayList<AccDetailsVO> accDetailsList = new ArrayList<AccDetailsVO>(accDetailsMap.size());
        AccDetailsVO temp = null;
        for (Map.Entry<String, AccDetailsVO> entry : accDetailsMap.entrySet()) {
            temp = entry.getValue();
            if (temp.isOnlyFormulaUse()) continue;
            temp.setAccInfo(null);
            accDetailsList.add(temp);
        }
        return accDetailsList;
    }

    private List<CalResultVO> getItemSectionResultList(FormulaParse formulaCalImpl, Long calPersonId, Map<String, Map<String, Object>> resultCoverMap) throws Exception {
        Map<String, Map<String, Object>> itemSectionResultMap = formulaCalImpl.getItemSectionResultMap();
        if (itemSectionResultMap == null || itemSectionResultMap.size() == 0) {
            return new ArrayList<CalResultVO>(0);
        }
        Map uniqueCodeMap = this.calParamVO.getUniqueCodeMap();
        List needSaveSalaryItemList = this.calParamVO.getCalParamMap().getNeedSaveSalaryItemList();
        Map<String, Map<String, BigDecimal>> proportionMap = formulaCalImpl.getProportionMap();
        Map<String, Map<String, Integer>> prorationIndexMap = this.slItemProrationIndexMap.get(calPersonId);
        ArrayList<CalResultVO> calResultList = new ArrayList<CalResultVO>(10);
        Map<String, Integer> tempDateRangeIndexMap = null;
        CalResultVO calResult = null;
        SalaryItemVO tempSalaryItem = null;
        Map<String, BigDecimal> itemRangeProrationMap = null;
        String[] dateRange = null;
        for (Map.Entry<String, Map<String, Object>> itemEntry : itemSectionResultMap.entrySet()) {
            tempSalaryItem = (SalaryItemVO)uniqueCodeMap.get(itemEntry.getKey());
            if (null == tempSalaryItem || !needSaveSalaryItemList.contains(tempSalaryItem.getUniqueCode())) continue;
            itemRangeProrationMap = proportionMap.get(itemEntry.getKey());
            tempDateRangeIndexMap = prorationIndexMap.get(itemEntry.getKey());
            Map tempMap = resultCoverMap.getOrDefault(itemEntry.getKey(), new HashMap(16));
            for (Map.Entry<String, Object> dateRangeEntry : itemEntry.getValue().entrySet()) {
                dateRange = dateRangeEntry.getKey().split("@");
                calResult = new CalResultVO();
                calResult.setCalPersonId(calPersonId);
                calResult.setSalaryItemId(Long.valueOf(tempSalaryItem.getId()));
                calResult.setDataShowType(tempSalaryItem.getShowType());
                calResult.setStartDate(SWCDateTimeUtils.parseDate((String)dateRange[0], (String)"yyyy-MM-dd"));
                calResult.setEndDate(SWCDateTimeUtils.parseDate((String)dateRange[1], (String)"yyyy-MM-dd"));
                if (tempDateRangeIndexMap != null && tempDateRangeIndexMap.get(dateRangeEntry.getKey()) != null) {
                    calResult.setProrationIndex(tempDateRangeIndexMap.get(dateRangeEntry.getKey()).intValue());
                } else {
                    logger.info("calpersonid={},sluniquecode = {},dateRange = {}, no index", new Object[]{calPersonId, itemEntry.getKey(), dateRangeEntry.getKey()});
                }
                if (tempMap.containsKey(dateRangeEntry.getKey())) {
                    calResult.setResultCover(true);
                } else {
                    calResult.setResultCover(false);
                }
                this.dealDataScal(tempSalaryItem, dateRangeEntry.getValue(), calResult);
                this.setProrationValue(dateRangeEntry.getKey(), calResult, itemRangeProrationMap);
                calResultList.add(calResult);
            }
        }
        return calResultList;
    }

    private void dealDataScal(SalaryItemVO item, Object value, CalResultVO calResult) throws KDBizException {
        if (value == null) {
            return;
        }
        if (SWCStringUtils.equals((String)"amount", (String)item.getShowType())) {
            BigDecimal calAmountValue = new BigDecimal(String.valueOf(value));
            calResult.setCalAmountValue(calAmountValue);
            calResult.setCalResultValue((Object)calAmountValue);
        } else if (SWCStringUtils.equals((String)"num", (String)item.getShowType())) {
            BigDecimal oriAmountValue = new BigDecimal(String.valueOf(value));
            calResult.setCalResultValue((Object)oriAmountValue);
        } else if (SWCStringUtils.equals((String)"text", (String)item.getShowType())) {
            if (String.valueOf(value).length() > item.getDataLength()) {
                String msg = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u201c{0}\u201d\u7684\u8ba1\u7b97\u7ed3\u679c\u6570\u636e\u957f\u5ea6\u8fc7\u957f\uff0c\u5df2\u8d85\u51fa\u8bbe\u5b9a\u7684\u6570\u636e\u957f\u5ea6\u201c{1}\u201d\u3002", (String)"CalculationService_2", (String)"swc-hscs-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(msg, item.getName(), item.getDataLength()));
            }
            calResult.setCalResultValue(value);
        } else if (SWCStringUtils.equals((String)"date", (String)item.getShowType())) {
            long itemValue = ((Date)value).getTime();
            calResult.setCalResultValue((Object)itemValue);
        } else {
            calResult.setCalResultValue(value);
        }
    }

    private void setProrationValue(String dateRange, CalResultVO calResult, Map<String, BigDecimal> itemProrationMap) {
        if (null == itemProrationMap || itemProrationMap.size() == 0) {
            calResult.setProration(BigDecimal.ZERO);
        } else {
            BigDecimal tempProrationValue = itemProrationMap.get(dateRange);
            if (null == tempProrationValue) {
                calResult.setProration(BigDecimal.ZERO);
            } else {
                calResult.setProration(tempProrationValue);
            }
        }
    }

    private List<CalResultItem> setCalValueToFormulaItemParam(Long calPersonId, Map<String, Object> paramMap, Map<String, Object> spItemMap, Map<String, CalResultItem> spItemResultMap, Map<String, Map<String, Object>> sectionParamMap) throws ParseException {
        Map fetchItemDataTypeMap = this.calParamVO.getCalParamMap().getFetchItemDataTypeMap();
        Map fetchItemCodeIdMap = this.calParamVO.getCalParamMap().getFetchItemCodeIdMap();
        Map dateFormulaItemParamMap = this.calResultDataMap.getOrDefault(calPersonId, new HashMap(16));
        CalParamCacheInfo calParamMap = this.calParamVO.getCalParamMap();
        String calTaskDateRange = CalUtils.getDataRange(calParamMap.getStartDate(), calParamMap.getEndDate());
        ArrayList<CalResultItem> calTableCalItemList = new ArrayList<CalResultItem>(10);
        for (Map.Entry<String, Map<String, CalResultItem>> entry : dateFormulaItemParamMap.entrySet()) {
            if (calTaskDateRange.equals(entry.getKey())) {
                this.setCalItemProp(calPersonId, paramMap, calTableCalItemList, entry, "0");
                continue;
            }
            Map tempMap = sectionParamMap.getOrDefault(entry.getKey(), new HashMap(16));
            this.setCalItemProp(calPersonId, tempMap, calTableCalItemList, entry, "1");
            if (tempMap.size() != 0) continue;
            sectionParamMap.remove(entry.getKey());
        }
        if (paramMap.size() > 0) {
            this.buildFtCalItemResult(calPersonId, paramMap, fetchItemDataTypeMap, fetchItemCodeIdMap, calParamMap.getStartDate(), calParamMap.getEndDate(), "0", calTableCalItemList);
        }
        if (sectionParamMap.size() > 0) {
            String[] dateArr = null;
            Object var13_14 = null;
            Date prorationEnd = null;
            for (Map.Entry<String, Map<String, Object>> entry : sectionParamMap.entrySet()) {
                dateArr = entry.getKey().split("@");
                Date date = SWCDateTimeUtils.parseDate((String)dateArr[0], (String)"yyyy-MM-dd");
                prorationEnd = SWCDateTimeUtils.parseDate((String)dateArr[1], (String)"yyyy-MM-dd");
                this.buildFtCalItemResult(calPersonId, entry.getValue(), fetchItemDataTypeMap, fetchItemCodeIdMap, date, prorationEnd, "1", calTableCalItemList);
            }
        }
        if (spItemMap != null) {
            for (Map.Entry<Object, Object> entry : spItemMap.entrySet()) {
                String itemKey = (String)entry.getKey();
                Object value = entry.getValue();
                CalResultItem itemParam = spItemResultMap.get(itemKey);
                if (itemParam == null) continue;
                CalResultItem itemParamClone = (CalResultItem)itemParam.clone();
                itemParamClone.setCalPersonId(calPersonId);
                itemParamClone.setItemResult(value);
                itemParamClone.setProrationIndex(0);
                calTableCalItemList.add(itemParamClone);
            }
        }
        return calTableCalItemList;
    }

    private void buildFtCalItemResult(Long calPersonId, Map<String, Object> paramMap, Map<String, String> fetchItemDataTypeMap, Map<String, Long> fetchItemCodeIdMap, Date startDate, Date endDate, String prorateType, List<CalResultItem> calTableCalItemList) {
        if (paramMap == null || paramMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            if (entry.getKey().startsWith("BS_")) continue;
            calTableCalItemList.add(this.assembleFtCalResultItem(calPersonId, entry, fetchItemDataTypeMap, fetchItemCodeIdMap, startDate, endDate, prorateType));
        }
    }

    private void setCalItemProp(Long calPersonId, Map<String, Object> paramMap, List<CalResultItem> calTableCalItemList, Map.Entry<String, Map<String, CalResultItem>> dateEntry, String prorateType) {
        for (Map.Entry<String, CalResultItem> entry : dateEntry.getValue().entrySet()) {
            String itemKey = entry.getKey();
            CalResultItem itemParam = entry.getValue();
            itemParam.setItemResult(paramMap.remove(itemKey));
            itemParam.setCalPersonId(calPersonId);
            itemParam.setProrateType(prorateType);
            calTableCalItemList.add(itemParam);
        }
    }

    private CalResultItem assembleFtCalResultItem(Long calPersonId, Map.Entry<String, Object> entry, Map<String, String> fetchFieldInfoMap, Map<String, Long> fetchItemCodeIdMap, Date startDate, Date endDate, String prorateType) {
        CalResultItem calResultItem = new CalResultItem(CalResultItemEnum.SYSITEM);
        calResultItem.setCalPersonId(calPersonId);
        calResultItem.setItemId(fetchItemCodeIdMap.get(entry.getKey()));
        calResultItem.setDataShowType(fetchFieldInfoMap.get(entry.getKey()));
        calResultItem.setItemResult(entry.getValue());
        calResultItem.setProrateType(prorateType);
        calResultItem.setStartDate(startDate);
        calResultItem.setEndDate(endDate);
        return calResultItem;
    }

    public void setSlItemSectionResultMap(Map<Long, Map<String, Map<String, Object>>> slItemSectionResultMap) {
        if (slItemSectionResultMap == null) {
            slItemSectionResultMap = new HashMap<Long, Map<String, Map<String, Object>>>(16);
        }
        this.slItemSectionResultMap = slItemSectionResultMap;
    }

    public void setSlItemResultMap(Map<Long, Map<String, Object>> slItemResultMap) {
        if (slItemResultMap == null) {
            slItemResultMap = new HashMap<Long, Map<String, Object>>(16);
        }
        this.slItemResultMap = slItemResultMap;
    }

    public void setAllAccDetailsMap(Map<Long, Map<String, AccDetailsVO>> allAccDetailsMap) {
        this.allAccDetailsMap = null == allAccDetailsMap ? new HashMap<Long, Map<String, AccDetailsVO>>(16) : allAccDetailsMap;
    }

    public void setItemParamMap(Map<Long, Map<String, Object>> itemParamMap) {
        if (itemParamMap == null) {
            itemParamMap = new HashMap<Long, Map<String, Object>>(16);
        }
        this.itemParamMap = itemParamMap;
    }

    public static Map<Long, HashSet<Long>> getFileSalaryItemMap(CalParamCacheInfo calParamInfo, List<Long> salaryFileIdList) throws ParseException {
        Date startDate = SWCDateTimeUtils.formatDateToDate((Date)calParamInfo.getStartDate(), (String)"yyyy-MM-dd");
        Date endDate = SWCDateTimeUtils.formatDateToDate((Date)calParamInfo.getEndDate(), (String)"yyyy-MM-dd");
        List calRuleItemIdList = calParamInfo.getCalRuleItemIdList();
        GetValidSalaryItemInSalaryFileService validSalaryItemInSalaryFileService = GetValidSalaryItemInSalaryFileService.createInstance();
        return validSalaryItemInSalaryFileService.getValidSalaryItemMap(salaryFileIdList, startDate, endDate, (HashSet)CalUtils.listStringToSetLong(calRuleItemIdList));
    }

    public void setItemSectionParamMap(Map<Long, Map<String, Map<String, Object>>> itemSectionParamMap) {
        if (itemSectionParamMap == null) {
            itemSectionParamMap = new HashMap<Long, Map<String, Map<String, Object>>>(16);
        }
        this.itemSectionParamMap = itemSectionParamMap;
    }

    public void setItemSectionMap(Map<Long, Map<String, List<String>>> itemSectionMap) {
        this.itemSectionMap = itemSectionMap;
    }

    public void setAllDataReaderDataMap(Map<Long, Map<String, Object>> allDataReaderDataMap) {
        this.allDataReaderDataMap = allDataReaderDataMap;
    }

    public void setCalResultDataMap(Map<Long, Map<String, Map<String, CalResultItem>>> calResultDataMap) {
        this.calResultDataMap = calResultDataMap;
    }

    public void setCalConvertSectionMap(Map<Long, Map<String, List<String>>> calConvertSectionMap) {
        this.calConvertSectionMap = calConvertSectionMap;
    }

    public void setSlItemConvertRelMap(Map<Long, Map<String, Map<String, ProrationRuleVO>>> slItemConvertRelMap) {
        this.slItemConvertRelMap = slItemConvertRelMap;
    }

    public void setSlItemProrationIndexMap(Map<Long, Map<String, Map<String, Integer>>> slItemProrationIndexMap) {
        this.slItemProrationIndexMap = slItemProrationIndexMap;
    }

    public Map<Long, Map<String, Object>> getSpItemCalResultMap() {
        return this.spItemCalResultMap;
    }

    public void setSpItemCalResultMap(Map<Long, Map<String, Object>> spItemCalResultMap) {
        if (spItemCalResultMap == null) {
            spItemCalResultMap = new HashMap<Long, Map<String, Object>>(16);
        }
        this.spItemCalResultMap = spItemCalResultMap;
    }

    public Map<Long, Map<String, Long>> getFormulaConsumeTimeMap() {
        return this.formulaConsumeTimeMap;
    }

    public void setFormulaConsumeTimeMap(Map<Long, Map<String, Long>> formulaConsumeTimeMap) {
        this.formulaConsumeTimeMap = formulaConsumeTimeMap;
    }
}

