/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.insurance;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hscs.business.extpoint.IQueryInsuranceDataExtService;
import kd.sdk.swc.hscs.common.events.QueryInsuranceDataEvent;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.exchangerate.helper.ExchangeRateHelper;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.proration.HandleProrationHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.common.vo.InsuranceItemMapping;
import kd.swc.hscs.common.vo.SalaryItemVO;

public class InsuranceHelper {
    private static final Log logger = LogFactory.getLog(InsuranceHelper.class);

    public static BigDecimal getInsuranceItemValue(DynamicObject dynamicObject, String storagetype) {
        BigDecimal numvalue = SWCStringUtils.equals((String)"number", (String)storagetype) ? dynamicObject.getBigDecimal("entryentity.numvalue") : dynamicObject.getBigDecimal("entryentity.amountvalue");
        return numvalue;
    }

    public static BigDecimal getSumValue(List<DynamicObject> dynamicObjects, DynamicObject task, Map<String, ExchangeRateInfo> exrateCacheMap) {
        BigDecimal value = new BigDecimal("0");
        for (DynamicObject dynamicObject : dynamicObjects) {
            String storagetype = dynamicObject.getString("entryentity.storagetype");
            BigDecimal numvalue = InsuranceHelper.getInsuranceItemValue(dynamicObject, storagetype);
            if ((numvalue = InsuranceHelper.tranCurrencyValue(task, exrateCacheMap, dynamicObject, storagetype, numvalue)) == null) continue;
            value = value.add(numvalue);
        }
        return value;
    }

    private static BigDecimal tranCurrencyValue(DynamicObject task, Map<String, ExchangeRateInfo> exrateCacheMap, DynamicObject dynamicObject, String storagetype, BigDecimal numvalue) {
        long tarCurrency;
        long oriCurrency;
        if (SWCStringUtils.equals((String)storagetype, (String)"amount") && (oriCurrency = dynamicObject.getLong("entryentity.currency.id")) != (tarCurrency = task.getLong("payrollgroupv.currency.id"))) {
            String key = tarCurrency + "@" + oriCurrency;
            ExchangeRateInfo exchangeRateInfo = exrateCacheMap.get(key);
            if (exchangeRateInfo == null) {
                exchangeRateInfo = ExchangeRateHelper.getExchangeRateInfo((Long)oriCurrency, (Long)tarCurrency, (Long)task.getLong("payrollgroupv.exratetable.id"), (Date)task.getDate("exratedate"));
            }
            if (exchangeRateInfo != null) {
                logger.info("exchangeRateInfo:{}", (Object)JSON.toJSONString((Object)exchangeRateInfo));
            }
            if (exchangeRateInfo != null) {
                exrateCacheMap.put(key, exchangeRateInfo);
                numvalue = exchangeRateInfo.getQuoteType() != false ? numvalue.divide(exchangeRateInfo.getExchangeRate(), 18, 1) : numvalue.multiply(exchangeRateInfo.getExchangeRate()).setScale(CalUtils.getSystemDefaultScal(), 4);
            }
        }
        return numvalue;
    }

    public static BigDecimal getLatestValue(List<DynamicObject> dynamicObjects, DynamicObject task, Map<String, ExchangeRateInfo> exrateCacheMap) {
        BigDecimal value = new BigDecimal("0");
        Date date = null;
        DynamicObject latestData = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String storagetype = dynamicObject.getString("entryentity.storagetype");
            Date perioddate = dynamicObject.getDate("perioddate");
            BigDecimal numvalue = InsuranceHelper.getInsuranceItemValue(dynamicObject, storagetype);
            numvalue = InsuranceHelper.tranCurrencyValue(task, exrateCacheMap, dynamicObject, storagetype, numvalue);
            if (date != null && !perioddate.after(date)) continue;
            date = perioddate;
            value = numvalue;
            latestData = dynamicObject;
        }
        DynamicObject finalLatestData = latestData;
        dynamicObjects.removeIf(o -> !o.equals(finalLatestData));
        return value;
    }

    public static BigDecimal getEarliestValue(List<DynamicObject> dynamicObjects, DynamicObject task, Map<String, ExchangeRateInfo> exrateCacheMap) {
        BigDecimal value = new BigDecimal("0");
        Date date = null;
        DynamicObject earliestData = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String storagetype = dynamicObject.getString("entryentity.storagetype");
            Date perioddate = dynamicObject.getDate("perioddate");
            BigDecimal numvalue = InsuranceHelper.getInsuranceItemValue(dynamicObject, storagetype);
            numvalue = InsuranceHelper.tranCurrencyValue(task, exrateCacheMap, dynamicObject, storagetype, numvalue);
            if (date != null && !perioddate.before(date)) continue;
            date = perioddate;
            value = numvalue;
            earliestData = dynamicObject;
        }
        DynamicObject finalEarliestData = earliestData;
        dynamicObjects.removeIf(o -> !o.equals(finalEarliestData));
        return value;
    }

    /*
     * Could not resolve type clashes
     */
    public static Map<Long, Long> fetchInsuranceData(DynamicObjectCollection calPersonList, Map<String, InsuranceItemMapping> insuranceItemMap, Map<Long, Map<String, Object>> insuranceResultMap, Date payrolldate, Long calTaskId, Map<String, SalaryItemVO> uniqueCodeMap, Map<Long, HashSet<Long>> fileItemMap) {
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = taskHelper.queryOne("id,exratedate,payrollgroupv.exratetable.id,payrollgroupv.currency.id", (Object)calTaskId);
        HashMap<Long, Long> insuranceCalpersonMap = new HashMap<Long, Long>(calPersonList.size());
        List personIds = calPersonList.stream().map(o -> o.getLong("personhrv.boid")).collect(Collectors.toList());
        List calpersonIds = calPersonList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        SWCDataServiceHelper helper1 = new SWCDataServiceHelper("hsas_insurancedata");
        Date endDate = SWCDateTimeUtils.lastDayOfMonth((Date)payrolldate);
        endDate = HandleProrationHelper.replaceDateTime((Date)endDate, (String)"23:59:59");
        QFilter filter1 = new QFilter("withholddate", "<=", (Object)endDate);
        filter1.and("withholddate", ">=", (Object)SWCDateTimeUtils.firstDayOfMonth((Date)payrolldate));
        filter1.and("person", "in", personIds);
        QFilter filter = new QFilter("usestatus", "=", (Object)"0");
        filter.or("calperson", "in", calpersonIds);
        filter1.and(filter);
        QueryInsuranceDataEvent event = new QueryInsuranceDataEvent(calTaskId);
        IQueryInsuranceDataExtService extService = new IQueryInsuranceDataExtService(){};
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, IQueryInsuranceDataExtService.class, (String)"kd.sdk.swc.hscs.business.extpoint.IQueryInsuranceDataExtService#setFilter", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.setFilter(event);
            return null;
        });
        if (!SWCListUtils.isEmpty((List)event.getFilters())) {
            event.getFilters().forEach(arg_0 -> ((QFilter)filter1).and(arg_0));
        }
        DynamicObjectCollection insurancedata = helper1.queryOriginalCollection("id,perioddate,withholddate,withholdtype,employee.id,person.id,entryentity.insuranceitem,entryentity.numvalue,entryentity.amountvalue,entryentity.isnull,entryentity.currency.id,entryentity.storagetype", filter1.toArray());
        Map<Long, Map<Long, List<DynamicObject>>> insuancedataMap = insurancedata.stream().collect(Collectors.groupingBy(dy -> dy.getLong("person.id"), Collectors.groupingBy(o -> o.getLong("entryentity.insuranceitem"))));
        HashMap<String, ExchangeRateInfo> exrateCacheMap = new HashMap<String, ExchangeRateInfo>(16);
        for (DynamicObject calperson : calPersonList) {
            long personId = calperson.getLong("personhrv.boid");
            long calpersonId = calperson.getLong("id");
            long fileId = calperson.getLong("salaryfile.id");
            Map<Long, List<DynamicObject>> insuranItemDataMap = insuancedataMap.get(personId);
            Map dataMap = insuranceResultMap.getOrDefault(calpersonId, new HashMap(16));
            HashSet<Long> allowItems = fileItemMap.get(fileId);
            for (Map.Entry<String, InsuranceItemMapping> entry : insuranceItemMap.entrySet()) {
                String unicode = entry.getKey();
                InsuranceItemMapping mapping = entry.getValue();
                List<DynamicObject> dynamicObjects = null;
                if (allowItems != null && allowItems.contains(mapping.getSalaryItemId()) && insuranItemDataMap != null) {
                    dynamicObjects = insuranItemDataMap.get(mapping.getInsuranceItemId());
                }
                if (dynamicObjects == null) continue;
                String method = mapping.getMethod();
                String withholdtype = mapping.getWithholdtype();
                List<Object> filterDatas = new ArrayList(dynamicObjects);
                if (!SWCStringUtils.equals((String)withholdtype, (String)"all")) {
                    filterDatas = filterDatas.stream().filter(o -> SWCStringUtils.equals((String)o.getString("withholdtype"), (String)withholdtype)).collect(Collectors.toList());
                }
                if (filterDatas.size() <= 0) continue;
                BigDecimal value = new BigDecimal("0");
                switch (method) {
                    case "sum": {
                        value = InsuranceHelper.getSumValue(filterDatas, task, exrateCacheMap);
                        break;
                    }
                    case "latest": {
                        value = InsuranceHelper.getLatestValue(filterDatas, task, exrateCacheMap);
                        break;
                    }
                    case "earliest": {
                        value = InsuranceHelper.getEarliestValue(filterDatas, task, exrateCacheMap);
                        break;
                    }
                }
                for (DynamicObject dynamicObject : filterDatas) {
                    insuranceCalpersonMap.put(dynamicObject.getLong("id"), calpersonId);
                }
                SalaryItemVO item = uniqueCodeMap.get(unicode);
                if (item != null && value != null) {
                    value = value.setScale((int)item.getScale(), ItemDataUtils.getRoundingMode((long)item.getDataroundId()));
                }
                dataMap.put(unicode, value);
            }
            insuranceResultMap.put(calpersonId, dataMap);
        }
        return insuranceCalpersonMap;
    }

    public static void rollbackInsuranceData(List<Long> calPersonIds, Date payrolldate) {
        DynamicObject[] insuranceDatas;
        SWCDataServiceHelper insuranceDataHelper = new SWCDataServiceHelper("hsas_insurancedata");
        Date endDate = SWCDateTimeUtils.lastDayOfMonth((Date)payrolldate);
        endDate = HandleProrationHelper.replaceDateTime((Date)endDate, (String)"23:59:59");
        QFilter filter1 = new QFilter("withholddate", "<=", (Object)endDate);
        filter1.and("withholddate", ">=", (Object)SWCDateTimeUtils.firstDayOfMonth((Date)payrolldate));
        QFilter qFilter = new QFilter("calperson", "in", calPersonIds);
        qFilter.and(filter1);
        for (DynamicObject insuranceData : insuranceDatas = insuranceDataHelper.query("id,calperson,salaryfile,caltask,usestatus,withholddate", qFilter.toArray())) {
            insuranceData.set("usestatus", (Object)"0");
            insuranceData.set("caltask", null);
            insuranceData.set("calperson", null);
            insuranceData.set("salaryfile", null);
        }
        insuranceDataHelper.save(insuranceDatas);
    }
}

