/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.result;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.common.vo.CalResultVO;

public class SalaryResultService {
    private static final Log logger = LogFactory.getLog(SalaryResultService.class);

    public void saveSalaryResultList(List<Long> calPersonIdList, Map<Long, DynamicObject> existResult, DynamicObject task) {
        this.saveSalaryResultList(calPersonIdList, existResult, task, (totalSalaryMap, netSalaryMap, totalSalaryItemId, netSalaryItemId) -> {});
    }

    public void saveSalaryResultList(List<Long> calPersonIdList, List<CalResultVO> calResultList, DynamicObject task) {
        this.saveSalaryResultList(calPersonIdList, Maps.newHashMap(), task, (totalSalaryMap, netSalaryMap, totalSalaryItemId, netSalaryItemId) -> {
            for (CalResultVO calResultVO : calResultList) {
                if (calResultVO.getProrationIndex() != 0) continue;
                if (Objects.equals(totalSalaryItemId, calResultVO.getSalaryItemId()) && null != calResultVO.getCalResultValue()) {
                    totalSalaryMap.put(calResultVO.getCalTableId(), new BigDecimal(calResultVO.getCalResultValue().toString()));
                }
                if (!Objects.equals(netSalaryItemId, calResultVO.getSalaryItemId()) || null == calResultVO.getCalResultValue()) continue;
                netSalaryMap.put(calResultVO.getCalTableId(), new BigDecimal(calResultVO.getCalResultValue().toString()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSalaryResultList(List<Long> calPersonIdList, Map<Long, DynamicObject> existResult, DynamicObject task, SalaryMapDecorator salaryMap) {
        logger.info("saveSalaryResultList begin,calResultList.size:{},time={}", (Object)calPersonIdList.size(), (Object)System.currentTimeMillis());
        SWCDataServiceHelper resultHelper = new SWCDataServiceHelper("hsas_salaryresult");
        DynamicObject[] calPersons = this.getCalPersonById(calPersonIdList);
        DynamicObject[] caltables = this.getCalTableListWithoutProration(calPersonIdList);
        List<Long> fileIds = Arrays.stream(calPersons).map(obj -> obj.getLong("salaryfile.id")).collect(Collectors.toList());
        SWCDataServiceHelper calRuleHisHelper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject calRuleHis = calRuleHisHelper.queryOne("totalsalary.id,netsalary.id", (Object)task.getLong("calrulev.id"));
        long totalsalaryItemId = calRuleHis.getLong("totalsalary.id");
        long netsalaryItemId = calRuleHis.getLong("netsalary.id");
        long prePeriodPk = this.getPrePeriodPk(task);
        HashMap<Long, BigDecimal> preTotalSalaryMap = new HashMap<Long, BigDecimal>(16);
        if (SWCStringUtils.equals((String)task.getString("tasktype"), (String)"0") && prePeriodPk != 0L && totalsalaryItemId != 0L && netsalaryItemId != 0L) {
            DynamicObject[] preResults;
            for (DynamicObject preResult : preResults = this.getPreResults(resultHelper, task, fileIds, prePeriodPk)) {
                long fileId = preResult.getLong("salaryfile.id");
                BigDecimal bigDecimal = (BigDecimal)preTotalSalaryMap.get(fileId);
                if (bigDecimal != null) {
                    preTotalSalaryMap.put(fileId, bigDecimal.add(preResult.getBigDecimal("totalsalary")));
                    continue;
                }
                preTotalSalaryMap.put(fileId, preResult.getBigDecimal("totalsalary"));
            }
        }
        HashMap<Long, BigDecimal> totalSalaryMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> netSalaryMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject caltable : caltables) {
            DynamicObjectCollection entrys = caltable.getDynamicObjectCollection("hsas_caltableentry");
            for (DynamicObject entry : entrys) {
                if (entry.getInt("slprorationindex") != 0) continue;
                if (totalsalaryItemId == entry.getLong("salaryitem.id") && null != entry.getBigDecimal("calamountvalue")) {
                    totalSalaryMap.put(caltable.getLong("id"), entry.getBigDecimal("calamountvalue"));
                }
                if (netsalaryItemId != entry.getLong("salaryitem.id") || null == entry.getBigDecimal("calamountvalue")) continue;
                netSalaryMap.put(caltable.getLong("id"), entry.getBigDecimal("calamountvalue"));
            }
        }
        salaryMap.decorate(totalSalaryMap, netSalaryMap, totalsalaryItemId, netsalaryItemId);
        logger.info("totalSalaryMap:{},netSalaryMap:{}", (Object)((Object)totalSalaryMap).toString(), (Object)((Object)netSalaryMap).toString());
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_salaryresult");
        ArrayList<DynamicObject> results = new ArrayList<DynamicObject>(calPersons.length);
        Long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        Map<Long, Long> personCaltableIdMap = Arrays.stream(caltables).collect(Collectors.toMap(key -> key.getLong("calpersonid"), value -> value.getLong("id")));
        for (DynamicObject calPerson : calPersons) {
            Long caltableId = personCaltableIdMap.get(calPerson.getLong("id"));
            if (caltableId == null) {
                logger.info("caltableId is null");
                continue;
            }
            this.initSalaryResult(task, preTotalSalaryMap, totalSalaryMap, netSalaryMap, (DynamicObjectType)type, results, userId, now, caltableId, calPerson, existResult);
        }
        logger.info("results.size:{}", (Object)results.size());
        try (TXHandle tXHandle = TX.requiresNew();){
            QFilter taskFilter = new QFilter("caltask", "=", (Object)task.getLong("id"));
            QFilter salaryFileFilter = new QFilter("salaryfile", "in", fileIds);
            if (!CollectionUtils.isEmpty(existResult)) {
                DynamicObject[] values = existResult.values().toArray(new DynamicObject[0]);
                resultHelper.save(values);
                Set existIds = Arrays.stream(values).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
                salaryFileFilter.and(new QFilter("id", "not in", existIds));
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    long id = ((DynamicObject)iterator.next()).getLong("id");
                    if (id == 0L || !existIds.contains(id)) continue;
                    iterator.remove();
                }
            }
            resultHelper.deleteByFilter(new QFilter[]{taskFilter, salaryFileFilter});
            if (!CollectionUtils.isEmpty(results)) {
                resultHelper.save(results.toArray(new DynamicObject[0]));
            }
            tXHandle.commit();
        }
        logger.info("saveSalaryResultList end,time={}", (Object)System.currentTimeMillis());
    }

    private void initSalaryResult(DynamicObject task, Map<Long, BigDecimal> preTotalSalaryMap, Map<Long, BigDecimal> totalSalaryMap, Map<Long, BigDecimal> netSalaryMap, DynamicObjectType type, List<DynamicObject> results, Long userId, Date now, Long calTableId, DynamicObject calPerson, Map<Long, DynamicObject> existResult) {
        BigDecimal totalSalary;
        DynamicObject salaryResult = existResult.get(calTableId);
        if (salaryResult == null) {
            totalSalary = totalSalaryMap.get(calTableId);
            salaryResult = (DynamicObject)type.createInstance();
            salaryResult.set("totalsalary", (Object)totalSalary);
            salaryResult.set("caltableid", (Object)calTableId);
            salaryResult.set("netsalary", (Object)netSalaryMap.get(calTableId));
            salaryResult.set("currency", task.get("payrollgroupv.currency.id"));
            salaryResult.set("org", (Object)calPerson.getLong("org.id"));
            salaryResult.set("adminorg", (Object)calPerson.getLong("adminorg.id"));
            salaryResult.set("company", (Object)calPerson.getLong("empposorgrelhrv.company.id"));
            salaryResult.set("department", (Object)calPerson.getLong("adminorg.id"));
            salaryResult.set("position", (Object)calPerson.getLong("empposorgrelhrv.position.id"));
            salaryResult.set("job", (Object)calPerson.getLong("empposorgrelhrv.job.id"));
            salaryResult.set("joblevel", (Object)calPerson.getLong("empjobrelv.joblevel.id"));
            salaryResult.set("jobgrade", (Object)calPerson.getLong("empjobrelv.jobgrade.id"));
            salaryResult.set("laborrelstatus", (Object)calPerson.getLong("empentrelv.laborrelstatus.id"));
            salaryResult.set("laborreltype", (Object)calPerson.getLong("empentrelv.laborreltype.id"));
            salaryResult.set("caltask", (Object)task.getLong("id"));
            salaryResult.set("calperiodtype", (Object)task.getLong("periodtype.id"));
            salaryResult.set("calperiod", (Object)task.getLong("period.id"));
            salaryResult.set("startdate", (Object)task.getDate("startdate"));
            salaryResult.set("enddate", (Object)task.getDate("enddate"));
            salaryResult.set("person", (Object)calPerson.getLong("salaryfile.employee.id"));
            salaryResult.set("salaryfile", (Object)calPerson.getLong("salaryfile.id"));
            salaryResult.set("enterprise", (Object)calPerson.getLong("empentrelv.enterprise.id"));
            salaryResult.set("payrollgroup", (Object)task.getLong("payrollgroup.id"));
            salaryResult.set("calrule", (Object)task.getLong("calrule.id"));
            salaryResult.set("payrollscene", (Object)task.getLong("payrollscene.id"));
            salaryResult.set("creator", (Object)userId);
            salaryResult.set("createtime", (Object)now);
        } else {
            totalSalary = salaryResult.getBigDecimal("totalsalary");
        }
        salaryResult.set("growamountshow", (Object)"\u2014\u2014");
        salaryResult.set("growrateshow", (Object)"\u2014\u2014");
        salaryResult.set("modifier", (Object)userId);
        salaryResult.set("modifytime", (Object)now);
        BigDecimal preTotalSalary = preTotalSalaryMap.get(calPerson.getLong("salaryfile.id"));
        boolean isHasPre = false;
        if (preTotalSalary != null && totalSalary != null && "0".equals(task.getString("tasktype"))) {
            BigDecimal growSalary = totalSalary.subtract(preTotalSalary).setScale(2, 4);
            isHasPre = true;
            if (preTotalSalary.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal growRate = growSalary.multiply(new BigDecimal("100")).divide(preTotalSalary, 2, 4);
                salaryResult.set("growrateshow", (Object)growRate.toPlainString());
                salaryResult.set("growthrate", (Object)growRate);
            }
            salaryResult.set("growthamount", (Object)growSalary);
            salaryResult.set("growamountshow", (Object)growSalary.toPlainString());
        }
        salaryResult.set("ishaspre", (Object)isHasPre);
        results.add(salaryResult);
    }

    private DynamicObject[] getCalPersonById(List<Long> calPersonIdList) {
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        String selectProperties = "id,org.id,adminorg.id,empposorgrelhrv.company.id,empposorgrelhrv.position.id,empposorgrelhrv.job.id,empjobrelv.joblevel.id,empjobrelv.jobgrade.id,empentrelv.laborrelstatus.id,empentrelv.enterprise.idempentrelv.laborreltype.id,salaryfile.employee.id,salaryfile.id";
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        DynamicObject[] calPersons = calPersonHelper.query(selectProperties, new QFilter[]{filter});
        return calPersons;
    }

    private DynamicObject[] getCalTableListWithoutProration(List<Long> calPersonIdList) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_caltable");
        String selectProperties = "id,hsas_caltableentry.salaryitem,hsas_caltableentry.calamountvalue,calpersonid,hsas_caltableentry.slprorationindex";
        QFilter filter = new QFilter("calpersonid", "in", calPersonIdList);
        return calTableHelper.query(selectProperties, new QFilter[]{filter});
    }

    private long getPrePeriodPk(DynamicObject task) {
        Date salaryStartDate = task.getDate("startdate");
        SWCDataServiceHelper periodHelper = new SWCDataServiceHelper("hsbs_calperiod");
        long periodtypeId = task.getLong("periodtype.id");
        if (0L == periodtypeId) {
            return 0L;
        }
        DynamicObject period = periodHelper.queryOne("id", new QFilter[]{new QFilter("startdate", "<", (Object)salaryStartDate), new QFilter("periodtypeid", "=", (Object)periodtypeId)}, "startdate desc");
        if (period != null) {
            return period.getLong("id");
        }
        return 0L;
    }

    private DynamicObject[] getPreResults(SWCDataServiceHelper resultHelper, DynamicObject task, List<Long> fileIds, long prePeriodPk) {
        QFilter tasktypeFilter = new QFilter("caltask.tasktype", "=", (Object)"0");
        QFilter fileQfileter = new QFilter("salaryfile.id", "in", fileIds);
        QFilter payrollgroupQfilter = new QFilter("payrollgroup.id", "=", (Object)task.getLong("payrollgroup.id"));
        QFilter payrollsceneQfilter = new QFilter("payrollscene.id", "=", (Object)task.getLong("payrollscene.id"));
        QFilter calperiodQfilter = new QFilter("calperiod", "=", (Object)prePeriodPk);
        QFilter calcurrencyFilter = new QFilter("currency.id", "=", (Object)task.getLong("payrollgroupv.currency.id"));
        return resultHelper.query("id,totalsalary,salaryfile.id", new QFilter[]{fileQfileter, payrollgroupQfilter, payrollsceneQfilter, calperiodQfilter, calcurrencyFilter, tasktypeFilter});
    }

    static interface SalaryMapDecorator {
        public void decorate(Map<Long, BigDecimal> var1, Map<Long, BigDecimal> var2, Long var3, Long var4);
    }
}

