/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.result.calitemhandle;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.swc.hsbp.business.formula.enums.SaveDataTypeEnum;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hscs.business.cal.result.calitemhandle.BaseCalItemHandle;
import kd.swc.hscs.business.cal.result.calitemhandle.SaveCalItemHelper;
import kd.swc.hscs.common.vo.CalResultItem;
import kd.swc.hscs.common.vo.CalResultVO;

public class CalSLHandle
extends BaseCalItemHandle {
    CalSLHandle(CalResultItemEnum itemEnum) {
        super(itemEnum);
    }

    @Override
    protected void addEntryData(DynamicObject calTable, List<CalResultItem> itemResultList) {
        if (SWCListUtils.isEmpty(itemResultList)) {
            return;
        }
        DynamicObjectCollection slEntryList = calTable.getDynamicObjectCollection("hsas_caltableentry");
        if (slEntryList == null) {
            slEntryList = new DynamicObjectCollection();
        }
        DynamicObject entry = null;
        int seq = slEntryList.size() + 1;
        CalResultVO calResult = null;
        for (CalResultItem item : itemResultList) {
            entry = slEntryList.addNew();
            calResult = (CalResultVO)item;
            entry.set("seq", (Object)seq);
            entry.set("salaryitem", (Object)calResult.getSalaryItemId());
            entry.set("proportion", (Object)(calResult.getProration() == null ? BigDecimal.ZERO : calResult.getProration()));
            entry.set("slstartdate", (Object)calResult.getStartDate());
            entry.set("slenddate", (Object)calResult.getEndDate());
            entry.set("slprorationindex", (Object)calResult.getProrationIndex());
            entry.set("resultcover", (Object)calResult.isResultCover());
            this.setItemValue(calResult, entry);
            ++seq;
        }
        calTable.set("hsas_caltableentry", (Object)slEntryList);
    }

    private void setItemValue(CalResultVO itemParam, DynamicObject entry) {
        SaveDataTypeEnum dataType = SaveDataTypeEnum.getDataType((String)itemParam.getDataShowType());
        switch (dataType) {
            case NUM: {
                entry.set("numvalue", (Object)SaveCalItemHelper.getItemBigDecimalResult(itemParam.getCalResultValue()));
                break;
            }
            case DATE: {
                entry.set("datevalue", (Object)SaveCalItemHelper.getItemDateResult(itemParam.getCalResultValue()));
                break;
            }
            case TEXT: {
                entry.set("textvalue", (Object)SaveCalItemHelper.getItemStringResult(itemParam.getCalResultValue()));
                break;
            }
            case AMOUNT: {
                entry.set("calamountvalue", (Object)SaveCalItemHelper.getItemBigDecimalResult(itemParam.getCalResultValue()));
                break;
            }
        }
    }
}

