/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.result.calitemhandle;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.swc.hsbp.business.formula.enums.SaveDataTypeEnum;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hscs.business.cal.result.calitemhandle.BaseCalItemHandle;
import kd.swc.hscs.business.cal.result.calitemhandle.SaveCalItemHelper;
import kd.swc.hscs.common.vo.CalResultItem;

public class CalSPHandle
extends BaseCalItemHandle {
    public CalSPHandle(CalResultItemEnum itemEnum) {
        super(itemEnum);
    }

    @Override
    protected void addEntryData(DynamicObject calTable, List<CalResultItem> itemResultList) {
        if (SWCListUtils.isEmpty(itemResultList)) {
            return;
        }
        DynamicObjectCollection spEntryList = calTable.getDynamicObjectCollection("hsas_calspentry");
        if (spEntryList == null) {
            spEntryList = new DynamicObjectCollection();
        }
        Map<Long, DynamicObject> spEntryMap = spEntryList.stream().collect(Collectors.toMap(obj -> obj.getLong("supportitem.id"), obj -> obj));
        DynamicObject entry = null;
        DynamicObject task = this.getTask();
        Date startDate = task.getDate("startdate");
        Date endDate = task.getDate("enddate");
        int seq = spEntryList.size() + 1;
        for (CalResultItem item : itemResultList) {
            entry = spEntryMap.get(item.getItemId());
            if (entry != null) {
                entry.set("spcalblock", (Object)"2");
                this.setItemValue(item, entry);
                continue;
            }
            entry = spEntryList.addNew();
            entry.set("seq", (Object)seq);
            entry.set("supportitem", (Object)item.getItemId());
            entry.set("spcalblock", (Object)SaveCalItemHelper.getCalBlock(this.getCalType()));
            entry.set("spstartdate", (Object)startDate);
            entry.set("spenddate", (Object)endDate);
            entry.set("spprorationindex", (Object)item.getProrationIndex());
            this.setItemValue(item, entry);
            ++seq;
        }
        calTable.set("hsas_calspentry", (Object)spEntryList);
    }

    private void setItemValue(CalResultItem itemParam, DynamicObject entry) {
        SaveDataTypeEnum dataType = SaveDataTypeEnum.getDataType((String)itemParam.getDataShowType());
        switch (dataType) {
            case NUM: {
                entry.set("spnumvalue", (Object)SaveCalItemHelper.getItemBigDecimalResult(itemParam.getItemResult()));
                break;
            }
            case DATE: {
                entry.set("spdatevalue", (Object)SaveCalItemHelper.getItemDateResult(itemParam.getItemResult()));
                break;
            }
            case TEXT: {
                entry.set("sptextvalue", (Object)SaveCalItemHelper.getItemStringResult(itemParam.getItemResult()));
                break;
            }
        }
    }
}

