/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.rollback.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hscs.business.extpoint.ICalRollBackExtService;
import kd.sdk.swc.hscs.common.events.CalRollBackEvent;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.enums.FailureTypeEnum;
import kd.swc.hsbp.common.enums.TaxStateEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.check.AccCheckService;
import kd.swc.hscs.business.cal.helper.CalOperationHelper;
import kd.swc.hscs.business.cal.insurance.InsuranceHelper;
import kd.swc.hscs.business.cal.result.ResultCheckService;
import kd.swc.hscs.business.cal.rollback.CalRollBackExtServiceImpl;
import kd.swc.hscs.business.cal.rollback.helper.TaxPushHelper;
import kd.swc.hscs.business.cal.service.BizDataService;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.business.cal.utils.SalaryCalMutexUtils;

public class RollBackCalFilterService {
    private static final Log LOGGER = LogFactory.getLog(RollBackCalFilterService.class);
    private static final String TAX_ROLL_BACK_FAILED = "1";
    private static final String CAL_ROLL_BACK_FAILED = "2";
    public static final String USER_ID = "userId";
    public static final String CAL_RECORD_ID = "calRecordId";

    public void rollBackCal(DynamicObject calTask, List<Long> calPersonIdList, Long calRecordId, String cancelType, String stopOperateKey) {
        DynamicObject[] validCalPersonArr;
        Long calTaskId = calTask.getLong("id");
        String logCommonInfo = ",calTaskId = " + calTaskId + ",calRecordId = " + calRecordId;
        LOGGER.info("rollBackCal begin {}", (Object)logCommonInfo);
        DynamicObject[] allCalPersonArr = this.getCalPersonArr(calTaskId, calPersonIdList);
        Map<Long, DynamicObject> orginalCalPersonMap = Arrays.asList(allCalPersonArr).stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
        int failCount = calPersonIdList.size() - allCalPersonArr.length;
        LOGGER.info("exist {} calperson is not in task", (Object)failCount);
        ArrayList<Long> personIndexIdList = new ArrayList<Long>(orginalCalPersonMap.size());
        DynamicObjectCollection calDetailList = new DynamicObjectCollection();
        if (!"stopcal".equals(cancelType)) {
            allCalPersonArr = this.checkAndAddSalaryCalMutex(allCalPersonArr, calTaskId, calDetailList, calRecordId);
        }
        this.collectPersonIndexId(allCalPersonArr, personIndexIdList);
        AccCheckService checkService = new AccCheckService(calTaskId, calRecordId);
        allCalPersonArr = checkService.checkAccForCancelCal(allCalPersonArr, calDetailList);
        StringBuilder failedCountSb = new StringBuilder("the first step failed count is: ");
        failedCountSb.append(failCount += calDetailList.size());
        boolean openTaxCal = TaxCalServiceHelper.getTaxCalEnableStatusByTask((DynamicObject)calTask);
        if (openTaxCal) {
            if (allCalPersonArr.length > 0) {
                ArrayList<DynamicObject> rollBackCalPersonList = new ArrayList<DynamicObject>(allCalPersonArr.length);
                this.rollBackCalPersonFromTax(allCalPersonArr, calTask, rollBackCalPersonList, calDetailList, calRecordId, cancelType);
                validCalPersonArr = rollBackCalPersonList.toArray(new DynamicObject[0]);
                failedCountSb.append(", the tax failed count is ").append(allCalPersonArr.length - rollBackCalPersonList.size());
                failCount += allCalPersonArr.length - rollBackCalPersonList.size();
            } else {
                validCalPersonArr = allCalPersonArr;
            }
        } else {
            validCalPersonArr = allCalPersonArr;
        }
        RollbackDeleteDataResult result = this.deleteRelateDataRollback(validCalPersonArr, calTask, calRecordId, calDetailList, cancelType);
        int successCount = result.getSuccessPersons().length;
        failCount += result.getFailPersons().length;
        Set<Long> successIdSet = Arrays.stream(validCalPersonArr).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        this.recoverCalStatus(orginalCalPersonMap, successIdSet, calRecordId);
        try {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
            DynamicObject[] updateArr = new DynamicObject[orginalCalPersonMap.size()];
            orginalCalPersonMap.values().toArray(updateArr);
            helper.update(updateArr);
        }
        catch (Exception ex) {
            LOGGER.error("{}, update cal status and tax status of all cal persons failed.", (Object)logCommonInfo, (Object)ex);
            successCount = 0;
            failCount = calPersonIdList.size();
            calDetailList.clear();
            this.handleExceptionData(orginalCalPersonMap, ex.getMessage(), calDetailList, calRecordId, CAL_ROLL_BACK_FAILED, cancelType);
        }
        failedCountSb.append(", the sum failed count is ").append(failCount);
        String logInfoSb = logCommonInfo + ", begin to update cal record , and the success count is " + successCount + ", " + failedCountSb;
        LOGGER.info(logInfoSb);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caldetail");
        if ("stopcal".equals(cancelType)) {
            QFilter filter = new QFilter("record", "=", (Object)calRecordId);
            filter.and("calpersonid", "in", calPersonIdList);
            helper.deleteByFilter(new QFilter[]{filter});
        }
        Object[] allCalDetailArr = new DynamicObject[calDetailList.size()];
        calDetailList.toArray(allCalDetailArr);
        helper.save((DynamicObject[])allCalDetailArr);
        TaxPushHelper.updateProgress(calTaskId, calRecordId, successCount, failCount, cancelType, stopOperateKey);
        CalUtils.deleteSalaryCalMutexData(personIndexIdList, calTaskId);
        try {
            LOGGER.info("start invodeCalRollRack");
            CalRollBackEvent event = new CalRollBackEvent(calTaskId, calPersonIdList, calRecordId, cancelType);
            this.invokeCalRollBack(event);
            LOGGER.info("finish invodeCalRollRack");
        }
        catch (Exception exception) {
            LOGGER.error("invokeCalRollBack_error", (Throwable)exception);
        }
        LOGGER.info("rollBackCal end {}", (Object)logCommonInfo);
    }

    private void collectPersonIndexId(DynamicObject[] allCalPersonArr, List<Long> personIndexIdList) {
        if (allCalPersonArr == null || allCalPersonArr.length == 0) {
            return;
        }
        for (DynamicObject obj : allCalPersonArr) {
            personIndexIdList.add(obj.getLong("personhrv.personindexid"));
        }
    }

    private DynamicObject[] checkAndAddSalaryCalMutex(DynamicObject[] allCalPersonArr, Long calTaskId, DynamicObjectCollection calDetailList, Long calRecordId) {
        if (allCalPersonArr == null || allCalPersonArr.length == 0) {
            return new DynamicObject[0];
        }
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        Map<Long, DynamicObject> calPersonMap = Arrays.asList(allCalPersonArr).stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
        Map<Long, DynamicObject> personIndexMap = SalaryCalMutexUtils.checkRepeatAndBuildMap(allCalPersonArr, errorMap, CAL_ROLL_BACK_FAILED);
        ArrayList<DynamicObject> existDataList = new ArrayList<DynamicObject>(10);
        SalaryCalMutexUtils.checkPersonHrIsCaling(personIndexMap, errorMap, CAL_ROLL_BACK_FAILED, calTaskId, existDataList);
        if (personIndexMap.size() == 0 && existDataList.size() == 0) {
            this.handleErrorData(errorMap, calDetailList, calRecordId, calPersonMap);
            return new DynamicObject[0];
        }
        SalaryCalMutexUtils.addSalaryCalMutexData(personIndexMap, errorMap, CAL_ROLL_BACK_FAILED, calTaskId, existDataList);
        this.handleErrorData(errorMap, calDetailList, calRecordId, calPersonMap);
        existDataList.addAll(personIndexMap.values());
        DynamicObject[] calPersonArr = new DynamicObject[existDataList.size()];
        existDataList.toArray(calPersonArr);
        return calPersonArr;
    }

    private void handleErrorData(Map<Long, String> errorMap, DynamicObjectCollection calDetailList, Long calRecordId, Map<Long, DynamicObject> calPersonMap) {
        if (errorMap.size() == 0) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_caldetail");
        for (Map.Entry<Long, String> entry : errorMap.entrySet()) {
            DynamicObject calPerson = calPersonMap.get(entry.getKey());
            calDetailList.add((Object)TaxPushHelper.createCalDetail(type, calPerson, entry.getValue(), calRecordId, FailureTypeEnum.CHECK_FAIL.getCode(), CalStatusEnum.FAIL.getCode()));
        }
    }

    private void recoverCalStatus(Map<Long, DynamicObject> calPersonMap, Set<Long> successIdSet, Long calRecordId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_%s", calRecordId));
        HashMap calPersonStatusMap = (HashMap)appCache.get(String.format(Locale.ROOT, "RECOVER_CALSTATUS_%s", calRecordId), Map.class);
        if (calPersonStatusMap == null) {
            LOGGER.info("calPersonStatusMap is null");
            calPersonStatusMap = new HashMap(0);
        }
        String calStatus = null;
        for (Map.Entry<Long, DynamicObject> entry : calPersonMap.entrySet()) {
            if (successIdSet.contains(entry.getKey()) || !SWCStringUtils.isNotEmpty((String)(calStatus = (String)calPersonStatusMap.get(String.valueOf(entry.getKey()))))) continue;
            entry.getValue().set("calstatus", (Object)calStatus);
            entry.getValue().set("modifytime", (Object)new Date());
            entry.getValue().set("modifier", (Object)RequestContext.get().getCurrUserId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RollbackDeleteDataResult deleteRelateDataRollback(DynamicObject[] calPersonArr, DynamicObject calTask, Long calRecordId, DynamicObjectCollection calDetailList, String cancelType) {
        ArrayList<Long> calPersonIdList;
        RollbackDeleteDataResult result;
        block8: {
            result = new RollbackDeleteDataResult();
            if (calPersonArr == null || calPersonArr.length == 0) {
                result.setFailPersons(new DynamicObject[0]);
                result.setSuccessPersons(new DynamicObject[0]);
                return result;
            }
            Long calTaskId = calTask.getLong("id");
            String logCommonInfo = "calRecordId = " + calRecordId;
            calPersonIdList = new ArrayList<Long>(calPersonArr.length);
            ArrayList<Long> calResultIdList = new ArrayList<Long>(calPersonArr.length);
            ArrayList<Long> salaryFileIdList = new ArrayList<Long>(calPersonArr.length);
            HashMap<Long, DynamicObject> calPersonMap = new HashMap<Long, DynamicObject>(calPersonArr.length);
            for (DynamicObject obj : calPersonArr) {
                calPersonIdList.add(obj.getLong("id"));
                calResultIdList.add(obj.getLong("calresultid"));
                salaryFileIdList.add(obj.getLong("salaryfile.id"));
                calPersonMap.put(obj.getLong("id"), obj);
            }
            boolean rollBackSuccessfully = true;
            TXHandle txHandle = TX.required();
            try {
                LOGGER.info("{},rollback data db begin", (Object)logCommonInfo);
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
                DynamicObject[] filter = new QFilter("id", "in", calResultIdList);
                filter.and("caltask", "=", (Object)calTaskId);
                helper.deleteByFilter(filter.toArray());
                CalOperationHelper.deleteAccData(calPersonIdList, calTask.getDate("exratedate"), calTask.getLong("payrollgroupv.exratetable.id"), calTaskId);
                Date payRollDate = calTask.getDate("payrolldate");
                this.deleteBizDataRel(calTaskId, calPersonIdList, payRollDate);
                this.deleteAttBizDataRel(calTaskId, calPersonIdList);
                QFilter qFilter = new QFilter("caltask", "=", (Object)calTaskId);
                qFilter.and("salaryfile", "in", salaryFileIdList);
                SWCDataServiceHelper salaryResultHelper = new SWCDataServiceHelper("hsas_salaryresult");
                salaryResultHelper.deleteByFilter(new QFilter[]{qFilter});
                InsuranceHelper.rollbackInsuranceData(calPersonIdList, calTask.getDate("payrolldate"));
                result.setSuccessPersons(calPersonArr);
                result.setFailPersons(new DynamicObject[0]);
                LOGGER.info("{},rollback data db end", (Object)logCommonInfo);
            }
            catch (Exception exception) {
                LOGGER.error("deleteRelateDataRollback error.", (Throwable)exception);
                txHandle.markRollback();
                rollBackSuccessfully = false;
                result.setSuccessPersons(new DynamicObject[0]);
                result.setFailPersons(calPersonArr);
                String commonErrMsg = ResManager.loadKDString((String)"\u5185\u90e8\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RollBackCalFilterHelper_0", (String)"swc-hscs-business", (Object[])new Object[0]);
                String errMsg = exception.getMessage() != null && exception.getMessage().length() > 900 ? exception.getMessage().substring(0, 900) : exception.getMessage();
                this.handleExceptionData(calPersonMap, commonErrMsg + errMsg, calDetailList, calRecordId, CAL_ROLL_BACK_FAILED, cancelType);
                LOGGER.error("{}, failed to roll back cal table, acc or biz data.", (Object)logCommonInfo);
            }
            finally {
                txHandle.close();
                if (!rollBackSuccessfully) break block8;
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_caldetail");
                for (DynamicObject obj : calPersonArr) {
                    calDetailList.add((Object)TaxPushHelper.createCalDetail(type, obj, null, calRecordId, null, TAX_ROLL_BACK_FAILED));
                    obj.set("taxstatus", (Object)TaxStateEnum.UNPUSH.getCode());
                    obj.set("pushtime", null);
                    obj.set("pulltime", null);
                    obj.set("calresultid", null);
                    obj.set("calstatus", (Object)CalStateEnum.UNCAL.getCode());
                    obj.set("modifytime", (Object)new Date());
                    obj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                }
            }
        }
        ResultCheckService resultCheckService = new ResultCheckService();
        resultCheckService.deleteCheckDataAndReCount(calPersonIdList, null, calTask.getLong("id"));
        return result;
    }

    private void invokeCalRollBack(CalRollBackEvent event) {
        CalRollBackExtServiceImpl rollBackExtService = new CalRollBackExtServiceImpl();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)rollBackExtService, ICalRollBackExtService.class, (String)"kd.sdk.swc.hscs.business.extpoint.ICalRollBackExtService#calRollBack", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.calRollBack(event);
            return null;
        });
    }

    private void deleteAttBizDataRel(Long calTaskId, List<Long> calPersonIdList) {
        LOGGER.info("deleteAttBizDataRel begin\uff01");
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calattbizdatarel");
        this.excuteDelAttBizDataRel(calTaskId, calPersonIdList, helper, "hsas_attbizdatasummary", "usagecount");
        SWCDataServiceHelper noCntHelper = new SWCDataServiceHelper("hsas_calattnocntrel");
        this.excuteDelAttBizDataRel(calTaskId, calPersonIdList, noCntHelper, "hsas_attbizdatasummary", "nocounttimes");
        SWCDataServiceHelper detRelHelper = new SWCDataServiceHelper("hsas_calattbsdetailrel");
        this.excuteDelAttBizDataRel(calTaskId, calPersonIdList, detRelHelper, "hsas_attbizdatadetail", "usagecount");
        SWCDataServiceHelper noCntDetRelHelper = new SWCDataServiceHelper("hsas_calattdetnocntrel");
        this.excuteDelAttBizDataRel(calTaskId, calPersonIdList, noCntDetRelHelper, "hsas_attbizdatadetail", "nocounttimes");
        LOGGER.info("deleteAttBizDataRel end");
    }

    private void excuteDelAttBizDataRel(Long calTaskId, List<Long> calPersonIdList, SWCDataServiceHelper helper, String entityName, String updateField) {
        LOGGER.info("deleteAttBizDataRel begin\uff01");
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            return;
        }
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        filter.and("calpersonid", "in", calPersonIdList);
        DynamicObjectCollection attBizDataRelColl = helper.queryOriginalCollection("id, attbizdataid", new QFilter[]{filter});
        if (attBizDataRelColl == null || attBizDataRelColl.size() == 0) {
            return;
        }
        Set<Long> attBizDataIdSet = attBizDataRelColl.stream().map(allBizDataRel -> allBizDataRel.getLong("attbizdataid")).collect(Collectors.toSet());
        this.updateAttBizDataUseCount(attBizDataIdSet, entityName, updateField);
        Set calBizDataRelIdSet = attBizDataRelColl.stream().map(allBizDataRel -> allBizDataRel.getLong("id")).collect(Collectors.toSet());
        QFilter delFilter = new QFilter("id", "in", calBizDataRelIdSet);
        helper.deleteByFilter(new QFilter[]{delFilter});
        LOGGER.info("deleteAttBizDataRel end");
    }

    private DynamicObject[] getCalPersonArr(Long calTaskId, List<Long> calPersonIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("caltask", "=", (Object)calTaskId);
        filter.and("id", "in", calPersonIdList);
        return helper.loadDynamicObjectArray(filter.toArray());
    }

    private void rollBackCalPersonFromTax(DynamicObject[] allCalPersonArr, DynamicObject calTaskDy, List<DynamicObject> rollBackCalPersonList, DynamicObjectCollection calDetailList, long calRecordId, String cancelType) {
        String logCommonInfo = "rollBackCalPersonFromTax: calRecordId is " + calRecordId;
        LOGGER.info("{}, begin to roll back tax data.", (Object)logCommonInfo);
        ArrayList<String> calPersonIdList = new ArrayList<String>(allCalPersonArr.length);
        HashMap<Long, DynamicObject> calPersonMap = new HashMap<Long, DynamicObject>(allCalPersonArr.length);
        for (DynamicObject obj : allCalPersonArr) {
            calPersonIdList.add(String.valueOf(obj.getLong("id")));
            calPersonMap.put(obj.getLong("id"), obj);
        }
        Map<String, Object> response = null;
        try {
            response = this.rollBackTaxData(calTaskDy, calRecordId, calPersonIdList);
        }
        catch (Exception exception) {
            LOGGER.error("{}, access tax roll back interface failed, error:", (Object)logCommonInfo, (Object)exception);
            String commonErrMsg = ResManager.loadKDString((String)"\u5185\u90e8\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RollBackCalFilterHelper_0", (String)"swc-hscs-business", (Object[])new Object[0]);
            String errMsg = exception.getMessage() != null && exception.getMessage().length() > 900 ? exception.getMessage().substring(0, 900) : exception.getMessage();
            this.handleExceptionData(calPersonMap, commonErrMsg + errMsg, calDetailList, calRecordId, TAX_ROLL_BACK_FAILED, cancelType);
            return;
        }
        LOGGER.info("{}, begin to resolve the rolled back data of tax.", (Object)logCommonInfo);
        this.handleRollBackDataResponseOfTax(calPersonMap, response, calDetailList, calRecordId, cancelType);
        rollBackCalPersonList.addAll(calPersonMap.values());
    }

    private Map<String, Object> rollBackTaxData(DynamicObject calTaskInfo, Long calRecordId, List<String> calPersonIdList) {
        String logCommonInfo = "rollBackTaxData: calRecordId is " + calTaskInfo.getLong("id");
        LOGGER.info("{}, begin to invoke IndividualTaxCalService.cancelCalculate", (Object)logCommonInfo);
        ArrayList dataMap = new ArrayList(calPersonIdList.size());
        for (String calPersonIdStr : calPersonIdList) {
            HashMap<String, String> srcDataMap = new HashMap<String, String>(1);
            srcDataMap.put("srcDataKey", calPersonIdStr);
            dataMap.add(srcDataMap);
        }
        HashMap<String, Object> rollBackTaxRequest = new HashMap<String, Object>(16);
        rollBackTaxRequest.put("srcType", TAX_ROLL_BACK_FAILED);
        rollBackTaxRequest.put("payDate", calTaskInfo.getDate("paydate"));
        rollBackTaxRequest.put("country", String.valueOf(calTaskInfo.getLong("country.id")));
        rollBackTaxRequest.put("currency", calTaskInfo.getLong("payrollgroupv.currency.id"));
        rollBackTaxRequest.put("operateKey", calRecordId + "cancelcal");
        rollBackTaxRequest.put("preValidateKey", calRecordId + "cancelcal");
        rollBackTaxRequest.put("operator", RequestContext.get().getCurrUserId());
        rollBackTaxRequest.put("langeCode", Lang.get().getLangTag());
        rollBackTaxRequest.put("calTaskNumber", calTaskInfo.getString("number"));
        rollBackTaxRequest.put("calTaskName", calTaskInfo.getString("name"));
        rollBackTaxRequest.put("data", dataMap);
        LOGGER.info("{}, rollBackTaxRequest ==> {}.", (Object)logCommonInfo, (Object)((Object)rollBackTaxRequest).toString());
        Map rollBackTaxResponse = (Map)SWCMServiceUtils.invokeSITService((String)"sitcs", (String)"IndividualTaxCalService", (String)"cancelCalculate", (Object[])new Object[]{rollBackTaxRequest});
        LOGGER.info("{}, rollBackTaxResponse => {}.", (Object)logCommonInfo, (Object)(rollBackTaxResponse != null ? rollBackTaxResponse.toString() : null));
        return rollBackTaxResponse;
    }

    private void handleExceptionData(Map<Long, DynamicObject> calPersonMap, String msg, DynamicObjectCollection calDetailList, Long calRecordId, String cancelFailType, String cancelType) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_caldetail");
        for (Map.Entry<Long, DynamicObject> entry : calPersonMap.entrySet()) {
            calDetailList.add((Object)TaxPushHelper.createCalDetail(type, entry.getValue(), msg, calRecordId, FailureTypeEnum.CANCELCAL_FAIL.getCode(), CAL_ROLL_BACK_FAILED));
            if (!CAL_ROLL_BACK_FAILED.equals(cancelFailType) && !"stopcal".equals(cancelType)) continue;
            entry.getValue().set("calstatus", (Object)CalStateEnum.CANCELCAL_ERROR.getCode());
            entry.getValue().set("modifytime", (Object)new Date());
            entry.getValue().set("modifier", (Object)RequestContext.get().getCurrUserId());
        }
    }

    public void handleRollBackDataResponseOfTax(Map<Long, DynamicObject> calPersonMap, Map<String, Object> response, DynamicObjectCollection calDetailList, Long calRecordId, String cancelType) {
        if (response == null) {
            LOGGER.info("response is null ,calRecordId = {}", (Object)calRecordId);
            String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RollBackCalFilterHelper_1", (String)"swc-hscs-business", (Object[])new Object[0]);
            this.handleExceptionData(calPersonMap, msg, calDetailList, calRecordId, TAX_ROLL_BACK_FAILED, cancelType);
            calPersonMap.clear();
            return;
        }
        Boolean isSucess = (Boolean)response.get("success");
        List dataList = (List)response.get("data");
        if (isSucess == null || !isSucess.booleanValue() || SWCListUtils.isEmpty((List)dataList)) {
            LOGGER.info("success is null or false ,calRecordId = {}", (Object)calRecordId);
            String msg = (String)response.get("message");
            if (SWCStringUtils.isEmpty((String)msg)) {
                msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RollBackCalFilterHelper_1", (String)"swc-hscs-business", (Object[])new Object[0]);
            }
            this.handleExceptionData(calPersonMap, msg, calDetailList, calRecordId, TAX_ROLL_BACK_FAILED, cancelType);
            calPersonMap.clear();
            return;
        }
        DynamicObject calPerson = null;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_caldetail");
        for (Map data : dataList) {
            isSucess = (Boolean)data.get("success");
            Long calPersonId = Long.valueOf((String)data.get("dataKey"));
            if (isSucess != null && isSucess.booleanValue()) {
                calPerson = calPersonMap.get(calPersonId);
                calPerson.set("taxstatus", (Object)TaxStateEnum.UNPUSH.getCode());
                calPerson.set("pushtime", null);
                continue;
            }
            calPerson = calPersonMap.remove(calPersonId);
            this.setCalPersonStatus(calPerson, cancelType);
            calDetailList.add((Object)TaxPushHelper.createCalDetail(type, calPerson, (String)data.get("message"), calRecordId, FailureTypeEnum.CANCELCAL_FAIL.getCode(), CAL_ROLL_BACK_FAILED));
        }
    }

    private void setCalPersonStatus(DynamicObject calPerson, String cancelType) {
        if (!"stopcal".equals(cancelType)) {
            return;
        }
        calPerson.set("calstatus", (Object)CalStateEnum.CANCELCAL_ERROR.getCode());
        calPerson.set("modifytime", (Object)new Date());
        calPerson.set("modifier", (Object)RequestContext.get().getCurrUserId());
    }

    private void deleteBizDataRel(Long calTaskId, List<Long> calPersonIdList, Date payRollDate) {
        this.deleteRecurBizDataRel(calTaskId, calPersonIdList);
        this.deleteNonRecurBizDataRel(calTaskId, calPersonIdList, payRollDate);
    }

    private void deleteRecurBizDataRel(Long calTaskId, List<Long> calPersonIdList) {
        QFilter delFilter;
        LOGGER.info("deleteRecurBizDataRel begin");
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calbizdatarel");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        filter.and("calpersonid", "in", calPersonIdList);
        DynamicObjectCollection bizDataRelColl = helper.queryOriginalCollection("id,bizdataid", new QFilter[]{filter});
        SWCDataServiceHelper noCntHelper = new SWCDataServiceHelper("hsas_calbsnocntrel");
        DynamicObjectCollection bizDataNoCntRelColl = noCntHelper.queryOriginalCollection("id,bizdataid", new QFilter[]{filter});
        if (bizDataRelColl.size() == 0 && bizDataNoCntRelColl.size() == 0) {
            return;
        }
        ArrayList<Long> recurBizDataIdList = new ArrayList<Long>(bizDataRelColl.size());
        ArrayList<Long> calBizDataRelId = new ArrayList<Long>(bizDataRelColl.size());
        for (DynamicObject bizDataRel : bizDataRelColl) {
            recurBizDataIdList.add(bizDataRel.getLong("bizdataid"));
            calBizDataRelId.add(bizDataRel.getLong("id"));
        }
        ArrayList<Long> recurBizDataNoCntIdList = new ArrayList<Long>(bizDataRelColl.size());
        ArrayList<Long> calBizDataNoCntRelId = new ArrayList<Long>(bizDataRelColl.size());
        for (DynamicObject bizDataRel : bizDataNoCntRelColl) {
            recurBizDataNoCntIdList.add(bizDataRel.getLong("bizdataid"));
            calBizDataNoCntRelId.add(bizDataRel.getLong("id"));
        }
        this.updateBizDataUseCount(recurBizDataIdList, "hsas_recurbizdata", recurBizDataNoCntIdList);
        if (calBizDataRelId.size() > 0) {
            delFilter = new QFilter("id", "in", calBizDataRelId);
            helper.deleteByFilter(new QFilter[]{delFilter});
        }
        if (calBizDataNoCntRelId.size() > 0) {
            delFilter = new QFilter("id", "in", calBizDataNoCntRelId);
            noCntHelper.deleteByFilter(new QFilter[]{delFilter});
        }
        LOGGER.info("deleteRecurBizDataRel end");
    }

    private void deleteNonRecurBizDataRel(Long calTaskId, List<Long> calPersonIdList, Date payRollDate) {
        QFilter delFilter;
        LOGGER.info("deleteNonRecurBizDataRel begin");
        if (SWCListUtils.isEmpty(calPersonIdList)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calnonbizdatarel");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        filter.and("payrolldate", "=", (Object)payRollDate);
        filter.and("calpersonid", "in", calPersonIdList);
        DynamicObjectCollection bizDataRelColl = helper.queryOriginalCollection("id,bizdataid", new QFilter[]{filter});
        SWCDataServiceHelper noCnthelper = new SWCDataServiceHelper("hsas_noncalbsnocntrel");
        DynamicObjectCollection bizDataNoCntRelColl = noCnthelper.queryOriginalCollection("id,bizdataid", new QFilter[]{filter});
        if (bizDataRelColl.size() == 0 && bizDataNoCntRelColl.size() == 0) {
            return;
        }
        ArrayList<Long> unRecurBizDataIdList = new ArrayList<Long>(bizDataRelColl.size());
        ArrayList<Long> calBizDataRelId = new ArrayList<Long>(bizDataRelColl.size());
        for (DynamicObject bizDataRel : bizDataRelColl) {
            unRecurBizDataIdList.add(bizDataRel.getLong("bizdataid"));
            calBizDataRelId.add(bizDataRel.getLong("id"));
        }
        ArrayList<Long> unRecurBizDataNoCntIdList = new ArrayList<Long>(bizDataRelColl.size());
        ArrayList<Long> calBizDataNoCntRelId = new ArrayList<Long>(bizDataRelColl.size());
        for (DynamicObject bizDataRel : bizDataNoCntRelColl) {
            unRecurBizDataNoCntIdList.add(bizDataRel.getLong("bizdataid"));
            calBizDataNoCntRelId.add(bizDataRel.getLong("id"));
        }
        Set<Long> bizDateRecordIdSet = this.updateBizDataUseCount(unRecurBizDataIdList, "hsas_nonrecurbizdata", unRecurBizDataNoCntIdList);
        BizDataService bizDataService = new BizDataService();
        bizDataService.updateBizDataRecordUseCount(bizDateRecordIdSet);
        if (calBizDataRelId.size() > 0) {
            delFilter = new QFilter("id", "in", calBizDataRelId);
            helper.deleteByFilter(new QFilter[]{delFilter});
        }
        if (calBizDataNoCntRelId.size() > 0) {
            delFilter = new QFilter("id", "in", calBizDataNoCntRelId);
            noCnthelper.deleteByFilter(new QFilter[]{delFilter});
        }
        LOGGER.info("deleteNonRecurBizDataRel end");
    }

    private void updateAttBizDataUseCount(Set<Long> attBizDataIdSet, String entryName, String updateField) {
        DynamicObject[] bizDataColl;
        if (SWCObjectUtils.isEmpty(attBizDataIdSet)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entryName);
        QFilter filter = new QFilter("id", "in", attBizDataIdSet);
        for (DynamicObject bizData : bizDataColl = helper.query("id, usagecount, nocounttimes", new QFilter[]{filter})) {
            int updateFieldValue = bizData.getInt(updateField);
            if (updateFieldValue <= 0) continue;
            bizData.set(updateField, (Object)(updateFieldValue - 1));
        }
        helper.update(bizDataColl);
    }

    private Set<Long> updateBizDataUseCount(List<Long> bizDataIdList, String entryName, List<Long> bizDataNoCntIdList) {
        if (SWCListUtils.isEmpty(bizDataIdList) && SWCListUtils.isEmpty(bizDataNoCntIdList)) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> bizDataIdSet = new HashSet<Long>(16);
        bizDataIdSet.addAll(bizDataIdList);
        bizDataIdSet.addAll(bizDataNoCntIdList);
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entryName);
        QFilter filter = new QFilter("id", "in", bizDataIdSet);
        boolean isRecu = true;
        String fields = null;
        if ("hsas_nonrecurbizdata".equals(entryName)) {
            isRecu = false;
            fields = "id,usagecount,nocounttimes,modifytime,bizdatarecord";
        } else {
            fields = "id,usagecount,nocounttimes,modifytime";
        }
        HashSet<Long> bizDateRecordIdSet = new HashSet<Long>(16);
        DynamicObject[] bizDataColl = helper.query(fields, new QFilter[]{filter});
        Date modifyTime = new Date();
        for (DynamicObject bizData : bizDataColl) {
            long bizRecordId;
            int noCountTimes;
            int usageCount = bizData.getInt("usagecount");
            if (usageCount > 0 && bizDataIdList.contains(bizData.getLong("id"))) {
                bizData.set("usagecount", (Object)(usageCount - 1));
            }
            if ((noCountTimes = bizData.getInt("nocounttimes")) > 0 && bizDataNoCntIdList.contains(bizData.getLong("id"))) {
                bizData.set("nocounttimes", (Object)(noCountTimes - 1));
            }
            bizData.set("modifytime", (Object)modifyTime);
            if (isRecu || (bizRecordId = bizData.getLong("bizdatarecord")) == 0L) continue;
            bizDateRecordIdSet.add(bizRecordId);
        }
        helper.update(bizDataColl);
        return bizDateRecordIdSet;
    }

    public static class RollbackDeleteDataResult {
        DynamicObject[] successPersons;
        DynamicObject[] failPersons;

        public DynamicObject[] getSuccessPersons() {
            return this.successPersons;
        }

        public void setSuccessPersons(DynamicObject[] successPersons) {
            this.successPersons = successPersons;
        }

        public DynamicObject[] getFailPersons() {
            return this.failPersons;
        }

        public void setFailPersons(DynamicObject[] failPersons) {
            this.failPersons = failPersons;
        }
    }
}

