/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.service;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class BizDataService {
    private static final Log LOGGER = LogFactory.getLog(BizDataService.class);

    public void updateBizDataRecordUseCount(Set<Long> bizDateRecordIdSet) {
        LOGGER.info("updateBizDataRecordUseCount start,bizDateRecordIdSet size = {}", (Object)bizDateRecordIdSet.size());
        if (bizDateRecordIdSet.size() == 0) {
            return;
        }
        SWCDataServiceHelper bizDataRecordHelper = new SWCDataServiceHelper("hsas_bizdatarecord");
        QFilter recordFilter = new QFilter("id", "in", bizDateRecordIdSet);
        DynamicObject[] bizDataRecordArray = bizDataRecordHelper.query("id,usagecount,nocounttimes,modifytime,bsed", new QFilter[]{recordFilter});
        if (bizDataRecordArray == null || bizDataRecordArray.length == 0) {
            return;
        }
        Set bsedSet = Arrays.asList(bizDataRecordArray).stream().map(obj -> obj.getDate("bsed")).collect(Collectors.toSet());
        SWCDataServiceHelper nonDataService = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        QFilter filter = new QFilter("bizdatarecord", "in", bizDateRecordIdSet);
        filter.and("bsed", "in", bsedSet);
        DynamicObjectCollection nonBizDataColl = nonDataService.queryOriginalCollection("id,usagecount,nocounttimes,bizdatarecord", new QFilter[]{filter});
        if (nonBizDataColl.size() == 0) {
            return;
        }
        HashMap recordIdAndUseCountMap = new HashMap(16);
        Map<String, Integer> tempMap = null;
        for (DynamicObject obj2 : nonBizDataColl) {
            Integer existUseCount;
            tempMap = (HashMap)recordIdAndUseCountMap.get(obj2.getLong("bizdatarecord"));
            if (tempMap == null) {
                tempMap = new HashMap(2);
                recordIdAndUseCountMap.put(obj2.getLong("bizdatarecord"), tempMap);
            }
            if ((existUseCount = (Integer)tempMap.get("usagecount")) == null) {
                existUseCount = 0;
            }
            existUseCount = existUseCount + obj2.getInt("usagecount");
            Integer existNoCount = (Integer)tempMap.get("nocounttimes");
            if (existNoCount == null) {
                existNoCount = 0;
            }
            existNoCount = existNoCount + obj2.getInt("nocounttimes");
            tempMap.put("usagecount", existUseCount);
            tempMap.put("nocounttimes", existNoCount);
        }
        Date modifyTime = new Date();
        for (DynamicObject obj3 : bizDataRecordArray) {
            tempMap = (Map)recordIdAndUseCountMap.get(obj3.getLong("id"));
            if (tempMap == null) {
                obj3.set("usagecount", (Object)0);
                obj3.set("nocounttimes", (Object)0);
                obj3.set("modifytime", (Object)modifyTime);
                continue;
            }
            obj3.set("usagecount", tempMap.get("usagecount"));
            obj3.set("nocounttimes", tempMap.get("nocounttimes"));
            obj3.set("modifytime", (Object)modifyTime);
        }
        bizDataRecordHelper.update(bizDataRecordArray);
        LOGGER.info("updateBizDataRecordUseCount end");
    }
}

