/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.FailureTypeEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hscs.business.cal.base.FormulaParse;
import kd.swc.hscs.business.cal.fetchdata.FormulaFecthData;
import kd.swc.hscs.business.cal.helper.CalValidSalaryItemHelper;
import kd.swc.hscs.business.cal.helper.HandleCalProrationHelper;
import kd.swc.hscs.business.cal.helper.SalaryCalServiceHelper;
import kd.swc.hscs.business.cal.result.FormulaCalRecord;
import kd.swc.hscs.business.cal.utils.CalReportUtils;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.business.thread.CalculateThreadTask;
import kd.swc.hscs.common.enums.OperationTypeEnum;
import kd.swc.hscs.common.vo.BatchCalResultParamVO;
import kd.swc.hscs.common.vo.CalOperationVO;
import kd.swc.hscs.common.vo.CalParamCacheInfo;
import kd.swc.hscs.common.vo.CalParamVO;
import kd.swc.hscs.common.vo.CalRecordVO;

public class CalculationService {
    private static final Log LOGGER = LogFactory.getLog(CalculateThreadTask.class);
    private List<Long> calPersonIdList;
    private FormulaParse formulaParse;
    private FormulaParse convertFormulaCal;
    private volatile Map<String, FormulaParse> threadClassMap;
    private CalParamVO calParamVO;
    private boolean isSyncCal = false;
    private Map<Long, Map<String, Object>> responseMap;

    public CalculationService(List<Long> calPersonIdList, FormulaParse formulaParse, Map<String, FormulaParse> threadClassMap, CalParamVO calParamVO, FormulaParse convertFormulaCal) {
        this.calPersonIdList = calPersonIdList;
        this.formulaParse = formulaParse;
        this.threadClassMap = threadClassMap;
        this.calParamVO = calParamVO;
        this.convertFormulaCal = convertFormulaCal;
        this.isSyncCal = false;
        this.responseMap = new HashMap<Long, Map<String, Object>>();
    }

    public CalculationService(List<Long> calPersonIdList, FormulaParse formulaParse, CalParamVO calParamVO, FormulaParse convertFormulaCal, boolean isSyncCal, Map<Long, Map<String, Object>> responseMap) {
        this.calPersonIdList = calPersonIdList;
        this.formulaParse = formulaParse;
        this.threadClassMap = new HashMap<String, FormulaParse>();
        this.calParamVO = calParamVO;
        this.convertFormulaCal = convertFormulaCal;
        this.isSyncCal = isSyncCal;
        this.responseMap = responseMap;
    }

    private String getTraceId() {
        return RequestContext.get().getTraceId();
    }

    public void calculate() {
        LOGGER.info("calculate\u2014begin,calRecordId = {},calBatchId = {},calType = {}", new Object[]{this.calParamVO.getRecordId(), this.calParamVO.getRecordId(), this.calParamVO.getCalType()});
        Date startDate = new Date();
        if (CalUtils.isTerminationCal(Long.valueOf(this.calParamVO.getRecordId()))) {
            return;
        }
        String threadName = Thread.currentThread().getName();
        String traceId = this.getTraceId();
        BatchCalResultParamVO batchResultVO = new BatchCalResultParamVO();
        HandleCalProrationHelper calProrationHelper = new HandleCalProrationHelper(this.calParamVO, this.calPersonIdList);
        try {
            calProrationHelper.dealProration();
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
            LOGGER.error("dealProration error,calBatchId = {},traceId = {},errorMsg = {}", new Object[]{this.calParamVO.getCalBatchId(), traceId, ex.getMessage()});
            String msg = ex.getMessage();
            if (msg == null) {
                msg = ResManager.loadKDString((String)"\u5206\u6bb5\u5904\u7406\u5931\u8d25\uff1a\u672a\u77e5\u5f02\u5e38\u3002", (String)"CalculationService_1", (String)"swc-hscs-business", (Object[])new Object[0]);
            }
            this.addCalOperation(this.calParamVO.getCalType(), startDate, 0, this.calPersonIdList.size());
            this.handleException(batchResultVO, msg);
            return;
        }
        Map<String, Object> calItemQueryDataMap = this.getCalItemDataMap(calProrationHelper, batchResultVO, traceId);
        if (calItemQueryDataMap == null) {
            LOGGER.info("calItemQueryDataMap is null,traceId={}", (Object)traceId);
            this.addCalOperation(this.calParamVO.getCalType(), startDate, 0, this.calPersonIdList.size());
            return;
        }
        if (CalUtils.isTerminationCal(Long.valueOf(this.calParamVO.getRecordId()))) {
            return;
        }
        CalParamCacheInfo calParamCacheInfo = this.calParamVO.getCalParamMap();
        batchResultVO.setItemCount(calParamCacheInfo.getItemCount());
        batchResultVO.setRecurBizDataIdSet((Set)calItemQueryDataMap.get("recurBizDataIdSet"));
        batchResultVO.setNonRecurBizDataIdSet((Set)calItemQueryDataMap.get("nonRecurBizDataIdSet"));
        batchResultVO.setAttBizDataSummaryIdSet((Set)calItemQueryDataMap.get("attBizDataSummaryIdSet"));
        batchResultVO.setAttBizDataDetailIdSet((Set)calItemQueryDataMap.get("attBizDataDetailIdSet"));
        batchResultVO.setInsuranceCalpersonMap((Map)calItemQueryDataMap.get("insurancedataCalpersonMap"));
        batchResultVO.setCalRecordList((List)calItemQueryDataMap.get("fetchAttBizDataFailList"));
        ArrayList accInfoList = new ArrayList(10);
        if (!SWCListUtils.isEmpty((List)calParamCacheInfo.getAccInfoList())) {
            accInfoList.addAll(calParamCacheInfo.getAccInfoList());
        }
        if (calParamCacheInfo.getPreTaxAccMap() != null && calParamCacheInfo.getPreTaxAccMap().size() > 0) {
            accInfoList.addAll(calParamCacheInfo.getPreTaxAccMap().values());
        }
        List successCalPersonList = (List)calItemQueryDataMap.get("successCalPersonList");
        batchResultVO.setAccInfoList(accInfoList);
        try {
            FormulaParse formulaCalImpl = this.getSalaryCalClass(threadName);
            FormulaParse convertFormulaCalImpl = this.getConvertFormulaCalClass(threadName);
            SalaryCalServiceHelper calServiceHelper = new SalaryCalServiceHelper(this.calParamVO, traceId);
            CalculationService.setCalServiceHelperProp(calServiceHelper, calItemQueryDataMap, calProrationHelper);
            String calType = this.calParamVO.getCalType();
            CalValidSalaryItemHelper calValidSalaryItemHelper = new CalValidSalaryItemHelper(successCalPersonList, this.calParamVO.getCalTaskId(), calType, traceId);
            HashMap<Long, HashSet<String>> calPersonSLItemRelMap = calValidSalaryItemHelper.getCalPersonAndRelationSIUniqueCodeMap();
            for (Long calPersonId : successCalPersonList) {
                calServiceHelper.salaryItemCal(formulaCalImpl, calPersonId, calPersonSLItemRelMap, calType, convertFormulaCalImpl, batchResultVO);
            }
        }
        catch (Exception ex) {
            LOGGER.error("call error,traceId = {}", (Object)traceId);
            LOGGER.error("call error", (Throwable)ex);
            String msg = ex.getMessage();
            if (msg == null) {
                msg = ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\uff1a\u672a\u77e5\u5f02\u5e38\u3002", (String)"CalculationService_4", (String)"swc-hscs-business", (Object[])new Object[0]);
            }
            String errorElement = CalReportUtils.getErrorElement(FailureTypeEnum.CAL_FAIL.getCode(), null);
            List<CalRecordVO> calRecordList = CalUtils.getCalRecordList(this.calPersonIdList, msg, FailureTypeEnum.CAL_FAIL.getCode(), errorElement);
            List calRecords = batchResultVO.getCalRecordList();
            if (!SWCListUtils.isEmpty((List)calRecords)) {
                calRecordList.addAll(calRecords);
            }
            batchResultVO.setCalRecordList(calRecordList);
        }
        String resultKey = String.format(Locale.ROOT, "calbatch_result_%s", UUID.randomUUID().toString());
        ISWCAppCache resultCache = SWCAppCache.get((String)resultKey);
        try {
            String resultJsonString = SerializationUtils.toJsonString((Object)batchResultVO);
            LOGGER.info("cache result start,calBatchId = {},startTime={}", (Object)this.calParamVO.getCalBatchId(), (Object)System.currentTimeMillis());
            resultCache.put("result_cache_key", (Object)resultJsonString);
            LOGGER.info("cache result end,calBatchId = {},endTime = {}", (Object)this.calParamVO.getCalBatchId(), (Object)System.currentTimeMillis());
        }
        catch (Exception ex) {
            LOGGER.error("cal cache result error", (Throwable)ex);
        }
        if (this.isSyncCal) {
            FormulaCalRecord formulaCalRecord = new FormulaCalRecord(Long.valueOf(this.calParamVO.getCalTaskId()), Long.valueOf(this.calParamVO.getRecordId()), Long.valueOf(this.calParamVO.getCalBatchId()), this.isSyncCal, this.responseMap);
            formulaCalRecord.saveCalResultData(resultKey, this.calParamVO.getCalType(), false, this.calPersonIdList);
        } else {
            CalUtils.sendSaveMessage(this.calParamVO.getCalBatchId(), this.calParamVO.getCalTaskId(), this.calParamVO.getRecordId(), resultKey, this.calParamVO.getCalType(), this.calParamVO.getResultCheck(), this.calPersonIdList);
        }
        this.addCalOperation(this.calParamVO.getCalType(), startDate, 0, 0);
        LOGGER.info("calculate\u2014end,calRecordId = {},calBatchId = {},calType = {}", new Object[]{this.calParamVO.getRecordId(), this.calParamVO.getRecordId(), this.calParamVO.getCalType()});
    }

    private void addCalOperation(String calType, Date startDate, int successCount, int failCout) {
        CalOperationVO operationVO = CalUtils.genCalOperationObj(RequestContext.get().getTraceId(), calType, successCount, failCout);
        CalUtils.addCalOperation(Long.parseLong(this.calParamVO.getRecordId()), Long.parseLong(this.calParamVO.getCalBatchId()), OperationTypeEnum.FECTHDATA.getCode(), startDate, operationVO);
    }

    public static void setCalServiceHelperProp(SalaryCalServiceHelper calServiceHelper, Map<String, Object> calItemQueryDataMap, HandleCalProrationHelper calProrationHelper) {
        calServiceHelper.setItemParamMap((Map)calItemQueryDataMap.get("itemResultParamMap"));
        calServiceHelper.setItemSectionParamMap((Map)calItemQueryDataMap.get("itemSectionResultParamMap"));
        calServiceHelper.setSlItemResultMap((Map)calItemQueryDataMap.get("slItemResultMap"));
        calServiceHelper.setSlItemSectionResultMap((Map)calItemQueryDataMap.get("slItemSectionResultMap"));
        calServiceHelper.setAllAccDetailsMap((Map)calItemQueryDataMap.get("allAccDetailsDataMap"));
        calServiceHelper.setAllDataReaderDataMap((Map)calItemQueryDataMap.get("fetchItemDataMap"));
        calServiceHelper.setCalResultDataMap((Map)calItemQueryDataMap.get("calResultDataMap"));
        calServiceHelper.setSpItemCalResultMap((Map)calItemQueryDataMap.get("spItemCalResultMap"));
        calServiceHelper.setItemSectionMap(calProrationHelper.getItemSectionMap());
        calServiceHelper.setCalConvertSectionMap(calProrationHelper.getCalConvertSectionMap());
        calServiceHelper.setSlItemConvertRelMap(calProrationHelper.getSlItemConvertRelMap());
        calServiceHelper.setSlItemProrationIndexMap(calProrationHelper.getSlItemProrationIndexMap());
    }

    private FormulaParse getSalaryCalClass(String threadName) {
        String key = String.format(Locale.ROOT, "salaryItemCal_%s_%s", threadName, this.calParamVO.getCalBatchId());
        FormulaParse formulaCalImpl = this.threadClassMap.get(key);
        if (formulaCalImpl == null) {
            formulaCalImpl = (FormulaParse)this.formulaParse.clone();
            this.threadClassMap.put(key, formulaCalImpl);
        }
        return formulaCalImpl;
    }

    private FormulaParse getConvertFormulaCalClass(String threadName) {
        if (this.convertFormulaCal == null) {
            return null;
        }
        String key = String.format(Locale.ROOT, "convertCal_%s_%s", threadName, this.calParamVO.getCalBatchId());
        FormulaParse convertFormulaCalImpl = this.threadClassMap.get(key);
        if (convertFormulaCalImpl == null) {
            convertFormulaCalImpl = (FormulaParse)this.convertFormulaCal.clone();
            this.threadClassMap.put(key, convertFormulaCalImpl);
        }
        return convertFormulaCalImpl;
    }

    private Map<String, Object> getCalItemDataMap(HandleCalProrationHelper calProrationHelper, BatchCalResultParamVO batchResultVO, String traceId) {
        try {
            FormulaFecthData fecthData = new FormulaFecthData(this.calPersonIdList, this.calParamVO, calProrationHelper.getFtItemProrateRangeQueryMap(), calProrationHelper.getBsItemProrateRangeQueryMap(), false);
            Map<String, Object> calParamMap = fecthData.getCalItemData();
            return calParamMap;
        }
        catch (Exception ex) {
            LOGGER.error("getCalItemDataMap error,calBatchId = {},traceId = {},errorMsg = {}", new Object[]{this.calParamVO.getCalBatchId(), traceId, ex.getMessage()});
            LOGGER.error((Throwable)ex);
            String msg = ex.getMessage();
            if (msg == null) {
                msg = ResManager.loadKDString((String)"\u53d6\u6570\u5931\u8d25\uff1a\u672a\u77e5\u5f02\u5e38\u3002", (String)"CalculationService_5", (String)"swc-hscs-business", (Object[])new Object[0]);
            }
            this.handleException(batchResultVO, msg);
            return null;
        }
    }

    private void handleException(BatchCalResultParamVO batchResultVO, String msg) {
        String errorElement = CalReportUtils.getErrorElement(FailureTypeEnum.FETCHDATA_FAIL.getCode(), null);
        List<CalRecordVO> calRecordList = CalUtils.getCalRecordList(this.calPersonIdList, msg, FailureTypeEnum.FETCHDATA_FAIL.getCode(), errorElement);
        String resultKey = String.format(Locale.ROOT, "calbatch_result_%s", UUID.randomUUID().toString());
        batchResultVO.setCalRecordList(calRecordList);
        ISWCAppCache resultCache = SWCAppCache.get((String)resultKey);
        resultCache.put("result_cache_key", (Object)SerializationUtils.toJsonString((Object)batchResultVO));
        if (this.isSyncCal) {
            FormulaCalRecord formulaCalRecord = new FormulaCalRecord(Long.valueOf(this.calParamVO.getCalTaskId()), Long.valueOf(this.calParamVO.getRecordId()), Long.valueOf(this.calParamVO.getCalBatchId()), this.isSyncCal, this.responseMap);
            formulaCalRecord.saveCalResultData(resultKey, this.calParamVO.getCalType(), false, this.calPersonIdList);
        } else {
            CalUtils.sendSaveMessage(this.calParamVO.getCalBatchId(), this.calParamVO.getCalTaskId(), this.calParamVO.getRecordId(), resultKey, this.calParamVO.getCalType(), this.calParamVO.getResultCheck(), this.calPersonIdList);
        }
    }
}

