/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.tool;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hscs.business.cal.base.FormulaParse;
import kd.swc.hscs.business.cal.fetchdata.FormulaFecthData;
import kd.swc.hscs.business.cal.generateclass.FormulaAnalysis;
import kd.swc.hscs.business.cal.helper.CalValidSalaryItemHelper;
import kd.swc.hscs.business.cal.helper.HandleCalParamsHelper;
import kd.swc.hscs.business.cal.helper.HandleCalProrationHelper;
import kd.swc.hscs.business.cal.helper.SalaryCalServiceHelper;
import kd.swc.hscs.business.cal.service.CalService;
import kd.swc.hscs.business.cal.service.CalculationService;
import kd.swc.hscs.business.cal.service.HandleParamsBeforeCalService;
import kd.swc.hscs.business.cal.service.PreTaxCalService;
import kd.swc.hscs.common.vo.BatchCalResultParamVO;
import kd.swc.hscs.common.vo.CalParamCacheInfo;
import kd.swc.hscs.common.vo.CalParamVO;

public class CalPerformanceService {
    private static final Log log = LogFactory.getLog(CalPerformanceService.class);

    public byte[] getCalClass(Long calTaskId) throws Exception {
        log.info("getCalClass start,calTaskId = {}", (Object)calTaskId);
        CalParamCacheInfo calParamInfo = new CalParamCacheInfo();
        DynamicObject calTaskInfo = HandleParamsBeforeCalService.getCalTaskInfo(calTaskId);
        HandleCalParamsHelper.dealCalRuleDataAndCacheCalParam(calParamInfo, calTaskInfo.getLong("calrulev.id"), calTaskInfo.getString("calversionno"), calTaskInfo.getLong("country.id"), calTaskInfo.getLong("org.id"));
        byte[] calClassArr = FormulaAnalysis.getCalClassByteArray(calParamInfo.getFormulaList(), calParamInfo.getFcMap());
        log.info("getCalClass end,calTaskId = {}", (Object)calTaskId);
        return calClassArr;
    }

    public Map<String, Object> calPerformanceReportData(Long calTaskId, List<Long> calPersonIdList) throws Exception {
        log.info("calPerformanceReportData start,calTaskId = {},calPersonIdList size = {}", (Object)calTaskId, calPersonIdList);
        String calType = "cal";
        Long calRecordId = DB.genLongId((String)"t_hsas_calrecord");
        log.info("calRecordId = {}", (Object)calRecordId);
        long startTime = System.currentTimeMillis();
        HandleParamsBeforeCalService handleParamsBeforeCalService = new HandleParamsBeforeCalService();
        CalParamCacheInfo calParamCacheInfo = handleParamsBeforeCalService.handleParamsBeforCal(calTaskId, calRecordId, calType);
        CalParamVO calParamVO = PreTaxCalService.getCalParamVO(calTaskId, calParamCacheInfo, calType);
        long stepTwoTime = System.currentTimeMillis();
        FormulaParse formulaCalImpl = CalService.createAndGetCalClass(calParamCacheInfo);
        FormulaParse convertFormulaCalImpl = CalService.createConvertCalClass(calParamCacheInfo);
        long stepThreeTime = System.currentTimeMillis();
        HandleCalProrationHelper calProrationHelper = new HandleCalProrationHelper(calParamVO, calPersonIdList);
        calProrationHelper.dealProration();
        long stepFourTime = System.currentTimeMillis();
        FormulaFecthData fecthData = new FormulaFecthData(calPersonIdList, calParamVO, calProrationHelper.getFtItemProrateRangeQueryMap(), calProrationHelper.getBsItemProrateRangeQueryMap(), true);
        Map<String, Object> calItemQueryDataMap = fecthData.getCalItemData();
        long stepFiveTime = System.currentTimeMillis();
        String traceId = RequestContext.get().getTraceId();
        SalaryCalServiceHelper calServiceHelper = new SalaryCalServiceHelper(calParamVO, traceId);
        CalculationService.setCalServiceHelperProp(calServiceHelper, calItemQueryDataMap, calProrationHelper);
        CalValidSalaryItemHelper calValidSalaryItemHelper = new CalValidSalaryItemHelper(calPersonIdList, calParamVO.getCalTaskId(), calType, traceId);
        BatchCalResultParamVO batchResultVO = new BatchCalResultParamVO();
        HashMap<Long, HashSet<String>> calPersonSLItemRelMap = calValidSalaryItemHelper.getCalPersonAndRelationSIUniqueCodeMap();
        for (Long calPersonId : calPersonIdList) {
            calServiceHelper.salaryItemCal(formulaCalImpl, calPersonId, calPersonSLItemRelMap, calType, convertFormulaCalImpl, batchResultVO);
        }
        long endTime = System.currentTimeMillis();
        Map<String, Object> fetchConsumeTimeMap = fecthData.getFetchConsumeTimeMap();
        Map<Long, Map<String, Long>> formulaConsumeTimeMap = calServiceHelper.getFormulaConsumeTimeMap();
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("fetchConsumeTimeMap", fetchConsumeTimeMap);
        resultMap.put("formulaConsumeTimeMap", formulaConsumeTimeMap);
        resultMap.put("totalConsumeTime", endTime - startTime);
        resultMap.put("handleParamsBeforCal", stepTwoTime - startTime);
        resultMap.put("createCalClass", stepThreeTime - stepTwoTime);
        resultMap.put("fecthData", stepFiveTime - stepFourTime);
        resultMap.put("cal", endTime - stepFiveTime);
        log.info("calPerformanceReportData end,calTaskId = {},calPersonIdList size = {}", (Object)calTaskId, calPersonIdList);
        return resultMap;
    }
}

