/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cost.runnable;

import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;

public class CostSetUpSaveRunnable
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(CostSetUpSaveRunnable.class);
    private List<DynamicObject> costSetupRstList;

    public CostSetUpSaveRunnable(List<DynamicObject> costSetupRstList) {
        this.costSetupRstList = costSetupRstList;
    }

    @Override
    public void run() {
        this.saveCostInfo();
    }

    private void saveCostInfo() {
        try {
            LOGGER.info("CostSetUpSaveRunnable costSetupRstList size:{}", (Object)this.costSetupRstList.size());
            if (!SWCListUtils.isEmpty(this.costSetupRstList)) {
                this.removeEmptyCostSetUpRst(this.costSetupRstList);
                LOGGER.info("CostSetUpSaveRunnable costSetupRstList finally not empty size:{}", (Object)this.costSetupRstList.size());
                DynamicObject[] costSetupRstArray = this.costSetupRstList.toArray(new DynamicObject[0]);
                SWCDataServiceHelper setUpRstHelper = new SWCDataServiceHelper("pcs_costsetuprst");
                setUpRstHelper.save(costSetupRstArray);
            }
        }
        catch (Exception e) {
            LOGGER.error("CostSetUpSaveRunnable save fail message:", (Object)e.getMessage());
        }
    }

    private void removeEmptyCostSetUpRst(List<DynamicObject> costSetupRstList) {
        if (!SWCListUtils.isEmpty(costSetupRstList)) {
            Iterator<DynamicObject> iterator = costSetupRstList.iterator();
            while (iterator.hasNext()) {
                DynamicObject costSetupRstObj = iterator.next();
                DynamicObjectCollection costSetUpRstEntryColl = costSetupRstObj.getDynamicObjectCollection("entryentity");
                if (!SWCListUtils.isEmpty((List)costSetUpRstEntryColl)) continue;
                iterator.remove();
            }
        }
    }
}

