/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cost.runnable;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.costallocation.entity.CostAllocationProgressInfo;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hscs.business.cost.helper.GenerateCostSetUpHelper;
import kd.swc.hscs.business.cost.service.GenerateCostSetUpService;
import kd.swc.hscs.business.cost.vo.SetUpCommonInfo;

public class GenerateCostSetUpRunnable
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(GenerateCostSetUpRunnable.class);
    private SetUpCommonInfo setUpCommonInfo;
    private RequestContext requestContext;
    private List<Long> salaryfileIdList;

    public GenerateCostSetUpRunnable(SetUpCommonInfo setUpCommonInfo, List<Long> salaryfileIdList, RequestContext requestContext) {
        this.setUpCommonInfo = setUpCommonInfo;
        this.requestContext = requestContext;
        this.salaryfileIdList = salaryfileIdList;
    }

    @Override
    public void run() {
        this.doGenerateCostSetUpTask();
    }

    private void doGenerateCostSetUpTask() {
        Long calTaskId = this.setUpCommonInfo.getCalTaskId();
        try {
            String threadName = Thread.currentThread().getName();
            LOGGER.info("doGenerateCostSetUpTask begin threadName :{}", (Object)threadName);
            RequestContext.copyAndSet((RequestContext)this.requestContext);
            String isTermination = (String)AppCache.get((String)"pcs").get(String.format(Locale.ROOT, "istermination_%s", calTaskId.toString()), String.class);
            int result = 0;
            if (!"true".equals(isTermination)) {
                GenerateCostSetUpService createCostSetUpService = new GenerateCostSetUpService(this.setUpCommonInfo, this.salaryfileIdList);
                result = createCostSetUpService.generateCostSetUp(this.setUpCommonInfo.getGenerateStrategy());
                this.updateCostStatusAndProgressInfo(calTaskId, result);
            } else {
                LOGGER.info("isTermination is true.");
                GenerateCostSetUpHelper.dealTermination(calTaskId);
            }
        }
        catch (Exception e) {
            AppCache.get((String)"pcs").remove(String.format(Locale.ROOT, "istermination_%s", calTaskId.toString()));
            LOGGER.error("GenerateCostSetUpRunnable doGenerateCostSetUpTask execute task fail:", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCostStatusAndProgressInfo(Long calTaskId, int result) {
        int currentSalaryfileIdSize = this.salaryfileIdList.size();
        int salaryfileIdListSize = this.salaryfileIdList.size();
        Long costAllocationId = this.setUpCommonInfo.getCostAllocationId();
        Long costAllocationRecordId = this.setUpCommonInfo.getCostAllocationRecordId();
        String lockKey = "_updateCostStatusAndProgressInfo_" + calTaskId;
        DLock lock = DLock.create((String)lockKey);
        try {
            if (lock.tryLock(5000L)) {
                this.setProgressInfo(calTaskId, currentSalaryfileIdSize, result);
                this.updateCostStatus(calTaskId, salaryfileIdListSize, costAllocationId, costAllocationRecordId);
            } else {
                LOGGER.error("GenerateCostSetUpRunnable updateCostStatusAndProgressInfo tryLock fail,calTaskId =", (Object)calTaskId);
            }
        }
        catch (Exception e) {
            LOGGER.error("GenerateCostSetUpRunnable updateCostStatusAndProgressInfo fail:", (Object)e.getMessage());
        }
        finally {
            lock.unlock();
            lock.close();
        }
    }

    private void updateCostStatus(Long calTaskId, int salaryfileIdListSize, Long costAllocationId, Long costAllocationRecordId) {
        CostAllocationProgressInfo costAllocationProgressInfo = GenerateCostSetUpRunnable.getProgressInfoFromCache(calTaskId);
        int total = costAllocationProgressInfo.getTotal();
        int finishCache = costAllocationProgressInfo.getFinish();
        LOGGER.info(MessageFormat.format("GenerateCostSetUpRunnable updateCostStatusAndProgressInfo total:{0}, finishCache:{1}, salaryfileIdListSize:{2}", total, finishCache, salaryfileIdListSize));
        if (total == finishCache || total == salaryfileIdListSize) {
            ISWCAppCache appCache = SWCAppCache.get((String)"generateCostSetUp_newConst_appCache");
            appCache.remove(this.setUpCommonInfo.getCostStruId().toString());
            int failCount = costAllocationProgressInfo.getFail();
            GenerateCostSetUpHelper.updateCostAllocationStatus(costAllocationId, failCount == 0 ? "1" : "4");
            GenerateCostSetUpHelper.updateCostAllocationRecordInfo(costAllocationRecordId, failCount == 0 ? "1" : "4", failCount);
        }
    }

    private void setProgressInfo(Long calTaskId, int currentSalaryfileIdSize, int result) {
        CostAllocationProgressInfo costAllocationProgressInfo = GenerateCostSetUpRunnable.getProgressInfoFromCache(calTaskId);
        int total = costAllocationProgressInfo.getTotal();
        int finishCache = costAllocationProgressInfo.getFinish();
        int totalFinish = finishCache + currentSalaryfileIdSize;
        int failCount = costAllocationProgressInfo.getFail();
        costAllocationProgressInfo.setStatus(totalFinish == total ? 2 : 1);
        costAllocationProgressInfo.setFinish(totalFinish);
        costAllocationProgressInfo.setFail(result == 0 ? failCount : failCount + currentSalaryfileIdSize);
        String key = String.format(Locale.ROOT, "cache_costallocation_key_%s", calTaskId);
        SWCAppCache.get((String)"pcs").put(key, (Object)costAllocationProgressInfo);
    }

    public static CostAllocationProgressInfo getProgressInfoFromCache(Long calTaskId) {
        String key = String.format(Locale.ROOT, "cache_costallocation_key_%s", calTaskId);
        CostAllocationProgressInfo costAllocationProgressInfo = (CostAllocationProgressInfo)SWCAppCache.get((String)"pcs").get(key, CostAllocationProgressInfo.class);
        if (costAllocationProgressInfo == null) {
            costAllocationProgressInfo = new CostAllocationProgressInfo();
        }
        return costAllocationProgressInfo;
    }
}

