/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.costallot.runnable;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.log.HRLog;
import kd.hr.hbp.common.log.HRLogFactory;
import kd.sdk.swc.hscs.common.events.CostAllotDetailArgs;
import kd.sdk.swc.hscs.service.api.ICostAllotDetailService;
import kd.swc.hsbp.business.costallocation.entity.CostAllocationProgressInfo;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cost.util.CostLogUtils;
import kd.swc.hscs.business.costallot.helper.CostAllotDetailExtService;
import kd.swc.hscs.business.costallot.helper.CostCreateAllotDetailHelper;
import kd.swc.hscs.business.costallot.service.AllotExrateService;
import kd.swc.hscs.business.costallot.vo.AllotCostDealInfo;
import kd.swc.hscs.business.costallot.vo.AllotDetailEntryInfo;
import kd.swc.hscs.business.costallot.vo.CostAllotDetailInfo;
import kd.swc.hscs.common.enums.CostAllotFeedbackEnum;

public class CostAllotDetailRunnable
implements Runnable {
    private static final HRLog HR_LOG = HRLogFactory.getLog((String)"pcs_costlog", CostAllotDetailRunnable.class);
    private static final Log LOGGER = LogFactory.getLog(CostAllotDetailRunnable.class);
    private RequestContext requestContext;
    private Long calTaskId;
    private Long costAllotDyId;
    private Long recordId;
    private Long costStruId;
    private Long costAdapterId;
    private Long adaptionOrgId;
    private Long costAdapterCurrencyId;
    private int total;
    private int successCount;
    private int failedCount = 0;
    private int amtPrecision;
    private String strategy;
    private String batchId;
    private List<String> failList;
    private List<String> successList;
    private List<Long> salaryFileList;
    private List<Long> batchList;
    private List<DynamicObject> updateCalPersonList;
    private List<Long> correctCalPersonIdList;
    private List<Long> calAmountZeroPersonList;
    private List<String> messageList;
    private HashSet<String> feedBackDetailSet;
    private Map<Long, DynamicObject> salaryFileIdRefOBjMap;
    private DynamicObject calTask;
    private DynamicObject costAdapterObj;
    private DynamicObjectCollection saveAllotDetailColl;
    private DynamicObjectCollection saveFeedbackDetailColl;
    private CostAllotDetailInfo costAllotDetailInfo;
    private AllotExrateService allotExrateService;

    public CostAllotDetailRunnable(RequestContext requestContext, Long calTaskId, Long costAllotDyId, Long recordId, String strategy, DynamicObject costAdapterObj, List<Long> batchList, int total, List<Long> salaryFileList, String batchId) {
        this.requestContext = requestContext;
        this.calTaskId = calTaskId;
        this.costAllotDyId = costAllotDyId;
        this.recordId = recordId;
        this.strategy = strategy;
        this.costAdapterObj = costAdapterObj;
        this.batchList = batchList;
        this.total = total;
        this.salaryFileList = salaryFileList;
        this.batchId = batchId;
        this.saveFeedbackDetailColl = new DynamicObjectCollection();
        this.saveAllotDetailColl = new DynamicObjectCollection();
        this.correctCalPersonIdList = new ArrayList<Long>(10);
        this.calAmountZeroPersonList = new ArrayList<Long>(10);
        this.updateCalPersonList = new ArrayList<DynamicObject>(10);
        this.failList = new ArrayList<String>(10);
        this.successList = new ArrayList<String>(10);
        this.messageList = new ArrayList<String>(10);
        this.feedBackDetailSet = new HashSet(16);
        this.allotExrateService = new AllotExrateService();
        this.costAllotDetailInfo = new CostAllotDetailInfo();
    }

    @Override
    public void run() {
        try {
            String isDetailTermination = (String)AppCache.get((String)"pcs").get(String.format(Locale.ROOT, "isdetailtermination_%s", this.calTaskId), String.class);
            LOGGER.info("updateAllotProcess one isDetailTermination:{}", (Object)isDetailTermination);
            if (!"true".equals(isDetailTermination)) {
                this.generateCostAllot();
                LOGGER.info("updateAllotProcess one batchId:{}", (Object)this.batchId);
                if (StringUtils.isNotBlank((CharSequence)this.batchId)) {
                    this.updateAllotProcessWithHsas(this.batchId, this.calTaskId, this.costAllotDyId, this.batchList.size(), this.successCount, this.feedBackDetailSet);
                } else {
                    this.updateAllotProcessWithPcs(this.calTaskId, this.costAllotDyId, this.batchList.size());
                }
            } else {
                LOGGER.info("isDetailTermination is true.");
                CostCreateAllotDetailHelper.dealTermination(this.calTaskId);
            }
        }
        catch (Exception e) {
            AppCache.get((String)"pcs").remove(String.format(Locale.ROOT, "isdetailtermination_%s", this.calTaskId));
            LOGGER.error("execute CostAllotDetailRunnable fail:{}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllotProcessWithPcs(Long calTaskId, Long costAllotDyId, int batchTotal) {
        String lockKey = "_updateAllotProcessWithPcs_" + calTaskId;
        DLock lock = DLock.create((String)lockKey);
        try {
            if (lock.tryLock(10000L)) {
                LOGGER.info("updateAllotProcessWithPcs secord go to lock ");
                CostCreateAllotDetailHelper.setProgressInfo(calTaskId, batchTotal, this.successCount, 0);
                CostAllocationProgressInfo costAllocationProgressInfo = CostCreateAllotDetailHelper.getProgressInfoFromCache(calTaskId);
                int total = costAllocationProgressInfo.getTotal();
                int finishCache = costAllocationProgressInfo.getFinish();
                int fail = costAllocationProgressInfo.getFail();
                int costFileNumber = finishCache + fail;
                LOGGER.info("updateAllotProcessWithPcs three totalSum :{}", (Object)costFileNumber);
                LOGGER.info(MessageFormat.format("GenerateCostAllotDetailRunnable updateAllotProcessWithPcs total:{0}, costFileNumber:{1}", total, costFileNumber));
                if (total == costFileNumber) {
                    LOGGER.info("updateAllotProcessWithPcs four updateCostAllotStatus ");
                    CostCreateAllotDetailHelper.updateCostAllotStatus(costAllotDyId, "1");
                    CostCreateAllotDetailHelper.updateCostAllocationRecordInfo(this.recordId, fail == 0 ? "1" : "4", fail);
                }
            } else {
                LOGGER.error("updateAllotProcessWithPcs tryLock fail,calTaskId{}", (Object)calTaskId);
            }
        }
        finally {
            lock.unlock();
            lock.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllotProcessWithHsas(String batchId, Long calTaskId, Long costAllotDyId, int totalNum, int successNum, HashSet<String> errorInfos) {
        String lockKey = "_updateAllotProcessWithHsas_" + batchId + calTaskId;
        DLock lock = DLock.create((String)lockKey);
        try {
            if (lock.tryLock(10000L)) {
                LOGGER.info("updateAllotProcessWithHsas secord go to lock ");
                CostCreateAllotDetailHelper.updateProcess(batchId, calTaskId, totalNum, successNum, errorInfos);
                ISWCAppCache appCache = SWCAppCache.get((String)"SWC_PAYROLL_TASK");
                HashMap process = (HashMap)appCache.get("process" + batchId + calTaskId, HashMap.class);
                int totalSum = (Integer)process.get("successCount") + (Integer)process.get("failCount");
                LOGGER.info(MessageFormat.format("GenerateCostAllotDetailRunnable updateAllotProcessWithHsas three totalSum:{0}, total:{1}", totalSum, this.total));
                if (totalSum == this.total) {
                    LOGGER.info("updateAllotProcessWithHsas four updateCostAllotStatus ");
                    int failCount = (Integer)process.get("failCount");
                    CostCreateAllotDetailHelper.updateCostAllotStatus(costAllotDyId, "1");
                    CostCreateAllotDetailHelper.updateCostAllocationRecordInfo(this.recordId, failCount == 0 ? "1" : "4", failCount);
                }
            } else {
                LOGGER.error("updateAllotProcessWithHsas tryLock fail,batchId{},calTaskId{}", (Object)batchId, (Object)calTaskId);
            }
        }
        finally {
            lock.unlock();
            lock.close();
        }
    }

    private CostAllotDetailInfo generateCostAllot() {
        this.costAdapterId = this.costAdapterObj.getLong("id");
        this.adaptionOrgId = this.costAdapterObj.getLong("createorg.id");
        this.amtPrecision = this.costAdapterObj.getInt("currency.amtprecision");
        this.costAdapterCurrencyId = this.costAdapterObj.getLong("currency.id");
        this.costStruId = this.costAdapterObj.getLong("coststru.id");
        String threadName = Thread.currentThread().getName();
        LOGGER.info("generateCostAllot begin threadName :{}", (Object)threadName);
        int len = this.batchList.size();
        LOGGER.info("############start create costallot,current batch size is : {}", (Object)len);
        this.calTask = CostCreateAllotDetailHelper.queryCalTaskById(this.calTaskId);
        String propertity = "id,salaryfile,allotstatus,onholdstatus,calstatus,calresultid,org,adminorg,empentrelv,empgroup,empposorgrelhrv";
        DynamicObject[] calPersonArr = CostCreateAllotDetailHelper.queryCalPersonIdsByCalPersonIds(propertity, this.batchList);
        Map<String, List<Long>> packageCalInfo = CostCreateAllotDetailHelper.packgeCalInfo(calPersonArr);
        List<Long> salaryFileIdList = packageCalInfo.get("salaryfileIdList");
        this.salaryFileIdRefOBjMap = CostCreateAllotDetailHelper.getSalaryfileIdRefOBjMap(salaryFileIdList);
        Map<String, Object> setupInfoMap = CostCreateAllotDetailHelper.packegeSetupInfo(this.calTaskId, salaryFileIdList);
        Map salaryFileIdRefSalaryItemMap = (Map)setupInfoMap.get("salaryfileIdRefsalaryItemMap");
        Map costSetupConstIdRefCostSetupConstValMap = (Map)setupInfoMap.get("costSetupConstIdRefCostSetupConstValMap");
        List<Long> calTableIdList = packageCalInfo.get("calTableIdList");
        Map<Long, DynamicObject> calTableIdRefCalTableObjMap = CostCreateAllotDetailHelper.getCalTableIdRefCalTableObjMap(calTableIdList);
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        HashMap<String, String> calStateMap = new HashMap<String, String>(16);
        for (DynamicObject calPerson : calPersonArr) {
            if (!this.validateCalStatus(calPerson, calStateMap)) continue;
            Long salaryFileId = calPerson.getLong("salaryfile.id");
            this.messageList.add(String.format(Locale.ROOT, "########salaryfile.id is : %s#############", salaryFileId));
            Map<String, DynamicObject> salaryFileSetupMap = this.getCostSetup(salaryFileIdRefSalaryItemMap, salaryFileId, calPerson);
            if (salaryFileSetupMap == null) continue;
            long calTableId = calPerson.getLong("calresultid");
            this.messageList.add(String.format(Locale.ROOT, "########calresultid is : %s#############", calTableId));
            DynamicObject calTable = calTableIdRefCalTableObjMap.get(calTableId);
            if (calTable == null) continue;
            DynamicObjectCollection calTableEntry = calTable.getDynamicObjectCollection("hsas_caltableentry");
            this.dealCalPersonEntry(salaryFileSetupMap, calTableEntry, calPerson, costSetupConstIdRefCostSetupConstValMap);
            String messageStr = StringUtils.join((Object[])this.messageList.toArray(), (String)"\n");
            CostLogUtils.info(HR_LOG, this.recordId, messageStr);
            this.messageList.clear();
        }
        this.updateOrSaveAllot(this.failList, this.successList, len, packageCalInfo, this.strategy, this.salaryFileList);
        if (!this.saveFeedbackDetailColl.isEmpty()) {
            for (DynamicObject feedbackDetailDy : this.saveFeedbackDetailColl) {
                String feedBackDetail = feedbackDetailDy.getString("feedbackdetail");
                this.feedBackDetailSet.add(feedBackDetail);
            }
        }
        this.costAllotDetailInfo.setFailedCount(this.failedCount);
        this.costAllotDetailInfo.setSuccessCount(this.successCount);
        this.costAllotDetailInfo.setFeedBackDetailSet(this.feedBackDetailSet);
        this.costAllotDetailInfo.setFailList(this.failList);
        this.costAllotDetailInfo.setSuccessList(this.successList);
        this.saveAllotDetailColl = null;
        calTableIdRefCalTableObjMap.clear();
        setupInfoMap.clear();
        return this.costAllotDetailInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrSaveAllot(List<String> failList, List<String> successList, int len, Map<String, List<Long>> packgeCalInfo, String strategy, List<Long> salaryFileList) {
        try (TXHandle txHandle = TX.requiresNew();){
            List<Long> calPersonIdList;
            List<Long> feedBackCalIdList = packgeCalInfo.get("feedBackCalIdList");
            if (!feedBackCalIdList.isEmpty()) {
                QFilter feedBackCalIdListFilter = new QFilter("caltableid", "in", feedBackCalIdList);
                DeleteServiceHelper.delete((String)"pcs_allotfeedback", (QFilter[])new QFilter[]{feedBackCalIdListFilter});
            }
            if (!(calPersonIdList = packgeCalInfo.get("calPersonIdList")).isEmpty()) {
                QFilter calPersonIdFilter = new QFilter("caltableid", "in", calPersonIdList);
                calPersonIdFilter.and(new QFilter("issyspreset", "=", (Object)Boolean.FALSE));
                DeleteServiceHelper.delete((String)"pcs_allotdetail", (QFilter[])new QFilter[]{calPersonIdFilter});
            }
            if (!this.saveAllotDetailColl.isEmpty()) {
                SWCDataServiceHelper allotDetailHelper = new SWCDataServiceHelper("pcs_allotdetail");
                QFilter qFilter = new QFilter("caltask", "=", (Object)this.calTaskId);
                if (SWCStringUtils.equals((String)"2", (String)strategy)) {
                    qFilter.and(new QFilter("salaryfile.id", "in", salaryFileList));
                    allotDetailHelper.deleteByFilter(new QFilter[]{qFilter});
                    this.saveAllotDetailColl.removeIf(dynamicObject -> !salaryFileList.contains(dynamicObject.getLong("salaryfile.id")));
                }
                CostAllotDetailExtService extService = new CostAllotDetailExtService();
                CostAllotDetailArgs args = new CostAllotDetailArgs(this.saveAllotDetailColl);
                HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, ICostAllotDetailService.class, (String)"kd.sdk.swc.hscs.service.api.ICostAllotDetailService#setCostAllotDetailFields", null);
                hrPluginProxy.callReplaceIfPresent(proxy -> {
                    proxy.setCostAllotDetailFields(args);
                    return null;
                });
                allotDetailHelper.save(this.saveAllotDetailColl);
                List collect = this.saveAllotDetailColl.stream().map(result -> result.getString("salaryfile.id")).distinct().collect(Collectors.toList());
                this.successCount = collect.size();
                LOGGER.info("saved allotDetail success! successCount size is : {}", (Object)this.successCount);
                if (!this.updateCalPersonList.isEmpty()) {
                    DynamicObject[] calPersonArr = CostCreateAllotDetailHelper.queryCalPersonArr(this.correctCalPersonIdList);
                    CostCreateAllotDetailHelper.updateCalPersonAllotStatus(calPersonArr);
                    LOGGER.info("update CalPerson AllotStatus success!");
                }
            }
            if (!this.calAmountZeroPersonList.isEmpty()) {
                DynamicObject[] calAmountZeroPersonArr = CostCreateAllotDetailHelper.queryCalPersonArr(this.calAmountZeroPersonList);
                CostCreateAllotDetailHelper.updateCalPersonAllotStatus(calAmountZeroPersonArr);
                this.successCount += this.calAmountZeroPersonList.size();
                LOGGER.info("update calAmountZeroPersonArr AllotStatus success!");
            }
            if (!this.saveFeedbackDetailColl.isEmpty()) {
                SWCDataServiceHelper allotFeedbackHelper = new SWCDataServiceHelper("pcs_allotfeedback");
                allotFeedbackHelper.save(this.saveFeedbackDetailColl);
            }
            this.updateCalPersonList.clear();
            this.correctCalPersonIdList.forEach(param -> successList.add(String.valueOf(param)));
            this.calAmountZeroPersonList.forEach(param -> successList.add(String.valueOf(param)));
            LOGGER.info("saved allotDetail getCalPerson successList.size is : {}", (Object)successList.size());
            this.correctCalPersonIdList.clear();
        }
    }

    private boolean validateCalStatus(DynamicObject calPerson, Map<String, String> calStateMap) {
        String errorDesc = this.getValidateCalErrorInfo(calPerson, calStateMap);
        String errorCode = errorDesc.split("#")[0];
        String errorMsg = errorDesc.split("#")[1];
        if (!CostAllotFeedbackEnum.NORMAL.getCode().equals(errorCode)) {
            CostAllotFeedbackEnum feedbackEnum = CostAllotFeedbackEnum.NORMAL;
            if (CostAllotFeedbackEnum.ALLOTCREATED.getCode().equals(errorCode)) {
                feedbackEnum = CostAllotFeedbackEnum.ALLOTCREATED;
            } else if (CostAllotFeedbackEnum.NOAUDIT.getCode().equals(errorCode)) {
                feedbackEnum = CostAllotFeedbackEnum.NOAUDIT;
            }
            this.saveFeedbackDetailColl.add((Object)this.createAllotFeedback(calPerson, feedbackEnum, errorMsg));
            ++this.failedCount;
            return false;
        }
        return true;
    }

    private DynamicObject createAllotFeedback(DynamicObject calPerson, CostAllotFeedbackEnum allotFeedbackEnum, String desc) {
        SWCDataServiceHelper allotFeedbackHelper = new SWCDataServiceHelper("pcs_allotfeedback");
        DynamicObject allotFeedbackObj = allotFeedbackHelper.generateEmptyDynamicObject();
        allotFeedbackObj.set("caltableid", (Object)calPerson.getLong("id"));
        allotFeedbackObj.set("salaryfile", (Object)calPerson.getDynamicObject("salaryfile"));
        allotFeedbackObj.set("caltask", (Object)this.calTaskId);
        allotFeedbackObj.set("feedbacktime", (Object)new Date());
        allotFeedbackObj.set("feedbacktype", (Object)allotFeedbackEnum.getCode());
        allotFeedbackObj.set("feedbackdetail", (Object)(desc == null ? allotFeedbackEnum.getDesc().getDescription() : desc));
        return allotFeedbackObj;
    }

    public String getValidateCalErrorInfo(DynamicObject calPerson, Map<String, String> calStateMap) {
        String format = "%s#%s";
        String calState = calPerson.getString("calstatus");
        if (CalStateEnum.UNCAL.getCode().equals(calState) || CalStateEnum.PARTIAL_CALED.getCode().equals(calState)) {
            String calStateDesc = calStateMap.get(calState);
            if (SWCStringUtils.isEmpty((String)calStateDesc)) {
                calStateDesc = CalStateEnum.getDesc((String)calState);
                calStateMap.put(calState, calStateDesc);
            }
            return String.format(format, CostAllotFeedbackEnum.NOAUDIT.getCode(), String.format(Locale.ROOT, CostAllotFeedbackEnum.NOAUDIT.getDesc().getDescription(), calStateDesc));
        }
        String allotStatus = calPerson.getString("allotstatus");
        if ("B".equals(allotStatus)) {
            return String.format(Locale.ROOT, format, CostAllotFeedbackEnum.ALLOTCREATED.getCode(), CostAllotFeedbackEnum.ALLOTCREATED.getDesc().getDescription());
        }
        return String.format(Locale.ROOT, format, CostAllotFeedbackEnum.NORMAL.getCode(), CostAllotFeedbackEnum.NORMAL.getDesc().getDescription());
    }

    private Map<String, DynamicObject> getCostSetup(Map<String, Map<String, DynamicObject>> costSetupMap, Long salaryFileId, DynamicObject calPerson) {
        Map<String, DynamicObject> costSetUp = costSetupMap.get(salaryFileId.toString());
        if (costSetUp == null || this.validateCostSetupIsAllNull(costSetUp.values())) {
            this.saveFeedbackDetailColl.add((Object)this.createAllotFeedback(calPerson, CostAllotFeedbackEnum.NOCOSTSETUP, CostAllotFeedbackEnum.NOCOSTSETUP.getDesc().getDescription()));
            ++this.failedCount;
            return null;
        }
        return costSetUp;
    }

    private boolean validateCostSetupIsAllNull(Collection<DynamicObject> costSetups) {
        for (DynamicObject costSetup : costSetups) {
            DynamicObjectCollection entryEntity = costSetup.getDynamicObjectCollection("entryentity");
            if (entryEntity.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void dealCalPersonEntry(Map<String, DynamicObject> salaryFileSetupMap, DynamicObjectCollection calTableEntry, DynamicObject calPerson, Map<Long, String> costSetupConstIdRefCostSetupConstValMap) {
        long calPersonId = calPerson.getLong("id");
        Long calCurrencyId = this.calTask.getLong("payrollgroupv.currency.id");
        HashMap<Long, AllotCostDealInfo> allotCostDealInfoMap = new HashMap<Long, AllotCostDealInfo>(calTableEntry.size());
        int calAmountZeroNum = 0;
        for (int ii = 0; ii < calTableEntry.size(); ++ii) {
            DynamicObject dynamicObject = (DynamicObject)calTableEntry.get(ii);
            if (dynamicObject.getInt("slprorationindex") != 0) continue;
            int entryFailCount = 0;
            BigDecimal assBigDecimalSum = BigDecimal.ZERO;
            BigDecimal calBigDecimalSum = BigDecimal.ZERO;
            BigDecimal calAmount = dynamicObject.getBigDecimal("calamountvalue");
            BigDecimal isNotRevealAmount = dynamicObject.getBigDecimal("calamountvalue");
            if (calAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.messageList.add("calAmount is zero....");
                if (++calAmountZeroNum != calTableEntry.size()) continue;
                this.calAmountZeroPersonList.add(calPersonId);
                continue;
            }
            long calEntrySalaryItemId = dynamicObject.getLong("salaryitem.id");
            String calEntrySalaryItemIdStr = String.valueOf(calEntrySalaryItemId);
            DynamicObject salaryItemCostSetup = salaryFileSetupMap.get(calEntrySalaryItemIdStr);
            if (salaryItemCostSetup == null) {
                String calEntrySalaryItemName = dynamicObject.getString("salaryitem.name");
                this.messageList.add(String.format(Locale.ROOT, "salaryitem is %s, has no costsetup.", calEntrySalaryItemName));
                continue;
            }
            Long costItemId = salaryItemCostSetup.getLong("costitem.id");
            if (costItemId == null || costItemId == 0L) {
                this.messageList.add("salaryItemCostSetup has no costItem");
                continue;
            }
            DynamicObjectCollection salaryItemCostSetupEntry = salaryItemCostSetup.getDynamicObjectCollection("entryentity");
            if (salaryItemCostSetupEntry.isEmpty()) continue;
            HashMap<String, String> receralDetailInfoMap = new HashMap<String, String>(16);
            boolean dealAllotResultFlag = false;
            boolean isRevealDetail = false;
            BigDecimal allotrateSum = BigDecimal.ZERO;
            for (int i = 0; i < salaryItemCostSetupEntry.size(); ++i) {
                DynamicObject salaryItemCostSetupEntObj = (DynamicObject)salaryItemCostSetupEntry.get(i);
                Long costSetupConstId = salaryItemCostSetupEntObj.getLong("defcostsetupconst.id");
                String costSetupConstIdStr = String.valueOf(costSetupConstId);
                String costSetupConstVal = salaryItemCostSetupEntObj.getString("defcostsetupconstval");
                String costItemIdStr = costItemId.toString();
                AllotCostDealInfo allotCostDealInfo = (AllotCostDealInfo)allotCostDealInfoMap.get(costSetupConstId);
                if (allotCostDealInfo == null) {
                    allotCostDealInfo = new AllotCostDealInfo();
                    allotCostDealInfoMap.put(costSetupConstId, allotCostDealInfo);
                }
                Map<String, Map<String, Object>> salaryItemInfoMap = allotCostDealInfo.getSalaryitemInfoMap();
                Map<String, AllotDetailEntryInfo> costSetupAllotInfoMap = allotCostDealInfo.getCostSetupAllotInfoMap();
                BigDecimal allotRate = salaryItemCostSetupEntObj.getBigDecimal("percentage");
                allotrateSum = allotrateSum.add(allotRate);
                if (BigDecimal.valueOf(100L).compareTo(allotrateSum) == 0 && salaryItemCostSetupEntry.size() > 1 && i == salaryItemCostSetupEntry.size() - 1) {
                    isRevealDetail = true;
                    this.messageList.add("pay attention to generatecostallotdetail isRevealDetail is true, because percentage is 100");
                }
                if (!isRevealDetail) {
                    isRevealDetail = salaryItemCostSetupEntObj.getBoolean("isrevealdetail");
                }
                if (isRevealDetail) {
                    receralDetailInfoMap.put("costSetupConstId", costSetupConstIdStr);
                    receralDetailInfoMap.put("ostSetupConstVal", costSetupConstVal);
                    this.correctCalPersonIdList.add(calPersonId);
                    continue;
                }
                Map<String, Object> salaryItemInfo = salaryItemInfoMap.get(calEntrySalaryItemIdStr);
                if (salaryItemInfo == null) {
                    salaryItemInfo = new HashMap<String, Object>(16);
                    salaryItemInfo.put("totalResidueAllotAmount", calAmount);
                    salaryItemInfo.put("residueAmount", calAmount);
                    salaryItemInfoMap.put(calEntrySalaryItemIdStr, salaryItemInfo);
                }
                allotCostDealInfo.setSalaryitemInfoMap(salaryItemInfoMap);
                BigDecimal totalResidueAllotAmount = (BigDecimal)salaryItemInfo.get("totalResidueAllotAmount");
                if (totalResidueAllotAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                AllotDetailEntryInfo allotDetailEntryInfo = costSetupAllotInfoMap.get(costItemIdStr + '_' + calEntrySalaryItemIdStr);
                if (allotDetailEntryInfo == null) {
                    allotDetailEntryInfo = this.initAllotDetailEntryInfo(calCurrencyId, calEntrySalaryItemId, calEntrySalaryItemIdStr, costItemIdStr, costSetupAllotInfoMap);
                }
                DynamicObject calSalaryItemObj = dynamicObject.getDynamicObject("salaryitem");
                BigDecimal setupAssuAmount = allotDetailEntryInfo.getAssuamount();
                BigDecimal setupCalCurAssuAmount = allotDetailEntryInfo.getCalamount();
                allotRate = allotRate.divide(new BigDecimal("100"));
                BigDecimal setupMaxAmount = salaryItemCostSetupEntObj.getBigDecimal("maxmount");
                Date exrateDate = this.calTask.getDate("exratedate");
                Long exrateTableId = this.calTask.getLong("payrollgroupv.exratetable.id");
                if (setupMaxAmount != null && setupMaxAmount.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal setupMaxAmt2CalCurrencyAmt = this.allotExrateService.getExratedAmount(this.costAdapterCurrencyId, calCurrencyId, exrateDate, exrateTableId, setupMaxAmount);
                    BigDecimal rateAmount = calAmount.abs().multiply(allotRate);
                    BigDecimal calAmt2AllotCurrencyAmt = this.allotExrateService.getExratedAmount(calCurrencyId, this.costAdapterCurrencyId, exrateDate, exrateTableId, rateAmount);
                    if (setupMaxAmt2CalCurrencyAmt.compareTo(rateAmount) >= 0) {
                        setupCalCurAssuAmount = setupCalCurAssuAmount.add(rateAmount);
                        setupAssuAmount = setupAssuAmount.add(calAmt2AllotCurrencyAmt);
                    } else {
                        BigDecimal setupMaxAmount2CalCurAmount = this.allotExrateService.getExratedAmount(calCurrencyId, this.costAdapterCurrencyId, exrateDate, exrateTableId, setupMaxAmount);
                        setupCalCurAssuAmount = setupCalCurAssuAmount.add(setupMaxAmount2CalCurAmount);
                        setupAssuAmount = setupAssuAmount.add(setupMaxAmount);
                    }
                    calAmount = calAmount.subtract(setupCalCurAssuAmount);
                } else {
                    setupCalCurAssuAmount = setupCalCurAssuAmount.add(isNotRevealAmount.multiply(allotRate));
                    setupAssuAmount = this.allotExrateService.getExratedAmount(calCurrencyId, this.costAdapterCurrencyId, exrateDate, exrateTableId, setupCalCurAssuAmount);
                    calAmount = calAmount.subtract(setupCalCurAssuAmount);
                }
                String validateAmtResult = CostCreateAllotDetailHelper.validateAmtArr(calSalaryItemObj.getString("name"), setupCalCurAssuAmount, setupAssuAmount);
                if (!SWCStringUtils.isEmpty((String)validateAmtResult)) {
                    this.addFeedBack(calPerson, entryFailCount, CostAllotFeedbackEnum.AMT_FORMAT_ERROR, validateAmtResult);
                    continue;
                }
                int round = this.allotExrateService.exchangeDataround(calSalaryItemObj.getString("dataround.number"));
                int calCruPrecision = this.calTask.getInt("payrollgroupv.currency.amtprecision");
                allotDetailEntryInfo.setCalamount(this.allotExrateService.getScaleFormatValue(setupCalCurAssuAmount, calCruPrecision, round));
                allotDetailEntryInfo.setAssuamount(this.allotExrateService.getScaleFormatValue(setupAssuAmount, this.amtPrecision, round));
                assBigDecimalSum = assBigDecimalSum.add(this.allotExrateService.getScaleFormatValue(setupCalCurAssuAmount, calCruPrecision, round));
                calBigDecimalSum = calBigDecimalSum.add(this.allotExrateService.getScaleFormatValue(setupAssuAmount, this.amtPrecision, round));
                dealAllotResultFlag = true;
            }
            this.messageList.add(String.format(Locale.ROOT, "########allotrate is : %s ########.", allotrateSum));
            if (!receralDetailInfoMap.isEmpty() && calAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.messageList.add("go into  dealRevealDetail");
                this.dealRevealDetail(dynamicObject, receralDetailInfoMap, allotCostDealInfoMap, costItemId, assBigDecimalSum, calBigDecimalSum);
            }
            if (!dealAllotResultFlag) continue;
            this.correctCalPersonIdList.add(calPersonId);
        }
        this.sumAllotCostDealResult(allotCostDealInfoMap);
        for (Map.Entry<Long, AllotCostDealInfo> entry : allotCostDealInfoMap.entrySet()) {
            this.saveAllotDetail(calPerson, entry, costSetupConstIdRefCostSetupConstValMap);
        }
        calPerson.set("allotstatus", (Object)"B");
        this.updateCalPersonList.add(calPerson);
    }

    private AllotDetailEntryInfo initAllotDetailEntryInfo(Long calCurrencyId, long calEntrySalaryItemId, String calEntrySalaryItemIdStr, String costItemIdStr, Map<String, AllotDetailEntryInfo> costSetupAllotInfoMap) {
        AllotDetailEntryInfo allotDetailEntryInfo = new AllotDetailEntryInfo();
        allotDetailEntryInfo.setSalaryitem(calEntrySalaryItemId);
        allotDetailEntryInfo.setCalcurrency(calCurrencyId);
        allotDetailEntryInfo.setAssucurrency(this.costAdapterCurrencyId);
        allotDetailEntryInfo.setCalamount(BigDecimal.ZERO);
        allotDetailEntryInfo.setAssuamount(BigDecimal.ZERO);
        allotDetailEntryInfo.setOriamount(BigDecimal.ZERO);
        costSetupAllotInfoMap.put(costItemIdStr + '_' + calEntrySalaryItemIdStr, allotDetailEntryInfo);
        return allotDetailEntryInfo;
    }

    private void sumAllotCostDealResult(Map<Long, AllotCostDealInfo> allotCostDealInfoMap) {
        for (Map.Entry<Long, AllotCostDealInfo> allotCostDealInfoMapEntry : allotCostDealInfoMap.entrySet()) {
            AllotCostDealInfo allotCostDealInfo = allotCostDealInfoMapEntry.getValue();
            Map<String, AllotDetailEntryInfo> costSetupAllotInfoMap = allotCostDealInfo.getCostSetupAllotInfoMap();
            HashMap<String, AllotDetailEntryInfo> resultMap = new HashMap<String, AllotDetailEntryInfo>(16);
            for (Map.Entry<String, AllotDetailEntryInfo> entry : costSetupAllotInfoMap.entrySet()) {
                String key = entry.getKey();
                String costItemId = key.substring(0, key.indexOf(95));
                AllotDetailEntryInfo existAllotDetailEntryInfo = (AllotDetailEntryInfo)resultMap.get(costItemId);
                AllotDetailEntryInfo value = entry.getValue();
                if (existAllotDetailEntryInfo != null) {
                    BigDecimal calAmount = value.getCalamount();
                    BigDecimal assuAmount = value.getAssuamount();
                    BigDecimal calAmountExist = existAllotDetailEntryInfo.getCalamount();
                    BigDecimal assuAmountExist = existAllotDetailEntryInfo.getAssuamount();
                    value.setCalamount(calAmount.add(calAmountExist));
                    value.setAssuamount(assuAmount.add(assuAmountExist));
                }
                resultMap.put(costItemId, value);
            }
            allotCostDealInfo.setCostSetupAllotInfoMap(resultMap);
        }
    }

    private void addFeedBack(DynamicObject calPerson, int entryFailCount, CostAllotFeedbackEnum allotFeedbackEnum, String exrateErrorMsg) {
        LOGGER.info(SWCStringUtils.isEmpty((String)exrateErrorMsg) ? allotFeedbackEnum.getDesc().getDescription() : exrateErrorMsg);
        this.saveFeedbackDetailColl.add((Object)this.createAllotFeedback(calPerson, allotFeedbackEnum, exrateErrorMsg));
        this.failedCount = entryFailCount == 0 ? this.failedCount + 1 : this.failedCount;
    }

    private void saveAllotDetail(DynamicObject calPerson, Map.Entry<Long, AllotCostDealInfo> allotCostDealInfoMapEntry, Map<Long, String> costSetupConstIdRefCostSetupConstValMap) {
        Long costSetupConstId = allotCostDealInfoMapEntry.getKey();
        Date exrateDate = this.calTask.getDate("exratedate");
        Date payrollDate = this.calTask.getDate("payrolldate");
        Long exrateTable = this.calTask.getLong("payrollgroupv.exratetable.id");
        Long calCurrencyId = this.calTask.getLong("payrollgroupv.currency.id");
        long salaryFileId = calPerson.getLong("salaryfile.id");
        DynamicObject salaryFile = this.salaryFileIdRefOBjMap.get(salaryFileId);
        DynamicObject allotDetailObj = CostCreateAllotDetailHelper.createCostAllotDynamicObj(calPerson, this.calTask, salaryFile);
        ExchangeRateInfo cal2AllotExrateInfo = this.allotExrateService.getExrate(calCurrencyId, this.costAdapterCurrencyId, exrateDate, exrateTable);
        ExchangeRateInfo allot2calExrateInfo = this.allotExrateService.getExrate(this.costAdapterCurrencyId, calCurrencyId, exrateDate, exrateTable);
        allotDetailObj.set("caltask", (Object)this.calTaskId);
        allotDetailObj.set("coststru", (Object)this.costStruId);
        allotDetailObj.set("personorg", (Object)this.adaptionOrgId);
        allotDetailObj.set("costadapter", (Object)this.costAdapterId);
        allotDetailObj.set("costsetupconst", (Object)costSetupConstId);
        allotDetailObj.set("belongperiod", (Object)payrollDate);
        allotDetailObj.set("costsetupconstval", (Object)costSetupConstIdRefCostSetupConstValMap.get(costSetupConstId));
        allotDetailObj.set("caexrate", (Object)cal2AllotExrateInfo.getExchangeRate());
        allotDetailObj.set("acexratequotetype", (Object)(cal2AllotExrateInfo.getQuoteType() != false ? "1" : "0"));
        allotDetailObj.set("acexrate", (Object)allot2calExrateInfo.getExchangeRate());
        allotDetailObj.set("caexratequotetype", (Object)(allot2calExrateInfo.getQuoteType() != false ? "1" : "0"));
        AllotCostDealInfo allotCostDealInfo = allotCostDealInfoMapEntry.getValue();
        Map<String, AllotDetailEntryInfo> costSetupAllotInfoMap = allotCostDealInfo.getCostSetupAllotInfoMap();
        SWCDataServiceHelper allotDetailHelper = new SWCDataServiceHelper("pcs_allotdetail");
        for (Map.Entry<String, AllotDetailEntryInfo> entry : costSetupAllotInfoMap.entrySet()) {
            String costItemId = entry.getKey();
            AllotDetailEntryInfo allotDetailEntry = entry.getValue();
            DynamicObject allotDetailEntryObj = allotDetailHelper.generateEmptyEntryDynamicObject("pcs_allotdetailentry");
            allotDetailEntryObj.set("costitem", (Object)Long.valueOf(costItemId));
            allotDetailEntryObj.set("calcurrency", (Object)allotDetailEntry.getCalcurrency());
            allotDetailEntryObj.set("calamount", (Object)allotDetailEntry.getCalamount());
            allotDetailEntryObj.set("assucurrency", (Object)allotDetailEntry.getAssucurrency());
            allotDetailEntryObj.set("assuamount", (Object)allotDetailEntry.getAssuamount());
            allotDetailObj.getDynamicObjectCollection("pcs_allotdetailentry").add((Object)allotDetailEntryObj);
        }
        this.saveAllotDetailColl.add((Object)allotDetailObj);
    }

    private void dealRevealDetail(DynamicObject calTableEnt, Map<String, String> receralDetailInfoMap, Map<Long, AllotCostDealInfo> allotCostDealInfoMap, Long costItemId, BigDecimal assBigDecimalSum, BigDecimal calBigDecimalSum) {
        Map<String, AllotDetailEntryInfo> costSetupAllotInfoMap;
        AllotDetailEntryInfo allotDetailEntryInfo;
        BigDecimal calAmount = calTableEnt.getBigDecimal("calamountvalue");
        String costSetupConstIdStr = receralDetailInfoMap.get("costSetupConstId");
        Long costSetupConstIdLong = Long.valueOf(costSetupConstIdStr);
        Date exrateDate = this.calTask.getDate("exratedate");
        Long exrateTableId = this.calTask.getLong("payrollgroupv.exratetable.id");
        Long calCurrencyId = this.calTask.getLong("payrollgroupv.currency.id");
        long calEntrySalaryItemId = calTableEnt.getLong("salaryitem.id");
        String calEntrySalaryItemIdStr = String.valueOf(calEntrySalaryItemId);
        AllotCostDealInfo allotCostDealInfo = allotCostDealInfoMap.get(Long.valueOf(costSetupConstIdStr));
        if (allotCostDealInfo == null) {
            allotCostDealInfo = new AllotCostDealInfo();
            allotCostDealInfoMap.put(costSetupConstIdLong, allotCostDealInfo);
        }
        if ((allotDetailEntryInfo = (costSetupAllotInfoMap = allotCostDealInfo.getCostSetupAllotInfoMap()).get(costItemId.toString() + '_' + calEntrySalaryItemIdStr)) == null) {
            allotDetailEntryInfo = new AllotDetailEntryInfo();
            ExchangeRateInfo cal2AllotExrateInfo = this.allotExrateService.getExrate(calCurrencyId, this.costAdapterCurrencyId, exrateDate, exrateTableId);
            ExchangeRateInfo allot2calExrateInfo = this.allotExrateService.getExrate(this.costAdapterCurrencyId, calCurrencyId, exrateDate, exrateTableId);
            allotDetailEntryInfo.setCaexrate(cal2AllotExrateInfo);
            allotDetailEntryInfo.setAcexrate(allot2calExrateInfo);
            allotDetailEntryInfo.setCalcurrency(calCurrencyId);
            allotDetailEntryInfo.setAssucurrency(this.costAdapterCurrencyId);
            allotDetailEntryInfo.setSalaryitem(costItemId);
            allotDetailEntryInfo.setCalamount(BigDecimal.ZERO);
            allotDetailEntryInfo.setAssuamount(BigDecimal.ZERO);
            costSetupAllotInfoMap.put(costItemId.toString() + '_' + calEntrySalaryItemIdStr, allotDetailEntryInfo);
        }
        BigDecimal setupAssuAmount = this.allotExrateService.getExratedAmount(calCurrencyId, this.costAdapterCurrencyId, exrateDate, exrateTableId, calAmount);
        DynamicObject calSalaryItemObj = calTableEnt.getDynamicObject("salaryitem");
        int round = this.allotExrateService.exchangeDataround(calSalaryItemObj.getString("dataround.number"));
        setupAssuAmount = this.allotExrateService.getScaleFormatValue(setupAssuAmount, this.amtPrecision, round);
        BigDecimal subtractCalAmount = calAmount.subtract(assBigDecimalSum);
        BigDecimal subtractAssuamount = setupAssuAmount.subtract(calBigDecimalSum);
        allotDetailEntryInfo.setCalamount(subtractCalAmount.add(allotDetailEntryInfo.getCalamount()));
        allotDetailEntryInfo.setAssuamount(subtractAssuamount.add(allotDetailEntryInfo.getAssuamount()));
    }
}

