/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.hisdata.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hscs.business.extpoint.IHisDataCheckExtService;
import kd.sdk.swc.hscs.common.events.HisDataTaskCheckEvent;
import kd.sdk.swc.hscs.common.hisdatacheck.DataCheckFailDTO;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.ImportTaskFailMsgEnum;
import kd.swc.hsbp.common.enums.WriteTaskTypeEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskVO;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.business.hisdata.check.HisDataCheckExtService;
import kd.swc.hscs.business.hisdata.utils.DataCheckUtils;
import org.jetbrains.annotations.NotNull;

public class DataCheckServiceTask
implements Callable<String> {
    private static final Log logger = LogFactory.getLog(DataCheckServiceTask.class);
    private RequestContext requestContext;
    private List<DynamicObject> temporaryList;
    private DynamicObject calTask;
    private Long verifyRecordId;
    private String writeTaskType;
    private Map<String, Long> empGroupMap;
    private Map<String, Long> adminOrgMap;

    public DataCheckServiceTask(RequestContext requestContext, List<DynamicObject> temporaryList, Long verifyRecordId, DynamicObject calTask, String writeTaskType, Map<String, Long> empGroupMap, Map<String, Long> adminOrgMap) {
        this.requestContext = requestContext;
        this.temporaryList = temporaryList;
        this.verifyRecordId = verifyRecordId;
        this.calTask = calTask;
        this.writeTaskType = writeTaskType;
        this.empGroupMap = empGroupMap;
        this.adminOrgMap = adminOrgMap;
    }

    @Override
    public String call() throws Exception {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        logger.info("dataCheckTask begin,importTaskId={},traceId={}", (Object)this.calTask.getLong("id"), (Object)RequestContext.get().getTraceId());
        try {
            if (DataCheckUtils.isCancelOperate(this.verifyRecordId)) {
                logger.info("cancelOperate");
                return null;
            }
            HashSet<String> empNumberSet = new HashSet<String>(16);
            HashSet<String> fileNumberSet = new HashSet<String>(16);
            for (DynamicObject obj : this.temporaryList) {
                if (SWCStringUtils.isEmpty((String)obj.getString("filenumber"))) {
                    empNumberSet.add(obj.getString("empnumber"));
                    continue;
                }
                fileNumberSet.add(obj.getString("filenumber"));
            }
            DynamicObjectCollection checkPassList = new DynamicObjectCollection();
            Map<String, List<DynamicObject>> personMap = this.getPersonData(empNumberSet);
            Map<String, DynamicObject> fileMap = this.getSalaryFileData(fileNumberSet);
            DynamicObjectCollection verifyList = new DynamicObjectCollection();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_verifydetail");
            DynamicObjectCollection noCheckPassList = new DynamicObjectCollection();
            HashMap<Long, DynamicObject> temporaryMap = new HashMap<Long, DynamicObject>(16);
            DynamicObject salaryFile = null;
            for (DynamicObject temporary : this.temporaryList) {
                if (SWCStringUtils.isEmpty((String)temporary.getString("filenumber"))) {
                    this.checkDataForNoFileNumber(checkPassList, personMap, verifyList, (DynamicObjectType)type, noCheckPassList, temporary);
                    continue;
                }
                salaryFile = fileMap.get(temporary.getString("filenumber"));
                if (salaryFile == null) {
                    verifyList.add((Object)DataCheckUtils.getVerifyDetailObj((DynamicObjectType)type, temporary, "0", ImportTaskFailMsgEnum.SALARYFILE_NOT_EXIST, this.verifyRecordId));
                    noCheckPassList.add((Object)temporary);
                    continue;
                }
                if (salaryFile.getLong("payrollgroup.id") != this.calTask.getLong("payrollgroup.id")) {
                    verifyList.add((Object)DataCheckUtils.getVerifyDetailObj((DynamicObjectType)type, temporary, "1", ImportTaskFailMsgEnum.SALARYFILE_AND_PAYROLLGROUP_NOT_MATCH, this.verifyRecordId));
                    noCheckPassList.add((Object)temporary);
                    continue;
                }
                if (!salaryFile.getString("employee.empnumber").equals(temporary.getString("empnumber")) || !salaryFile.getString("employee.person.name").equals(temporary.getString("empname"))) {
                    verifyList.add((Object)DataCheckUtils.getVerifyDetailObj((DynamicObjectType)type, temporary, "1", ImportTaskFailMsgEnum.SALARYFILE_AND_PERSON_NOT_EXIST, this.verifyRecordId));
                    noCheckPassList.add((Object)temporary);
                    continue;
                }
                temporaryMap.put(salaryFile.getLong("id"), temporary);
            }
            checkPassList.addAll((Collection)this.checkFileHasHisAndRepeat(verifyList, (DynamicObjectType)type, noCheckPassList, temporaryMap));
            checkPassList = this.invokeDataCheckExtService(checkPassList, noCheckPassList, verifyList);
            for (DynamicObject obj : noCheckPassList) {
                obj.set("datastatus", (Object)"2");
                obj.set("modifytime", (Object)new Date());
                obj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            }
            int failCount = verifyList.size();
            int successCount = this.temporaryList.size() - failCount;
            checkPassList.addAll((Collection)noCheckPassList);
            if (DataCheckUtils.isCancelOperate(this.verifyRecordId)) {
                logger.info("cancelOperate");
                return null;
            }
            logger.info("successCount={}\uff0cfailCount={}", (Object)successCount, (Object)failCount);
            DataCheckUtils.saveDataCheckResult(verifyList, checkPassList, successCount, failCount, this.verifyRecordId);
        }
        catch (Exception e) {
            logger.error("dataCheckServiceTask error", (Throwable)e);
            DynamicObjectCollection tempList = new DynamicObjectCollection();
            tempList.addAll(this.temporaryList);
            DataCheckUtils.saveDataAfterException(tempList, this.verifyRecordId);
            DataCheckUtils.updateDataCheckProgress(0, tempList.size(), this.verifyRecordId);
        }
        logger.info("dataCheckTask end,importTaskId={},traceId={}", (Object)this.calTask.getLong("id"), (Object)RequestContext.get().getTraceId());
        return null;
    }

    private DynamicObjectCollection invokeDataCheckExtService(DynamicObjectCollection checkPassList, DynamicObjectCollection noCheckPassList, DynamicObjectCollection verifyList) {
        logger.info("invokeDataCheckExtService start");
        if (checkPassList.size() == 0) {
            return checkPassList;
        }
        Map<Long, DynamicObject> dataMap = checkPassList.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj, (k1, k2) -> k1));
        HisDataTaskCheckEvent event = new HisDataTaskCheckEvent(dataMap, new HashMap(16), this.writeTaskType);
        HisDataCheckExtService hisDataCheckExtService = new HisDataCheckExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)hisDataCheckExtService, IHisDataCheckExtService.class, (String)"kd.sdk.swc.hscs.business.extpoint.IHisDataCheckExtService#dataCheck", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.dataCheck(event);
            return null;
        });
        Map checkFailMap = event.getCheckFailMap();
        if (checkFailMap == null || checkFailMap.size() == 0) {
            logger.info("no ext service check");
            return checkPassList;
        }
        CalUtils.printLog("checkFailMap =>", checkFailMap);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_verifydetail");
        DynamicObjectCollection resultList = new DynamicObjectCollection();
        DataCheckFailDTO checkFailDTO = null;
        DynamicObject verify = null;
        for (DynamicObject obj2 : checkPassList) {
            checkFailDTO = (DataCheckFailDTO)checkFailMap.get(obj2.getLong("id"));
            if (checkFailDTO == null) {
                resultList.add((Object)obj2);
                continue;
            }
            verify = DataCheckUtils.getVerifyDetailObj((DynamicObjectType)type, obj2, checkFailDTO.getFailType(), ImportTaskFailMsgEnum.SALARYFILE_AND_PERSON_NOT_EXIST, this.verifyRecordId);
            verify.set("failmsg", (Object)checkFailDTO.getFailMsgValue());
            verify.set("errorelement", (Object)checkFailDTO.getErrorElement());
            verifyList.add((Object)verify);
            noCheckPassList.add((Object)obj2);
        }
        logger.info("invokeDataCheckExtService end");
        return resultList;
    }

    private void checkDataForNoFileNumber(DynamicObjectCollection checkPassList, Map<String, List<DynamicObject>> personMap, DynamicObjectCollection verifyList, DynamicObjectType type, DynamicObjectCollection noCheckPassList, DynamicObject temporary) {
        List<DynamicObject> empObjList = personMap.get(temporary.getString("empnumber"));
        Date workStartDate = temporary.getDate("workstartdate");
        if (SWCListUtils.isEmpty(empObjList)) {
            verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, temporary, "0", ImportTaskFailMsgEnum.PERSON_NOT_EXIST, this.verifyRecordId));
            noCheckPassList.add((Object)temporary);
            return;
        }
        if (workStartDate == null) {
            DynamicObject empObj = empObjList.get(0);
            if (!SWCStringUtils.equals((String)empObj.getString("person.name"), (String)temporary.getString("empname"))) {
                verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, temporary, "1", ImportTaskFailMsgEnum.EMPNUMBER_AND_NAME_NOT_MATCH, this.verifyRecordId));
                noCheckPassList.add((Object)temporary);
                return;
            }
        } else {
            boolean isMatch = false;
            for (DynamicObject empObj : empObjList) {
                if (!SWCStringUtils.equals((String)empObj.getString("person.name"), (String)temporary.getString("empname")) || !SWCDateUtils.isEqual((Date)workStartDate, (Date)empObj.getDate("startdate"))) continue;
                isMatch = true;
                break;
            }
            if (!isMatch) {
                verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, temporary, "1", ImportTaskFailMsgEnum.EMPNUMBER_NAME_AND_WORKSTARTDATE_NOT_MATCH, this.verifyRecordId));
                noCheckPassList.add((Object)temporary);
                return;
            }
        }
        if (SWCStringUtils.isNotEmpty((String)temporary.getString("empgroupname"))) {
            Long empGroupId = this.empGroupMap.get(temporary.getString("empgroupname"));
            if (empGroupId == null) {
                verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, temporary, "0", ImportTaskFailMsgEnum.EMPGROUP_NOT_EXIT, this.verifyRecordId));
                noCheckPassList.add((Object)temporary);
                return;
            }
            temporary.set("empgroup", (Object)empGroupId);
        }
        if (temporary.getDynamicObject("adminorg") == null && SWCStringUtils.isNotEmpty((String)temporary.getString("adminorgname"))) {
            Long adminOrgId = this.adminOrgMap.get(temporary.getString("adminorgname"));
            if (adminOrgId == null) {
                verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, temporary, "0", ImportTaskFailMsgEnum.ADMINORG_NOT_EXIST, this.verifyRecordId));
                noCheckPassList.add((Object)temporary);
                return;
            }
            temporary.set("adminorg", (Object)adminOrgId);
        }
        temporary.set("datastatus", (Object)"3");
        temporary.set("modifytime", (Object)new Date());
        temporary.set("modifier", (Object)RequestContext.get().getCurrUserId());
        checkPassList.add((Object)temporary);
    }

    private Map<String, List<DynamicObject>> getPersonData(Set<String> empNumberSet) {
        if (empNumberSet == null || empNumberSet.size() == 0) {
            return new HashMap<String, List<DynamicObject>>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_employee");
        QFilter filter = new QFilter("empnumber", "in", empNumberSet);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        DynamicObjectCollection result = helper.queryOriginalCollection("empnumber,person.name,startdate", new QFilter[]{filter});
        return result.stream().collect(Collectors.groupingBy(obj -> obj.getString("empnumber")));
    }

    @NotNull
    private DynamicObjectCollection checkFileHasHisAndRepeat(DynamicObjectCollection verifyList, DynamicObjectType type, DynamicObjectCollection noCheckPassList, Map<Long, DynamicObject> temporaryMap) {
        logger.info("checkFileHasHisAndRepeat start,importTaskId={}", (Object)this.calTask.getLong("id"));
        if (temporaryMap.size() == 0) {
            return new DynamicObjectCollection();
        }
        HashMap<Long, ImportTaskFailMsgEnum> repeatCheckErrorMap = new HashMap<Long, ImportTaskFailMsgEnum>(temporaryMap.size());
        Set<Long> tempIdList = temporaryMap.keySet().stream().collect(Collectors.toSet());
        List<Long> salaryFileIdList = this.checkCurrentCalTaskFileRepeatData(this.calTask, tempIdList, repeatCheckErrorMap);
        if (!WriteTaskTypeEnum.HISDATAIMPORT.getCode().equals(this.writeTaskType)) {
            salaryFileIdList = this.checkCalTaskFileIdForCommon(this.calTask, salaryFileIdList, repeatCheckErrorMap);
        }
        Map<Object, Object> salaryFileMap = new HashMap(16);
        if (this.calTask.getLong("payrollscene.id") != 0L) {
            if (salaryFileIdList.size() > 0) {
                CalPayRollTaskVO taskVO = CalPersonHelper.queryCalPayRollTask((Long)this.calTask.getLong("id"), (Long)RequestContext.get().getCurrUserId());
                List salaryFileVidList = CalPersonHelper.getSalaryFileHisByRule((Long)this.calTask.getLong("id"), new HashSet<Long>(salaryFileIdList));
                salaryFileMap = this.getSalaryFileHisData(salaryFileVidList);
            }
        } else {
            salaryFileMap = this.matchSalaryFileHisData(salaryFileIdList);
        }
        DynamicObjectCollection checkPassList = new DynamicObjectCollection();
        DynamicObject salaryFile = null;
        ImportTaskFailMsgEnum tempFail = null;
        DynamicObject temporary = null;
        for (Map.Entry<Long, DynamicObject> entry : temporaryMap.entrySet()) {
            salaryFile = (DynamicObject)salaryFileMap.get(entry.getKey());
            if (salaryFile == null) {
                tempFail = (ImportTaskFailMsgEnum)repeatCheckErrorMap.get(entry.getKey());
                if (tempFail != null) {
                    verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, entry.getValue(), "2", tempFail, this.verifyRecordId));
                } else {
                    verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, entry.getValue(), "0", ImportTaskFailMsgEnum.CAPPERIOD_NOT_EFFECTIVE_VERSION, this.verifyRecordId));
                }
                noCheckPassList.add((Object)entry.getValue());
                continue;
            }
            temporary = entry.getValue();
            DynamicObject adminOrg = temporary.getDynamicObject("adminorg");
            if (adminOrg == null) {
                if (SWCStringUtils.isNotEmpty((String)temporary.getString("adminorgname"))) {
                    if (!SWCStringUtils.equals((String)temporary.getString("adminorgname"), (String)salaryFile.getString("adminorg.name"))) {
                        verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, entry.getValue(), "1", ImportTaskFailMsgEnum.SALARYFILE_AND_ADMINORG_NOT_MATCH, this.verifyRecordId));
                        noCheckPassList.add((Object)entry.getValue());
                        continue;
                    }
                    temporary.set("adminorg", (Object)salaryFile.getLong("adminorg.id"));
                }
            } else if (adminOrg.getLong("id") != salaryFile.getLong("adminorg.id")) {
                verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, entry.getValue(), "1", ImportTaskFailMsgEnum.SALARYFILE_AND_ADMINORG_NOT_MATCH, this.verifyRecordId));
                noCheckPassList.add((Object)entry.getValue());
                continue;
            }
            if (SWCStringUtils.isNotEmpty((String)temporary.getString("empgroupname"))) {
                if (!SWCStringUtils.equals((String)temporary.getString("empgroupname"), (String)salaryFile.getString("empgroup.name"))) {
                    verifyList.add((Object)DataCheckUtils.getVerifyDetailObj(type, entry.getValue(), "1", ImportTaskFailMsgEnum.SALARYFILE_AND_EMPGROUP_NOT_MATCH, this.verifyRecordId));
                    noCheckPassList.add((Object)entry.getValue());
                    continue;
                }
                temporary.set("empgroup", (Object)salaryFile.getLong("empgroup.id"));
            }
            entry.getValue().set("datastatus", (Object)"3");
            entry.getValue().set("modifytime", (Object)new Date());
            entry.getValue().set("modifier", (Object)RequestContext.get().getCurrUserId());
            checkPassList.add((Object)entry.getValue());
        }
        logger.info("checkFileHasHisAndRepeat end,importTaskId={}", (Object)this.calTask.getLong("id"));
        return checkPassList;
    }

    private Map<Long, DynamicObject> matchSalaryFileHisData(List<Long> fileIdList) {
        if (SWCListUtils.isEmpty(fileIdList)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Long currentUserId = RequestContext.get().getCurrUserId();
        QFilter filter = new QFilter("boid", "in", fileIdList);
        filter.and("paystatus", "=", (Object)"1");
        BaseDataHisHelper.addHisVerFilter((QFilter)filter);
        filter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
        filter.and("bsed", "<=", (Object)this.calTask.getDate("enddate"));
        filter.and("bsled", ">=", (Object)this.calTask.getDate("startdate"));
        List qFilterList = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((long)currentUserId, (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"47150e89000000ac");
        if (qFilterList != null) {
            qFilterList.stream().forEach(obj -> filter.and(obj));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObjectCollection fileHisData = helper.queryOriginalCollection("id,boid,adminorg.id,adminorg.name,empgroup.id,empgroup.name", new QFilter[]{filter}, "number asc,bsed desc");
        HashMap<Long, DynamicObject> salaryFileMap = new HashMap<Long, DynamicObject>(fileHisData.size());
        for (DynamicObject obj2 : fileHisData) {
            if (salaryFileMap.containsKey(obj2.getLong("boid"))) continue;
            salaryFileMap.put(obj2.getLong("boid"), obj2);
        }
        return salaryFileMap;
    }

    private Map<String, DynamicObject> getSalaryFileData(Set<String> fileNumberSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        String fields = "id,number,employee.empnumber,employee.person.name,payrollgroup.id";
        QFilter filter = new QFilter("number", "in", fileNumberSet);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        filter.and("status", "in", (Object)new String[]{"C", "B", "A"});
        DynamicObjectCollection list = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        return list.stream().collect(Collectors.toMap(obj -> obj.getString("number"), obj -> obj));
    }

    public Map<Long, DynamicObject> getSalaryFileHisData(List<Long> fileVIdList) {
        if (SWCListUtils.isEmpty(fileVIdList)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        String fields = "id,boid,adminorg.id,adminorg.name,empgroup.id,empgroup.name";
        QFilter filter = new QFilter("id", "in", fileVIdList);
        DynamicObjectCollection list = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        return list.stream().collect(Collectors.toMap(obj -> obj.getLong("boid"), obj -> obj));
    }

    private List<Long> checkCurrentCalTaskFileRepeatData(DynamicObject calTask, Set<Long> salaryFileIdSet, Map<Long, ImportTaskFailMsgEnum> repeatCheckErrorMap) {
        if (salaryFileIdSet.size() == 0) {
            return new ArrayList<Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        String fields = "id,salaryfile.id";
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTask.getLong("id"));
        filter.and("salaryfile.id", "in", salaryFileIdSet);
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        Set<Long> repeatFileIdSet = result.stream().map(obj -> obj.getLong("salaryfile.id")).collect(Collectors.toSet());
        repeatFileIdSet.forEach(obj -> repeatCheckErrorMap.put((Long)obj, ImportTaskFailMsgEnum.SALARYFILE_HAS_EXIST));
        salaryFileIdSet.removeAll(repeatFileIdSet);
        return salaryFileIdSet.stream().collect(Collectors.toList());
    }

    private List<Long> checkCalTaskFileIdForCommon(DynamicObject calTask, List<Long> salaryFileIdList, Map<Long, ImportTaskFailMsgEnum> repeatCheckErrorMap) {
        if (salaryFileIdList.size() == 0) {
            return new ArrayList<Long>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("payrollgroup.id", "=", (Object)calTask.getLong("payrollgroup.id"));
        filter.and("payrollscene.id", "=", (Object)calTask.getLong("payrollscene.id"));
        filter.and("period.id", "=", (Object)calTask.getLong("period.id"));
        filter.and("tasktype", "=", (Object)"0");
        filter.and("taskstatus", "!=", (Object)CalPayrollTaskStateEnum.DISUSED.getCode());
        filter.and("id", "!=", (Object)calTask.getLong("id"));
        DynamicObjectCollection calTaskList = helper.queryOriginalCollection("id", new QFilter[]{filter});
        Set calTaskIdSet = calTaskList.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        if (calTaskIdSet.size() == 0) {
            if ("0".equals(calTask.getString("tasktype"))) {
                return salaryFileIdList;
            }
            salaryFileIdList.forEach(obj -> repeatCheckErrorMap.put((Long)obj, ImportTaskFailMsgEnum.SALARYFILE_NOT_EXIST_IN_CALTASK));
            return new ArrayList<Long>(0);
        }
        helper.setEntityName("hsas_calperson");
        QFilter qFilter = new QFilter("caltask.id", "in", calTaskIdSet);
        qFilter.and("salaryfile.id", "in", salaryFileIdList);
        DynamicObjectCollection result = helper.queryOriginalCollection("salaryfile.id", new QFilter[]{qFilter});
        List<Long> existFileIdList = result.stream().map(obj -> obj.getLong("salaryfile.id")).collect(Collectors.toList());
        if ("0".equals(calTask.getString("tasktype"))) {
            salaryFileIdList.removeAll(existFileIdList);
            existFileIdList.forEach(obj -> repeatCheckErrorMap.put((Long)obj, ImportTaskFailMsgEnum.SALARYFILE_HAS_EXIST_IN_CALTASK));
            return salaryFileIdList;
        }
        salaryFileIdList.removeAll(existFileIdList);
        salaryFileIdList.forEach(obj -> repeatCheckErrorMap.put((Long)obj, ImportTaskFailMsgEnum.SALARYFILE_NOT_EXIST_IN_CALTASK));
        return existFileIdList;
    }
}

