/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.hisdata.writein;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.ImportTaskFailMsgEnum;
import kd.swc.hsbp.common.enums.MigrationFailTypeEnum;
import kd.swc.hscs.business.hisdata.helper.ImportTaskHelper;
import kd.swc.hscs.business.hisdata.utils.DataCheckUtils;
import org.apache.commons.collections.CollectionUtils;

public class ImportTaskUnWriteInAsyncTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(ImportTaskUnWriteInAsyncTask.class);
    private Long calPayRollTaskId;
    private Long importTaskId;
    private List<DynamicObject> temporaryDataList;
    private Long verifyRecordId;
    private List<DynamicObject> saveTempoararyDataList;
    List<DynamicObject> verifyDetailList;
    private CountDownLatch countDownLatch;

    public ImportTaskUnWriteInAsyncTask(Long importTaskId, List<DynamicObject> temporaryDataList, Long calPayRollTaskId, Long verifyRecordId, CountDownLatch countDownLatch) {
        this.importTaskId = importTaskId;
        this.temporaryDataList = temporaryDataList;
        this.calPayRollTaskId = calPayRollTaskId;
        this.verifyRecordId = verifyRecordId;
        this.countDownLatch = countDownLatch;
        this.saveTempoararyDataList = new ArrayList<DynamicObject>(temporaryDataList.size());
        this.verifyDetailList = new ArrayList<DynamicObject>(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("start unWriteInTask");
        if (ImportTaskHelper.checkIsCancel(MessageFormat.format("dataUnWriteIn_progress_{0}", this.importTaskId))) {
            this.countDownLatch.countDown();
            logger.info("cancel unWriteInTask");
            return;
        }
        TXHandle required = TX.required();
        boolean isFail = false;
        HashSet<Long> successCalPersonIdSet = new HashSet<Long>(this.temporaryDataList.size());
        HashMap<Long, ImportTaskFailMsgEnum> failCalPersonMsgMap = new HashMap<Long, ImportTaskFailMsgEnum>(this.temporaryDataList.size());
        int successCount = 0;
        int failCount = 0;
        try {
            Set<Long> calPersonIdSet = this.temporaryDataList.stream().filter(temporaryData -> temporaryData.getLong("calpersonid") != 0L).map(temporaryData -> temporaryData.getLong("calpersonid")).collect(Collectors.toSet());
            ImportTaskHelper.deleteCalPerson(calPersonIdSet, true, successCalPersonIdSet, failCalPersonMsgMap);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_verifydetail");
            for (DynamicObject temporaryData2 : this.temporaryDataList) {
                Long calPersonId = temporaryData2.getLong("calpersonid");
                ImportTaskFailMsgEnum msgEnum = (ImportTaskFailMsgEnum)failCalPersonMsgMap.get(calPersonId);
                if (msgEnum != null) {
                    this.verifyDetailList.add(DataCheckUtils.getVerifyDetailObj((DynamicObjectType)type, temporaryData2, MigrationFailTypeEnum.FAIL_TYPE_RELATION.getCode(), msgEnum, this.verifyRecordId));
                    ++failCount;
                    continue;
                }
                ++successCount;
                temporaryData2.set("calpersonid", null);
                temporaryData2.set("datastatus", (Object)"4");
                this.saveTempoararyDataList.add(temporaryData2);
            }
            this.saveTemporaryData();
        }
        catch (Exception exception) {
            try {
                logger.error("\u53cd\u5199\u5931\u8d25\uff1a", (Throwable)exception);
                isFail = true;
                required.markRollback();
            }
            catch (Throwable throwable) {
                if (!isFail && ImportTaskHelper.checkIsCancel(MessageFormat.format("dataUnWriteIn_progress_{0}", this.importTaskId))) {
                    required.markRollback();
                }
                required.close();
                throw throwable;
            }
            if (!isFail && ImportTaskHelper.checkIsCancel(MessageFormat.format("dataUnWriteIn_progress_{0}", this.importTaskId))) {
                required.markRollback();
            }
            required.close();
        }
        if (!isFail && ImportTaskHelper.checkIsCancel(MessageFormat.format("dataUnWriteIn_progress_{0}", this.importTaskId))) {
            required.markRollback();
        }
        required.close();
        if (!isFail) {
            ImportTaskHelper.updateWriteInProgress(successCount, failCount, this.importTaskId, this.calPayRollTaskId, true, successCalPersonIdSet.size(), this.verifyRecordId, this.verifyDetailList);
        } else {
            this.verifyDetailList.clear();
            ImportTaskHelper.updateWriteInProgress(0, this.temporaryDataList.size(), this.importTaskId, this.calPayRollTaskId, true, 0, this.verifyRecordId, this.verifyDetailList);
        }
        this.countDownLatch.countDown();
        logger.info("end unWriteInTask");
    }

    private void saveTemporaryData() {
        if (CollectionUtils.isEmpty(this.saveTempoararyDataList)) {
            return;
        }
        SWCDataServiceHelper temporaryDataHelper = new SWCDataServiceHelper("hsas_temporarydata");
        DynamicObject[] temporaryDatas = new DynamicObject[this.saveTempoararyDataList.size()];
        temporaryDatas = this.saveTempoararyDataList.toArray(temporaryDatas);
        temporaryDataHelper.save(temporaryDatas);
    }
}

