/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.mq;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.swc.hscs.business.cal.result.FormulaCalRecord;

public class DataSaveConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(DataSaveConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        log.info("DataSaveConsumer.onMessage start,messageId = {},resend = {}", (Object)messageId, (Object)resend);
        this.consumenMessage((Map)message, messageId);
        acker.ack(messageId);
        log.info("DataSaveConsumer.onMessage end,messageId = {}", (Object)messageId);
    }

    private void consumenMessage(Map<String, Object> messageMap, String messageId) {
        Long recordId = Long.parseLong((String)messageMap.get("calRecordId"));
        Long calBatchId = Long.parseLong((String)messageMap.get("calBatchId"));
        Long calTaskId = Long.parseLong((String)messageMap.get("calTaskId"));
        String cacheKey = (String)messageMap.get("result_cache_key");
        String calType = (String)messageMap.get("calType");
        boolean resultCheck = (Boolean)messageMap.get("resultcheck");
        List calPersonIdList = (List)messageMap.get("calPersonIdList");
        Long mqSendTime = (Long)messageMap.get("mqSendTime");
        Long mqReceiveTime = System.currentTimeMillis();
        Long mqWaitConsumeTime = mqReceiveTime - mqSendTime;
        String traceId = RequestContext.get().getTraceId();
        log.info("consumenMessage begin,recordId={},calBatchId={},mqWaitConsumeTime={},messageId={},cacheKey={}", new Object[]{recordId, calBatchId, mqWaitConsumeTime, messageId, cacheKey});
        FormulaCalRecord formulaCalRecord = new FormulaCalRecord(calTaskId, recordId, calBatchId, new Date(), traceId);
        formulaCalRecord.saveCalResultData(cacheKey, calType, resultCheck, calPersonIdList);
        log.info("consumenMessage end,recordId={},calBatchId={},mqEndTime={}", new Object[]{recordId, calBatchId, System.currentTimeMillis()});
    }
}

