/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail;

import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.exchangerate.helper.ExchangeRateHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CreatePayDetailHelper {
    private static final Log log = LogFactory.getLog(CreatePayDetailHelper.class);

    public static ExchangeRateInfo getExrate(DynamicObject calCurrency, DynamicObject payCurrency, Date exrateDate, DynamicObject exrateTable, Map<String, ExchangeRateInfo> exrateMap) {
        Long calCurrencyId = calCurrency.getLong("id");
        Long payCurrencyId = payCurrency.getLong("id");
        Long exratetableId = exrateTable.getLong("id");
        if (SWCStringUtils.equals((String)payCurrency.getString("id"), (String)calCurrency.getString("id"))) {
            return new ExchangeRateInfo();
        }
        String exrateKey = String.format("exrate_%d_%d_%s_%d", payCurrencyId, calCurrencyId, exrateDate, exratetableId);
        log.info("payCurrencyId :{} calCurrencyId :{}", (Object)payCurrencyId, (Object)calCurrencyId);
        ExchangeRateInfo info = exrateMap.get(exrateKey);
        if (info == null) {
            info = ExchangeRateHelper.getExchangeRateInfo((Long)calCurrencyId, (Long)payCurrencyId, (Long)exratetableId, (Date)exrateDate);
            if (info == null) {
                return null;
            }
            log.info("exchangeRate quoteType :{} exchangeRate :{}", (Object)info.getQuoteType(), (Object)info.getExchangeRate());
            exrateMap.put(exrateKey, info);
            return info;
        }
        return info;
    }

    public static RoundingMode getRoundingMode(long dataRoundId) {
        if (dataRoundId == 1010L) {
            return RoundingMode.HALF_UP;
        }
        if (dataRoundId == 1020L) {
            return RoundingMode.DOWN;
        }
        if (dataRoundId == 1030L) {
            return RoundingMode.UP;
        }
        return RoundingMode.HALF_UP;
    }
}

