/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CreatePayDetailType;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.vo.PayDetailResult;
import kd.swc.hscs.business.paydetail.thread.CreatePayDetailThread;

public class CreatePayDetailService {
    private static final Log logger = LogFactory.getLog(CreatePayDetailService.class);
    private static final int DEFAULT_COUNT = 5000;

    public PayDetailResult createPayDetail(List<Long> calPersonIds, CreatePayDetailType type, Long calPayRollTaskId, String batchId, String entityName) {
        logger.info("create payDetail start");
        List calPersonIdSplit = SWCListUtils.split(calPersonIds, (int)5000);
        ArrayList futureList = new ArrayList(calPersonIdSplit.size());
        PayDetailResult result = PayDetailResult.getInstance();
        RequestContext context = RequestContext.get();
        try {
            CountDownLatch latch = new CountDownLatch(calPersonIdSplit.size());
            calPersonIdSplit.forEach(obj -> {
                CreatePayDetailThread createPayDetailThread = new CreatePayDetailThread(context, latch, type, (List<Long>)obj, calPayRollTaskId, batchId, entityName);
                Future errorResult = SWCThreadPoolFactory.getPaydetailCreateThreadpool().submit((Callable)createPayDetailThread);
                futureList.add(errorResult);
            });
            boolean isSuccess = latch.await(30 * calPersonIdSplit.size(), TimeUnit.SECONDS);
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTaskId), (String)CalPersonOperationEnum.OP_CREATEPAY.getOperationKey());
            if (isSuccess) {
                futureList.forEach(e -> {
                    try {
                        result.addResult((PayDetailResult)e.get());
                    }
                    catch (Exception e1) {
                        logger.info("Create PayDetail Error:", (Object)e1.getMessage());
                    }
                });
            }
        }
        catch (Exception e2) {
            logger.info("Create PayDetail Error:", (Object)e2.getMessage());
        }
        return result;
    }
}

