/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail.createobject;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hscs.business.paydetail.createobject.PayAmountInfoDecorator;
import kd.swc.hscs.business.paydetail.createobject.PayDetailBaseInfo;
import kd.swc.hscs.business.paydetail.createobject.PayInfoDecorator;
import kd.swc.hscs.business.paydetail.entity.BankCardObserver;
import kd.swc.hscs.business.paydetail.entity.PayInfoDTO;

public class CalPayDetailInfoService {
    private static final Log logger = LogFactory.getLog(CalPayDetailInfoService.class);
    private Map<Long, String> salaryFileNotBankCardMap = new HashMap<Long, String>(16);

    public void createPayDetailInfo(DynamicObject calPerson, List<PayInfoDTO> payInfoList, DynamicObjectCollection saveDetailCollection) {
        logger.info("Begin Get PayDetail Info :{}", (Object)payInfoList.size());
        PayDetailBaseInfo baseInfo = new PayDetailBaseInfo(calPerson);
        payInfoList.forEach(payInfo -> {
            BankCardObserver observer = new BankCardObserver();
            PayAmountInfoDecorator amountInfoDecorator = new PayAmountInfoDecorator(baseInfo, payInfo.getPayAmountInfo(), observer);
            PayInfoDecorator payInfoDecorator = new PayInfoDecorator(amountInfoDecorator, payInfo.getPayOrgEnt());
            DynamicObject payDetail = payInfoDecorator.createInfo();
            this.salaryFileNotBankCardMap.putAll(observer.getErrorMap());
            saveDetailCollection.add((Object)payDetail);
        });
    }

    public Map<Long, String> getSalaryFileNotBankCardMap() {
        return this.salaryFileNotBankCardMap;
    }
}

