/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail.createobject;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.paydetail.createobject.PayDetailInterface;

public class PayDetailBaseInfo
implements PayDetailInterface {
    private static final String STORAGE_STATUS = "0";
    private static final String PREPARE_STATUS = "1";
    private Set<String> preparePayDetailCalStatusSet = new HashSet<String>(Arrays.asList(CalStateEnum.APPROVAL.getCode(), CalStateEnum.APPROVALED.getCode()));
    private SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
    private DynamicObject payCalPerson;

    public PayDetailBaseInfo(DynamicObject payCalPerson) {
        this.payCalPerson = payCalPerson;
    }

    @Override
    public DynamicObject createInfo() {
        DynamicObject payDetail = this.helper.generateEmptyDynamicObject();
        DynamicObject calTask = this.payCalPerson.getDynamicObject("caltask");
        payDetail.set("caltableid", (Object)this.payCalPerson.getLong("calresultid"));
        Long calPersonId = this.payCalPerson.getLong("id");
        payDetail.set("calpersonid", (Object)calPersonId);
        payDetail.set("caltask", (Object)calTask.getLong("id"));
        String calStatus = this.payCalPerson.getString("calstatus");
        String payState = this.preparePayDetailCalStatusSet.contains(calStatus) ? PREPARE_STATUS : STORAGE_STATUS;
        payDetail.set("paystate", (Object)payState);
        String onHoldStatus = this.payCalPerson.getString("onholdstatus");
        payDetail.set("onholdstatus", (Object)onHoldStatus);
        DynamicObject salaryFilev = this.payCalPerson.getDynamicObject("salaryfilev");
        payDetail.set("empgroup", (Object)salaryFilev.getLong("empgroup.id"));
        payDetail.set("number", (Object)salaryFilev.getString("person.number"));
        payDetail.set("payrollgroup", (Object)this.payCalPerson.getLong("caltask.payrollgroup.id"));
        long orgId = this.payCalPerson.getLong("org.id");
        payDetail.set("org", (Object)orgId);
        long adminOrgId = this.payCalPerson.getLong("adminorg.id");
        payDetail.set("adminorg", (Object)adminOrgId);
        long company = this.payCalPerson.getLong("empposorgrelhrv.company.id");
        payDetail.set("company", (Object)company);
        long department = this.payCalPerson.getLong("empposorgrelhrv.adminorg.id");
        payDetail.set("department", (Object)department);
        long position = this.payCalPerson.getLong("empposorgrelhrv.position.id");
        payDetail.set("position", (Object)position);
        long job = this.payCalPerson.getLong("empposorgrelhrv.job.id");
        payDetail.set("job", (Object)job);
        long laborRelStatus = this.payCalPerson.getLong("empentrelv.laborrelstatus.id");
        payDetail.set("laborrelstatus", (Object)laborRelStatus);
        long laborRelType = this.payCalPerson.getLong("empentrelv.laborreltype.id");
        payDetail.set("laborreltype", (Object)laborRelType);
        Date payRollDate = calTask.getDate("payrolldate");
        payDetail.set("payrolldate", (Object)calTask.getDate("payrolldate"));
        String calCount = calTask.getString("calcount");
        if (null != payRollDate && SWCStringUtils.isNotEmpty((String)calCount)) {
            String calPeriod = MessageFormat.format(ResManager.loadKDString((String)"{0}\u5e74{1}\u6708\u7b2c{2}\u6b21", (String)"PayDetailBaseInfo_0", (String)"swc-hscs-business", (Object[])new Object[0]), String.valueOf(SWCDateTimeUtils.getYear((Date)payRollDate)), SWCDateTimeUtils.getMonth((Date)payRollDate), calCount);
            payDetail.set("calperiod", (Object)calPeriod);
        }
        payDetail.set("bankofferstatus", (Object)PREPARE_STATUS);
        payDetail.set("bankoffertimes", (Object)0);
        payDetail.set("abandonedstatus", (Object)Boolean.FALSE);
        payDetail.set("agencypaystate", (Object)STORAGE_STATUS);
        payDetail.set("salaryfilehis", (Object)this.payCalPerson.getLong("salaryfilev.id"));
        payDetail.set("payrollscene", (Object)calTask.getLong("payrollscene.id"));
        payDetail.set("createtime", (Object)new Date());
        return payDetail;
    }
}

