/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail.payinfo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.GeneralFilterCompareService;
import kd.swc.hscs.business.paydetail.entity.CreatePayDetailDTO;
import kd.swc.hscs.business.paydetail.entity.CreatePayInfoDTO;
import kd.swc.hscs.business.paydetail.entity.PayAmountInfoDTO;
import kd.swc.hscs.business.paydetail.entity.PayInfoDTO;
import kd.swc.hscs.business.paydetail.entity.PaySubjectAdvancedDTO;
import kd.swc.hscs.business.paydetail.entity.PaySubjectRangeDTO;

public class CalPayDetailPayService {
    private static final Log logger = LogFactory.getLog(CalPayDetailPayService.class);

    public List<PayInfoDTO> getPaySubjectPayInfo(CreatePayDetailDTO createPayDetail, List<PayAmountInfoDTO> amountInfoList, CreatePayInfoDTO createPayInfo) {
        logger.info("Begin Get PaySubject Info :{}", (Object)amountInfoList.size());
        ArrayList<PayInfoDTO> payInfoList = new ArrayList<PayInfoDTO>(amountInfoList.size());
        GeneralFilterCompareService service = new GeneralFilterCompareService();
        PaySubjectRangeDTO paySubjectRangeInfo = this.getPaySubjectRangeInfo(createPayDetail);
        Map<Long, DynamicObject> paySubjectIdMap = createPayInfo.getPaySubjectIdMap();
        Map<Long, DynamicObject> perBankCardIdMap = createPayInfo.getPerBankCardIdMap();
        for (PayAmountInfoDTO amountInfo : amountInfoList) {
            DynamicObject paySetting = amountInfo.getPaySetting();
            Long paySubjectId = paySetting.getLong("paysubject.id");
            DynamicObject paySubject = paySubjectIdMap.get(paySubjectId);
            amountInfo.setPaySubjectVid(paySubject.getLong("sourcevid"));
            DynamicObjectCollection payOrgEnt = paySubject.getDynamicObjectCollection("payorgent");
            PayInfoDTO payInfoDTO = new PayInfoDTO(amountInfo);
            if (payOrgEnt.isEmpty()) {
                payInfoList.add(payInfoDTO);
                continue;
            }
            Long salaryItemId = amountInfo.getSalaryItemId();
            long currencyId = paySetting.getLong("currency.id");
            long payTypeId = paySetting.getLong("paytype.id");
            Long perBankCardId = paySetting.getLong("perbankcard.id");
            DynamicObject perBankCard = perBankCardIdMap.get(perBankCardId);
            Set<Long> cardPurposeIdSet = new HashSet<Long>(16);
            if (perBankCard != null) {
                DynamicObjectCollection cardPurpose = perBankCard.getDynamicObjectCollection("cardpurpose");
                cardPurposeIdSet = cardPurpose.stream().map(single -> single.getLong("fbasedataid_id")).collect(Collectors.toSet());
            }
            PaySubjectAdvancedDTO paySubjectAdvanced = new PaySubjectAdvancedDTO(salaryItemId, payTypeId, currencyId, cardPurposeIdSet);
            this.setPayInfoDTO(service, paySubjectRangeInfo, paySubjectAdvanced, payOrgEnt, payInfoDTO);
            payInfoDTO.setCashInterGration(paySubject.getString("cashintergration"));
            payInfoList.add(payInfoDTO);
        }
        return payInfoList;
    }

    private PaySubjectRangeDTO getPaySubjectRangeInfo(CreatePayDetailDTO createPayDetail) {
        DynamicObject payrollGroupHis = createPayDetail.getCommonDTO().getPayrollGroupHis();
        DynamicObject calPerson = createPayDetail.getCalPerson();
        String payrollGroupName = payrollGroupHis.getString("name");
        String adminOrg = calPerson.getString("adminorg.name");
        String companyName = calPerson.getString("empposorgrelhrv.company.name");
        String departmentName = calPerson.getString("empposorgrelhrv.adminorg.name");
        String labTypeName = calPerson.getString("empentrelv.laborreltype.name");
        String labStatusName = calPerson.getString("empentrelv.laborrelstatus.name");
        return new PaySubjectRangeDTO(payrollGroupName, adminOrg, companyName, departmentName, labTypeName, labStatusName);
    }

    private void setPayInfoDTO(GeneralFilterCompareService service, PaySubjectRangeDTO paySubjectRangeInfo, PaySubjectAdvancedDTO paySubjectAdvanced, DynamicObjectCollection payOrgEnt, PayInfoDTO payInfoDTO) {
        DynamicObject defaultEntity = null;
        boolean isMatch = false;
        for (DynamicObject entity : payOrgEnt) {
            Set<Long> bankPurposeIds;
            Set<Long> currencyIds;
            Set<Long> payMethodIds;
            boolean isDefault = entity.getBoolean("isdefault");
            if (isDefault) {
                defaultEntity = entity;
                continue;
            }
            String scope = entity.getString("applicationscope");
            Set<Long> salaryItemIds = entity.getDynamicObjectCollection("salaryitemmul").stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toSet());
            isMatch = paySubjectAdvanced.isMatchByAdvancedCfg(salaryItemIds, payMethodIds = entity.getDynamicObjectCollection("paymethodmul").stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toSet()), currencyIds = entity.getDynamicObjectCollection("currencymul").stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toSet()), bankPurposeIds = entity.getDynamicObjectCollection("bankpurposemul").stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toSet())) && service.isMatch(scope, paySubjectRangeInfo.getDtoNameLangMap());
            if (!isMatch) continue;
            payInfoDTO.setPayOrgEnt(entity);
            break;
        }
        if (!isMatch) {
            payInfoDTO.setPayOrgEnt(defaultEntity);
        }
    }
}

