/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail.thread;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CreatePayDetailType;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.PayDetailResult;
import kd.swc.hscs.business.paydetail.createobject.CalPayDetailInfoService;
import kd.swc.hscs.business.paydetail.entity.CreatePayDetailCommonDTO;
import kd.swc.hscs.business.paydetail.entity.CreatePayDetailDTO;
import kd.swc.hscs.business.paydetail.entity.CreatePayInfoDTO;
import kd.swc.hscs.business.paydetail.entity.PayAmountInfoDTO;
import kd.swc.hscs.business.paydetail.entity.PayInfoDTO;
import kd.swc.hscs.business.paydetail.payamount.CalPayDetailPayAmountService;
import kd.swc.hscs.business.paydetail.payinfo.CalPayDetailPayService;
import kd.swc.hscs.business.paydetail.validator.CalPayDetailValidatorService;

public class CreatePayDetailThread
implements Callable<PayDetailResult> {
    private static final Log logger = LogFactory.getLog(CreatePayDetailThread.class);
    private RequestContext requestContext;
    private CountDownLatch latch;
    private List<Long> calPersonIdList;
    private List<Long> salaryFileIdList;
    private Set<Long> paySubjectIdList;
    private Set<Long> perBankCardIdList;
    private List<CreatePayDetailDTO> createPayDetailDTOList;
    private CreatePayInfoDTO createPayInfo;
    private List<String> errorMsgList;
    private Integer successNum;
    private CreatePayDetailType type;
    private String batchId;
    private Long calPayRollTaskId;
    private String entityName;

    public CreatePayDetailThread(RequestContext requestContext, CountDownLatch latch, CreatePayDetailType type, List<Long> calPersonIdList, Long calPayRollTaskId, String batchId, String entityName) {
        this.requestContext = requestContext;
        this.latch = latch;
        this.calPersonIdList = calPersonIdList;
        this.paySubjectIdList = new HashSet<Long>(16);
        this.perBankCardIdList = new HashSet<Long>(16);
        this.errorMsgList = new ArrayList<String>(10);
        this.successNum = calPersonIdList.size();
        this.batchId = batchId;
        this.calPayRollTaskId = calPayRollTaskId;
        this.type = type;
        this.entityName = entityName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PayDetailResult call() {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        String traceId = this.requestContext.getTraceId();
        logger.info("Begin Create PayDetail TraceId \uff1a{}", (Object)traceId);
        CalPayDetailValidatorService validatorService = new CalPayDetailValidatorService(this.type);
        try {
            this.initData();
            validatorService.init();
            this.createPayDetailDTOList.removeIf(dto -> {
                List<String> errorMsg = validatorService.validator((CreatePayDetailDTO)dto);
                this.errorMsgList.addAll(errorMsg);
                return !errorMsg.isEmpty();
            });
            if (this.createPayDetailDTOList.isEmpty()) {
                this.successNum = 0;
                PayDetailResult payDetailResult = this.getPayDetailResult(this.successNum, this.calPersonIdList.size());
                return payDetailResult;
            }
            this.successNum = this.createPayDetailDTOList.size();
            logger.info("Validator End SuccessNum :{}", (Object)this.successNum);
            CalPayDetailPayAmountService service = new CalPayDetailPayAmountService();
            CalPayDetailInfoService infoService = new CalPayDetailInfoService();
            CalPayDetailPayService payService = new CalPayDetailPayService();
            DynamicObjectCollection saveDetailCollection = new DynamicObjectCollection();
            this.createPayDetailDTOList.removeIf(detailDTO -> {
                DynamicObject calPerson = detailDTO.getCalPerson();
                service.createPriorityQueue((CreatePayDetailDTO)detailDTO);
                List<PayAmountInfoDTO> amountInfoList = service.payAmountFormQueue();
                if (amountInfoList.isEmpty()) {
                    Integer n = this.successNum;
                    Integer n2 = this.successNum = Integer.valueOf(this.successNum - 1);
                    return true;
                }
                List<PayInfoDTO> payInfoDTOList = payService.getPaySubjectPayInfo((CreatePayDetailDTO)detailDTO, amountInfoList, this.createPayInfo);
                infoService.createPayDetailInfo(calPerson, payInfoDTOList, saveDetailCollection);
                return false;
            });
            logger.info("Create PayDetail End SuccessNum :{}", (Object)this.successNum);
            this.dealData(saveDetailCollection);
            this.errorMsgList.addAll(validatorService.validatorExchange(service.getCurrencyIdsMapCurrencyNames()));
            this.errorMsgList.addAll(validatorService.validatorBankCard(infoService.getSalaryFileNotBankCardMap()));
        }
        catch (Exception e) {
            logger.error("Create PayDetail Error:", (Throwable)e);
            this.successNum = 0;
        }
        finally {
            if (SWCStringUtils.isNotEmpty((String)this.batchId)) {
                this.updateProcessAndHandelOperationResult();
            }
            this.latch.countDown();
        }
        return this.getPayDetailResult(this.successNum, this.calPersonIdList.size() - this.successNum);
    }

    private void updateProcessAndHandelOperationResult() {
        String lockKey = "updateCalPayRollTaskOperationProcess" + this.calPayRollTaskId;
        try (DLock lock = DLock.create((String)lockKey);){
            if (lock.tryLock(300000L)) {
                this.handelOperationResult();
                this.updateProcess();
            }
        }
        catch (Exception e) {
            logger.error("updateProgress error  :", (Throwable)e);
        }
    }

    private void cacheCreatePayDetailSuccessIds(Long calPayRollTaskId, List<Long> successPkIds) {
        String lockKey = "cachePayDetailSuccessIds" + calPayRollTaskId;
        try (DLock lock = DLock.create((String)lockKey);){
            if (lock.tryLock(300000L)) {
                ISWCAppCache appCache = SWCAppCache.get((String)"SWC_PAYROLL_TASK");
                ArrayList<Long> successIds = (ArrayList<Long>)appCache.get(this.batchId + '_' + calPayRollTaskId + "createPayDetailIds", ArrayList.class);
                if (successIds == null) {
                    successIds = new ArrayList<Long>(10);
                }
                successIds.addAll(successPkIds);
                appCache.put(this.batchId + '_' + calPayRollTaskId + "createPayDetailIds", successIds);
            }
        }
        catch (Exception e) {
            logger.error("cachePayDetailSuccessIds error  :", (Throwable)e);
        }
    }

    private void handelOperationResult() {
        ISWCAppCache appCache = SWCAppCache.get((String)"SWC_PAYROLL_TASK");
        HashSet<String> errorInfos = (HashSet<String>)appCache.get(this.batchId + '_' + this.calPayRollTaskId + "opfail", HashSet.class);
        if (errorInfos == null) {
            errorInfos = new HashSet<String>(this.errorMsgList.size());
        }
        if (!SWCStringUtils.equals((String)this.entityName, (String)"hsas_calperson")) {
            for (String errorMessage : this.errorMsgList) {
                if (errorMessage.contains(ResManager.loadKDString((String)"\u7684\u6863\u6848\uff1a", (String)"AbstractCalPayRollTaskList_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]))) {
                    errorInfos.add(errorMessage.substring(errorMessage.indexOf(ResManager.loadKDString((String)"\u7684\u6863\u6848\uff1a", (String)"AbstractCalPayRollTaskList_7", (String)"swc-hsas-formplugin", (Object[])new Object[0])) + 4));
                    continue;
                }
                errorInfos.add(errorMessage);
            }
        } else {
            errorInfos.addAll(this.errorMsgList);
        }
        appCache.put(this.batchId + '_' + this.calPayRollTaskId + "opfail", errorInfos);
    }

    private void updateProcess() {
        ISWCAppCache appCache = SWCAppCache.get((String)"SWC_PAYROLL_TASK");
        HashMap<String, Integer> process = (HashMap<String, Integer>)appCache.get("process" + this.batchId + this.calPayRollTaskId, HashMap.class);
        if (process == null) {
            process = new HashMap<String, Integer>(2);
            process.put("successCount", this.successNum);
            process.put("failCount", this.calPersonIdList.size() - this.successNum);
        } else {
            process.put("successCount", (Integer)process.get("successCount") + this.successNum);
            process.put("failCount", (Integer)process.get("failCount") + this.calPersonIdList.size() - this.successNum);
        }
        appCache.put("process" + this.batchId + this.calPayRollTaskId, process);
    }

    private void initData() {
        PayDetailDataBuild payDetailData = new PayDetailDataBuild();
        this.queryCalPersonList(payDetailData);
        this.queryPayRollGroupInfo(payDetailData);
        this.queryCalRuleGetPayOutItem(payDetailData);
        this.queryCalTableList(payDetailData);
        this.queryRecentPaySetting(payDetailData);
        this.queryPaySubBankCardPaySetting(payDetailData);
        this.createPayDetailEntity(payDetailData);
    }

    private void createPayDetailEntity(PayDetailDataBuild payDetailData) {
        List<DynamicObject> calPersonList = payDetailData.getCalPersonList();
        Map<Long, List<DynamicObject>> calPersonIdMapCalResult = payDetailData.getCalPersonIdMapCalResult();
        Map<Long, DynamicObject> salaryFileMapPaySetting = payDetailData.getSalaryFileMapPaySetting();
        DynamicObject payRollGroupHis = payDetailData.getPayRollGroupHis();
        Map<Long, Long> payOutItemIdDataRoundIdMap = payDetailData.getPayOutItemIdDataRoundIdMap();
        CreatePayDetailCommonDTO detailCommonDTO = new CreatePayDetailCommonDTO(payRollGroupHis, payOutItemIdDataRoundIdMap);
        this.createPayDetailDTOList = new ArrayList<CreatePayDetailDTO>(calPersonList.size());
        for (DynamicObject calPerson : calPersonList) {
            long calPersonId = calPerson.getLong("id");
            long salaryFileId = calPerson.getLong("salaryfile.id");
            CreatePayDetailDTO detailDTO = new CreatePayDetailDTO(calPerson, calPersonIdMapCalResult.get(calPersonId), salaryFileMapPaySetting.get(salaryFileId));
            detailDTO.setCommonDTO(detailCommonDTO);
            this.createPayDetailDTOList.add(detailDTO);
        }
        this.createPayInfo = new CreatePayInfoDTO(payDetailData.getPaySubjectIdMap(), payDetailData.getPerBankCardIdMap());
    }

    private void queryPayRollGroupInfo(PayDetailDataBuild payDetailData) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        QFilter filter = new QFilter("id", "=", (Object)((DynamicObject)payDetailData.calPersonList.get(0)).getLong("caltask.payrollgroupv.id"));
        DynamicObject payRollGroupHis = helper.queryOne("name,exratetable,currency,calruleitementry.ispayoutitem,calruleitementry.salaryitem", new QFilter[]{filter});
        payDetailData.setPayRollGroupHis(payRollGroupHis);
    }

    private void queryCalRuleGetPayOutItem(PayDetailDataBuild payDetailData) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        QFilter filter = new QFilter("id", "=", (Object)((DynamicObject)payDetailData.calPersonList.get(0)).getLong("caltask.calrulev.id"));
        DynamicObject calRuleHis = helper.queryOne("calruleitementry.ispayoutitem,calruleitementry.salaryitem", new QFilter[]{filter});
        DynamicObjectCollection calRuleEntry = calRuleHis.getDynamicObjectCollection("calruleitementry");
        HashMap<Long, Long> payOutItemIdDataRoundIdMap = new HashMap<Long, Long>(16);
        for (DynamicObject entry : calRuleEntry) {
            if (!entry.getBoolean("ispayoutitem")) continue;
            Long itemId = entry.getLong("salaryitem.id");
            Long dataRoundId = entry.getLong("salaryitem.dataround.id");
            payOutItemIdDataRoundIdMap.put(itemId, dataRoundId);
        }
        payDetailData.setPayOutItemIdDataRoundIdMap(payOutItemIdDataRoundIdMap);
    }

    private void queryCalPersonList(PayDetailDataBuild payDetailData) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", this.calPersonIdList);
        String selectProperties = "paystatus,calstatus,caltask,onholdstatus,salarystatus,org,salaryfile,person,caltask.payrollgroup,salaryfilev,calresultid,orgnempgroupv.empgroup,caltask,adminorg,empposorgrelhrv, entrydate,empentrelv,laborreltype,regulardate,actualquitdate,payrollgroupv,payperiod,belongperiod,trialperiodv";
        DynamicObject[] query = helper.query(selectProperties, new QFilter[]{filter});
        ArrayList<DynamicObject> calPersonList = new ArrayList<DynamicObject>(query.length);
        ArrayList<Long> calResultIdList = new ArrayList<Long>(query.length);
        this.salaryFileIdList = new ArrayList<Long>(query.length);
        for (DynamicObject calPerson : query) {
            long salaryFileId = calPerson.getLong("salaryfile.id");
            long calResultId = calPerson.getLong("calresultid");
            this.salaryFileIdList.add(salaryFileId);
            calPersonList.add(calPerson);
            if (calResultId == 0L) continue;
            calResultIdList.add(calResultId);
        }
        payDetailData.setCalPersonList(calPersonList);
        payDetailData.setCalResultIdList(calResultIdList);
    }

    private void queryCalTableList(PayDetailDataBuild payDetailData) {
        logger.info(" query calTable begin: {}", (Object)System.currentTimeMillis());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "in", payDetailData.getCalResultIdList());
        filter.and(new QFilter("hsas_caltableentry.salaryitem", "in", payDetailData.getPayOutItemIdDataRoundIdMap().keySet()));
        DynamicObject[] query = helper.queryOriginalArray("calpersonid,hsas_caltableentry.calamountvalue,hsas_caltableentry.salaryitem.id,hsas_caltableentry.slprorationindex", new QFilter[]{filter});
        HashMap<Long, List<DynamicObject>> calPersonIdMapCalResult = new HashMap<Long, List<DynamicObject>>(query.length);
        for (DynamicObject calTable : query) {
            List calTableList = calPersonIdMapCalResult.getOrDefault(calTable.getLong("calpersonid"), new ArrayList(10));
            calTableList.add(calTable);
            calPersonIdMapCalResult.put(calTable.getLong("calpersonid"), calTableList);
        }
        payDetailData.setCalPersonIdMapCalResult(calPersonIdMapCalResult);
        logger.info(" query calTable end: {}", (Object)System.currentTimeMillis());
    }

    private void queryRecentPaySetting(PayDetailDataBuild payDetailData) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paysetting");
        String selectProperties = "id,sourcevid,salaryfile.id,salaryfile.sourcevid,entryentity.salaryitem,entryentity.salaryitemmark,entryentity.salaryitem.dataprecision.scale,entryentity.payrate,entryentity.paytype,entryentity.currency,entryentity.perbankcard,entryentity.paymentway,entryentity,payamount,entryentity.paysubject,entryentity.seq";
        QFilter salaryFileFilter = new QFilter("salaryfile", "in", this.salaryFileIdList);
        BaseDataHisHelper.addHisVerFilter((QFilter)salaryFileFilter);
        salaryFileFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        QFilter[] filters = new QFilter[]{salaryFileFilter};
        DynamicObject[] query = helper.query(selectProperties, filters);
        HashMap<Long, DynamicObject> salaryFileMapPaySetting = new HashMap<Long, DynamicObject>(query.length);
        for (DynamicObject paySetting : query) {
            salaryFileMapPaySetting.put(paySetting.getLong("salaryfile.id"), paySetting);
            DynamicObjectCollection paySettingEntryCol = paySetting.getDynamicObjectCollection("entryentity");
            paySettingEntryCol.forEach(obj -> {
                this.paySubjectIdList.add(obj.getLong("paysubject.id"));
                this.perBankCardIdList.add(obj.getLong("perbankcard.id"));
            });
        }
        payDetailData.setSalaryFileMapPaySetting(salaryFileMapPaySetting);
    }

    private void queryPaySubBankCardPaySetting(PayDetailDataBuild payDetailData) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_paysubject");
        String selectProperties = "id,sourcevid,cashintergration,payorgent.agentpayorg,payorgent.agentpayaccount,payorgent.agentpaybank,payorgent.isdefault,payorgent.applicationscope,payorgent.salaryitemmul,payorgent.paymethodmul,payorgent.currencymul,payorgent.bankpurposemul";
        QFilter filter = new QFilter("id", "in", this.paySubjectIdList);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] query = helper.query(selectProperties, filters);
        HashMap<Long, DynamicObject> paySubjectIdMap = new HashMap<Long, DynamicObject>(query.length);
        for (DynamicObject paySubject : query) {
            paySubjectIdMap.put(paySubject.getLong("id"), paySubject);
        }
        payDetailData.setPaySubjectIdMap(paySubjectIdMap);
        helper = new SWCDataServiceHelper("hrpi_perbankcard");
        selectProperties = "id,sourcevid,cardpurpose";
        filter = new QFilter("id", "in", this.perBankCardIdList);
        filters = new QFilter[]{filter};
        query = helper.query(selectProperties, filters);
        HashMap<Long, DynamicObject> perBankCardIdMap = new HashMap<Long, DynamicObject>(query.length);
        for (DynamicObject perBankCard : query) {
            perBankCardIdMap.put(perBankCard.getLong("id"), perBankCard);
        }
        payDetailData.setPerBankCardIdMap(perBankCardIdMap);
    }

    private void dealData(DynamicObjectCollection payDetails) {
        switch (this.type) {
            case NORMAL: {
                this.dealDataNormal(payDetails);
                break;
            }
            case RESEND: {
                this.dealDataResend(payDetails);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealDataNormal(DynamicObjectCollection payDetails) {
        if (payDetails.isEmpty()) {
            return;
        }
        long[] payDetailIds = DB.genLongIds((String)"hsas_paydetail", (int)payDetails.size());
        logger.info("Create PayDetail Id[0] :{}", (Object)payDetailIds[0]);
        for (int index = 0; index < payDetails.size(); ++index) {
            DynamicObject payDetail = (DynamicObject)payDetails.get(index);
            payDetail.set("id", (Object)payDetailIds[index]);
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", this.createPayDetailDTOList.stream().map(obj -> obj.getCalPerson().getLong("id")).collect(Collectors.toList()));
        DynamicObject[] calPersons = calPersonHelper.query("paystatus,modifier,modifytime", new QFilter[]{filter});
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject calPerson : calPersons) {
            calPerson.set("paystatus", (Object)PayStateEnum.UNPAY.getCode());
            calPerson.set("modifier", (Object)currUserId);
            calPerson.set("modifytime", (Object)date);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            calPersonHelper.save(calPersons);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
            helper.save(payDetails);
            this.cacheCreatePayDetailSuccessIds(this.calPayRollTaskId, Arrays.stream(payDetailIds).boxed().collect(Collectors.toList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealDataResend(DynamicObjectCollection payDetails) {
        DynamicObject[] payDetailAbandon;
        logger.info(" insert payDetail begin: {}", (Object)System.currentTimeMillis());
        String abandonedRes = ResManager.loadKDString((String)"\u91cd\u65b0\u751f\u6210\u660e\u7ec6", (String)"CreatePayDetailThread_0", (String)"swc-hscs-business", (Object[])new Object[0]);
        if (payDetails.isEmpty()) {
            return;
        }
        long[] payDetailIds = DB.genLongIds((String)"hsas_paydetail", (int)payDetails.size());
        for (int index = 0; index < payDetails.size(); ++index) {
            DynamicObject payDetail = (DynamicObject)payDetails.get(index);
            payDetail.set("id", (Object)payDetailIds[index]);
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filterCal = new QFilter("id", "in", this.createPayDetailDTOList.stream().map(obj -> obj.getCalPerson().getLong("id")).collect(Collectors.toList()));
        DynamicObject[] calPersons = calPersonHelper.query("modifier,modifytime,paystatus", new QFilter[]{filterCal});
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject dynamicObject : calPersons) {
            dynamicObject.set("modifier", (Object)currUserId);
            dynamicObject.set("modifytime", (Object)date);
            dynamicObject.set("paystatus", (Object)PayStateEnum.UNPAY.getCode());
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        QFilter filter = new QFilter("calpersonid", "in", this.createPayDetailDTOList.stream().map(obj -> obj.getCalPerson().getLong("id")).collect(Collectors.toList()));
        filter.and(new QFilter("abandonedstatus", "in", (Object)Boolean.FALSE));
        for (DynamicObject payDetail : payDetailAbandon = helper.query("abandonedstatus,abandonedres", new QFilter[]{filter})) {
            payDetail.set("abandonedstatus", (Object)Boolean.TRUE);
            payDetail.set("abandonedres", (Object)abandonedRes);
        }
        TXHandle tXHandle = TX.requiresNew();
        try {
            helper.save(payDetailAbandon);
            helper.save(payDetails);
            calPersonHelper.save(calPersons);
            tXHandle.commit();
        }
        catch (Exception e) {
            logger.error("Resend PayDetail Error:", (Object)e.getMessage());
            tXHandle.markRollback();
            this.successNum = 0;
        }
        finally {
            tXHandle.close();
            logger.info(" insert payDetail end:{} ", (Object)System.currentTimeMillis());
        }
    }

    private PayDetailResult getPayDetailResult(int success, int error) {
        return new PayDetailResult(Integer.valueOf(success), Integer.valueOf(error), this.errorMsgList);
    }

    static class PayDetailDataBuild {
        private List<DynamicObject> calPersonList;
        private List<Long> calResultIdList;
        private Map<Long, List<DynamicObject>> calPersonIdMapCalResult;
        private Map<Long, DynamicObject> salaryFileMapPaySetting;
        private Map<Long, Long> payOutItemIdDataRoundIdMap;
        private DynamicObject payRollGroupHis;
        private Map<Long, DynamicObject> paySubjectIdMap;
        private Map<Long, DynamicObject> perBankCardIdMap;

        private PayDetailDataBuild() {
        }

        public List<DynamicObject> getCalPersonList() {
            return this.calPersonList;
        }

        public void setCalPersonList(List<DynamicObject> calPersonList) {
            this.calPersonList = calPersonList;
        }

        public Map<Long, List<DynamicObject>> getCalPersonIdMapCalResult() {
            return this.calPersonIdMapCalResult;
        }

        public void setCalPersonIdMapCalResult(Map<Long, List<DynamicObject>> calPersonIdMapCalResult) {
            this.calPersonIdMapCalResult = calPersonIdMapCalResult;
        }

        public Map<Long, DynamicObject> getSalaryFileMapPaySetting() {
            return this.salaryFileMapPaySetting;
        }

        public void setSalaryFileMapPaySetting(Map<Long, DynamicObject> salaryFileMapPaySetting) {
            this.salaryFileMapPaySetting = salaryFileMapPaySetting;
        }

        public Map<Long, Long> getPayOutItemIdDataRoundIdMap() {
            return this.payOutItemIdDataRoundIdMap;
        }

        public void setPayOutItemIdDataRoundIdMap(Map<Long, Long> payOutItemIdDataRoundIdMap) {
            this.payOutItemIdDataRoundIdMap = payOutItemIdDataRoundIdMap;
        }

        public DynamicObject getPayRollGroupHis() {
            return this.payRollGroupHis;
        }

        public void setPayRollGroupHis(DynamicObject payRollGroupHis) {
            this.payRollGroupHis = payRollGroupHis;
        }

        public Map<Long, DynamicObject> getPaySubjectIdMap() {
            return this.paySubjectIdMap;
        }

        public void setPaySubjectIdMap(Map<Long, DynamicObject> paySubjectIdMap) {
            this.paySubjectIdMap = paySubjectIdMap;
        }

        public Map<Long, DynamicObject> getPerBankCardIdMap() {
            return this.perBankCardIdMap;
        }

        public void setPerBankCardIdMap(Map<Long, DynamicObject> perBankCardIdMap) {
            this.perBankCardIdMap = perBankCardIdMap;
        }

        public List<Long> getCalResultIdList() {
            return this.calResultIdList;
        }

        public void setCalResultIdList(List<Long> calResultIdList) {
            this.calResultIdList = calResultIdList;
        }
    }
}

