/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.paydetail.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hscs.business.paydetail.entity.CreatePayDetailDTO;
import kd.swc.hscs.business.paydetail.validator.PayDetailBaseValidator;

public class PaySettingValidator
extends PayDetailBaseValidator {
    private static final HashSet<String> NOTTARGET = new HashSet<String>(Arrays.asList("0", "2"));

    @Override
    List<String> validator(CreatePayDetailDTO detailDTO) {
        ArrayList<String> errMsg = new ArrayList<String>(10);
        DynamicObject paySetting = detailDTO.getPaySetting();
        if (paySetting == null) {
            DynamicObject calPerson = detailDTO.getCalPerson();
            String salaryFileNumber = calPerson.getString("salaryfilev.number");
            errMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u65e0\u53ef\u7528\u53d1\u653e\u8bbe\u7f6e\uff0c\u8bf7\u524d\u5f80\u4eba\u5458\u85aa\u8d44\u6863\u6848\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"HSASPaydetailService_3", (String)"swc-hsas-business", (Object[])new Object[0]), salaryFileNumber));
            return errMsg;
        }
        HashSet<Long> payOutItemIdList = new HashSet<Long>(detailDTO.getCommonDTO().getPayOutItemIdDataRoundIdMap().keySet());
        DynamicObjectCollection collection = paySetting.getDynamicObjectCollection("entryentity");
        boolean isHaveCover = false;
        for (DynamicObject entity : collection) {
            String salaryItemMark = entity.getString("salaryitemmark");
            if (NOTTARGET.contains(salaryItemMark)) {
                isHaveCover = true;
                break;
            }
            long salaryItemId = entity.getLong("salaryitem.id");
            payOutItemIdList.remove(salaryItemId);
        }
        if (!isHaveCover && !payOutItemIdList.isEmpty()) {
            DynamicObject calPerson = detailDTO.getCalPerson();
            String salaryFileNumber = calPerson.getString("salaryfilev.number");
            errMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u6863\u6848\uff1a\u672a\u5bf9\u5f53\u524d\u8ba1\u7b97\u89c4\u5219\u4e0b\u7684\u6240\u6709\u5b9e\u53d1\u9879\u76ee\u8fdb\u884c\u53d1\u653e\u8bbe\u7f6e\uff0c\u8bf7\u524d\u5f80\u4eba\u5458\u85aa\u8d44\u6863\u6848\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"PaySettingValidator_0", (String)"swc-hsas-business", (Object[])new Object[0]), salaryFileNumber));
        }
        if (errMsg.isEmpty() && this.getNextValidator() != null) {
            return this.getNextValidator().validator(detailDTO);
        }
        return errMsg;
    }
}

